/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.GetAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.PutAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.QueryResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Item.class);
    private String domainName;
    private String identifier;

    protected Item(String identifier, String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.domainName = domainName;
        this.identifier = identifier;
        SimpleDB.setVersionHeader(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ItemAttribute> getAttributes() throws SDBException {
        return this.getAttributes((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemAttribute> getAttributes(String attributeName) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributeName != null) {
            params.put("AttributeName.1", attributeName);
        }
        GetMethod method = new GetMethod();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpMethodBase)method, "GetAttributes", params, GetAttributesResponse.class);
            ArrayList<ItemAttribute> ret = new ArrayList<ItemAttribute>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.add(this.createAttribute(attr));
            }
            ArrayList<ItemAttribute> arrayList = ret;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemAttribute> getAttributes(List<String> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        GetMethod method = new GetMethod();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpMethodBase)method, "GetAttributes", params, GetAttributesResponse.class);
            ArrayList<ItemAttribute> ret = new ArrayList<ItemAttribute>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.add(this.createAttribute(attr));
            }
            ArrayList<ItemAttribute> arrayList = ret;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getAttributesMap(List<String> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        GetMethod method = new GetMethod();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpMethodBase)method, "GetAttributes", params, GetAttributesResponse.class);
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ArrayList<String> vals;
                String name = attr.getName().getValue();
                String encoding = attr.getName().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    name = new String(Base64.decodeBase64((byte[])name.getBytes()));
                }
                if ((vals = (ArrayList<String>)ret.get(name)) == null) {
                    vals = new ArrayList<String>();
                    ret.put(name, vals);
                }
                String value = attr.getName().getValue();
                encoding = attr.getName().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    value = new String(Base64.decodeBase64((byte[])value.getBytes()));
                }
                vals.add(value);
            }
            HashMap<String, List<String>> hashMap = ret;
            return hashMap;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttributes(List<ItemAttribute> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int i = 1;
        for (ItemAttribute attr : attributes) {
            String val = attr.getValue();
            if (val == null) continue;
            params.put("Attribute." + i + ".Name", attr.getName());
            params.put("Attribute." + i + ".Value", val);
            if (attr.isReplace()) {
                params.put("Attribute." + i + ".Replace", "true");
            }
            ++i;
        }
        GetMethod method = new GetMethod();
        try {
            this.makeRequestInt((HttpMethodBase)method, "PutAttributes", params, PutAttributesResponse.class);
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAttributes(List<ItemAttribute> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributes != null) {
            int i = 1;
            for (ItemAttribute attr : attributes) {
                params.put("Attribute." + i + ".Name", attr.getName());
                String value = attr.getValue();
                if (value != null) {
                    params.put("Attribute." + i + ".Value", value);
                }
                ++i;
            }
        }
        GetMethod method = new GetMethod();
        try {
            this.makeRequestInt((HttpMethodBase)method, "DeleteAttributes", params, DeleteAttributesResponse.class);
        }
        finally {
            method.releaseConnection();
        }
    }

    protected <T> T makeRequestInt(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    private ItemAttribute createAttribute(Attribute a) {
        String name = a.getName().getValue();
        String encoding = a.getName().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            name = new String(Base64.decodeBase64((byte[])name.getBytes()));
        }
        String value = a.getValue().getValue();
        encoding = a.getValue().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            value = new String(Base64.decodeBase64((byte[])value.getBytes()));
        }
        return new ItemAttribute(name, value, false);
    }

    static List<Item> createList(QueryResult.ItemName[] itemNames, String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server, int signatureVersion, HttpClient hc) throws SDBException {
        ArrayList<Item> ret = new ArrayList<Item>();
        for (int i = 0; i < itemNames.length; ++i) {
            String name = itemNames[i].getValue();
            String encoding = itemNames[i].getEncoding();
            if (encoding != null && encoding.equals("base64")) {
                name = new String(Base64.decodeBase64((byte[])name.getBytes()));
            }
            Item item = new Item(name, domainName, awsAccessId, awsSecretKey, isSecure, server);
            item.setSignatureVersion(signatureVersion);
            item.setHttpClient(hc);
            ret.add(item);
        }
        return ret;
    }
}

