/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.Domain;
import com.xerox.amazonws.sdb.ListDomainsResult;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.typica.sdb.jaxb.CreateDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.ListDomainsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDB
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(SimpleDB.class);

    public SimpleDB(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "sdb.amazonaws.com");
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        SimpleDB.setVersionHeader(this);
    }

    @Override
    public int getSignatureVersion() {
        return super.getSignatureVersion();
    }

    @Override
    public void setSignatureVersion(int version) {
        super.setSignatureVersion(version);
    }

    public ListDomainsResult listDomains() throws SDBException {
        return this.listDomains(null);
    }

    public ListDomainsResult listDomains(String nextToken) throws SDBException {
        return this.listDomains(nextToken, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain createDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        GetMethod method = new GetMethod();
        try {
            CreateDomainResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateDomain", params, CreateDomainResponse.class);
            Domain ret = new Domain(name, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
            ret.setSignatureVersion(this.getSignatureVersion());
            ret.setHttpClient(this.getHttpClient());
            Domain domain = ret;
            return domain;
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteDomain(Domain domain) throws SDBException {
        this.deleteDomain(domain.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        GetMethod method = new GetMethod();
        try {
            this.makeRequestInt((HttpMethodBase)method, "DeleteDomain", params, DeleteDomainResponse.class);
        }
        finally {
            method.releaseConnection();
        }
    }

    public Domain getDomain(String domainName) throws SDBException {
        Domain ret = new Domain(domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListDomainsResult listDomains(String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfDomains", "" + maxResults);
        }
        GetMethod method = new GetMethod();
        try {
            ListDomainsResponse response = this.makeRequestInt((HttpMethodBase)method, "ListDomains", params, ListDomainsResponse.class);
            ListDomainsResult listDomainsResult = new ListDomainsResult(response.getListDomainsResult().getNextToken(), Domain.createList(response.getListDomainsResult().getDomainNames().toArray(new String[0]), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getSignatureVersion(), this.getHttpClient()));
            return listDomainsResult;
        }
        finally {
            method.releaseConnection();
        }
    }

    protected <T> T makeRequestInt(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2007-11-07");
        connection.getHeaders().put("Version", vals);
    }
}

