/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sqs2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sqs2.MessageQueue;
import com.xerox.amazonws.sqs2.SQSException;
import com.xerox.amazonws.typica.sqs2.jaxb.CreateQueueResponse;
import com.xerox.amazonws.typica.sqs2.jaxb.ListQueuesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueService
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(QueueService.class);

    public QueueService(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "queue.amazonaws.com");
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public QueueService(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        QueueService.setVersionHeader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageQueue getOrCreateMessageQueue(String queueName) throws SQSException {
        if (queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http")) {
            return this.getMessageQueue(queueName);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("QueueName", queueName);
        GetMethod method = new GetMethod();
        try {
            CreateQueueResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateQueue", params, CreateQueueResponse.class);
            MessageQueue ret = new MessageQueue(response.getCreateQueueResult().getQueueUrl(), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
            ret.setHttpClient(this.getHttpClient());
            MessageQueue messageQueue = ret;
            return messageQueue;
        }
        finally {
            method.releaseConnection();
        }
    }

    public MessageQueue getMessageQueue(String queueName) throws SQSException {
        if (!(queueName.charAt(0) == '/' && queueName.lastIndexOf(47) > 0 || queueName.startsWith("http"))) {
            throw new IllegalArgumentException("Queue name must be more fully specified or use getOrCreateMessageQueue().");
        }
        MessageQueue ret = new MessageQueue(queueName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageQueue> listMessageQueues(String queueNamePrefix) throws SQSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queueNamePrefix != null && !queueNamePrefix.trim().equals("")) {
            params.put("QueueNamePrefix", queueNamePrefix);
        }
        GetMethod method = new GetMethod();
        try {
            ListQueuesResponse response = this.makeRequestInt((HttpMethodBase)method, "ListQueues", params, ListQueuesResponse.class);
            List<String> urls = response.getListQueuesResult().getQueueUrls();
            if (urls == null) {
                ArrayList<MessageQueue> arrayList = new ArrayList<MessageQueue>();
                return arrayList;
            }
            List<MessageQueue> list = MessageQueue.createList(urls.toArray(new String[0]), this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getHttpClient());
            return list;
        }
        finally {
            method.releaseConnection();
        }
    }

    protected <T> T makeRequestInt(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws SQSException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SQSException(ex);
        }
        catch (JAXBException ex) {
            throw new SQSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SQSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SQSException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2008-01-01");
        connection.getHeaders().put("Version", vals);
    }
}

