/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.wagon.events.TransferListener;

public class ArchetypeGenerationRequest {
    private boolean offline;
    private boolean interactiveMode;
    private TransferListener transferListener;
    private String outputDirectory;
    private ArtifactRepository localRepository;
    private Proxy activeProxy;
    private List servers = new ArrayList();
    private List mirrors = new ArrayList();
    private String archetypeName;
    private String archetypeGroupId;
    private String archetypeArtifactId;
    private String archetypeVersion;
    private String archetypeGoals = "";
    private String archetypeRepository;
    private String groupId;
    private String artifactId;
    private String version;
    private String packageName;
    private Properties properties = new Properties();

    public ArchetypeGenerationRequest() {
    }

    public ArchetypeGenerationRequest(Archetype archetype) {
        this.archetypeGroupId = archetype.getGroupId();
        this.archetypeArtifactId = archetype.getArtifactId();
        this.archetypeVersion = archetype.getVersion();
        this.archetypeRepository = archetype.getRepository();
    }

    public String getArchetypeGroupId() {
        return this.archetypeGroupId;
    }

    public ArchetypeGenerationRequest setArchetypeGroupId(String archetypeGroupId) {
        this.archetypeGroupId = archetypeGroupId;
        return this;
    }

    public String getArchetypeArtifactId() {
        return this.archetypeArtifactId;
    }

    public ArchetypeGenerationRequest setArchetypeArtifactId(String archetypeArtifactId) {
        this.archetypeArtifactId = archetypeArtifactId;
        return this;
    }

    public String getArchetypeVersion() {
        return this.archetypeVersion;
    }

    public ArchetypeGenerationRequest setArchetypeVersion(String archetypeVersion) {
        this.archetypeVersion = archetypeVersion;
        return this;
    }

    public String getArchetypeGoals() {
        return this.archetypeGoals;
    }

    public ArchetypeGenerationRequest setArchetypeGoals(String archetypeGoals) {
        this.archetypeGoals = archetypeGoals;
        return this;
    }

    public String getArchetypeName() {
        return this.archetypeName;
    }

    public ArchetypeGenerationRequest setArchetypeName(String archetypeName) {
        this.archetypeName = archetypeName;
        return this;
    }

    public String getArchetypeRepository() {
        return this.archetypeRepository;
    }

    public ArchetypeGenerationRequest setArchetypeRepository(String archetypeRepository) {
        this.archetypeRepository = archetypeRepository;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public ArchetypeGenerationRequest setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ArchetypeGenerationRequest setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ArchetypeGenerationRequest setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getPackage() {
        return this.packageName;
    }

    public ArchetypeGenerationRequest setPackage(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ArchetypeGenerationRequest setProperties(Properties additionalProperties) {
        this.properties = additionalProperties;
        return this;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public ArchetypeGenerationRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public ArchetypeGenerationRequest setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public ArchetypeGenerationRequest setInteractiveMode(boolean interactiveMode) {
        this.interactiveMode = interactiveMode;
        return this;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public ArchetypeGenerationRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public ArchetypeGenerationRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    public Proxy getActiveProxy() {
        return this.activeProxy;
    }

    public ArchetypeGenerationRequest setActiveProxy(Proxy activeProxy) {
        this.activeProxy = activeProxy;
        return this;
    }

    public ArchetypeGenerationRequest addMirror(Mirror mirror) {
        this.mirrors.add(mirror);
        return this;
    }

    public List getMirrors() {
        return this.mirrors;
    }

    public ArchetypeGenerationRequest addMirror(Server server) {
        this.servers.add(server);
        return this;
    }

    public List getServers() {
        return this.servers;
    }
}

