/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.OutputFileExists;
import org.apache.maven.archetype.exception.PomFileExists;
import org.apache.maven.archetype.exception.ProjectDirectoryExists;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.dom4j.DocumentException;

public class DefaultFilesetArchetypeGenerator
extends AbstractLogEnabled
implements FilesetArchetypeGenerator {
    private ArchetypeArtifactManager archetypeArtifactManager;
    private ArchetypeFilesResolver archetypeFilesResolver;
    private PomManager pomManager;
    private VelocityComponent velocity;

    public void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile, String basedir) throws UnknownArchetype, ArchetypeNotConfigured, ProjectDirectoryExists, PomFileExists, OutputFileExists, ArchetypeGenerationFailure {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(archetypeFile);
            if (!this.isArchetypeConfigured(archetypeDescriptor, request)) {
                throw new ArchetypeNotConfigured("The archetype is not configured");
            }
            Context context = this.prepareVelocityContext(request);
            String packageName = request.getPackage();
            String artifactId = request.getArtifactId();
            File outputDirectoryFile = new File(basedir, artifactId);
            File basedirPom = new File(basedir, "pom.xml");
            File pom = new File(outputDirectoryFile, "pom.xml");
            List archetypeResources = this.archetypeArtifactManager.getFilesetArchetypeResources(archetypeFile);
            ZipFile archetypeZipFile = this.archetypeArtifactManager.getArchetypeZipFile(archetypeFile);
            ClassLoader archetypeJarLoader = this.archetypeArtifactManager.getArchetypeJarLoader(archetypeFile);
            Thread.currentThread().setContextClassLoader(archetypeJarLoader);
            if (archetypeDescriptor.isPartial()) {
                this.getLogger().debug("Procesing partial archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists()) {
                    if (!pom.exists()) {
                        throw new PomFileExists("This is a partial archetype and the pom.xml file doesn't exist.");
                    }
                    this.processPomWithMerge(context, pom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                } else if (basedirPom.exists()) {
                    this.processPomWithMerge(context, basedirPom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, new File(basedir));
                } else {
                    this.processPom(context, pom, "");
                    this.processArchetypeTemplates(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                }
                if (archetypeDescriptor.getModules().size() > 0) {
                    this.getLogger().info("Modules ignored in partial mode");
                }
            } else {
                this.getLogger().debug("Processing complete archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists()) {
                    throw new ProjectDirectoryExists("The project directory already exists");
                }
                context.put("rootArtifactId", (Object)artifactId);
                this.processFilesetModule(artifactId, artifactId, archetypeResources, pom, archetypeZipFile, "", basedirPom, outputDirectoryFile, packageName, archetypeDescriptor, context);
            }
        }
        catch (FileNotFoundException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (IOException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (XmlPullParserException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (DocumentException ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (ArchetypeGenerationFailure ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        catch (InvalidPackaging ex) {
            throw new ArchetypeGenerationFailure(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace((String)packageName, (String)".", (String)"/");
    }

    private void copyFile(File outFile, String template, boolean failIfExists, ZipFile archetypeZipFile) throws FileNotFoundException, OutputFileExists, IOException {
        this.getLogger().debug("Copying file " + template);
        if (failIfExists && outFile.exists()) {
            throw new OutputFileExists("Don't rewrite file " + outFile.getName());
        }
        if (outFile.exists()) {
            this.getLogger().warn("CP Don't override file " + outFile);
        } else {
            ZipEntry input = archetypeZipFile.getEntry("archetype-resources/" + template);
            InputStream inputStream = archetypeZipFile.getInputStream(input);
            outFile.getParentFile().mkdirs();
            IOUtil.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(outFile));
        }
    }

    private void copyFiles(String directory, List fileSetResources, boolean packaged, String packageName, File outputDirectoryFile, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists) throws OutputFileExists, FileNotFoundException, IOException {
        Iterator iterator = fileSetResources.iterator();
        while (iterator.hasNext()) {
            String template = (String)iterator.next();
            String templateName = StringUtils.replaceOnce((String)template, (String)(directory + "/"), (String)"");
            if (!StringUtils.isEmpty((String)moduleOffset)) {
                templateName = StringUtils.replaceOnce((String)templateName, (String)(moduleOffset + "/"), (String)"");
            }
            templateName = StringUtils.replace((String)templateName, (String)File.separator, (String)"/");
            File outFile = new File(outputDirectoryFile, directory + "/" + (packaged ? this.getPackageAsDirectory(packageName) : "") + "/" + templateName);
            this.copyFile(outFile, template, failIfExists, archetypeZipFile);
        }
    }

    private String getEncoding(String archetypeEncoding) {
        return null == archetypeEncoding || "".equals(archetypeEncoding) ? "UTF-8" : archetypeEncoding;
    }

    private String getOffsetSeparator(String moduleOffset) {
        return StringUtils.isEmpty((String)moduleOffset) ? "/" : "/" + moduleOffset + "/";
    }

    private boolean isArchetypeConfigured(ArchetypeDescriptor archetypeDescriptor, ArchetypeGenerationRequest request) {
        boolean configured = true;
        Iterator requiredProperties = archetypeDescriptor.getRequiredProperties().iterator();
        while (configured && requiredProperties.hasNext()) {
            RequiredProperty requiredProperty = (RequiredProperty)requiredProperties.next();
            configured = configured && StringUtils.isNotEmpty((String)request.getProperties().getProperty(requiredProperty.getKey()));
        }
        return configured;
    }

    private void setParentArtifactId(Context context, String artifactId) {
        context.put("parentArtifactId", (Object)artifactId);
    }

    private Context prepareVelocityContext(ArchetypeGenerationRequest request) {
        VelocityContext context = new VelocityContext();
        context.put("groupId", (Object)request.getGroupId());
        context.put("artifactId", (Object)request.getArtifactId());
        context.put("version", (Object)request.getVersion());
        context.put("package", (Object)request.getPackage());
        Iterator<Object> iterator = request.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = request.getProperties().getProperty(key);
            context.put(key, (Object)value);
        }
        return context;
    }

    private void processArchetypeTemplates(AbstractArchetypeDescriptor archetypeDescriptor, List archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, false);
    }

    private void processArchetypeTemplatesWithWarning(ArchetypeDescriptor archetypeDescriptor, List archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, true);
    }

    private void processFileSet(String directory, List fileSetResources, boolean packaged, String packageName, Context context, File outputDirectoryFile, String moduleOffset, String archetypeEncoding, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure {
        Iterator iterator = fileSetResources.iterator();
        while (iterator.hasNext()) {
            String template = (String)iterator.next();
            String templateName = StringUtils.replaceOnce((String)template, (String)directory, (String)"");
            this.processTemplate(new File(outputDirectoryFile, directory + "/" + (packaged ? this.getPackageAsDirectory(packageName) : "") + "/" + templateName.substring(moduleOffset.length())), context, "archetype-resources/" + template, archetypeEncoding, failIfExists);
        }
    }

    private void processFilesetModule(String rootArtifactId, String artifactId, List archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, File basedirPom, File outputDirectoryFile, String packageName, AbstractArchetypeDescriptor archetypeDescriptor, Context context) throws DocumentException, XmlPullParserException, ArchetypeGenerationFailure, InvalidPackaging, IOException, OutputFileExists {
        outputDirectoryFile.mkdirs();
        this.getLogger().debug("Processing " + artifactId);
        this.processFilesetProject(archetypeDescriptor, StringUtils.replace((String)artifactId, (String)"${rootArtifactId}", (String)rootArtifactId), archetypeResources, pom, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile, basedirPom);
        String parentArtifactId = (String)context.get("parentArtifactId");
        Iterator subprojects = archetypeDescriptor.getModules().iterator();
        if (subprojects.hasNext()) {
            this.getLogger().debug(artifactId + " has modules (" + archetypeDescriptor.getModules() + ")");
            this.setParentArtifactId(context, StringUtils.replace((String)artifactId, (String)"${rootArtifactId}", (String)rootArtifactId));
        }
        while (subprojects.hasNext()) {
            ModuleDescriptor project = (ModuleDescriptor)subprojects.next();
            artifactId = project.getId();
            File moduleOutputDirectoryFile = new File(outputDirectoryFile, StringUtils.replace((String)project.getDir(), (String)"${rootArtifactId}", (String)rootArtifactId));
            context.put("artifactId", (Object)StringUtils.replace((String)project.getId(), (String)"${rootArtifactId}", (String)rootArtifactId));
            this.processFilesetModule(rootArtifactId, StringUtils.replace((String)project.getDir(), (String)"${rootArtifactId}", (String)rootArtifactId), archetypeResources, new File(moduleOutputDirectoryFile, "pom.xml"), archetypeZipFile, (StringUtils.isEmpty((String)moduleOffset) ? "" : moduleOffset + "/") + StringUtils.replace((String)project.getDir(), (String)"${rootArtifactId}", (String)rootArtifactId), pom, moduleOutputDirectoryFile, packageName, project, context);
        }
        this.restoreParentArtifactId(context, parentArtifactId);
        this.getLogger().debug("Processed " + artifactId);
    }

    private void processFilesetProject(AbstractArchetypeDescriptor archetypeDescriptor, String moduleId, List archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile, File basedirPom) throws DocumentException, XmlPullParserException, ArchetypeGenerationFailure, InvalidPackaging, IOException, FileNotFoundException, OutputFileExists {
        if (basedirPom.exists()) {
            this.processPomWithParent(context, pom, moduleOffset, basedirPom, moduleId);
        } else {
            this.processPom(context, pom, moduleOffset);
        }
        this.processArchetypeTemplates(archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile);
    }

    private void processPom(Context context, File pom, String moduleOffset) throws OutputFileExists, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
    }

    private void processPomWithMerge(Context context, File pom, String moduleOffset) throws OutputFileExists, IOException, XmlPullParserException, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom + " with merge");
        File temporaryPom = this.getTemporaryFile(pom);
        this.processTemplate(temporaryPom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        this.pomManager.mergePoms(pom, temporaryPom);
        try {
            FileUtils.forceDelete((File)temporaryPom);
        }
        catch (IOException e) {
            temporaryPom.deleteOnExit();
        }
    }

    private void processPomWithParent(Context context, File pom, String moduleOffset, File basedirPom, String moduleId) throws OutputFileExists, XmlPullParserException, DocumentException, IOException, InvalidPackaging, ArchetypeGenerationFailure {
        this.getLogger().debug("Processing pom " + pom + " with parent " + basedirPom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        this.getLogger().debug("Adding module " + moduleId);
        this.pomManager.addModule(basedirPom, moduleId);
        this.pomManager.addParent(pom, basedirPom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTemplate(File outFile, Context context, String templateFileName, String encoding, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure {
        templateFileName = templateFileName.replace(File.separatorChar, '/');
        this.getLogger().debug("Prosessing template " + templateFileName);
        if (failIfExists && outFile.exists()) {
            throw new OutputFileExists("Don't rewrite file " + outFile.getAbsolutePath());
        }
        if (!outFile.exists()) {
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            this.getLogger().debug("Merging into " + outFile);
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), encoding);
                this.velocity.getEngine().mergeTemplate(templateFileName, encoding, context, (Writer)writer);
                ((Writer)writer).flush();
            }
            catch (Exception e) {
                try {
                    throw new ArchetypeGenerationFailure("Error merging velocity templates: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    writer = null;
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            return;
        }
        this.getLogger().warn("PT Don't override file " + outFile);
    }

    private void processTemplates(String packageName, File outputDirectoryFile, Context context, AbstractArchetypeDescriptor archetypeDescriptor, List archetypeResources, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure, FileNotFoundException, IOException {
        Iterator iterator = archetypeDescriptor.getFileSets().iterator();
        if (iterator.hasNext()) {
            this.getLogger().debug("Processing filesets");
        }
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            List fileSetResources = this.archetypeFilesResolver.filterFiles(moduleOffset, fileSet, archetypeResources);
            if (fileSet.isFiltered()) {
                this.getLogger().debug("Processing fileset " + fileSet + "\n\n\n\n" + fileSetResources + "\n\n" + archetypeResources + "\n\n");
                this.processFileSet(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, context, outputDirectoryFile, moduleOffset, this.getEncoding(fileSet.getEncoding()), failIfExists);
                this.getLogger().debug("Processed " + fileSetResources.size() + " files");
                continue;
            }
            this.getLogger().debug("Copying fileset " + fileSet);
            this.copyFiles(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, outputDirectoryFile, archetypeZipFile, moduleOffset, failIfExists);
            this.getLogger().debug("Copied " + fileSetResources.size() + " files");
        }
    }

    private void restoreParentArtifactId(Context context, String parentArtifactId) {
        if (StringUtils.isEmpty((String)parentArtifactId)) {
            context.remove((Object)"parentArtifactId");
        } else {
            context.put("parentArtifactId", (Object)parentArtifactId);
        }
    }

    private File getTemporaryFile(File file) {
        File tmp = FileUtils.createTempFile((String)file.getName(), (String)".tmp", (File)file.getParentFile());
        tmp.deleteOnExit();
        return tmp;
    }
}

