/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

class ConjunctionScorer
extends Scorer {
    private final Scorer[] scorers;
    private boolean firstTime = true;
    private boolean more;
    private final float coord;
    private int lastDoc = -1;

    public ConjunctionScorer(Similarity similarity, Collection scorers) throws IOException {
        this(similarity, scorers.toArray(new Scorer[scorers.size()]));
    }

    public ConjunctionScorer(Similarity similarity, Scorer[] scorers) throws IOException {
        super(similarity);
        this.scorers = scorers;
        this.coord = this.getSimilarity().coord(this.scorers.length, this.scorers.length);
    }

    public int doc() {
        return this.lastDoc;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            return this.init(0);
        }
        if (this.more) {
            this.more = this.scorers[this.scorers.length - 1].next();
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        int first = 0;
        Scorer lastScorer = this.scorers[this.scorers.length - 1];
        while (this.more) {
            Scorer firstScorer = this.scorers[first];
            this.lastDoc = lastScorer.doc();
            if (firstScorer.doc() >= this.lastDoc) break;
            this.more = firstScorer.skipTo(this.lastDoc);
            lastScorer = firstScorer;
            first = first == this.scorers.length - 1 ? 0 : first + 1;
        }
        return this.more;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            return this.init(target);
        }
        if (this.more) {
            this.more = this.scorers[this.scorers.length - 1].skipTo(target);
        }
        return this.doNext();
    }

    private boolean init(int target) throws IOException {
        this.firstTime = false;
        this.more = this.scorers.length > 1;
        for (int i = 0; i < this.scorers.length; ++i) {
            boolean bl = this.more = target == 0 ? this.scorers[i].next() : this.scorers[i].skipTo(target);
            if (this.more) continue;
            return false;
        }
        Arrays.sort(this.scorers, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Scorer)o1).doc() - ((Scorer)o2).doc();
            }
        });
        this.doNext();
        int end = this.scorers.length - 1 - 1;
        for (int i = 0; i < end >> 1; ++i) {
            Scorer tmp = this.scorers[i];
            this.scorers[i] = this.scorers[end - i];
            this.scorers[end - i] = tmp;
        }
        return this.more;
    }

    public float score() throws IOException {
        float sum = 0.0f;
        for (int i = 0; i < this.scorers.length; ++i) {
            sum += this.scorers[i].score();
        }
        return sum * this.coord;
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }
}

