/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.locator.GavHelpedLocator;
import org.sonatype.nexus.index.locator.Locator;
import org.sonatype.nexus.index.locator.MetadataLocator;
import org.sonatype.nexus.index.locator.PomLocator;

@Component(role=ArtifactContextProducer.class)
public class DefaultArtifactContextProducer
implements ArtifactContextProducer {
    private GavHelpedLocator pl = new PomLocator();
    private Locator ml = new MetadataLocator();

    public ArtifactContext getArtifactContext(IndexingContext context, File file) {
        File pom;
        File artifact;
        String repositoryPath = context.getRepository().getAbsolutePath();
        String artifactPath = file.getAbsolutePath();
        if (artifactPath.length() <= repositoryPath.length()) {
            return null;
        }
        if (!this.isIndexable(file)) {
            return null;
        }
        String path = artifactPath.substring(repositoryPath.length() + 1).replace('\\', '/');
        Gav gav = context.getGavCalculator().pathToGav(path);
        if (gav == null) {
            return null;
        }
        String groupId = gav.getGroupId();
        String artifactId = gav.getArtifactId();
        String version = gav.getBaseVersion();
        String classifier = gav.getClassifier();
        ArtifactInfo ai = new ArtifactInfo(context.getRepositoryId(), groupId, artifactId, version, classifier);
        if (!StringUtils.isEmpty((String)ai.classifier)) {
            ai.packaging = gav.getExtension();
        }
        ai.fextension = gav.getExtension();
        ai.fname = file.getName();
        if (file.getName().endsWith(".pom")) {
            artifact = null;
            pom = file;
        } else {
            artifact = file;
            pom = this.pl.locate(file, context.getGavCalculator(), gav);
        }
        File metadata = this.ml.locate(pom);
        return new ArtifactContext(pom, artifact, metadata, ai, gav);
    }

    private boolean isIndexable(File file) {
        if (file == null) {
            return false;
        }
        String filename = file.getName();
        return !filename.startsWith("maven-metadata") && !filename.endsWith(".properties") && !filename.endsWith(".xml") && !filename.endsWith(".asc") && !filename.endsWith(".md5") && !filename.endsWith(".sha1") && (!filename.endsWith(".pom") || !new File(file.getParent(), filename.replaceAll("\\.pom$", ".jar")).exists());
    }
}

