/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.util.Comparator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private final int[] digits;
    public static final Comparator<VersionNumber> DESCENDING = new Comparator<VersionNumber>(){

        @Override
        public int compare(VersionNumber o1, VersionNumber o2) {
            return o2.compareTo(o1);
        }
    };

    public VersionNumber(String num) {
        StringTokenizer tokens = new StringTokenizer(num, ".-");
        this.digits = new int[tokens.countTokens()];
        if (this.digits.length < 2) {
            throw new IllegalArgumentException("No digits: " + num);
        }
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase();
            if (token.equals("*")) {
                this.digits[i++] = 1000;
                continue;
            }
            if (token.equals("alpha")) {
                this.digits[i++] = -2;
                continue;
            }
            if (token.equals("beta")) {
                this.digits[i++] = -1;
                continue;
            }
            if (token.startsWith("ea")) {
                if (token.length() == 2) {
                    this.digits[i++] = -1000;
                    continue;
                }
                this.digits[i++] = -1000 + Integer.parseInt(token.substring(2));
                continue;
            }
            this.digits[i++] = Integer.parseInt(token);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.digits.length; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(Integer.toString(this.digits[i]));
        }
        return buf.toString();
    }

    public boolean isOlderThan(VersionNumber rhs) {
        return this.compareTo(rhs) < 0;
    }

    public boolean isNewerThan(VersionNumber rhs) {
        return this.compareTo(rhs) > 0;
    }

    public boolean equals(Object o) {
        return this.compareTo((VersionNumber)o) == 0;
    }

    public int hashCode() {
        int x = 0;
        for (int i : this.digits) {
            x = x << 1 | i;
        }
        return x;
    }

    @Override
    public int compareTo(VersionNumber rhs) {
        int i = 0;
        while (i != this.digits.length || i != rhs.digits.length) {
            if (i == this.digits.length) {
                return -1;
            }
            if (i == rhs.digits.length) {
                return 1;
            }
            int r = this.digits[i] - rhs.digits[i];
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }
}

