/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.artifact.VersionUtils;
import org.sonatype.nexus.index.ArtifactAvailablility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactInfo
implements Serializable {
    private static final long serialVersionUID = 6028843453477511104L;
    public static final String FS = "|";
    public static final Pattern FS_PATTERN = Pattern.compile(Pattern.quote("|"));
    public static final String NA = "NA";
    public static final String ROOT_GROUPS = "rootGroups";
    public static final String ROOT_GROUPS_VALUE = "rootGroups";
    public static final String ROOT_GROUPS_LIST = "rootGroupsList";
    public static final String ALL_GROUPS = "allGroups";
    public static final String ALL_GROUPS_VALUE = "allGroups";
    public static final String ALL_GROUPS_LIST = "allGroupsList";
    public static final String UINFO = "u";
    public static final String GROUP_ID = "g";
    public static final String ARTIFACT_ID = "a";
    public static final String VERSION = "v";
    public static final String PACKAGING = "p";
    public static final String CLASSIFIER = "l";
    public static final String INFO = "i";
    public static final String NAME = "n";
    public static final String DESCRIPTION = "d";
    public static final String LAST_MODIFIED = "m";
    public static final String SHA1 = "1";
    public static final String NAMES = "c";
    public static final String PLUGIN_PREFIX = "px";
    public static final String PLUGIN_GOALS = "gx";
    public static final String DELETED = "del";
    public static final Comparator<ArtifactInfo> VERSION_COMPARATOR = new VersionComparator();
    public static final Comparator<ArtifactInfo> REPOSITORY_VERSION_COMPARATOR = new RepositoryVersionComparator();
    public String fname;
    public String fextension;
    public String groupId;
    public String artifactId;
    public String version;
    private transient ArtifactVersion artifactVersion;
    public String classifier;
    public String packaging;
    public String name;
    public String description;
    public long lastModified = -1L;
    public long size = -1L;
    public String md5;
    public String sha1;
    public ArtifactAvailablility sourcesExists = ArtifactAvailablility.NOT_PRESENT;
    public ArtifactAvailablility javadocExists = ArtifactAvailablility.NOT_PRESENT;
    public ArtifactAvailablility signatureExists = ArtifactAvailablility.NOT_PRESENT;
    public String classNames;
    public String repository;
    public String path;
    public String remoteUrl;
    public String context;
    public String prefix;
    public List<String> goals;
    private String uinfo = null;

    public ArtifactInfo() {
    }

    public ArtifactInfo(String fname, String fextension, String groupId, String artifactId, String version, String classifier, String packaging, String name, String description, long lastModified, long size, String md5, String sha1, ArtifactAvailablility sourcesExists, ArtifactAvailablility javadocExists, ArtifactAvailablility signatureExists, String repository) {
        this.fname = fname;
        this.fextension = fextension;
        this.version = version;
        this.classifier = classifier;
        this.lastModified = lastModified;
        this.size = size;
        this.md5 = md5;
        this.sha1 = sha1;
        this.sourcesExists = sourcesExists;
        this.javadocExists = javadocExists;
        this.signatureExists = signatureExists;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.repository = repository;
        this.name = name;
        this.description = description;
    }

    public ArtifactInfo(String repository, String groupId, String artifactId, String version, String classifier) {
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public ArtifactVersion getArtifactVersion() {
        if (this.artifactVersion == null) {
            this.artifactVersion = new DefaultArtifactVersion(this.version);
        }
        return this.artifactVersion;
    }

    public String getUinfo() {
        if (this.uinfo == null) {
            this.uinfo = this.groupId + FS + this.artifactId + FS + this.version + FS + ArtifactInfo.nvl(this.classifier) + (StringUtils.isEmpty((String)this.classifier) || StringUtils.isEmpty((String)this.packaging) ? "" : FS + this.packaging);
        }
        return this.uinfo;
    }

    public String getRootGroup() {
        int n = this.groupId.indexOf(46);
        if (n > -1) {
            return this.groupId.substring(0, n);
        }
        return this.groupId;
    }

    public Gav calculateGav() {
        return new Gav(this.groupId, this.artifactId, this.version, this.classifier, this.fextension, null, null, this.fname, VersionUtils.isSnapshot(this.version), false, null, false, null);
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId + ':' + this.version + ':' + this.classifier + ':' + this.packaging;
    }

    public static String nvl(String v) {
        return v == null ? NA : v;
    }

    public static String renvl(String v) {
        return NA.equals(v) ? null : v;
    }

    public static String lst2str(Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append(FS);
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    public static List<String> str2lst(String str) {
        return Arrays.asList(FS_PATTERN.split(str));
    }

    static class RepositoryVersionComparator
    extends VersionComparator {
        RepositoryVersionComparator() {
        }

        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = super.compare(f1, f2);
            if (n != 0) {
                return n;
            }
            String r1 = f1.repository;
            String r2 = f2.repository;
            if (r1 == null) {
                return r2 == null ? 0 : -1;
            }
            return r2 == null ? 1 : r1.compareTo(r2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VersionComparator
    implements Comparator<ArtifactInfo> {
        VersionComparator() {
        }

        @Override
        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = f1.groupId.compareTo(f2.groupId);
            if (n != 0) {
                return n;
            }
            n = f1.artifactId.compareTo(f2.artifactId);
            if (n != 0) {
                return n;
            }
            n = -f1.getArtifactVersion().compareTo((Object)f2.getArtifactVersion());
            if (n != 0) {
                return n;
            }
            String c1 = f1.classifier;
            String c2 = f2.classifier;
            if (c1 == null) {
                if (c2 != null) {
                    return -1;
                }
            } else {
                if (c2 == null) {
                    return 1;
                }
                n = c1.compareTo(c2);
                if (n != 0) {
                    return n;
                }
            }
            String p1 = f1.packaging;
            String p2 = f2.packaging;
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            return p2 == null ? 1 : p1.compareTo(p2);
        }
    }
}

