/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.nexus.index.context.DocumentFilter;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.NexusAnalyzer;
import org.sonatype.nexus.index.context.NexusIndexWriter;
import org.sonatype.nexus.index.incremental.IncrementalHandler;
import org.sonatype.nexus.index.updater.IndexDataReader;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;
import org.sonatype.nexus.index.updater.ResourceFetcher;

@Component(role=IndexUpdater.class)
public class DefaultIndexUpdater
extends AbstractLogEnabled
implements IndexUpdater {
    @Requirement(role=IncrementalHandler.class)
    IncrementalHandler incrementalHandler;
    @Requirement
    private WagonManager wagonManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date fetchAndUpdateIndex(IndexUpdateRequest updateRequest) throws IOException {
        ResourceFetcher fetcher = updateRequest.getResourceFetcher();
        if (fetcher == null) {
            fetcher = new WagonFetcher(this.wagonManager, updateRequest.getTransferListener(), updateRequest.getProxyInfo());
            updateRequest.setResourceFetcher(fetcher);
        }
        IndexingContext context = updateRequest.getIndexingContext();
        fetcher.connect(context.getId(), context.getIndexUpdateUrl());
        try {
            Cloneable localProperties;
            Date contextTimestamp = context.getTimestamp();
            if (contextTimestamp != null && !updateRequest.isForceFullUpdate()) {
                localProperties = this.loadLocallyStoredRemoteProperties(context);
                Properties properties = this.downloadIndexProperties(context, fetcher);
                Date updateTimestamp = this.getTimestamp(properties, "nexus.index.timestamp");
                if (updateTimestamp != null) {
                    List<String> filenames = this.incrementalHandler.loadRemoteIncrementalUpdates(updateRequest, (Properties)localProperties, properties);
                    if (filenames != null) {
                        for (String filename : filenames) {
                            this.loadIndexDirectory(updateRequest, true, filename);
                        }
                        Date date = updateTimestamp;
                        return date;
                    }
                } else {
                    updateTimestamp = this.getTimestamp(properties, "nexus.index.time");
                }
                if (updateTimestamp != null && !updateTimestamp.after(contextTimestamp)) {
                    Date date = null;
                    return date;
                }
            }
            localProperties = this.loadIndexDirectory(updateRequest, false, "nexus-maven-repository-index.gz");
            return localProperties;
        }
        finally {
            fetcher.disconnect();
        }
    }

    public Date fetchAndUpdateIndex(IndexingContext context, TransferListener listener) throws IOException {
        return this.fetchAndUpdateIndex(context, listener, null);
    }

    public Date fetchAndUpdateIndex(IndexingContext context, TransferListener listener, ProxyInfo proxyInfo) throws IOException {
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(context);
        updateRequest.setResourceFetcher(new WagonFetcher(this.wagonManager, listener, proxyInfo));
        return this.fetchAndUpdateIndex(updateRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties fetchIndexProperties(IndexingContext context, ResourceFetcher fetcher) throws IOException {
        fetcher.connect(context.getId(), context.getIndexUpdateUrl());
        try {
            Properties properties = this.downloadIndexProperties(context, fetcher);
            return properties;
        }
        finally {
            fetcher.disconnect();
        }
    }

    public Properties fetchIndexProperties(IndexingContext context, TransferListener listener, ProxyInfo proxyInfo) throws IOException {
        return this.fetchIndexProperties(context, new WagonFetcher(this.wagonManager, listener, proxyInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date loadIndexDirectory(IndexUpdateRequest updateRequest, boolean merge, String remoteIndexFile) throws IOException {
        Date date;
        File indexArchive = File.createTempFile(remoteIndexFile, "");
        File indexDir = new File(indexArchive.getAbsoluteFile().getParentFile(), indexArchive.getName() + ".dir");
        indexDir.mkdirs();
        FSDirectory directory = FSDirectory.getDirectory((File)indexDir);
        BufferedInputStream is = null;
        try {
            updateRequest.getResourceFetcher().retrieve(remoteIndexFile, indexArchive);
            Date timestamp = null;
            if (indexArchive.length() > 0L) {
                is = new BufferedInputStream(new FileInputStream(indexArchive));
                timestamp = remoteIndexFile.endsWith(".gz") ? DefaultIndexUpdater.unpackIndexData(is, (Directory)directory, updateRequest.getIndexingContext()) : DefaultIndexUpdater.unpackIndexArchive(is, (Directory)directory, updateRequest.getIndexingContext());
            }
            if (updateRequest.getDocumentFilter() != null) {
                DefaultIndexUpdater.filterDirectory((Directory)directory, updateRequest.getDocumentFilter());
            }
            if (merge) {
                updateRequest.getIndexingContext().merge((Directory)directory);
            } else {
                updateRequest.getIndexingContext().replace((Directory)directory);
            }
            date = timestamp;
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            indexArchive.delete();
            if (directory != null) {
                directory.close();
            }
            try {
                FileUtils.deleteDirectory((File)indexDir);
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        IOUtil.close((InputStream)is);
        indexArchive.delete();
        if (directory != null) {
            directory.close();
        }
        try {
            FileUtils.deleteDirectory((File)indexDir);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date unpackIndexArchive(InputStream is, Directory directory, IndexingContext context) throws IOException {
        File indexArchive = File.createTempFile("nexus-index", "");
        File indexDir = new File(indexArchive.getAbsoluteFile().getParentFile(), indexArchive.getName() + ".dir");
        indexDir.mkdirs();
        FSDirectory fdir = FSDirectory.getDirectory((File)indexDir);
        try {
            DefaultIndexUpdater.unpackDirectory((Directory)fdir, is);
            DefaultIndexUpdater.copyUpdatedDocuments((Directory)fdir, directory, context);
            Date timestamp = IndexUtils.getTimestamp((Directory)fdir);
            IndexUtils.updateTimestamp(directory, timestamp);
            Date date = timestamp;
            return date;
        }
        finally {
            IndexUtils.close((Directory)fdir);
            indexArchive.delete();
            IndexUtils.delete(indexDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackDirectory(Directory directory, InputStream is) throws IOException {
        byte[] buf = new byte[4096];
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || entry.getName().indexOf(47) > -1) continue;
                IndexOutput io = directory.createOutput(entry.getName());
                try {
                    int n = 0;
                    while ((n = zis.read(buf)) != -1) {
                        io.writeBytes(buf, n);
                    }
                }
                finally {
                    IndexUtils.close(io);
                }
            }
        }
        catch (Throwable throwable) {
            IndexUtils.close(zis);
            throw throwable;
        }
        IndexUtils.close(zis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyUpdatedDocuments(Directory sourcedir, Directory targetdir, IndexingContext context) throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriter w = null;
        IndexReader r = null;
        try {
            r = IndexReader.open((Directory)sourcedir);
            w = new IndexWriter(targetdir, false, (Analyzer)new NexusAnalyzer(), true);
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (r.isDeleted(i)) continue;
                w.addDocument(IndexUtils.updateDocument(r.document(i), context));
            }
            w.optimize();
            w.flush();
        }
        catch (Throwable throwable) {
            IndexUtils.close(w);
            IndexUtils.close(r);
            throw throwable;
        }
        IndexUtils.close(w);
        IndexUtils.close(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterDirectory(Directory directory, DocumentFilter filter) throws IOException {
        IndexReader r = null;
        try {
            r = IndexReader.open((Directory)directory);
            int numDocs = r.numDocs();
            for (int i = 0; i < numDocs; ++i) {
                Document d;
                if (r.isDeleted(i) || filter.accept(d = r.document(i))) continue;
                r.deleteDocument(i);
            }
        }
        finally {
            IndexUtils.close(r);
        }
        IndexWriter w = null;
        try {
            w = new IndexWriter(directory, (Analyzer)new NexusAnalyzer());
            w.optimize();
            w.flush();
        }
        catch (Throwable throwable) {
            IndexUtils.close(w);
            throw throwable;
        }
        IndexUtils.close(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadLocallyStoredRemoteProperties(IndexingContext context) {
        Properties properties;
        String remoteIndexProperties = "nexus-maven-repository-index.properties";
        File indexProperties = new File(context.getIndexDirectoryFile(), remoteIndexProperties);
        FileInputStream fis = null;
        try {
            Properties properties2 = new Properties();
            fis = new FileInputStream(indexProperties);
            properties2.load(fis);
            properties = properties2;
        }
        catch (IOException e) {
            try {
                this.getLogger().debug("Unable to read remote properties stored locally", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
            IOUtil.close((InputStream)fis);
            return null;
        }
        IOUtil.close((InputStream)fis);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties downloadIndexProperties(IndexingContext context, ResourceFetcher fetcher) throws IOException {
        Properties properties;
        String remoteIndexProperties = "nexus-maven-repository-index.properties";
        File indexProperties = new File(context.getIndexDirectoryFile(), remoteIndexProperties);
        FileInputStream fis = null;
        try {
            fetcher.retrieve(remoteIndexProperties, indexProperties);
            Properties properties2 = new Properties();
            fis = new FileInputStream(indexProperties);
            properties2.load(fis);
            properties = properties2;
        }
        catch (Throwable throwable) {
            IOUtil.close(fis);
            throw throwable;
        }
        IOUtil.close((InputStream)fis);
        return properties;
    }

    public Date getTimestamp(Properties properties, String key) {
        String indexTimestamp = properties.getProperty(key);
        if (indexTimestamp != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(indexTimestamp);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date unpackIndexData(InputStream is, Directory d, IndexingContext context) throws IOException {
        NexusIndexWriter w = new NexusIndexWriter(d, new NexusAnalyzer(), true);
        try {
            IndexDataReader dr = new IndexDataReader(is);
            IndexDataReader.IndexDataReadResult result = dr.readIndex(w, context);
            Date date = result.getTimestamp();
            return date;
        }
        finally {
            IndexUtils.close(w);
        }
    }

    public static class WagonFetcher
    implements ResourceFetcher {
        private final WagonManager wagonManager;
        private final TransferListener listener;
        private final ProxyInfo proxyInfo;
        private Wagon wagon = null;

        public WagonFetcher(WagonManager wagonManager, TransferListener listener, ProxyInfo proxyInfo) {
            this.wagonManager = wagonManager;
            this.listener = listener;
            this.proxyInfo = proxyInfo;
        }

        public void connect(String id, String url) throws IOException {
            Repository repository = new Repository(id, url);
            try {
                this.wagon = this.wagonManager.getWagon(repository);
                if (this.listener != null) {
                    this.wagon.addTransferListener(this.listener);
                }
                if (this.proxyInfo != null) {
                    this.wagon.connect(repository, this.proxyInfo);
                } else {
                    this.wagon.connect(repository);
                }
            }
            catch (AuthenticationException ex) {
                String msg = "Authentication exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg);
            }
            catch (WagonException ex) {
                String msg = "Wagon exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg);
            }
        }

        public void disconnect() {
            if (this.wagon != null) {
                try {
                    this.wagon.disconnect();
                }
                catch (ConnectionException ex) {
                    this.logError("Failed to close connection", (Exception)((Object)ex));
                }
            }
        }

        public void retrieve(String name, File targetFile) throws IOException, FileNotFoundException {
            try {
                this.wagon.get(name, targetFile);
            }
            catch (AuthorizationException e) {
                String msg = "Authorization exception retrieving " + name;
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg);
            }
            catch (ResourceDoesNotExistException e) {
                String msg = "Resource " + name + " does not exist";
                this.logError(msg, (Exception)((Object)e));
                throw new FileNotFoundException(msg);
            }
            catch (WagonException e) {
                String msg = "Transfer for " + name + " failed";
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg + "; " + e.getMessage());
            }
        }

        private void logError(String msg, Exception ex) {
            if (this.listener != null) {
                this.listener.debug(msg + "; " + ex.getMessage());
            }
        }
    }
}

