/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.old.ArchetypeDescriptorException;
import org.apache.maven.archetype.old.ArchetypeNotFoundException;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DefaultOldArchetype
extends AbstractLogEnabled
implements OldArchetype {
    private static final String DEFAULT_TEST_RESOURCE_DIR = "/src/test/resources";
    private static final String DEFAULT_TEST_SOURCE_DIR = "/src/test/java";
    private static final String DEFAULT_RESOURCE_DIR = "/src/main/resources";
    private static final String DEFAULT_SOURCE_DIR = "/src/main/java";
    private VelocityComponent velocity;
    private Downloader downloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List remoteRepositories, Map parameters) throws ArchetypeNotFoundException, ArchetypeDescriptorException, ArchetypeTemplateProcessingException {
        FileReader fileReader;
        File pomFile;
        boolean creating;
        File outputDirectoryFile;
        ArchetypeDescriptor descriptor;
        URLClassLoader archetypeJarLoader;
        File archetype;
        try {
            archetype = this.downloader.download(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetypeRepository, localRepository, remoteRepositories);
        }
        catch (DownloadException e) {
            throw new ArchetypeDescriptorException("Error attempting to download archetype.", e);
        }
        catch (DownloadNotFoundException e) {
            throw new ArchetypeNotFoundException("OldArchetype does not exist.", e);
        }
        if (this.getLogger().isInfoEnabled()) {
            if (!parameters.isEmpty()) {
                this.getLogger().info("----------------------------------------------------------------------------");
                this.getLogger().info("Using following parameters for creating OldArchetype: " + archetypeArtifactId + ":" + archetypeVersion);
                this.getLogger().info("----------------------------------------------------------------------------");
                Set keys = parameters.keySet();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String parameterName = (String)it.next();
                    String parameterValue = (String)parameters.get(parameterName);
                    this.getLogger().info("Parameter: " + parameterName + ", Value: " + parameterValue);
                }
            } else {
                this.getLogger().info("No Parameters found for creating OldArchetype");
            }
        }
        ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
        try {
            URL[] urls = new URL[]{archetype.toURL()};
            archetypeJarLoader = new URLClassLoader(urls);
            InputStream is = this.getStream("META-INF/maven/archetype.xml", archetypeJarLoader);
            if (is == null && (is = this.getStream("META-INF/archetype.xml", archetypeJarLoader)) == null) {
                throw new ArchetypeDescriptorException("The META-INF/maven/archetype.xml descriptor cannot be found.");
            }
            descriptor = builder.build(new InputStreamReader(is));
        }
        catch (IOException e) {
            throw new ArchetypeDescriptorException("Error reading the META-INF/maven/archetype.xml descriptor.", e);
        }
        catch (XmlPullParserException e) {
            throw new ArchetypeDescriptorException("Error reading the META-INF/maven/archetype.xml descriptor.", e);
        }
        String basedir = (String)parameters.get("basedir");
        String artifactId = (String)parameters.get("artifactId");
        File parentPomFile = new File(basedir, "pom.xml");
        if (parentPomFile.exists() && descriptor.isAllowPartial() && artifactId == null) {
            outputDirectoryFile = new File(basedir);
            creating = false;
            pomFile = parentPomFile;
        } else {
            if (artifactId == null) {
                throw new ArchetypeTemplateProcessingException("Artifact ID must be specified when creating a new project from an archetype.");
            }
            outputDirectoryFile = new File(basedir, artifactId);
            creating = true;
            if (outputDirectoryFile.exists()) {
                if (!descriptor.isAllowPartial()) {
                    throw new ArchetypeTemplateProcessingException(outputDirectoryFile.getName() + " already exists - please run from a clean directory");
                }
                creating = false;
            }
            pomFile = new File(outputDirectoryFile, "pom.xml");
        }
        if (creating) {
            if (parameters.get("groupId") == null) {
                throw new ArchetypeTemplateProcessingException("Group ID must be specified when creating a new project from an archetype.");
            }
            if (parameters.get("version") == null) {
                throw new ArchetypeTemplateProcessingException("Version must be specified when creating a new project from an archetype.");
            }
        }
        String outputDirectory = outputDirectoryFile.getAbsolutePath();
        String packageName = (String)parameters.get("package");
        VelocityContext context = new VelocityContext();
        context.put("package", (Object)packageName);
        Iterator iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = parameters.get(key);
            context.put(key, value);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(archetypeJarLoader);
        Model parentModel = null;
        if (creating && parentPomFile.exists()) {
            fileReader = null;
            try {
                fileReader = new FileReader(parentPomFile);
                MavenXpp3Reader reader = new MavenXpp3Reader();
                parentModel = reader.read((Reader)fileReader);
                if (!"pom".equals(parentModel.getPackaging())) {
                    throw new ArchetypeTemplateProcessingException("Unable to add module to the current project as it is not of packaging type 'pom'");
                }
            }
            catch (IOException e) {
                try {
                    throw new ArchetypeTemplateProcessingException("Unable to read parent POM", e);
                    catch (XmlPullParserException e2) {
                        throw new ArchetypeTemplateProcessingException("Unable to read parent POM", e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileReader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)fileReader);
            parentModel.getModules().add(artifactId);
        }
        try {
            this.processTemplates(pomFile, outputDirectory, (Context)context, descriptor, packageName, parentModel);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (parentModel != null) {
            boolean added;
            fileReader = null;
            StringWriter w = new StringWriter();
            try {
                fileReader = new FileReader(parentPomFile);
                added = DefaultOldArchetype.addModuleToParentPom(artifactId, fileReader, w);
            }
            catch (IOException e) {
                throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
            }
            catch (DocumentException e) {
                throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
            }
            finally {
                IOUtil.close((Reader)fileReader);
            }
            if (added) {
                try {
                    FileUtils.fileWrite((String)parentPomFile.getAbsolutePath(), (String)w.toString());
                }
                catch (IOException e) {
                    throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
                }
            }
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("OldArchetype created in dir: " + outputDirectory);
        }
    }

    static boolean addModuleToParentPom(String artifactId, Reader fileReader, Writer fileWriter) throws DocumentException, IOException, ArchetypeTemplateProcessingException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(fileReader);
        Element project = document.getRootElement();
        String packaging = null;
        Element packagingElement = project.element("packaging");
        if (packagingElement != null) {
            packaging = packagingElement.getStringValue();
        }
        if (!"pom".equals(packaging)) {
            throw new ArchetypeTemplateProcessingException("Unable to add module to the current project as it is not of packaging type 'pom'");
        }
        Element modules = project.element("modules");
        if (modules == null) {
            modules = project.addText("  ").addElement("modules");
            modules.setText("\n  ");
            project.addText("\n");
        }
        boolean found = false;
        Iterator i = modules.elementIterator("module");
        while (i.hasNext() && !found) {
            Element module = (Element)i.next();
            if (!module.getText().equals(artifactId)) continue;
            found = true;
        }
        if (!found) {
            Node lastTextNode = null;
            Iterator i2 = modules.nodeIterator();
            while (i2.hasNext()) {
                Node node = (Node)i2.next();
                if (node.getNodeType() == 1) {
                    lastTextNode = null;
                    continue;
                }
                if (node.getNodeType() != 3) continue;
                lastTextNode = node;
            }
            if (lastTextNode != null) {
                modules.remove(lastTextNode);
            }
            modules.addText("\n    ");
            modules.addElement("module").setText(artifactId);
            modules.addText("\n  ");
            XMLWriter writer = new XMLWriter(fileWriter);
            writer.write(document);
        }
        return !found;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTemplates(File pomFile, String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, Model parentModel) throws ArchetypeTemplateProcessingException {
        Resource resource;
        boolean foundBuildElement;
        Model generatedModel;
        if (!pomFile.exists()) {
            this.processTemplate(outputDirectory, context, "pom.xml", new TemplateDescriptor(), false, null);
        }
        FileReader pomReader = null;
        try {
            pomReader = new FileReader(pomFile);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            generatedModel = reader.read((Reader)pomReader);
        }
        catch (IOException e) {
            try {
                throw new ArchetypeTemplateProcessingException("Error reading POM", e);
                catch (XmlPullParserException e2) {
                    throw new ArchetypeTemplateProcessingException("Error reading POM", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(pomReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)pomReader);
        if (parentModel != null) {
            Parent parent = new Parent();
            parent.setGroupId(parentModel.getGroupId());
            if (parent.getGroupId() == null) {
                parent.setGroupId(parentModel.getParent().getGroupId());
            }
            parent.setArtifactId(parentModel.getArtifactId());
            parent.setVersion(parentModel.getVersion());
            if (parent.getVersion() == null) {
                parent.setVersion(parentModel.getParent().getVersion());
            }
            generatedModel.setParent(parent);
            FileWriter pomWriter = null;
            try {
                pomWriter = new FileWriter(pomFile);
                MavenXpp3Writer writer = new MavenXpp3Writer();
                writer.write((Writer)pomWriter, generatedModel);
            }
            catch (IOException e) {
                try {
                    throw new ArchetypeTemplateProcessingException("Error rewriting POM", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(pomWriter);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)pomWriter);
        }
        Build build = generatedModel.getBuild();
        boolean overrideSrcDir = false;
        boolean overrideResourceDir = false;
        boolean overrideTestSrcDir = false;
        boolean overrideTestResourceDir = false;
        boolean bl = foundBuildElement = build != null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("********************* Debug info for resources created from generated Model ***********************");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Was build element found in generated POM?: " + foundBuildElement);
        }
        if (foundBuildElement && null != build.getSourceDirectory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Overriding default source directory ");
            }
            overrideSrcDir = true;
            String srcDirectory = build.getSourceDirectory();
            srcDirectory = StringUtils.replace((String)srcDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, srcDirectory));
        }
        if (foundBuildElement && null != build.getScriptSourceDirectory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Overriding default script source directory ");
            }
            String scriptSourceDirectory = build.getScriptSourceDirectory();
            scriptSourceDirectory = StringUtils.replace((String)scriptSourceDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, scriptSourceDirectory));
        }
        if (foundBuildElement && build.getResources().size() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().info("Overriding default resource directory ");
            }
            overrideResourceDir = true;
            Iterator resourceItr = build.getResources().iterator();
            while (resourceItr.hasNext()) {
                resource = (Resource)resourceItr.next();
                String resourceDirectory = resource.getDirectory();
                resourceDirectory = StringUtils.replace((String)resourceDirectory, (String)"\\", (String)"/");
                FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, resourceDirectory));
            }
        }
        if (foundBuildElement && null != build.getTestSourceDirectory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Overriding default test directory ");
            }
            overrideTestSrcDir = true;
            String testDirectory = build.getTestSourceDirectory();
            testDirectory = StringUtils.replace((String)testDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, testDirectory));
        }
        if (foundBuildElement && build.getTestResources().size() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Overriding default test resource directory ");
            }
            overrideTestResourceDir = true;
            Iterator testResourceItr = build.getTestResources().iterator();
            while (testResourceItr.hasNext()) {
                resource = (Resource)testResourceItr.next();
                String testResourceDirectory = resource.getDirectory();
                testResourceDirectory = StringUtils.replace((String)testResourceDirectory, (String)"\\", (String)"/");
                FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, testResourceDirectory));
            }
        }
        this.getLogger().info("********************* End of debug info from resources from generated POM ***********************");
        if (descriptor.getSources().size() > 0) {
            if (!overrideSrcDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_SOURCE_DIR));
                this.processSources(outputDirectory, context, descriptor, packageName, DEFAULT_SOURCE_DIR);
            } else {
                this.processSources(outputDirectory, context, descriptor, packageName, build.getSourceDirectory());
            }
        }
        if (descriptor.getResources().size() > 0) {
            if (!overrideResourceDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_RESOURCE_DIR));
            }
            this.processResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getTestSources().size() > 0) {
            if (!overrideTestSrcDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_TEST_SOURCE_DIR));
                this.processTestSources(outputDirectory, context, descriptor, packageName, DEFAULT_TEST_SOURCE_DIR);
            } else {
                this.processTestSources(outputDirectory, context, descriptor, packageName, build.getTestSourceDirectory());
            }
        }
        if (descriptor.getTestResources().size() > 0) {
            if (!overrideTestResourceDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_TEST_RESOURCE_DIR));
            }
            this.processTestResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getSiteResources().size() > 0) {
            this.processSiteResources(outputDirectory, context, descriptor, packageName);
        }
    }

    private void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName) throws ArchetypeTemplateProcessingException {
        this.processTemplate(outputDirectory, context, template, descriptor, packageInFileName, packageName, null);
    }

    private String getOutputDirectory(String outputDirectory, String testResourceDirectory) {
        return outputDirectory + (testResourceDirectory.startsWith("/") ? testResourceDirectory : "/" + testResourceDirectory);
    }

    protected void processSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String sourceDirectory) throws ArchetypeTemplateProcessingException {
        Iterator i = descriptor.getSources().iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            this.processTemplate(outputDirectory, context, template, descriptor.getSourceDescriptor(template), true, packageName, sourceDirectory);
        }
    }

    protected void processTestSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String testSourceDirectory) throws ArchetypeTemplateProcessingException {
        Iterator i = descriptor.getTestSources().iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            this.processTemplate(outputDirectory, context, template, descriptor.getTestSourceDescriptor(template), true, packageName, testSourceDirectory);
        }
    }

    protected void processResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        Iterator i = descriptor.getResources().iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            this.processTemplate(outputDirectory, context, template, descriptor.getResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTestResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        Iterator i = descriptor.getTestResources().iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            this.processTemplate(outputDirectory, context, template, descriptor.getTestResourceDescriptor(template), false, packageName);
        }
    }

    protected void processSiteResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws ArchetypeTemplateProcessingException {
        Iterator i = descriptor.getSiteResources().iterator();
        while (i.hasNext()) {
            String template = (String)i.next();
            this.processTemplate(outputDirectory, context, template, descriptor.getSiteResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName, String sourceDirectory) throws ArchetypeTemplateProcessingException {
        block16: {
            File f;
            block15: {
                template = StringUtils.replace((String)template, (String)"\\", (String)"/");
                if (packageInFileName && packageName != null) {
                    String templateFileName = StringUtils.replace((String)template, (String)"/", (String)File.separator);
                    String path = packageName.replace('.', '/');
                    String filename = FileUtils.filename((String)templateFileName);
                    String dirname = FileUtils.dirname((String)templateFileName).replace('\\', '/');
                    if ((sourceDirectory = sourceDirectory.replace('\\', '/')).startsWith("/")) {
                        sourceDirectory = sourceDirectory.substring(1);
                    }
                    if (!dirname.startsWith(sourceDirectory)) {
                        throw new ArchetypeTemplateProcessingException("Template '" + template + "' not in directory '" + sourceDirectory + "'");
                    }
                    String extraPackages = dirname.substring(sourceDirectory.length());
                    if (extraPackages.startsWith("/")) {
                        extraPackages = extraPackages.substring(1);
                    }
                    if (extraPackages.length() > 0) {
                        path = path + "/" + extraPackages;
                    }
                    f = new File(new File(new File(outputDirectory, sourceDirectory), path), filename);
                } else {
                    f = new File(outputDirectory, template);
                }
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                if (!descriptor.isFiltered()) break block15;
                OutputStreamWriter writer = null;
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), descriptor.getEncoding());
                    template = "archetype-resources/" + template;
                    this.velocity.getEngine().mergeTemplate(template, descriptor.getEncoding(), context, (Writer)writer);
                    ((Writer)writer).flush();
                }
                catch (Exception e) {
                    try {
                        throw new ArchetypeTemplateProcessingException("Error merging velocity templates", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        throw throwable;
                    }
                }
                IOUtil.close((Writer)writer);
                break block16;
            }
            InputStream is = this.getStream("archetype-resources/" + template, null);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                IOUtil.copy((InputStream)is, (OutputStream)fos);
            }
            catch (Exception e) {
                try {
                    throw new ArchetypeTemplateProcessingException("Error copying file", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(fos);
                    IOUtil.close((InputStream)is);
                    throw throwable;
                }
            }
            IOUtil.close((OutputStream)fos);
            IOUtil.close((InputStream)is);
        }
    }

    protected void createProjectDirectoryStructure(String outputDirectory) {
    }

    private InputStream getStream(String name, ClassLoader loader) {
        if (loader == null) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }
}

