/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableBiMapBuilder<K, V> {
    private BiMap<K, V> biMap;

    public ImmutableBiMapBuilder() {
        this(8);
    }

    public ImmutableBiMapBuilder(int expectedSize) {
        this.biMap = new HashBiMap(expectedSize);
    }

    public ImmutableBiMapBuilder<K, V> put(@Nullable K key, @Nullable V value) {
        Preconditions.checkState(this.biMap != null, "bimap has already been created");
        this.biMap.put(key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiMap<K, V> getBiMap() {
        Preconditions.checkState(this.biMap != null, "bimap has already been created");
        try {
            BiMap<K, V> biMap = Maps.unmodifiableBiMap(this.biMap);
            return biMap;
        }
        finally {
            this.biMap = null;
        }
    }
}

