/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jvnet.hudson.update_center.DefaultArtifactTransformationManager;
import org.jvnet.hudson.update_center.HPI;
import org.jvnet.hudson.update_center.HudsonWar;
import org.jvnet.hudson.update_center.PluginHistory;
import org.jvnet.hudson.update_center.VersionNumber;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRepository {
    private final NexusIndexer indexer;
    private final ArtifactFactory af;
    private final ArtifactResolver ar;
    private final List<ArtifactRepository> remoteRepositories;
    private final ArtifactRepository local;

    public MavenRepository() throws Exception {
        this("java.net2", new URL("http://download.java.net/maven/2/"));
    }

    public MavenRepository(String id, File indexDirectory, URL repository) throws Exception {
        ClassWorld classWorld = new ClassWorld("plexus.core", MavenRepository.class.getClassLoader());
        ContainerConfiguration configuration = new DefaultContainerConfiguration().setClassWorld(classWorld);
        DefaultPlexusContainer plexus = new DefaultPlexusContainer(configuration);
        plexus.getComponentDescriptor(ArtifactTransformationManager.class, ArtifactTransformationManager.class.getName(), "default").setImplementationClass(DefaultArtifactTransformationManager.class);
        this.indexer = (NexusIndexer)plexus.lookup(NexusIndexer.class);
        this.indexer.addIndexingContext(id, id, null, indexDirectory, null, null, NexusIndexer.DEFAULT_INDEX);
        this.af = (ArtifactFactory)plexus.lookup(ArtifactFactory.class);
        this.ar = (ArtifactResolver)plexus.lookup(ArtifactResolver.class);
        ArtifactRepositoryFactory arf = (ArtifactRepositoryFactory)plexus.lookup(ArtifactRepositoryFactory.class);
        ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "daily", "warn");
        this.remoteRepositories = Collections.singletonList(arf.createArtifactRepository(id, repository.toExternalForm(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), policy, policy));
        this.local = arf.createArtifactRepository("local", new File(new File(System.getProperty("user.home")), ".m2/repository").toURI().toURL().toExternalForm(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), policy, policy);
    }

    public MavenRepository(String id, URL repository) throws Exception {
        this(id, MavenRepository.load(id, new URL(repository, ".index/nexus-maven-repository-index.zip")), repository);
    }

    private static File load(String id, URL url) throws IOException {
        File dir = new File(new File(System.getProperty("java.io.tmpdir")), "maven-index/" + id);
        File zip = new File(dir, "index.zip");
        File expanded = new File(dir, "expanded");
        URLConnection con = url.openConnection();
        if (!expanded.exists() || !zip.exists() || zip.lastModified() != con.getLastModified()) {
            System.out.println("Downloading " + url);
            dir.mkdirs();
            File tmp = new File(dir, "index.zi_");
            FileOutputStream o = new FileOutputStream(tmp);
            IOUtils.copy((InputStream)con.getInputStream(), (OutputStream)o);
            o.close();
            if (expanded.exists()) {
                FileUtils.deleteDirectory((File)expanded);
            }
            expanded.mkdirs();
            Expand e = new Expand();
            e.setSrc(tmp);
            e.setDest(expanded);
            e.execute();
            tmp.renameTo(zip);
            zip.setLastModified(con.getLastModified());
        } else {
            System.out.println("Reusing the locally cached " + url + " at " + zip);
        }
        return expanded;
    }

    File resolve(ArtifactInfo a) throws AbstractArtifactResolutionException {
        return this.resolve(a, a.packaging);
    }

    File resolve(ArtifactInfo a, String type) throws AbstractArtifactResolutionException {
        Artifact artifact = this.af.createArtifact(a.groupId, a.artifactId, a.version, "compile", type);
        this.ar.resolve(artifact, this.remoteRepositories, this.local);
        return artifact.getFile();
    }

    public Collection<PluginHistory> listHudsonPlugins() throws PlexusContainerException, ComponentLookupException, IOException, UnsupportedExistingLuceneIndexException, AbstractArtifactResolutionException {
        BooleanQuery q = new BooleanQuery();
        q.add(this.indexer.constructQuery("p", "hpi"), BooleanClause.Occur.MUST);
        FlatSearchRequest request = new FlatSearchRequest((Query)q);
        FlatSearchResponse response = this.indexer.searchFlat(request);
        TreeMap<String, PluginHistory> plugins = new TreeMap<String, PluginHistory>();
        for (ArtifactInfo a : response.getResults()) {
            if (a.version.contains("SNAPSHOT") || a.artifactId.equals("ivy2") || a.artifactId.equals("ConfigurationSlicing")) continue;
            PluginHistory p = (PluginHistory)plugins.get(a.artifactId);
            if (p == null) {
                p = new PluginHistory(a.artifactId);
                plugins.put(a.artifactId, p);
            }
            p.artifacts.put(new VersionNumber(a.version), this.createHpiArtifact(a, p));
            p.groupId.add(a.groupId);
        }
        return plugins.values();
    }

    public TreeMap<VersionNumber, HudsonWar> getHudsonWar() throws IOException, AbstractArtifactResolutionException {
        BooleanQuery q = new BooleanQuery();
        q.add(this.indexer.constructQuery("g", "org.jvnet.hudson.main"), BooleanClause.Occur.MUST);
        q.add(this.indexer.constructQuery("p", "war"), BooleanClause.Occur.MUST);
        FlatSearchRequest request = new FlatSearchRequest((Query)q);
        FlatSearchResponse response = this.indexer.searchFlat(request);
        TreeMap<VersionNumber, HudsonWar> r = new TreeMap<VersionNumber, HudsonWar>(VersionNumber.DESCENDING);
        for (ArtifactInfo a : response.getResults()) {
            if (a.version.contains("SNAPSHOT") || !a.artifactId.equals("hudson-war") || a.classifier != null) continue;
            VersionNumber v = new VersionNumber(a.version);
            r.put(v, this.createHudsonWarArtifact(a));
        }
        return r;
    }

    protected HPI createHpiArtifact(ArtifactInfo a, PluginHistory p) throws AbstractArtifactResolutionException {
        return new HPI(this, p, a);
    }

    protected HudsonWar createHudsonWarArtifact(ArtifactInfo a) {
        return new HudsonWar(this, a);
    }
}

