/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import hudson.plugins.jira.soap.RemotePage;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.jvnet.hudson.update_center.ConfluencePluginList;
import org.jvnet.hudson.update_center.HPI;

public class Plugin {
    public final String artifactId;
    public final HPI latest;
    public final HPI previous;
    public final RemotePage page;
    public final String[] labels;
    private static final Pattern EXCERPT_PATTERN = Pattern.compile("\\{excerpt(?::hidden(?:=true)?)?\\}\\s*(.+)\\{excerpt\\}", 32);
    private static final Pattern HYPERLINK_PATTERN = Pattern.compile("\\[([^|\\]]+)\\|([^|\\]]+)(|([^]])+)?\\]");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(?:\\r\\n|\\n)");
    private static final Properties OVERRIDES = new Properties();

    public Plugin(String artifactId, HPI latest, HPI previous, ConfluencePluginList cpl) throws IOException {
        this.artifactId = artifactId;
        this.latest = latest;
        this.previous = previous;
        this.page = this.findPage(cpl);
        this.labels = this.getLabels(cpl);
    }

    private RemotePage findPage(ConfluencePluginList cpl) throws IOException {
        try {
            DocumentFactory factory = new DocumentFactory();
            factory.setXPathNamespaceURIs(Collections.singletonMap("m", "http://maven.apache.org/POM/4.0.0"));
            File pom = this.latest.resolvePOM();
            Document dom = new SAXReader(factory).read(pom);
            Node url = dom.selectSingleNode("/project/url");
            if (url == null) {
                url = dom.selectSingleNode("/m:project/m:url");
            }
            if (url != null) {
                String wikiPage = ((Element)url).getTextTrim();
                try {
                    return cpl.getPage(wikiPage);
                }
                catch (RemoteException e) {
                    System.err.println("Failed to fetch " + wikiPage);
                    e.printStackTrace();
                }
            }
        }
        catch (DocumentException e) {
            System.err.println("Can't parse POM for " + this.artifactId);
            e.printStackTrace();
        }
        try {
            String p = OVERRIDES.getProperty(this.artifactId);
            if (p != null) {
                return cpl.getPage(p);
            }
        }
        catch (RemoteException e) {
            System.err.println("Override failed for " + this.artifactId);
            e.printStackTrace();
        }
        try {
            return cpl.findNearest(this.artifactId);
        }
        catch (RemoteException e) {
            System.err.println("Failed to locate nearest");
            e.printStackTrace();
            return null;
        }
    }

    private String[] getLabels(ConfluencePluginList cpl) {
        if (this.page != null) {
            try {
                return cpl.getLabels(this.page);
            }
            catch (RemoteException e) {
                System.err.println("Failed to fetch labels for " + this.page.getUrl());
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getExcerptInHTML() {
        String content = this.page.getContent();
        if (content == null) {
            return null;
        }
        Matcher m = EXCERPT_PATTERN.matcher(content);
        if (!m.find()) {
            return null;
        }
        String excerpt = m.group(1);
        String oneLiner = NEWLINE_PATTERN.matcher(excerpt).replaceAll(" ");
        return HYPERLINK_PATTERN.matcher(oneLiner).replaceAll("<a href='$2'>$1</a>");
    }

    public JSONObject toJSON() throws IOException {
        JSONObject json = this.latest.toJSON(this.artifactId);
        SimpleDateFormat fisheyeDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.00Z'", Locale.US);
        fisheyeDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        json.put("releaseTimestamp", (Object)fisheyeDateFormatter.format(this.latest.getTimestamp()));
        if (this.previous != null) {
            json.put("previousTimestamp", (Object)fisheyeDateFormatter.format(this.previous.getTimestamp()));
        }
        if (this.page != null) {
            json.put("wiki", (Object)this.page.getUrl());
            json.put("title", (Object)this.page.getTitle());
            String excerpt = this.getExcerptInHTML();
            if (excerpt != null) {
                json.put("excerpt", (Object)excerpt);
            }
            if (this.labels != null) {
                json.put("labels", (Object)this.labels);
            }
        }
        HPI hpi = this.latest;
        json.put("requiredCore", (Object)this.fixNull(hpi.getRequiredHudsonVersion()));
        if (hpi.getCompatibleSinceVersion() != null) {
            json.put("compatibleSinceVersion", (Object)hpi.getCompatibleSinceVersion());
        }
        if (hpi.getSandboxStatus() != null) {
            json.put("sandboxStatus", (Object)hpi.getSandboxStatus());
        }
        JSONArray deps = new JSONArray();
        for (HPI.Dependency d : hpi.getDependencies()) {
            deps.add((Object)d.toJSON());
        }
        json.put("dependencies", (Object)deps);
        JSONArray devs = new JSONArray();
        if (!hpi.getDevelopers().isEmpty()) {
            for (HPI.Developer dev : hpi.getDevelopers()) {
                devs.add((Object)dev.toJSON());
            }
        } else {
            try {
                devs.add((Object)new HPI.Developer(" :" + this.latest.getBuiltBy() + ": ").toJSON());
            }
            catch (ParseException e) {
                throw new AssertionError((Object)e);
            }
        }
        json.put("developers", (Object)devs);
        return json;
    }

    private String fixNull(String v) {
        if ("null".equals(v)) {
            return null;
        }
        return v;
    }

    static {
        try {
            OVERRIDES.load(Plugin.class.getClassLoader().getResourceAsStream("wiki-overrides.properties"));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

