/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;

public class UnicodeToHexTransliterator
extends Transliterator {
    private static final String COPYRIGHT = "\u00a9 IBM Corporation 1999. All rights reserved.";
    static final String _ID = "Any-Hex";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char ZERO = '0';
    private static final char POUND = '#';
    private static final char BACKSLASH = '\\';
    private String pattern;
    private String prefix;
    private String suffix;
    private int minDigits;
    private boolean uppercase;

    public UnicodeToHexTransliterator(String pattern, boolean uppercase, UnicodeFilter filter) {
        super(_ID, filter);
        this.uppercase = uppercase;
        this.applyPattern(pattern);
    }

    public UnicodeToHexTransliterator(String pattern) {
        this(pattern, true, null);
    }

    public UnicodeToHexTransliterator() {
        super(_ID, null);
        this.pattern = "\\\\u0000";
        this.prefix = "\\u";
        this.suffix = "";
        this.minDigits = 4;
        this.uppercase = true;
    }

    public void applyPattern(String thePattern) {
        StringBuffer prefixBuf = null;
        StringBuffer suffixBuf = null;
        int minDigits = 0;
        int maxDigits = 0;
        int mode = 0;
        int i = 0;
        while (i < thePattern.length()) {
            char c = thePattern.charAt(i);
            boolean isLiteral = false;
            if (c == '\\') {
                if (i + 1 < thePattern.length()) {
                    isLiteral = true;
                    c = thePattern.charAt(++i);
                } else {
                    throw new IllegalArgumentException("Trailing '\\'");
                }
            }
            if (!isLiteral) {
                switch (c) {
                    case '#': {
                        if (mode == 0) {
                            ++mode;
                        } else if (mode != 1) {
                            throw new IllegalArgumentException("Unquoted '#'");
                        }
                        ++maxDigits;
                        break;
                    }
                    case '0': {
                        if (mode < 2) {
                            mode = 2;
                        } else if (mode != 2) {
                            throw new IllegalArgumentException("Unquoted '0'");
                        }
                        ++minDigits;
                        ++maxDigits;
                        break;
                    }
                    default: {
                        isLiteral = true;
                    }
                }
            }
            if (isLiteral) {
                if (mode == 0) {
                    if (prefixBuf == null) {
                        prefixBuf = new StringBuffer();
                    }
                    prefixBuf.append(c);
                } else {
                    mode = 3;
                    if (suffixBuf == null) {
                        suffixBuf = new StringBuffer();
                    }
                    suffixBuf.append(c);
                }
            }
            ++i;
        }
        if (minDigits < 1 || maxDigits > 4) {
            throw new IllegalArgumentException("Invalid min/max digit count");
        }
        this.pattern = thePattern;
        this.prefix = prefixBuf == null ? "" : prefixBuf.toString();
        this.suffix = suffixBuf == null ? "" : suffixBuf.toString();
        this.minDigits = minDigits;
    }

    public String toPattern() {
        return this.pattern;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    public void setUppercase(boolean outputUppercase) {
        this.uppercase = outputUppercase;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean incremental) {
        int cursor = offsets.start;
        int limit = offsets.limit;
        StringBuffer hex = new StringBuffer(this.prefix);
        int prefixLen = this.prefix.length();
        while (cursor < limit) {
            char c = text.charAt(cursor);
            hex.setLength(prefixLen);
            boolean showRest = false;
            int i = 3;
            while (i >= 0) {
                int d = c >> i * 4 & 0xF;
                if (showRest || d != 0 || this.minDigits > i) {
                    hex.append(HEX_DIGITS[this.uppercase ? d | 0x10 : d]);
                    showRest = true;
                }
                --i;
            }
            hex.append(this.suffix);
            text.replace(cursor, cursor + 1, hex.toString());
            int len = hex.length();
            cursor += len;
            limit += --len;
        }
        offsets.contextLimit += limit - offsets.limit;
        offsets.limit = limit;
        offsets.start = cursor;
    }
}

