/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.StandardListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayListMultimap<K, V>
extends StandardListMultimap<K, V> {
    static final int DEFAULT_CAPACITY = 10;
    final int initialListCapacity;
    private static final long serialVersionUID = -3840170139986607881L;

    public ArrayListMultimap() {
        super(new HashMap());
        this.initialListCapacity = 10;
    }

    public ArrayListMultimap(int distinctKeys, int valuesPerKey) {
        super(new HashMap(Maps.capacity(distinctKeys)));
        Preconditions.checkArgument(valuesPerKey >= 0);
        this.initialListCapacity = valuesPerKey;
    }

    public ArrayListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size(), multimap instanceof ArrayListMultimap ? ((ArrayListMultimap)multimap).initialListCapacity : 10);
        this.putAll((Multimap)multimap);
    }

    @Override
    List<V> createCollection() {
        return new ArrayList(this.initialListCapacity);
    }

    public void trimToSize() {
        for (Collection collection : this.backingMap().values()) {
            ArrayList arrayList = (ArrayList)collection;
            arrayList.trimToSize();
        }
    }
}

