/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.StandardBiMap;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumBiMap<K extends Enum<K>, V extends Enum<V>>
extends StandardBiMap<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;

    public EnumBiMap(Class<K> keyType, Class<V> valueType) {
        super(new EnumMap(keyType), new EnumMap(valueType));
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public EnumBiMap(EnumBiMap<K, V> map) {
        this(map.keyType, map.valueType);
        this.putAll((Map)map);
    }

    public EnumBiMap(Map<K, V> map) {
        this(EnumBiMap.inferKeyType(map), EnumBiMap.inferValueType(map));
        this.putAll((Map)map);
    }

    static <K extends Enum<K>> Class<K> inferKeyType(Map<K, ?> map) {
        if (map instanceof EnumBiMap) {
            return ((EnumBiMap)map).keyType;
        }
        if (map instanceof EnumHashBiMap) {
            return ((EnumHashBiMap)map).keyType;
        }
        Preconditions.checkArgument(!map.isEmpty());
        return ((Enum)map.keySet().iterator().next()).getDeclaringClass();
    }

    private static <V extends Enum<V>> Class<V> inferValueType(Map<?, V> map) {
        if (map instanceof EnumBiMap) {
            return ((EnumBiMap)map).valueType;
        }
        Preconditions.checkArgument(!map.isEmpty());
        return ((Enum)map.values().iterator().next()).getDeclaringClass();
    }

    public Class<K> keyType() {
        return this.keyType;
    }

    public Class<V> valueType() {
        return this.valueType;
    }
}

