/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentCollection<T> {
    protected MutablePlexusContainer container;
    protected final Class<T> componentType;
    protected String role;
    protected List<String> roleHints;
    protected String hostComponent;
    protected Logger logger;
    private List<ClassRealm> realms;
    private int lastRealmCount = -1;
    private Map<String, ComponentDescriptor<T>> componentDescriptorMap;
    private ClassWorld world;

    public AbstractComponentCollection(MutablePlexusContainer container, Class<T> componentType, String role, List<String> roleHints, String hostComponent) {
        this.container = container;
        this.componentType = componentType;
        this.role = role;
        this.roleHints = roleHints;
        this.hostComponent = hostComponent;
        this.logger = container.getLoggerManager().getLoggerForComponent(role);
        this.world = container.getContainerRealm().getWorld();
    }

    private boolean realmsHaveChanged() {
        return this.realms == null || this.world.getRealms().size() != this.lastRealmCount;
    }

    protected Map<String, ComponentDescriptor<T>> getComponentDescriptorMap() {
        this.checkUpdate();
        return this.componentDescriptorMap;
    }

    protected boolean checkUpdate() {
        if (this.componentDescriptorMap != null && !this.realmsHaveChanged()) {
            return false;
        }
        HashMap<String, ComponentDescriptor<T>> newComponentDescriptors = new HashMap<String, ComponentDescriptor<T>>();
        Map<String, ComponentDescriptor<T>> componentMap = this.container.getComponentDescriptorMap(this.componentType, this.role);
        if (this.roleHints != null && !this.roleHints.isEmpty()) {
            for (String roleHint : this.roleHints) {
                ComponentDescriptor<T> componentDescriptor = componentMap.get(roleHint);
                if (componentDescriptor == null) continue;
                newComponentDescriptors.put(roleHint, componentDescriptor);
            }
        } else {
            newComponentDescriptors.putAll(componentMap);
        }
        if (this.componentDescriptorMap == null || newComponentDescriptors.size() != this.componentDescriptorMap.size()) {
            this.componentDescriptorMap = newComponentDescriptors;
            return true;
        }
        return false;
    }

    protected T lookup(String role, String roleHint) {
        try {
            return this.container.lookup(this.componentType, role, roleHint);
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup a member of active collection with role: " + role + " and role-hint: " + roleHint, e);
            return null;
        }
    }

    public void clear() {
        this.releaseAllCallback();
        this.componentDescriptorMap.clear();
        this.componentDescriptorMap = null;
        this.realms = null;
        this.lastRealmCount = -1;
    }

    protected abstract void releaseAllCallback();
}

