/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusXmlComponentDiscoverer
implements ComponentDiscoverer {
    private static final String PLEXUS_XML_RESOURCE = "META-INF/plexus/plexus.xml";
    private ComponentDiscovererManager manager;

    @Override
    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }

    @Override
    public List<ComponentSetDescriptor> findComponents(Context context, ClassRealm realm) throws PlexusConfigurationException {
        PlexusConfiguration configuration = this.discoverConfiguration(context, realm);
        ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors(configuration, realm);
        ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
        this.manager.fireComponentDiscoveryEvent(event);
        return Collections.singletonList(componentSetDescriptor);
    }

    public PlexusConfiguration discoverConfiguration(Context context, ClassRealm realm) throws PlexusConfigurationException {
        Enumeration resources;
        try {
            resources = realm.getParentRealm() != null ? realm.findRealmResources(PLEXUS_XML_RESOURCE) : realm.findResources(PLEXUS_XML_RESOURCE);
        }
        catch (IOException e) {
            throw new PlexusConfigurationException("Error retrieving configuration resources: META-INF/plexus/plexus.xml from class realm: " + realm.getId(), e);
        }
        PlexusConfiguration configuration = null;
        for (URL url : Collections.list(resources)) {
            XmlStreamReader reader = null;
            try {
                reader = ReaderFactory.newXmlReader((InputStream)url.openStream());
                ContextMapAdapter contextAdapter = new ContextMapAdapter(context);
                InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, (Map)contextAdapter);
                PlexusConfiguration discoveredConfig = PlexusTools.buildConfiguration(url.toExternalForm(), (Reader)interpolationFilterReader);
                if (configuration == null) {
                    configuration = discoveredConfig;
                    continue;
                }
                configuration = PlexusConfigurationMerger.merge(configuration, discoveredConfig);
            }
            catch (IOException ex) {
                throw new PlexusConfigurationException("Error reading configuration from: " + url.toExternalForm(), ex);
            }
            finally {
                IOUtil.close((Reader)reader);
            }
        }
        return configuration;
    }

    private ComponentSetDescriptor createComponentDescriptors(PlexusConfiguration configuration, ClassRealm realm) throws PlexusConfigurationException {
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        if (configuration != null) {
            PlexusConfiguration[] componentConfigurations;
            for (PlexusConfiguration componentConfiguration : componentConfigurations = configuration.getChild("components").getChildren("component")) {
                ComponentDescriptor componentDescriptor;
                try {
                    componentDescriptor = PlexusTools.buildComponentDescriptor(componentConfiguration);
                }
                catch (PlexusConfigurationException e) {
                    throw new PlexusConfigurationException("Cannot build component descriptor from resource found in:\n" + Arrays.asList(realm.getURLs()), e);
                }
                componentDescriptor.setComponentType("plexus");
                componentDescriptor.setRealm(realm);
                componentDescriptor.setComponentSetDescriptor(componentSetDescriptor);
                componentSetDescriptor.addComponentDescriptor(componentDescriptor);
            }
        }
        return componentSetDescriptor;
    }
}

