/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import com.sun.xml.bind.v2.util.EditDistance;
import hudson.plugins.jira.soap.ConfluenceSoapService;
import hudson.plugins.jira.soap.RemoteLabel;
import hudson.plugins.jira.soap.RemotePage;
import hudson.plugins.jira.soap.RemotePageSummary;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.jvnet.hudson.confluence.Confluence;

public class ConfluencePluginList {
    private final ConfluenceSoapService service;
    private final Map<String, RemotePageSummary> children = new HashMap<String, RemotePageSummary>();
    private final String[] normalizedTitles;
    private final Map<String, RemotePage> pageCache = new HashMap<String, RemotePage>();
    private final Map<Long, String[]> labelCache = new HashMap<Long, String[]>();
    private static final String[] HUDSON_WIKI_PREFIX = new String[]{"http://hudson.gotdns.com/wiki/display/HUDSON/", "http://wiki.hudson-ci.org/display/HUDSON/"};

    public ConfluencePluginList() throws IOException, ServiceException {
        this.service = Confluence.connect((URL)new URL("http://wiki.hudson-ci.org/"));
        RemotePage page = this.service.getPage("", "HUDSON", "Plugins");
        for (RemotePageSummary child : this.service.getChildren("", page.getId())) {
            this.children.put(this.normalize(child.getTitle()), child);
        }
        this.normalizedTitles = this.children.keySet().toArray(new String[this.children.size()]);
    }

    private String normalize(String title) {
        if ((title = title.toLowerCase().trim()).endsWith("plugin")) {
            title = title.substring(0, title.length() - 6).trim();
        }
        return title.replace(" ", "-");
    }

    public RemotePage findNearest(String pluginArtifactId) throws RemoteException {
        String nearest = EditDistance.findNearest((String)(pluginArtifactId = pluginArtifactId.toLowerCase()), (String[])this.normalizedTitles);
        if (EditDistance.editDistance((String)nearest, (String)pluginArtifactId) < 4) {
            return this.service.getPage("", "HUDSON", this.children.get(nearest).getTitle());
        }
        return null;
    }

    public RemotePage getPage(String url) throws RemoteException {
        for (String p : HUDSON_WIKI_PREFIX) {
            if (!url.startsWith(p)) continue;
            String pageName = url.substring(p.length()).replace('+', ' ');
            RemotePage page = this.pageCache.get(pageName);
            if (page == null) {
                page = this.service.getPage("", "HUDSON", pageName);
                this.pageCache.put(pageName, page);
            }
            return page;
        }
        return null;
    }

    public String[] getLabels(RemotePage page) throws RemoteException {
        String[] r = this.labelCache.get(page.getId());
        if (r == null) {
            RemoteLabel[] labels = this.service.getLabelsById("", page.getId());
            if (labels == null) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>(labels.length);
            for (RemoteLabel label : labels) {
                if (!label.getName().startsWith("plugin-")) continue;
                result.add(label.getName().substring(7));
            }
            r = result.toArray(new String[result.size()]);
            this.labelCache.put(page.getId(), r);
        }
        return r;
    }
}

