/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.jvnet.hudson.update_center.MavenArtifact;
import org.jvnet.hudson.update_center.MavenRepository;
import org.jvnet.hudson.update_center.PluginHistory;
import org.sonatype.nexus.index.ArtifactInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HPI
extends MavenArtifact {
    public final PluginHistory history;

    public HPI(MavenRepository repository, PluginHistory history, ArtifactInfo artifact) throws AbstractArtifactResolutionException {
        super(repository, artifact);
        this.history = history;
    }

    @Override
    public URL getURL() throws MalformedURLException {
        return new URL("http://updates.hudson-labs.org/download/plugins/" + this.artifact.artifactId + "/" + this.version + "/" + this.artifact.artifactId + ".hpi");
    }

    public String getBuiltBy() throws IOException {
        return this.getManifestAttributes().getValue("Built-By");
    }

    public String getRequiredHudsonVersion() throws IOException {
        return this.getManifestAttributes().getValue("Hudson-Version");
    }

    public String getCompatibleSinceVersion() throws IOException {
        return this.getManifestAttributes().getValue("Compatible-Since-Version");
    }

    public String getDisplayName() throws IOException {
        return this.getManifestAttributes().getValue("Long-Name");
    }

    public String getSandboxStatus() throws IOException {
        return this.getManifestAttributes().getValue("Sandbox-Status");
    }

    public List<Dependency> getDependencies() throws IOException {
        String deps = this.getManifestAttributes().getValue("Plugin-Dependencies");
        if (deps == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> r = new ArrayList<Dependency>();
        for (String token : deps.split(",")) {
            r.add(new Dependency(token));
        }
        return r;
    }

    public List<Developer> getDevelopers() throws IOException {
        String devs = this.getManifestAttributes().getValue("Plugin-Developers");
        if (devs == null || devs.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Developer> r = new ArrayList<Developer>();
        for (String token : devs.split(",")) {
            try {
                r.add(new Developer(token));
            }
            catch (ParseException e) {
                System.err.println(e);
            }
        }
        return r;
    }

    public static class Developer {
        public final String name;
        public final String developerId;
        public final String email;

        Developer(String token) throws ParseException {
            String[] pieces = token.split(":", -1);
            if (pieces.length != 3) {
                throw new ParseException("Unexpected developer name: " + token, 0);
            }
            this.name = pieces[0];
            this.developerId = pieces[1];
            this.email = pieces[2];
        }

        public JSONObject toJSON() {
            JSONObject o = new JSONObject();
            if (!this.name.equals("") && !this.name.equals(" ")) {
                o.put("name", (Object)this.name);
            }
            if (!this.developerId.equals("")) {
                o.put("developerId", (Object)this.developerId);
            }
            if (!this.email.equals("") && !this.email.equals(" ")) {
                o.put("email", (Object)this.email);
            }
            if (!o.isEmpty()) {
                return o;
            }
            return null;
        }
    }

    public static class Dependency {
        public final String name;
        public final String version;
        public final boolean optional;
        private static final String OPTIONAL = ";resolution:=optional";

        Dependency(String token) {
            this.optional = token.endsWith(OPTIONAL);
            if (this.optional) {
                token = token.substring(0, token.length() - OPTIONAL.length());
            }
            String[] pieces = token.split(":");
            this.name = pieces[0];
            this.version = pieces[1];
        }

        public JSONObject toJSON() {
            JSONObject o = new JSONObject();
            o.put("name", (Object)this.name);
            o.put("version", (Object)this.version);
            o.put("optional", (Object)this.optional);
            return o;
        }
    }
}

