/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.jvnet.hudson.crypto.CertificateUtil;
import org.jvnet.hudson.crypto.SignatureOutputStream;
import org.jvnet.hudson.update_center.ConfluencePluginList;
import org.jvnet.hudson.update_center.HPI;
import org.jvnet.hudson.update_center.HudsonWar;
import org.jvnet.hudson.update_center.IndexHtmlBuilder;
import org.jvnet.hudson.update_center.MavenArtifact;
import org.jvnet.hudson.update_center.MavenRepository;
import org.jvnet.hudson.update_center.MavenRepositoryImpl;
import org.jvnet.hudson.update_center.Plugin;
import org.jvnet.hudson.update_center.PluginHistory;
import org.jvnet.hudson.update_center.VersionNumber;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    @Option(name="-o", usage="json file")
    public File output = new File("output.json");
    @Option(name="-r", usage="release history JSON file")
    public File releaseHistory = new File("release-history.json");
    @Option(name="-h", usage="htaccess file")
    public File htaccess = new File(".htaccess");
    @Option(name="-download", usage="Build download server layout")
    public File download = null;
    @Option(name="-www", usage="Built hudson-ci.org layout")
    public File www = null;
    @Option(name="-index.html", usage="Update the version number of the latest hudson.war in hudson-ci.org/index.html")
    public File indexHtml = null;
    @Option(name="-key", usage="Private key to sign the update center. Must be used in conjunction with -certificate.")
    public File privateKey = null;
    @Option(name="-certificate", usage="X509 certificate for the private key given by the -key option")
    public List<File> certificates = new ArrayList<File>();
    @Option(name="-id", required=true, usage="Uniquely identifies this update center. We recommend you use a dot-separated name like \"com.sun.wts.hudson\". This value is not exposed to users, but instead internally used by Hudson.")
    public String id;
    @Option(name="-connectionCheckUrl", usage="Specify an URL of the 'always up' server for performing connection check.")
    public String connectionCheckUrl;

    public static void main(String[] args) throws Exception {
        System.exit(new Main().run(args));
    }

    public int run(String[] args) throws Exception {
        CmdLineParser p = new CmdLineParser((Object)this);
        try {
            p.parseArgument(args);
            if (this.www != null) {
                this.output = new File(this.www, "update-center.json");
                this.htaccess = new File(this.www, "latest/.htaccess");
                this.indexHtml = new File(this.www, "index.html");
                this.releaseHistory = new File(this.www, "release-history.json");
            }
            this.run();
            return 0;
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            p.printUsage((OutputStream)System.err);
            return 1;
        }
    }

    public void run() throws Exception {
        MavenRepository repo = this.createRepository();
        this.updateIndexHtml(repo);
        PrintWriter latestRedirect = new PrintWriter((Writer)new FileWriter(this.htaccess), true);
        JSONObject root = new JSONObject();
        root.put("updateCenterVersion", (Object)"1");
        root.put("core", (Object)this.buildCore(repo, latestRedirect));
        root.put("plugins", (Object)this.buildPlugins(repo, latestRedirect));
        root.put("id", (Object)this.id);
        if (this.connectionCheckUrl != null) {
            root.put("connectionCheckUrl", (Object)this.connectionCheckUrl);
        }
        if (this.privateKey != null && !this.certificates.isEmpty()) {
            this.sign(root);
        } else if (this.privateKey != null || !this.certificates.isEmpty()) {
            throw new Exception("private key and certificate must be both specified");
        }
        PrintWriter pw = new PrintWriter(new FileWriter(this.output));
        pw.println("updateCenter.post(");
        pw.println(root.toString(2));
        pw.println(");");
        pw.close();
        JSONObject rhRoot = new JSONObject();
        rhRoot.put("releaseHistory", (Object)this.buildReleaseHistory(repo));
        PrintWriter rhpw = new PrintWriter(new FileWriter(this.releaseHistory));
        rhpw.println(rhRoot.toString(2));
        rhpw.close();
        latestRedirect.close();
    }

    protected MavenRepository createRepository() throws Exception {
        MavenRepositoryImpl r = new MavenRepositoryImpl();
        r.addRemoteRepository("java.net2", new URL("http://cucumber.hudson-labs.org/.index/nexus-maven-repository-index.zip"), new URL("http://maven.dyndns.org/2/"));
        return r;
    }

    private void sign(JSONObject o) throws GeneralSecurityException, IOException {
        JSONObject sign = new JSONObject();
        List<X509Certificate> certs = this.getCertificateChain();
        X509Certificate signer = certs.get(0);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        DigestOutputStream dos = new DigestOutputStream(new NullOutputStream(), sha1);
        PrivateKey key = ((KeyPair)new PEMReader((Reader)new FileReader(this.privateKey)).readObject()).getPrivate();
        Signature sig = Signature.getInstance("SHA1withRSA");
        sig.initSign(key);
        SignatureOutputStream sos = new SignatureOutputStream(sig);
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(signer.getPublicKey());
        SignatureOutputStream vos = new SignatureOutputStream(verifier);
        o.writeCanonical((Writer)new OutputStreamWriter((OutputStream)new TeeOutputStream(new TeeOutputStream(dos, sos), vos), "UTF-8"));
        byte[] digest = sha1.digest();
        sign.put("digest", (Object)new String(Base64.encodeBase64((byte[])digest)));
        byte[] s = sig.sign();
        sign.put("signature", (Object)new String(Base64.encodeBase64((byte[])s)));
        JSONArray a = new JSONArray();
        for (X509Certificate cert : certs) {
            a.add((Object)new String(Base64.encodeBase64((byte[])cert.getEncoded())));
        }
        sign.put("certificates", (Object)a);
        if (!verifier.verify(s)) {
            throw new GeneralSecurityException("Signature failed to validate. Either the certificate and the private key weren't matching, or a bug in the program.");
        }
        o.put("signature", (Object)sign);
    }

    private List<X509Certificate> getCertificateChain() throws FileNotFoundException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (File f : this.certificates) {
            X509Certificate c = (X509Certificate)cf.generateCertificate(new FileInputStream(f));
            c.checkValidity();
            certs.add(c);
        }
        Set<TrustAnchor> rootCAs = CertificateUtil.getDefaultRootCAs();
        rootCAs.add(new TrustAnchor((X509Certificate)cf.generateCertificate(this.getClass().getResourceAsStream("/hudson-community.cert")), null));
        try {
            CertificateUtil.validatePath(certs, rootCAs);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return certs;
    }

    private void updateIndexHtml(MavenRepository repo) throws IOException, AbstractArtifactResolutionException {
        if (this.indexHtml != null) {
            VersionNumber latest = repo.getHudsonWar().firstKey();
            System.out.println("Latest version is " + latest);
            String content = IOUtils.toString(new FileInputStream(this.indexHtml), "UTF-8");
            content = content.replaceFirst("LATEST_VERSION.+/LATEST_VERSION", "LATEST_VERSION-->" + latest + "<!--/LATEST_VERSION");
            FileOutputStream out = new FileOutputStream(this.indexHtml);
            IOUtils.write(content, (OutputStream)out, "UTF-8");
            out.close();
        }
    }

    protected JSONObject buildPlugins(MavenRepository repository, PrintWriter redirect) throws Exception {
        ConfluencePluginList cpl = new ConfluencePluginList();
        JSONObject plugins = new JSONObject();
        for (PluginHistory hpi : repository.listHudsonPlugins()) {
            System.out.println(hpi.artifactId);
            ArrayList<HPI> versions = new ArrayList<HPI>(hpi.artifacts.values());
            HPI latest = (HPI)versions.get(0);
            HPI previous = versions.size() > 1 ? (HPI)versions.get(1) : null;
            Plugin plugin = new Plugin(hpi.artifactId, latest, previous, cpl);
            if (plugin.page != null) {
                System.out.println("=> " + plugin.page.getTitle());
            }
            System.out.println("=> " + plugin.toJSON());
            plugins.put(plugin.artifactId, (Object)plugin.toJSON());
            String permalink = String.format("/latest/%s.hpi", plugin.artifactId);
            redirect.printf("Redirect 302 %s %s\n", permalink, latest.getURL().getPath());
            if (this.download != null) {
                for (HPI v : versions) {
                    this.stage(v, new File(this.download, "plugins/" + hpi.artifactId + "/" + v.version + "/" + hpi.artifactId + ".hpi"));
                }
            }
            if (this.www == null) continue;
            this.buildIndex(new File(this.www, "download/plugins/" + hpi.artifactId), hpi.artifactId, versions, permalink);
        }
        return plugins;
    }

    private void stage(MavenArtifact a, File dst) throws IOException, InterruptedException {
        File src = a.resolve();
        if (dst.exists() && dst.lastModified() == src.lastModified() && dst.length() == src.length()) {
            return;
        }
        dst.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("ln", "-f", src.getAbsolutePath(), dst.getAbsolutePath());
        if (pb.start().waitFor() != 0) {
            throw new IOException("ln failed");
        }
    }

    protected JSONArray buildReleaseHistory(MavenRepository repository) throws Exception {
        ConfluencePluginList cpl = new ConfluencePluginList();
        JSONArray releaseHistory = new JSONArray();
        for (Map.Entry<Date, Map<String, HPI>> relsOnDate : repository.listHudsonPluginsByReleaseDate().entrySet()) {
            String relDate = MavenArtifact.getDateFormat().format(relsOnDate.getKey());
            System.out.println("Releases on " + relDate);
            JSONArray releases = new JSONArray();
            for (Map.Entry<String, HPI> rel : relsOnDate.getValue().entrySet()) {
                HPI h = rel.getValue();
                JSONObject o = new JSONObject();
                try {
                    Plugin plugin = new Plugin(h.artifact.artifactId, h, null, cpl);
                    String title = plugin.getTitle();
                    if (title == null || title.equals("")) {
                        title = h.artifact.artifactId;
                    }
                    o.put("title", (Object)title);
                    o.put("wiki", (Object)plugin.getWiki());
                    o.put("version", (Object)h.version);
                    System.out.println("\t" + title + ":" + h.version);
                }
                catch (IOException e) {
                    System.out.println("Failed to resolve plugin " + h.artifact.artifactId + " so using defaults");
                    o.put("title", (Object)h.artifact.artifactId);
                    o.put("wiki", (Object)"");
                    o.put("version", (Object)h.version);
                }
                releases.add((Object)o);
            }
            JSONObject d = new JSONObject();
            d.put("date", (Object)relDate);
            d.put("releases", (Object)releases);
            releaseHistory.add((Object)d);
        }
        return releaseHistory;
    }

    private void buildIndex(File dir, String title, Collection<? extends MavenArtifact> versions, String permalink) throws IOException {
        ArrayList<? extends MavenArtifact> list = new ArrayList<MavenArtifact>(versions);
        Collections.sort(list, new Comparator<MavenArtifact>(){

            @Override
            public int compare(MavenArtifact o1, MavenArtifact o2) {
                return -o1.getVersion().compareTo(o2.getVersion());
            }
        });
        IndexHtmlBuilder index = new IndexHtmlBuilder(dir, title);
        index.add(permalink, "permalink to the latest");
        for (MavenArtifact mavenArtifact : list) {
            index.add(mavenArtifact);
        }
        index.close();
    }

    private void ln(String from, File to) throws InterruptedException, IOException {
        to.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command("ln", "-sf", from, to.getAbsolutePath());
        if (pb.start().waitFor() != 0) {
            throw new IOException("ln failed");
        }
    }

    protected JSONObject buildCore(MavenRepository repository, PrintWriter redirect) throws Exception {
        TreeMap<VersionNumber, HudsonWar> wars = repository.getHudsonWar();
        HudsonWar latest = wars.get(wars.firstKey());
        JSONObject core = latest.toJSON("core");
        System.out.println("core\n=> " + core);
        redirect.printf("Redirect 302 /latest/hudson.war %s\n", latest.getURL().getPath());
        redirect.printf("Redirect 302 /latest/debian/hudson.deb http://pkg.hudson-labs.org/debian/binary/hudson_%s_all.deb\n", latest.getVersion());
        redirect.printf("Redirect 302 /latest/redhat/hudson.rpm http://pkg.hudson-labs.org/redhat/RPMS/noarch/hudson-%s-1.1.noarch.rpm\n", latest.getVersion());
        redirect.printf("Redirect 302 /latest/opensuse/hudson.rpm http://pkg.hudson-labs.org/opensuse/RPMS/noarch/hudson-%s-1.1.noarch.rpm\n", latest.getVersion());
        if (this.download != null) {
            for (HudsonWar w : wars.values()) {
                this.stage(w, new File(this.download, "war/" + w.version + "/hudson.war"));
            }
        }
        if (this.www != null) {
            this.buildIndex(new File(this.www, "download/war/"), "hudson.war", wars.values(), "/latest/hudson.war");
        }
        return core;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

