/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.sf.json.JSONObject;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.jvnet.hudson.update_center.MavenRepository;
import org.jvnet.hudson.update_center.VersionNumber;
import org.sonatype.nexus.index.ArtifactInfo;

public class MavenArtifact {
    public final MavenRepository repository;
    public final ArtifactInfo artifact;
    public final String version;
    private File hpi;
    private long timestamp;
    private Manifest manifest;

    public MavenArtifact(MavenRepository repository, ArtifactInfo artifact) {
        this.artifact = artifact;
        this.repository = repository;
        this.version = artifact.version;
    }

    public File resolve() throws IOException {
        try {
            if (this.hpi == null) {
                this.hpi = this.repository.resolve(this.artifact);
            }
            return this.hpi;
        }
        catch (AbstractArtifactResolutionException e) {
            throw (IOException)new IOException("Failed to resolve artifact " + this.artifact).initCause(e);
        }
    }

    public File resolvePOM() throws IOException {
        try {
            return this.repository.resolve(this.artifact, "pom");
        }
        catch (AbstractArtifactResolutionException e) {
            throw (IOException)new IOException("Failed to resolve artifact " + this.artifact).initCause(e);
        }
    }

    public JSONObject toJSON(String name) throws IOException {
        JSONObject o = new JSONObject();
        o.put("name", (Object)name);
        o.put("version", (Object)this.version);
        o.put("url", (Object)this.getURL().toExternalForm());
        o.put("buildDate", (Object)this.getTimestampAsString());
        return o;
    }

    public VersionNumber getVersion() {
        return new VersionNumber(this.version);
    }

    public String getTimestampAsString() throws IOException {
        long lastModified = this.getTimestamp();
        SimpleDateFormat bdf = MavenArtifact.getDateFormat();
        return bdf.format(lastModified);
    }

    public Date getTimestampAsDate() throws IOException {
        Date tsDate;
        long lastModified = this.getTimestamp();
        SimpleDateFormat bdf = MavenArtifact.getDateFormat();
        try {
            tsDate = bdf.parse(bdf.format(new Date(lastModified)));
        }
        catch (ParseException pe) {
            throw new IOException(pe.getMessage());
        }
        return tsDate;
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("MMM dd, yyyy", Locale.US);
    }

    public long getTimestamp() throws IOException {
        if (this.timestamp == 0L) {
            this.getManifest();
        }
        return this.timestamp;
    }

    private Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            JarFile jar = new JarFile(this.resolve());
            ZipEntry e = jar.getEntry("META-INF/MANIFEST.MF");
            this.timestamp = e.getTime();
            this.manifest = jar.getManifest();
            jar.close();
        }
        return this.manifest;
    }

    public Attributes getManifestAttributes() throws IOException {
        return this.getManifest().getMainAttributes();
    }

    public URL getURL() throws MalformedURLException {
        return new URL("http://hudson-ci.org/maven-repository/" + this.artifact.groupId.replace('.', '/') + "/" + this.artifact.artifactId + "/" + this.artifact.version + "/" + this.artifact.artifactId + "-" + this.artifact.version + "." + this.artifact.packaging);
    }
}

