/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.update_center;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jvnet.hudson.update_center.HPI;
import org.jvnet.hudson.update_center.HudsonWar;
import org.jvnet.hudson.update_center.PluginHistory;
import org.jvnet.hudson.update_center.VersionNumber;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenRepository {
    public abstract Collection<PluginHistory> listHudsonPlugins() throws PlexusContainerException, ComponentLookupException, IOException, UnsupportedExistingLuceneIndexException, AbstractArtifactResolutionException;

    public Map<Date, Map<String, HPI>> listHudsonPluginsByReleaseDate() throws PlexusContainerException, ComponentLookupException, IOException, UnsupportedExistingLuceneIndexException, AbstractArtifactResolutionException {
        Collection<PluginHistory> all = this.listHudsonPlugins();
        TreeMap<Date, Map<String, HPI>> plugins = new TreeMap<Date, Map<String, HPI>>();
        for (PluginHistory p : all) {
            for (HPI h : p.artifacts.values()) {
                Date releaseDate = h.getTimestampAsDate();
                System.out.println("adding " + h.artifact.artifactId + ":" + h.version);
                TreeMap<String, HPI> pluginsOnDate = (TreeMap<String, HPI>)plugins.get(releaseDate);
                if (pluginsOnDate == null) {
                    pluginsOnDate = new TreeMap<String, HPI>();
                    plugins.put(releaseDate, pluginsOnDate);
                }
                pluginsOnDate.put(p.artifactId, h);
            }
        }
        return plugins;
    }

    public abstract TreeMap<VersionNumber, HudsonWar> getHudsonWar() throws IOException, AbstractArtifactResolutionException;

    protected File resolve(ArtifactInfo a) throws AbstractArtifactResolutionException {
        return this.resolve(a, a.packaging);
    }

    protected abstract File resolve(ArtifactInfo var1, String var2) throws AbstractArtifactResolutionException;
}

