/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cf;

import com.vmware.vim.cf.NullObject;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.util.MorUtil;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedObjectCache
implements Observer {
    private Map<ManagedObjectReference, Map<String, Object>> items;
    private boolean isReady = false;
    private ServiceInstance si;

    ManagedObjectCache(ServiceInstance si) {
        this.si = si;
        this.items = new ConcurrentHashMap<ManagedObjectReference, Map<String, Object>>();
    }

    public Map<ManagedObjectReference, Map<String, Object>> getCachedItems() {
        return this.items;
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg instanceof PropertyFilterUpdate[]) {
            PropertyFilterUpdate[] pfus = (PropertyFilterUpdate[])arg;
            int i = 0;
            while (pfus != null && i < pfus.length) {
                ObjectUpdate[] ous = pfus[i].getObjectSet();
                int j = 0;
                while (ous != null && j < ous.length) {
                    ManagedObjectReference mor = ous[j].getObj();
                    if (!this.items.containsKey(mor)) {
                        this.items.put(mor, new ConcurrentHashMap());
                    }
                    Map<String, Object> moMap = this.items.get(mor);
                    PropertyChange[] pcs = ous[j].getChangeSet();
                    if (pcs != null) {
                        int k = 0;
                        while (k < pcs.length) {
                            Object value = pcs[k].getVal();
                            value = value == null ? NullObject.NULL : value;
                            String propName = pcs[k].getName();
                            if (moMap.containsKey(propName)) {
                                moMap.put(propName, value);
                            } else {
                                String parentPropName = this.getExistingParentPropName(moMap, propName);
                                if (parentPropName != null) {
                                    ManagedObject mo = MorUtil.createExactManagedObject(this.si.getServerConnection(), mor);
                                    moMap.put(parentPropName, mo.getPropertyByPath(parentPropName));
                                } else {
                                    moMap.put(propName, value);
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.isReady = true;
    }

    private String getExistingParentPropName(Map<String, Object> moMap, String propName) {
        int lastDot;
        int pos = propName.indexOf("[");
        if (pos != -1) {
            propName = propName.substring(0, pos);
        }
        do {
            if ((lastDot = propName.lastIndexOf(".")) != -1) continue;
            return null;
        } while (!moMap.containsKey(propName = propName.substring(0, lastDot)));
        return propName;
    }

    public boolean isReady() {
        return this.isReady;
    }
}

