/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.rest;

import com.vmware.vim.rest.ResultConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient {
    private String baseUrl = null;

    static {
        try {
            RestClient.trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception exception) {}
    }

    public RestClient(String serverUrl, String username, String password) {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        } else if (serverUrl.endsWith("/mob")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 4);
        } else if (serverUrl.endsWith("/mob/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 5);
        }
        this.baseUrl = serverUrl;
        this.setLogin(username, password);
    }

    public String get(String urlStr) throws IOException {
        urlStr = this.preProcessUrl(urlStr);
        StringBuffer sb = this.getRawPage(urlStr);
        int start = sb.indexOf("<xml id=\"objData\">");
        int objPos = sb.indexOf("<object>", start);
        sb.replace(objPos, objPos + 8, "<object xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>");
        int end = sb.indexOf("</textarea>", objPos);
        return sb.substring(start, end);
    }

    private String preProcessUrl(String url) {
        if (url == null || url.equals("/")) {
            url = String.valueOf(this.baseUrl) + "/mob";
        } else if (!url.startsWith("http") && !url.startsWith("https")) {
            if (url.startsWith("/mob/?moid=")) {
                url = String.valueOf(this.baseUrl) + url;
            } else if (url.startsWith("moid=")) {
                url = String.valueOf(this.baseUrl) + "/mob/?" + url;
            } else if (url.startsWith("?moid=")) {
                url = String.valueOf(this.baseUrl) + "/mob/" + url;
            }
        }
        return url;
    }

    private StringBuffer getRawPage(String urlStr) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
        conn.connect();
        return this.readStream(conn.getInputStream());
    }

    public String post(String urlStr) throws Exception {
        return this.post(urlStr, new Hashtable<String, String>());
    }

    public String post(String urlStr, Map<String, String> para) throws Exception {
        urlStr = this.preProcessUrl(urlStr);
        HttpURLConnection getCon = (HttpURLConnection)new URL(urlStr).openConnection();
        getCon.connect();
        String cookie = getCon.getHeaderField("Set-Cookie");
        cookie = cookie.substring(0, cookie.indexOf(";"));
        HttpURLConnection postCon = (HttpURLConnection)new URL(urlStr).openConnection();
        postCon.setRequestMethod("POST");
        postCon.setDoOutput(true);
        postCon.setDoInput(true);
        postCon.setRequestProperty("Cookie", cookie);
        OutputStream os = postCon.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os);
        for (String key : para.keySet()) {
            String value = para.get(key);
            key = URLEncoder.encode(key, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            out.write(String.valueOf(key) + "=" + value);
        }
        out.close();
        InputStream is = postCon.getInputStream();
        StringBuffer sb = this.readStream(is);
        String resultFlag = "Method Invocation Result:";
        int start = sb.indexOf(resultFlag);
        String result = sb.substring(start + resultFlag.length());
        return ResultConverter.convert2Xml(result);
    }

    public String getUrlStr() {
        return this.baseUrl;
    }

    private StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        in.close();
        return sb;
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private void setLogin(String username, String password) {
        final String user = username;
        final String pass = password;
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pass.toCharArray());
            }
        });
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

