/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.AuthMinimumAdminPermission;
import com.vmware.vim25.AuthorizationDescription;
import com.vmware.vim25.AuthorizationPrivilege;
import com.vmware.vim25.AuthorizationRole;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.Permission;
import com.vmware.vim25.RemoveFailed;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.UserNotFound;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class AuthorizationManager
extends ManagedObject {
    public AuthorizationManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public AuthorizationDescription getDescription() {
        return (AuthorizationDescription)this.getCurrentProperty("description");
    }

    public AuthorizationPrivilege[] getPrivilegeList() {
        return (AuthorizationPrivilege[])this.getCurrentProperty("privilegeList");
    }

    public AuthorizationRole[] getRoleList() {
        return (AuthorizationRole[])this.getCurrentProperty("roleList");
    }

    public int addAuthorizationRole(String name, String[] privIds) throws InvalidName, AlreadyExists, RuntimeFault, RemoteException {
        return this.getVimService().addAuthorizationRole(this.getMOR(), name, privIds);
    }

    public void mergePermissions(int srcRoleId, int dstRoleId) throws AuthMinimumAdminPermission, NotFound, RuntimeFault, RemoteException {
        this.getVimService().mergePermissions(this.getMOR(), srcRoleId, dstRoleId);
    }

    public void removeAuthorizationRole(int roleId, boolean failIfUsed) throws RemoveFailed, NotFound, RuntimeFault, RemoteException {
        this.getVimService().removeAuthorizationRole(this.getMOR(), roleId, failIfUsed);
    }

    public void removeEntityPermission(ManagedEntity entity, String user, boolean isGroup) throws AuthMinimumAdminPermission, NotFound, RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        this.getVimService().removeEntityPermission(this.getMOR(), entity.getMOR(), user, isGroup);
    }

    public void resetEntityPermissions(ManagedEntity entity, Permission[] permission) throws AuthMinimumAdminPermission, NotFound, UserNotFound, RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        this.getVimService().resetEntityPermissions(this.getMOR(), entity.getMOR(), permission);
    }

    public Permission[] retrieveEntityPermissions(ManagedEntity entity, boolean inherited) throws RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        return this.getVimService().retrieveEntityPermissions(this.getMOR(), entity.getMOR(), inherited);
    }

    public Permission[] retrieveAllPermissions() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveAllPermissions(this.getMOR());
    }

    public Permission[] retrieveRolePermissions(int roleId) throws NotFound, RuntimeFault, RemoteException {
        return this.getVimService().retrieveRolePermissions(this.getMOR(), roleId);
    }

    public void setEntityPermissions(ManagedEntity entity, Permission[] permission) throws AuthMinimumAdminPermission, NotFound, UserNotFound, RuntimeFault, RemoteException {
        if (entity == null) {
            throw new IllegalArgumentException("entity must not be null.");
        }
        this.getVimService().setEntityPermissions(this.getMOR(), entity.getMOR(), permission);
    }

    public void updateAuthorizationRole(int roleId, String newName, String[] privIds) throws InvalidName, AlreadyExists, NotFound, RuntimeFault, RemoteException {
        this.getVimService().updateAuthorizationRole(this.getMOR(), roleId, newName, privIds);
    }
}

