/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.ClusterActionHistory;
import com.vmware.vim25.ClusterConfigInfo;
import com.vmware.vim25.ClusterConfigSpec;
import com.vmware.vim25.ClusterDasAdvancedRuntimeInfo;
import com.vmware.vim25.ClusterDrsFaults;
import com.vmware.vim25.ClusterDrsMigration;
import com.vmware.vim25.ClusterDrsRecommendation;
import com.vmware.vim25.ClusterHostRecommendation;
import com.vmware.vim25.ClusterRecommendation;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.HostConnectFault;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TooManyHosts;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class ClusterComputeResource
extends ComputeResource {
    public ClusterComputeResource(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public ClusterActionHistory[] getActionHistory() {
        return (ClusterActionHistory[])this.getCurrentProperty("actionHistory");
    }

    public ClusterConfigInfo getConfiguration() {
        return (ClusterConfigInfo)this.getCurrentProperty("configuration");
    }

    public ClusterDrsFaults[] getDrsFault() {
        return (ClusterDrsFaults[])this.getCurrentProperty("drsFault");
    }

    public ClusterDrsRecommendation[] getDrsRecommendation() {
        return (ClusterDrsRecommendation[])this.getCurrentProperty("drsRecommendation");
    }

    public ClusterDrsMigration[] getMigrationHistory() {
        return (ClusterDrsMigration[])this.getCurrentProperty("migrationHistory");
    }

    public ClusterRecommendation[] getRecommendation() {
        return (ClusterRecommendation[])this.getCurrentProperty("recommendation");
    }

    public Task addHost_Task(HostConnectSpec spec, boolean asConnected, ResourcePool resourcePool) throws InvalidLogin, HostConnectFault, RuntimeFault, RemoteException {
        return this.addHost_Task(spec, asConnected, resourcePool, null);
    }

    public Task addHost_Task(HostConnectSpec spec, boolean asConnected, ResourcePool resourcePool, String license) throws InvalidLogin, HostConnectFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMOR = this.getVimService().addHost_Task(this.getMOR(), spec, asConnected, resourcePool == null ? null : resourcePool.getMOR(), license);
        return new Task(this.getServerConnection(), taskMOR);
    }

    public void applyRecommendation(String key) throws RuntimeFault, RemoteException {
        this.getVimService().applyRecommendation(this.getMOR(), key);
    }

    public void cancelRecommendation(String key) throws RuntimeFault, RemoteException {
        this.getVimService().cancelRecommendation(this.getMOR(), key);
    }

    public Task moveHostInto_Task(HostSystem host, ResourcePool resourcePool) throws TooManyHosts, InvalidState, RuntimeFault, RemoteException {
        if (host == null) {
            throw new IllegalArgumentException("host must not be null.");
        }
        ManagedObjectReference taskMOR = this.getVimService().moveHostInto_Task(this.getMOR(), host.getMOR(), resourcePool == null ? null : resourcePool.getMOR());
        return new Task(this.getServerConnection(), taskMOR);
    }

    public Task moveInto_Task(HostSystem[] hosts) throws TooManyHosts, DuplicateName, InvalidState, RuntimeFault, RemoteException {
        if (hosts == null) {
            throw new IllegalArgumentException("hosts must not be null.");
        }
        ManagedObjectReference taskMOR = this.getVimService().moveInto_Task(this.getMOR(), MorUtil.createMORs(hosts));
        return new Task(this.getServerConnection(), taskMOR);
    }

    public ClusterHostRecommendation[] recommendHostsForVm(VirtualMachine vm, ResourcePool pool) throws RuntimeFault, RemoteException {
        if (vm == null) {
            throw new IllegalArgumentException("vm must not be null.");
        }
        return this.getVimService().recommendHostsForVm(this.getMOR(), vm.getMOR(), pool == null ? null : pool.getMOR());
    }

    public Task reconfigureCluster_Task(ClusterConfigSpec spec, boolean modify) throws RuntimeFault, RemoteException {
        ManagedObjectReference taskMOR = this.getVimService().reconfigureCluster_Task(this.getMOR(), spec, modify);
        return new Task(this.getServerConnection(), taskMOR);
    }

    public void refreshRecommendation() throws RuntimeFault, RemoteException {
        this.getVimService().refreshRecommendation(this.getMOR());
    }

    public ClusterDasAdvancedRuntimeInfo retrieveDasAdvancedRuntimeInfo() throws RuntimeFault, RemoteException {
        return this.getVimService().retrieveDasAdvancedRuntimeInfo(this.getMOR());
    }
}

