/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.HostConnectFault;
import com.vmware.vim25.HostConnectInfo;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.rmi.RemoteException;

public class Datacenter
extends ManagedEntity {
    public Datacenter(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public Folder getVmFolder() throws InvalidProperty, RuntimeFault, RemoteException {
        return (Folder)this.getManagedObject("vmFolder");
    }

    public Folder getHostFolder() throws InvalidProperty, RuntimeFault, RemoteException {
        return (Folder)this.getManagedObject("hostFolder");
    }

    public Datastore[] getDatastores() {
        return this.getDatastores("datastore");
    }

    public Folder getDatastoreFolder() {
        return (Folder)this.getManagedObject("datastoreFolder");
    }

    public Folder getNetworkFolder() {
        return (Folder)this.getManagedObject("networkFolder");
    }

    public Network[] getNetworks() throws InvalidProperty, RuntimeFault, RemoteException {
        return this.getNetworks("network");
    }

    public Task powerOnMultiVM_Task(VirtualMachine[] vms) throws RuntimeFault, RemoteException {
        return this.powerOnMultiVM_Task(vms, null);
    }

    public Task powerOnMultiVM_Task(VirtualMachine[] vms, OptionValue[] option) throws RuntimeFault, RemoteException {
        if (vms == null) {
            throw new IllegalArgumentException("vms must not be null.");
        }
        ManagedObjectReference[] mors = MorUtil.createMORs(vms);
        ManagedObjectReference tmor = this.getVimService().powerOnMultiVM_Task(this.getMOR(), mors, option);
        return new Task(this.getServerConnection(), tmor);
    }

    public HostConnectInfo queryConnectionInfo(String hostname, int port, String username, String password, String sslThumbprint) throws InvalidLogin, HostConnectFault, RuntimeFault, RemoteException {
        return this.getVimService().queryConnectionInfo(this.getMOR(), hostname, port, username, password, sslThumbprint);
    }
}

