/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DatastoreCapability;
import com.vmware.vim25.DatastoreHostMount;
import com.vmware.vim25.DatastoreInfo;
import com.vmware.vim25.DatastoreMountPathDatastorePair;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.InvalidDatastore;
import com.vmware.vim25.InvalidName;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PlatformConfigFault;
import com.vmware.vim25.ResourceInUse;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.StorageIORMInfo;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.mo.HostDatastoreBrowser;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;

public class Datastore
extends ManagedEntity {
    public Datastore(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public HostDatastoreBrowser getBrowser() {
        return (HostDatastoreBrowser)this.getManagedObject("browser");
    }

    public DatastoreCapability getCapability() {
        return (DatastoreCapability)this.getCurrentProperty("capability");
    }

    public DatastoreHostMount[] getHost() {
        return (DatastoreHostMount[])this.getCurrentProperty("host");
    }

    public DatastoreInfo getInfo() {
        return (DatastoreInfo)this.getCurrentProperty("info");
    }

    public StorageIORMInfo getIormConfiguration() {
        return (StorageIORMInfo)this.getCurrentProperty("iormConfiguration");
    }

    public DatastoreSummary getSummary() {
        return (DatastoreSummary)this.getCurrentProperty("summary");
    }

    public VirtualMachine[] getVms() {
        return this.getVms("vm");
    }

    public void destroyDatastore() throws ResourceInUse, RuntimeFault, RemoteException {
        this.getVimService().destroyDatastore(this.getMOR());
    }

    public void refreshDatastore() throws RuntimeFault, RemoteException {
        this.getVimService().refreshDatastore(this.getMOR());
    }

    public void refreshDatastoreStorageInfo() throws RuntimeFault, RemoteException {
        this.getVimService().refreshDatastoreStorageInfo(this.getMOR());
    }

    public void renameDatastore(String newName) throws InvalidName, DuplicateName, RuntimeFault, RemoteException {
        this.getVimService().renameDatastore(this.getMOR(), newName);
    }

    public Task updateVirtualMachineFiles_Task(DatastoreMountPathDatastorePair[] mountPathDatastoreMapping) throws PlatformConfigFault, ResourceInUse, TaskInProgress, InvalidDatastore, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().updateVirtualMachineFiles_Task(this.getMOR(), mountPathDatastoreMapping);
        return new Task(this.getServerConnection(), mor);
    }
}

