/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.DVSFeatureCapability;
import com.vmware.vim25.DVSManagerDvsConfigTarget;
import com.vmware.vim25.DistributedVirtualSwitchHostProductSpec;
import com.vmware.vim25.DistributedVirtualSwitchManagerCompatibilityResult;
import com.vmware.vim25.DistributedVirtualSwitchManagerDvsProductSpec;
import com.vmware.vim25.DistributedVirtualSwitchManagerHostContainer;
import com.vmware.vim25.DistributedVirtualSwitchManagerHostDvsFilterSpec;
import com.vmware.vim25.DistributedVirtualSwitchProductSpec;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.DistributedVirtualSwitch;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import java.rmi.RemoteException;

public class DistributedVirtualSwitchManager
extends ManagedObject {
    public DistributedVirtualSwitchManager(ServerConnection sc, ManagedObjectReference mor) {
        super(sc, mor);
    }

    public DistributedVirtualSwitchProductSpec[] queryAvailableDvsSpec() throws RuntimeFault, RemoteException {
        return this.getVimService().queryAvailableDvsSpec(this.getMOR());
    }

    public HostSystem[] queryCompatibleHostForExistingDvs(ManagedEntity container, boolean recursive, DistributedVirtualSwitch dvs) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().queryCompatibleHostForExistingDvs(this.getMOR(), container.getMOR(), recursive, dvs.getMOR());
        HostSystem[] hosts = new HostSystem[mors.length];
        int i = 0;
        while (i < hosts.length) {
            hosts[i] = new HostSystem(this.getServerConnection(), mors[i]);
            ++i;
        }
        return hosts;
    }

    public HostSystem[] queryCompatibleHostForNewDvs(ManagedEntity container, boolean recursive, DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        ManagedObjectReference[] mors = this.getVimService().queryCompatibleHostForNewDvs(this.getMOR(), container.getMOR(), recursive, switchProductSpec);
        HostSystem[] hosts = new HostSystem[mors.length];
        int i = 0;
        while (i < hosts.length) {
            hosts[i] = new HostSystem(this.getServerConnection(), mors[i]);
            ++i;
        }
        return hosts;
    }

    public DistributedVirtualSwitchHostProductSpec[] queryDvsCompatibleHostSpec(DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsCompatibleHostSpec(this.getMOR(), switchProductSpec);
    }

    public DistributedVirtualSwitchManagerCompatibilityResult[] queryDvsCheckCompatibility(DistributedVirtualSwitchManagerHostContainer hostContainer, DistributedVirtualSwitchManagerDvsProductSpec dvsProductSpec, DistributedVirtualSwitchManagerHostDvsFilterSpec[] hostFilterSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsCheckCompatibility(this.getMOR(), hostContainer, dvsProductSpec, hostFilterSpec);
    }

    public DVSManagerDvsConfigTarget queryDvsConfigTarget(HostSystem host, DistributedVirtualSwitch dvs) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsConfigTarget(this.getMOR(), host == null ? null : host.getMOR(), dvs == null ? null : dvs.getMOR());
    }

    public DistributedVirtualSwitch queryDvsByUuid(String uuid) throws NotFound, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().queryDvsByUuid(this.getMOR(), uuid);
        return new DistributedVirtualSwitch(this.getServerConnection(), mor);
    }

    public DVSFeatureCapability queryDvsFeatureCapability(DistributedVirtualSwitchProductSpec switchProductSpec) throws RuntimeFault, RemoteException {
        return this.getVimService().queryDvsFeatureCapability(this.getMOR(), switchProductSpec);
    }
}

