/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AlreadyExists;
import com.vmware.vim25.DatastoreNotWritableOnHost;
import com.vmware.vim25.DuplicateName;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.HostDatastoreSystemCapabilities;
import com.vmware.vim25.HostNasVolumeSpec;
import com.vmware.vim25.HostScsiDisk;
import com.vmware.vim25.HostUnresolvedVmfsResignatureSpec;
import com.vmware.vim25.HostUnresolvedVmfsVolume;
import com.vmware.vim25.InaccessibleDatastore;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFound;
import com.vmware.vim25.ResourceInUse;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VmfsAmbiguousMount;
import com.vmware.vim25.VmfsDatastoreCreateSpec;
import com.vmware.vim25.VmfsDatastoreExpandSpec;
import com.vmware.vim25.VmfsDatastoreExtendSpec;
import com.vmware.vim25.VmfsDatastoreOption;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;

public class HostDatastoreSystem
extends ManagedObject {
    public HostDatastoreSystem(ServerConnection serverConnection, ManagedObjectReference mor) {
        super(serverConnection, mor);
    }

    public HostDatastoreSystemCapabilities getCapabilities() {
        return (HostDatastoreSystemCapabilities)this.getCurrentProperty("capabilities");
    }

    public Datastore[] getDatastores() {
        return this.getDatastores("datastore");
    }

    public void configureDatastorePrincipal(String userName, String password) throws HostConfigFault, InvalidState, RuntimeFault, RemoteException {
        this.getVimService().configureDatastorePrincipal(this.getMOR(), userName, password);
    }

    public Datastore createLocalDatastore(String name, String path) throws HostConfigFault, DuplicateName, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createLocalDatastore(this.getMOR(), name, path);
        return new Datastore(this.getServerConnection(), mor);
    }

    public Datastore createNasDatastore(HostNasVolumeSpec spec) throws HostConfigFault, DuplicateName, AlreadyExists, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createNasDatastore(this.getMOR(), spec);
        return new Datastore(this.getServerConnection(), mor);
    }

    public Datastore createVmfsDatastore(VmfsDatastoreCreateSpec spec) throws HostConfigFault, DuplicateName, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().createVmfsDatastore(this.getMOR(), spec);
        return new Datastore(this.getServerConnection(), mor);
    }

    public Datastore expandVmfsDatastore(Datastore datastore, VmfsDatastoreExpandSpec spec) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference mor = this.getVimService().expandVmfsDatastore(this.getMOR(), datastore.getMOR(), spec);
        return new Datastore(this.getServerConnection(), mor);
    }

    public Datastore extendVmfsDatastore(Datastore datastore, VmfsDatastoreExtendSpec spec) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        if (datastore == null) {
            throw new IllegalArgumentException("datastore must not be null.");
        }
        ManagedObjectReference mor = this.getVimService().extendVmfsDatastore(this.getMOR(), datastore.getMOR(), spec);
        return new Datastore(this.getServerConnection(), mor);
    }

    public HostScsiDisk[] queryAvailableDisksForVmfs(Datastore datastore) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().queryAvailableDisksForVmfs(this.getMOR(), datastore == null ? null : datastore.getMOR());
    }

    public VmfsDatastoreOption[] queryVmfsDatastoreCreateOptions(String devicePath) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.getVimService().queryVmfsDatastoreCreateOptions(this.getMOR(), devicePath);
    }

    public VmfsDatastoreOption[] queryVmfsDatastoreExtendOptions(Datastore datastore, String devicePath) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        return this.queryVmfsDatastoreExtendOptions(datastore, devicePath, null);
    }

    public VmfsDatastoreOption[] queryVmfsDatastoreExtendOptions(Datastore datastore, String devicePath, Boolean suppressExpandCandidates) throws HostConfigFault, NotFound, RuntimeFault, RemoteException {
        if (datastore == null) {
            throw new IllegalArgumentException("datastore must not be null.");
        }
        return this.getVimService().queryVmfsDatastoreExtendOptions(this.getMOR(), datastore.getMOR(), devicePath, suppressExpandCandidates);
    }

    public VmfsDatastoreOption[] queryVmfsDatastoreExpandOptions(Datastore datastore) throws NotFound, HostConfigFault, RuntimeFault, RemoteException {
        return this.getVimService().queryVmfsDatastoreExpandOptions(this.getMOR(), datastore.getMOR());
    }

    public HostUnresolvedVmfsVolume[] queryUnresolvedVmfsVolumes() throws RuntimeFault, RemoteException {
        return this.getVimService().queryUnresolvedVmfsVolumes(this.getMOR());
    }

    public void removeDatastore(Datastore datastore) throws HostConfigFault, ResourceInUse, NotFound, RuntimeFault, RemoteException {
        if (datastore == null) {
            throw new IllegalArgumentException("datastore must not be null.");
        }
        this.getVimService().removeDatastore(this.getMOR(), datastore.getMOR());
    }

    public Task resignatureUnresolvedVmfsVolume_Task(HostUnresolvedVmfsResignatureSpec resolutionSpec) throws VmfsAmbiguousMount, HostConfigFault, RuntimeFault, RemoteException {
        ManagedObjectReference taskMor = this.getVimService().resignatureUnresolvedVmfsVolume_Task(this.getMOR(), resolutionSpec);
        return new Task(this.getServerConnection(), taskMor);
    }

    public void updateLocalSwapDatastore(Datastore datastore) throws InaccessibleDatastore, DatastoreNotWritableOnHost, RuntimeFault, RemoteException {
        this.getVimService().updateLocalSwapDatastore(this.getMOR(), datastore == null ? null : datastore.getMOR());
    }
}

