/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo;

import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.mo.util.PropertyCollectorUtil;
import java.rmi.RemoteException;

public class InventoryNavigator {
    private ManagedEntity rootEntity = null;
    private SelectionSpec[] selectionSpecs = null;

    public InventoryNavigator(ManagedEntity rootEntity) {
        this.rootEntity = rootEntity;
    }

    public ManagedEntity[] searchManagedEntities(boolean recurse) throws InvalidProperty, RuntimeFault, RemoteException {
        String[][] typeinfo = new String[][]{{"ManagedEntity"}};
        return this.searchManagedEntities(typeinfo, recurse);
    }

    public ManagedEntity[] searchManagedEntities(String type) throws InvalidProperty, RuntimeFault, RemoteException {
        String[][] typeinfo = new String[][]{{type, "name"}};
        return this.searchManagedEntities(typeinfo, true);
    }

    public ManagedEntity[] searchManagedEntities(String[][] typeinfo, boolean recurse) throws InvalidProperty, RuntimeFault, RemoteException {
        ObjectContent[] ocs = this.retrieveObjectContents(typeinfo, recurse);
        return this.createManagedEntities(ocs);
    }

    private ObjectContent[] retrieveObjectContents(String[][] typeinfo, boolean recurse) throws InvalidProperty, RuntimeFault, RemoteException {
        if (typeinfo == null || typeinfo.length == 0) {
            return null;
        }
        PropertyCollector pc = this.rootEntity.getServerConnection().getServiceInstance().getPropertyCollector();
        if (recurse && this.selectionSpecs == null) {
            AboutInfo ai = this.rootEntity.getServerConnection().getServiceInstance().getAboutInfo();
            this.selectionSpecs = ai.apiVersion.startsWith("4") ? PropertyCollectorUtil.buildFullTraversalV4() : PropertyCollectorUtil.buildFullTraversal();
        }
        PropertySpec[] propspecary = PropertyCollectorUtil.buildPropertySpecArray(typeinfo);
        ObjectSpec os = new ObjectSpec();
        os.setObj(this.rootEntity.getMOR());
        os.setSkip(Boolean.FALSE);
        os.setSelectSet(this.selectionSpecs);
        PropertyFilterSpec spec = new PropertyFilterSpec();
        spec.setObjectSet(new ObjectSpec[]{os});
        spec.setPropSet(propspecary);
        return pc.retrieveProperties(new PropertyFilterSpec[]{spec});
    }

    private ManagedEntity[] createManagedEntities(ObjectContent[] ocs) {
        if (ocs == null) {
            return new ManagedEntity[0];
        }
        ManagedEntity[] mes = new ManagedEntity[ocs.length];
        int i = 0;
        while (i < mes.length) {
            ManagedObjectReference mor = ocs[i].getObj();
            mes[i] = MorUtil.createExactManagedEntity(this.rootEntity.getServerConnection(), mor);
            ++i;
        }
        return mes;
    }

    public ManagedEntity searchManagedEntity(String type, String name) throws InvalidProperty, RuntimeFault, RemoteException {
        String[][] typeinfo;
        ObjectContent[] ocs;
        if (name == null || name.length() == 0) {
            return null;
        }
        if (type == null) {
            type = "ManagedEntity";
        }
        if ((ocs = this.retrieveObjectContents(typeinfo = new String[][]{{type, "name"}}, true)) == null || ocs.length == 0) {
            return null;
        }
        int i = 0;
        while (i < ocs.length) {
            String nameInPropSet;
            DynamicProperty[] propSet = ocs[i].getPropSet();
            if (propSet.length > 0 && name.equalsIgnoreCase(nameInPropSet = (String)propSet[0].getVal())) {
                ManagedObjectReference mor = ocs[i].getObj();
                return MorUtil.createExactManagedEntity(this.rootEntity.getServerConnection(), mor);
            }
            ++i;
        }
        return null;
    }
}

