/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ws.SoapFaultException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlGen {
    private static String PACKAGE_NAME = "com.vmware.vim25";
    private static Namespace XSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static QName XSI_TYPE = new QName("type", XSI);
    private static String[] BASIC_TYPES = new String[]{"String", "int", "short", "long", "byte", "boolean", "Boolean", "Calendar"};
    private static final Set<String> PRIMITIVE_DATA_TYPES = new HashSet<String>();
    private static final Map<String, Class> VimClasses;
    private static final Package VIM_PKG;
    static final Class INT_ARRAY_CLASS;
    static final Class BYTE_ARRAY_CLASS;

    static {
        PRIMITIVE_DATA_TYPES.add("int");
        PRIMITIVE_DATA_TYPES.add("boolean");
        PRIMITIVE_DATA_TYPES.add("short");
        PRIMITIVE_DATA_TYPES.add("byte");
        PRIMITIVE_DATA_TYPES.add("long");
        VimClasses = new HashMap<String, Class>();
        VIM_PKG = ManagedObjectReference.class.getPackage();
        INT_ARRAY_CLASS = new int[0].getClass();
        BYTE_ARRAY_CLASS = new byte[0].getClass();
    }

    public static SoapFaultException parseSoapFault(Element root) throws Exception {
        Element faultE;
        String faultTypeName;
        List subElems;
        SoapFaultException sfe = new SoapFaultException();
        sfe.setFaultCode(root.elementText("faultcode"));
        sfe.setFaultString(root.elementText("faultstring"));
        sfe.setFaultActor(root.elementText("faultactor"));
        Element detailE = root.element("detail");
        if (detailE != null && (subElems = detailE.elements()).size() != 0 && (faultTypeName = (faultE = (Element)subElems.get(0)).attributeValue(XSI_TYPE)) != null) {
            sfe.detail = (Throwable)XmlGen.fromXml(XmlGen.getVimClass(faultTypeName), faultE);
        }
        return sfe;
    }

    public static Object fromXML(String type, Element root) throws Exception {
        List subNodes = root.elements();
        if (subNodes.size() == 0) {
            return null;
        }
        if (type.startsWith("ManagedObjectReference")) {
            if (!type.endsWith("[]")) {
                Element e = (Element)subNodes.get(0);
                return XmlGen.createMOR(e.attributeValue("type"), e.getText());
            }
            ManagedObjectReference[] mos = new ManagedObjectReference[subNodes.size()];
            int i = 0;
            while (i < subNodes.size()) {
                Element elem = (Element)subNodes.get(i);
                mos[i] = XmlGen.createMOR(elem.attributeValue("type"), elem.getText());
                ++i;
            }
            return mos;
        }
        if (XmlGen.isBasicType(type)) {
            String[] vals = new String[subNodes.size()];
            int i = 0;
            while (i < vals.length) {
                vals[i] = ((Element)subNodes.get(i)).getText();
                ++i;
            }
            return XmlGen.parseValue(type, vals);
        }
        if (type.endsWith("[]")) {
            String arrayItemTypeName = type.substring(0, type.length() - 2);
            Class clazz = XmlGen.getVimClass(arrayItemTypeName);
            Object ao = Array.newInstance(clazz, subNodes.size());
            int i = 0;
            while (i < subNodes.size()) {
                Element e = (Element)subNodes.get(i);
                String xsiType = e.attributeValue(XSI_TYPE);
                Object o = XmlGen.fromXml(XmlGen.getVimClass(xsiType == null ? arrayItemTypeName : xsiType), (Element)subNodes.get(i));
                Array.set(ao, i, o);
                ++i;
            }
            return ao;
        }
        return XmlGen.fromXml(XmlGen.getVimClass(type), (Element)subNodes.get(0));
    }

    private static boolean isBasicType(String type) {
        int i = 0;
        while (i < BASIC_TYPES.length) {
            if (type.startsWith(BASIC_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Class getVimClass(String type) {
        if (VimClasses.containsKey(type)) {
            return VimClasses.get(type);
        }
        try {
            Class<?> clazz = null;
            if (!type.endsWith("[]")) {
                clazz = Class.forName(String.valueOf(PACKAGE_NAME) + "." + type);
            } else {
                String compType = type.substring(0, type.length() - 2);
                clazz = Array.newInstance(XmlGen.getVimClass(compType), 0).getClass();
            }
            VimClasses.put(type, clazz);
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
    }

    private static Object fromXml(Class clazz, Element node) throws Exception {
        Object obj = clazz.newInstance();
        List subNodes = node.elements();
        int sizeOfSubNodes = subNodes.size();
        int i = 0;
        while (i < sizeOfSubNodes) {
            Object ao;
            Element e = (Element)subNodes.get(i);
            String tagName = e.getName();
            Field field = null;
            field = PRIMITIVE_DATA_TYPES.contains(tagName) ? clazz.getField("_" + tagName) : clazz.getField(tagName);
            Class fType = field.getType();
            boolean isFieldArray = fType.isArray();
            if (isFieldArray) {
                fType = fType.getComponentType();
            }
            Class fRealType = fType;
            String xsiType = e.attributeValue(XSI_TYPE);
            if (xsiType != null && !xsiType.startsWith("xsd:")) {
                fRealType = XmlGen.getVimClass(xsiType);
            }
            if (fRealType == ManagedObjectReference.class) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGen.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ManagedObjectReference[] mos = new ManagedObjectReference[sizeOfFieldArray];
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        Element elem = (Element)subNodes.get(j + i);
                        mos[j] = XmlGen.createMOR(elem.attributeValue("type"), elem.getText());
                        ++j;
                    }
                    field.set(obj, mos);
                    i = i + sizeOfFieldArray - 1;
                } else {
                    field.set(obj, XmlGen.createMOR(e.attributeValue("type"), e.getText()));
                }
            } else if (fRealType.isEnum()) {
                if (!isFieldArray) {
                    Object fo = Enum.valueOf(fRealType, e.getText());
                    field.set(obj, fo);
                } else {
                    int sizeOfFieldArray = XmlGen.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ao = Array.newInstance(fRealType, sizeOfFieldArray);
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        String enumStr = ((Element)subNodes.get(j + i)).getText();
                        Array.set(ao, j, Enum.valueOf(fRealType, enumStr));
                        ++j;
                    }
                    field.set(obj, ao);
                    i = i + sizeOfFieldArray - 1;
                }
            } else if (fRealType.getPackage() == VIM_PKG) {
                if (isFieldArray) {
                    int sizeOfFieldArray = XmlGen.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                    ao = Array.newInstance(fType, sizeOfFieldArray);
                    String fGenericType = fType.getSimpleName();
                    int j = 0;
                    while (j < sizeOfFieldArray) {
                        Element elem = (Element)subNodes.get(j + i);
                        String elemXsiType = elem.attributeValue(XSI_TYPE);
                        String elemType = elemXsiType != null ? elemXsiType : fGenericType;
                        Object o = XmlGen.fromXml(XmlGen.getVimClass(elemType), elem);
                        Array.set(ao, j, o);
                        ++j;
                    }
                    field.set(obj, ao);
                    i = i + sizeOfFieldArray - 1;
                } else {
                    Object o = XmlGen.fromXml(fRealType, e);
                    field.set(obj, o);
                }
            } else if (isFieldArray) {
                int sizeOfFieldArray = XmlGen.getNumberOfSameTags(subNodes, sizeOfSubNodes, i, tagName);
                String[] values = new String[sizeOfFieldArray];
                int j = 0;
                while (j < values.length) {
                    values[j] = ((Element)subNodes.get(j + i)).getText();
                    ++j;
                }
                String fTrueType = null;
                if (xsiType != null) {
                    fTrueType = String.valueOf(xsiType.substring("xsd:".length())) + "[]";
                } else {
                    fTrueType = fRealType.getSimpleName();
                    if (!fTrueType.endsWith("[]")) {
                        fTrueType = String.valueOf(fTrueType) + "[]";
                    }
                }
                XmlGen.setArrayFieldValue(field, obj, fTrueType, values);
                i = i + sizeOfFieldArray - 1;
            } else if (xsiType != null) {
                xsiType = xsiType.substring("xsd:".length());
                XmlGen.setFieldValue(field, obj, xsiType, e.getText());
            } else {
                XmlGen.setFieldValue(field, obj, fRealType.getSimpleName(), e.getText());
            }
            ++i;
        }
        return obj;
    }

    private static final int getNumberOfSameTags(List<Element> subNodes, int sizeOfSubNodes, int from, String tagName) {
        int numOfTags = 1;
        int j = from + 1;
        while (j < sizeOfSubNodes) {
            if (!subNodes.get(j).getName().equals(tagName)) break;
            ++numOfTags;
            ++j;
        }
        return numOfTags;
    }

    private static ManagedObjectReference createMOR(String type, String value) {
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.val = value;
        mor.type = type;
        return mor;
    }

    private static byte[] parseByteArray(String[] values) {
        byte[] bs = new byte[values.length];
        int i = 0;
        while (i < bs.length) {
            bs[i] = Byte.parseByte(values[i]);
            ++i;
        }
        return bs;
    }

    private static long[] parseLongArray(String[] values) {
        long[] ls = new long[values.length];
        int i = 0;
        while (i < ls.length) {
            ls[i] = Long.parseLong(values[i]);
            ++i;
        }
        return ls;
    }

    private static short[] parseShortArray(String[] values) {
        short[] ss = new short[values.length];
        int i = 0;
        while (i < ss.length) {
            ss[i] = Short.parseShort(values[i]);
            ++i;
        }
        return ss;
    }

    private static int[] parseIntArray(String[] values) {
        int[] is = new int[values.length];
        int i = 0;
        while (i < is.length) {
            is[i] = Integer.parseInt(values[i]);
            ++i;
        }
        return is;
    }

    private static boolean[] parseBooleanArray(String[] values) {
        boolean[] bs = new boolean[values.length];
        int i = 0;
        while (i < bs.length) {
            bs[i] = Boolean.parseBoolean(values[i]);
            ++i;
        }
        return bs;
    }

    private static Object parseValue(String type, String[] values) {
        if ("String".equals(type) || "string".equals(type)) {
            return values[0];
        }
        if ("String[]".equals(type)) {
            return values;
        }
        if ("int".equals(type)) {
            return new Integer(values[0]);
        }
        if ("int[]".equals(type)) {
            return XmlGen.parseIntArray(values);
        }
        if ("short".equals(type)) {
            return new Short(values[0]);
        }
        if ("short[]".equals(type)) {
            return XmlGen.parseShortArray(values);
        }
        if ("byte".equals(type)) {
            return new Byte(values[0]);
        }
        if ("byte[]".equals(type)) {
            return XmlGen.parseByteArray(values);
        }
        if ("long".equals(type)) {
            return new Long(values[0]);
        }
        if ("long[]".equals(type)) {
            return XmlGen.parseLongArray(values);
        }
        if ("boolean".equals(type)) {
            return new Boolean(values[0]);
        }
        if ("boolean[]".equals(type)) {
            return XmlGen.parseBooleanArray(values);
        }
        if ("Calendar".equals(type) || "dateTime".equals(type)) {
            Calendar cal = DatatypeConverter.parseTime((String)values[0]);
            return cal;
        }
        throw new RuntimeException("Unexpected Type@setField: " + type + values[0]);
    }

    private static final void setFieldValue(Field f, Object obj, String type, String value) throws IllegalArgumentException, IllegalAccessException {
        if ("String".equals(type) || "string".equals(type)) {
            f.set(obj, value);
        } else if ("int".equals(type)) {
            f.set(obj, Integer.parseInt(value));
        } else if ("Integer".equals(type)) {
            f.set(obj, new Integer(value));
        } else if ("short".equals(type)) {
            f.set(obj, Short.parseShort(value));
        } else if ("Short".equals(type)) {
            f.set(obj, new Short(value));
        } else if ("byte".equals(type)) {
            f.set(obj, Byte.parseByte(value));
        } else if ("Byte".equals(type)) {
            f.set(obj, new Byte(value));
        } else if ("long".equals(type)) {
            f.set(obj, Long.parseLong(value));
        } else if ("Long".equals(type)) {
            f.set(obj, new Long(value));
        } else if ("boolean".equals(type)) {
            f.set(obj, Boolean.parseBoolean(value));
        } else if ("Boolean".equals(type)) {
            f.set(obj, new Boolean(value));
        } else if ("Calendar".equals(type) || "dateTime".equals(type)) {
            Calendar cal = DatatypeConverter.parseTime((String)value);
            f.set(obj, cal);
        } else {
            throw new RuntimeException("Unexpected Type@setField: " + f.getType().getCanonicalName() + f.getName());
        }
    }

    private static void setArrayFieldValue(Field f, Object obj, String type, String[] values) throws IllegalArgumentException, IllegalAccessException {
        if ("String[]".equals(type) || "string[]".equals(type)) {
            f.set(obj, values);
        } else if ("int[]".equals(type)) {
            f.set(obj, XmlGen.parseIntArray(values));
        } else if ("short[]".equals(type)) {
            f.set(obj, XmlGen.parseShortArray(values));
        } else if ("byte[]".equals(type)) {
            f.set(obj, XmlGen.parseByteArray(values));
        } else if ("long[]".equals(type)) {
            f.set(obj, XmlGen.parseLongArray(values));
        } else if ("boolean[]".equals(type)) {
            f.set(obj, XmlGen.parseBooleanArray(values));
        } else {
            throw new RuntimeException("Unexpected Type@setField: " + f.getType().getCanonicalName() + f.getName());
        }
    }

    public static String toXML(String tag, String type, Object obj) {
        if (obj == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (XmlGen.isBasicType(type)) {
            XmlGen.toXML(sb, tag, obj.getClass(), obj);
        } else {
            Class clazz = XmlGen.getVimClass(type);
            XmlGen.toXML(sb, tag, clazz, obj);
        }
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, String tagName, Class type, Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (obj.getClass() == INT_ARRAY_CLASS) {
                int[] objs = (int[])obj;
                int i = 0;
                while (i < objs.length) {
                    sb.append("<" + tagName + ">");
                    sb.append(objs[i]);
                    sb.append("</" + tagName + ">");
                    ++i;
                }
            } else if (obj.getClass() == BYTE_ARRAY_CLASS) {
                byte[] objs = (byte[])obj;
                int i = 0;
                while (i < objs.length) {
                    sb.append("<" + tagName + ">");
                    sb.append(objs[i]);
                    sb.append("</" + tagName + ">");
                    ++i;
                }
            } else {
                Object[] objs = (Object[])obj;
                int i = 0;
                while (i < objs.length) {
                    XmlGen.toXML(sb, tagName, type.getComponentType(), objs[i]);
                    ++i;
                }
            }
        } else if (clazz == ManagedObjectReference.class) {
            ManagedObjectReference mor = (ManagedObjectReference)obj;
            sb.append("<" + tagName + " type=\"" + mor.type + "\">");
            sb.append(mor.val);
            sb.append("</" + tagName + ">");
        } else if (clazz.getCanonicalName().startsWith("java.lang")) {
            if (clazz != type) {
                sb.append("<" + tagName + " xsi:type=\"" + XmlGen.getXSIType(obj) + "\">");
            } else {
                sb.append("<" + tagName + ">");
            }
            sb.append(obj);
            sb.append("</" + tagName + ">");
        } else if (clazz.isEnum()) {
            sb.append("<" + tagName + ">" + obj + "</" + tagName + ">");
        } else if (obj instanceof Calendar) {
            sb.append("<" + tagName + " xsi:type=\"xsd:dateTime\">" + DatatypeConverter.printDateTime((Calendar)((Calendar)obj)) + "</" + tagName + ">");
        } else {
            if (clazz == type) {
                sb.append("<" + tagName + ">");
            } else {
                String nameSpaceType = clazz.getSimpleName();
                sb.append("<" + tagName + " xsi:type=\"" + nameSpaceType + "\">");
            }
            Field[] fields = XmlGen.getAllFields(clazz);
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                String fName = f.getName();
                Object value = null;
                try {
                    value = f.get(obj);
                }
                catch (IllegalAccessException iae) {
                    iae.printStackTrace();
                }
                if (value != null) {
                    Class<?> fType = f.getType();
                    XmlGen.toXML(sb, fName, fType, value);
                }
                ++i;
            }
            sb.append("</" + tagName + ">");
        }
    }

    private static String getXSIType(Object obj) {
        Class<?> type = obj.getClass();
        if (Integer.class == type) {
            return "xsd:int";
        }
        if (Long.class == type) {
            return "xsd:long";
        }
        if (Boolean.class == type) {
            return "xsd:boolean";
        }
        if (Short.class == type) {
            return "xsd:short";
        }
        if (Float.class == type) {
            return "xsd:float";
        }
        if (String.class == type) {
            return "xsd:string";
        }
        if (Byte.class == type) {
            return "xsd:byte";
        }
        if (obj instanceof Calendar) {
            return "xsd:dateTime";
        }
        throw new RuntimeException("Unknow data type during serialization:" + type);
    }

    private static Field[] getAllFields(Class<?> c) {
        Field[] fields = null;
        ArrayList<Field> al = new ArrayList<Field>();
        XmlGen.getAllFields(c, al);
        fields = new Field[al.size()];
        al.toArray(fields);
        return fields;
    }

    private static void getAllFields(Class<?> clazz, ArrayList<Field> al) {
        Class<?> supClazz = clazz.getSuperclass();
        if (supClazz != null) {
            XmlGen.getAllFields(supClazz, al);
        }
        Field[] fs = clazz.getDeclaredFields();
        int i = 0;
        while (i < fs.length) {
            al.add(fs[i]);
            ++i;
        }
    }
}

