/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jvnet.its.AgeTrendBuilder;
import org.jvnet.its.ColorPalette;
import org.jvnet.its.Graph;
import org.jvnet.its.TrendBuilder;
import org.kohsuke.jnt.IssueField;
import org.kohsuke.jnt.IssueStatus;
import org.kohsuke.jnt.JNIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugsLifeGraph
extends Graph<TableXYDataset> {
    private static final Comparator<JNIssue.Activity> AGE_COMPARATOR = new Comparator<JNIssue.Activity>(){

        @Override
        public int compare(JNIssue.Activity lhs, JNIssue.Activity rhs) {
            return new Long(lhs.getAge()).compareTo(rhs.getAge());
        }
    };

    @Override
    protected TableXYDataset buildDataSet(List<JNIssue.Activity> activities) throws IOException {
        EnumMap<IssueStatus, AgeTrendBuilder> trends = new EnumMap<IssueStatus, AgeTrendBuilder>(IssueStatus.class);
        for (IssueStatus s : IssueStatus.values()) {
            trends.put(s, new AgeTrendBuilder());
        }
        Collections.sort(activities, AGE_COMPARATOR);
        activities = activities.subList(0, (activities.size() * 9 + 9) / 10);
        for (JNIssue.Activity a : activities) {
            if (!a.isUpdate()) {
                ((AgeTrendBuilder)trends.get(a.getCurrentStatus())).inc(a);
                continue;
            }
            if (a.getField() != IssueField.STATUS) continue;
            IssueStatus o = IssueStatus.valueOf((String)a.getOldValue());
            ((AgeTrendBuilder)trends.get(o)).dec(a);
            IssueStatus n = IssueStatus.valueOf((String)a.getNewValue());
            ((AgeTrendBuilder)trends.get(n)).inc(a);
        }
        TrendBuilder.completeMissingLinks(trends.values());
        CategoryTableXYDataset ds = new CategoryTableXYDataset();
        for (Map.Entry e : trends.entrySet()) {
            ((AgeTrendBuilder)e.getValue()).addTo(ds, ((IssueStatus)e.getKey()).name());
        }
        this.saveDataset((Dataset)ds);
        return ds;
    }

    @Override
    protected JFreeChart createChart(TableXYDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedXYAreaChart(null, (String)"days", (String)"ratio", (TableXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ColorPalette.DARK_RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(2, (Paint)ColorPalette.DARK_YELLOW);
        renderer.setSeriesPaint(3, (Paint)ColorPalette.YELLOW);
        renderer.setSeriesPaint(4, (Paint)ColorPalette.GREEN);
        renderer.setSeriesPaint(5, (Paint)ColorPalette.DARK_GREEN);
        renderer.setSeriesPaint(6, (Paint)Color.WHITE);
        final int totalIssues = this.getTotalIssues(dataset);
        NumberAxis y = (NumberAxis)plot.getRangeAxis();
        y.setNumberFormatOverride(new NumberFormat(){
            final NumberFormat pformat = NumberFormat.getPercentInstance();

            public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                return this.pformat.format(number / (double)totalIssues, toAppendTo, pos);
            }

            public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
                return this.format((double)number, toAppendTo, pos);
            }

            public Number parse(String source, ParsePosition parsePosition) {
                throw new UnsupportedOperationException();
            }
        });
        y.setRange(0.0, (double)totalIssues);
        return chart;
    }

    private int getTotalIssues(TableXYDataset dataset) {
        int totalIssues = 0;
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            totalIssues = (int)((double)totalIssues + dataset.getYValue(i, 0));
        }
        return totalIssues;
    }

    @Override
    protected String getImageName() {
        return "life.png";
    }
}

