/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jvnet.its.ColorPalette;
import org.jvnet.its.Graph;
import org.jvnet.its.TimePeriodFactory;
import org.kohsuke.jnt.IssueField;
import org.kohsuke.jnt.IssueStatus;
import org.kohsuke.jnt.JNIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatedVsResolvedGraph
extends Graph<XYDataset> {
    private final TimePeriodFactory timePeriodFactory;

    public CreatedVsResolvedGraph(TimePeriodFactory timePeriodFactory) {
        this.timePeriodFactory = timePeriodFactory;
    }

    @Override
    protected XYDataset buildDataSet(List<JNIssue.Activity> activities) throws IOException {
        TreeMap<TimePeriod, Integer> created = new TreeMap<TimePeriod, Integer>();
        TreeMap<TimePeriod, Integer> resolved = new TreeMap<TimePeriod, Integer>();
        for (JNIssue.Activity a : activities) {
            if (!a.isUpdate()) {
                this.inc(a, created);
                continue;
            }
            if (a.getField() != IssueField.STATUS) continue;
            IssueStatus o = IssueStatus.valueOf((String)a.getOldValue());
            IssueStatus n = IssueStatus.valueOf((String)a.getNewValue());
            if (o.needsWork && !n.needsWork) {
                this.inc(a, resolved);
            }
            if (o.needsWork || !n.needsWork) continue;
            this.inc(a, created);
        }
        TimeTableXYDataset ds = new TimeTableXYDataset();
        this.buildDataSet(resolved, ds, "resolved");
        this.buildDataSet(created, ds, "created");
        this.saveDataset((Dataset)ds);
        return ds;
    }

    private void buildDataSet(Map<TimePeriod, Integer> incoming, TimeTableXYDataset ds, String label) {
        for (Map.Entry<TimePeriod, Integer> e : incoming.entrySet()) {
            ds.add(e.getKey(), (Number)e.getValue(), label, false);
        }
    }

    private void inc(JNIssue.Activity a, Map<TimePeriod, Integer> data) {
        TimePeriod l = this.timePeriodFactory.toTimePeriod(a.getTimestamp());
        Integer v = data.get(l);
        v = v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1);
        data.put(l, v);
    }

    @Override
    protected String getImageName() {
        return "created-vs-resolved.png";
    }

    @Override
    protected JFreeChart createChart(XYDataset dataset) {
        DateAxis xAxis = new DateAxis("date");
        NumberAxis yAxis = new NumberAxis("# of issues");
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setForegroundAlpha(0.8f);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.GREEN);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        XYBarRenderer xybarrenderer = (XYBarRenderer)plot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        JFreeChart chart = new JFreeChart("Created vs Resolved", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    private boolean isInt(double v) {
        return Math.floor(v) == v;
    }
}

