/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jvnet.its.Main;
import org.kohsuke.jnt.JNIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graph<DS extends Dataset> {
    public void generate(List<JNIssue.Activity> activities, File outDir) throws IOException {
        Object ds = Main.full ? this.buildDataSet(activities) : (Dataset)this.loadDataset();
        JFreeChart chart = this.createChart(ds);
        this.write(chart, new File(outDir, this.getImageName()));
    }

    protected abstract String getImageName();

    protected abstract JFreeChart createChart(DS var1);

    protected abstract DS buildDataSet(List<JNIssue.Activity> var1) throws IOException;

    protected Object loadDataset() throws IOException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.getDataFile()));
        try {
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            ois.close();
        }
    }

    protected void saveDataset(Dataset ds) throws IOException {
        if (!Main.debug) {
            return;
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.getDataFile()));
        oos.writeObject(ds);
        oos.close();
    }

    private File getDataFile() {
        return new File(this.getClass().getName() + ".dataset");
    }

    public void write(JFreeChart chart, File target) throws IOException {
        BufferedImage image = chart.createBufferedImage(640, 480);
        FileOutputStream fos = new FileOutputStream(target);
        ImageIO.write((RenderedImage)image, "PNG", fos);
        fos.close();
    }
}

