/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jvnet.its.BugCountGraph;
import org.jvnet.its.BugsLifeGraph;
import org.jvnet.its.CreatedVsResolvedGraph;
import org.jvnet.its.TimePeriodFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.jnt.JNIssue;
import org.kohsuke.jnt.JNProject;
import org.kohsuke.jnt.JavaNet;
import org.kohsuke.jnt.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    @Argument
    public final List<String> projects = new ArrayList<String>();
    @Option(name="-span", metaVar="[week|month]", usage="Specifies the timespan for histogram")
    public TimePeriodFactory timePeriodFactory = TimePeriodFactory.MONTH;
    @Option(name="-o", usage="Specifies the output directory")
    public File outputDirectory = new File(".");
    @Option(name="-debug")
    public static boolean debug = false;
    static boolean full = true;

    public static void main(String[] args) {
        System.exit(Main.run(args));
    }

    public static int run(String[] args) {
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            if (main.projects.isEmpty()) {
                System.err.println("No project is given");
                Main.printUsage(parser);
                return -1;
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            Main.printUsage(parser);
            return -1;
        }
        try {
            main.execute();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println("Usage: java -jar issuetracker-stats.jar <java.net project> ...");
        parser.printUsage((OutputStream)System.err);
    }

    public void execute() throws ProcessingException, IOException {
        if (full) {
            JavaNet con = JavaNet.connect();
            for (String project : this.projects) {
                JNProject p = con.getProject(project);
                System.err.println("Working on " + project);
                Map allIssues = p.getIssueTracker().getAll();
                ArrayList<JNIssue.Activity> activities = new ArrayList<JNIssue.Activity>();
                for (JNIssue i : allIssues.values()) {
                    activities.addAll(i.getActivities());
                }
                Collections.sort(activities);
                File dir = new File(this.outputDirectory, project);
                dir.mkdirs();
                this.generateGraphs(activities, dir);
            }
        } else {
            this.generateGraphs(new ArrayList<JNIssue.Activity>(), this.outputDirectory);
        }
    }

    private void generateGraphs(List<JNIssue.Activity> activities, File dir) throws IOException {
        new CreatedVsResolvedGraph(this.timePeriodFactory).generate(activities, dir);
        new BugCountGraph().generate(activities, dir);
        new BugsLifeGraph().generate(activities, dir);
        FileOutputStream out = new FileOutputStream(new File(dir, "index.html"));
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("index.html"), (OutputStream)out);
        out.close();
    }
}

