/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jvnet.its.ColorPalette;
import org.jvnet.its.Graph;
import org.jvnet.its.TimelineTrendBuilder;
import org.jvnet.its.TrendBuilder;
import org.kohsuke.jnt.IssueField;
import org.kohsuke.jnt.IssueStatus;
import org.kohsuke.jnt.JNIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugCountGraph
extends Graph<XYDataset> {
    @Override
    protected IntervalXYDataset buildDataSet(List<JNIssue.Activity> activities) throws IOException {
        TimelineTrendBuilder open = new TimelineTrendBuilder();
        TimelineTrendBuilder total = new TimelineTrendBuilder();
        for (JNIssue.Activity a : activities) {
            if (!a.isUpdate()) {
                open.inc(a);
                total.inc(a);
                continue;
            }
            if (a.getField() != IssueField.STATUS) continue;
            IssueStatus o = IssueStatus.valueOf((String)a.getOldValue());
            IssueStatus n = IssueStatus.valueOf((String)a.getNewValue());
            if (o.needsWork && !n.needsWork) {
                open.dec(a);
            }
            if (o.needsWork || !n.needsWork) continue;
            open.inc(a);
        }
        TrendBuilder.completeMissingLinks(open, total);
        TimeTableXYDataset ds = new TimeTableXYDataset();
        open.addTo(ds, "open issues");
        total.addTo(ds, "total issues");
        this.saveDataset((Dataset)ds);
        return ds;
    }

    @Override
    protected String getImageName() {
        return "count.png";
    }

    @Override
    protected JFreeChart createChart(XYDataset dataset) {
        JFreeChart jfreechart = ChartFactory.createTimeSeriesChart(null, (String)"time", (String)"# of issues", (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        jfreechart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot plot = (XYPlot)jfreechart.getPlot();
        XYStepAreaRenderer renderer = new XYStepAreaRenderer();
        plot.setRenderer((XYItemRenderer)renderer);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.GREEN);
        return jfreechart;
    }
}

