/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jvnet.its.BugCountGraph;
import org.jvnet.its.BugsLifeGraph;
import org.jvnet.its.CreatedVsResolvedGraph;
import org.jvnet.its.Main;
import org.jvnet.its.TimePeriodFactory;
import org.kohsuke.jnt.JNIssue;
import org.kohsuke.jnt.JNProject;
import org.kohsuke.jnt.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private TimePeriodFactory timePeriodFactory = TimePeriodFactory.MONTH;

    public void setTimePeriodFactory(TimePeriodFactory timePeriodFactory) {
        this.timePeriodFactory = timePeriodFactory;
    }

    public void generate(JNProject p, File outputDirectory) throws ProcessingException, IOException {
        Map allIssues = p.getIssueTracker().getAll();
        ArrayList<JNIssue.Activity> activities = new ArrayList<JNIssue.Activity>();
        for (JNIssue i : allIssues.values()) {
            activities.addAll(i.getActivities());
        }
        Collections.sort(activities);
        this.generateGraphs(activities, outputDirectory);
    }

    void generateGraphs(List<JNIssue.Activity> activities, File dir) throws IOException {
        new CreatedVsResolvedGraph(this.timePeriodFactory).generate(activities, dir);
        new BugCountGraph().generate(activities, dir);
        new BugsLifeGraph().generate(activities, dir);
        FileOutputStream out = new FileOutputStream(new File(dir, "index.html"));
        out.write("<html><body>".getBytes());
        IOUtils.copy((InputStream)Main.class.getResourceAsStream("index.html"), (OutputStream)out);
        out.write("</body></html>".getBytes());
        out.close();
    }
}

