/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.its;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.data.xy.XYDataset;
import org.kohsuke.jnt.JNIssue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TrendBuilder<K extends Comparable<K>, DS extends XYDataset> {
    private final TreeMap<K, Integer> trend = new TreeMap();
    private int n;

    public void inc(JNIssue.Activity a) {
        ++this.n;
        this.trend.put(this.getKey(a), this.n);
    }

    protected abstract K getKey(JNIssue.Activity var1);

    public void dec(JNIssue.Activity a) {
        --this.n;
        this.trend.put(this.getKey(a), this.n);
    }

    public static void completeMissingLinks(Collection<? extends TrendBuilder> builders) {
        for (TrendBuilder trendBuilder : builders) {
            for (TrendBuilder trendBuilder2 : builders) {
                if (trendBuilder == trendBuilder2) continue;
                trendBuilder.complete(trendBuilder2.trend.keySet());
            }
        }
    }

    public static void completeMissingLinks(TrendBuilder ... builders) {
        TrendBuilder.completeMissingLinks(Arrays.asList(builders));
    }

    public int get(K key) {
        Map.Entry<K, Integer> prev = null;
        for (Map.Entry<K, Integer> e : this.trend.entrySet()) {
            if (((Comparable)e.getKey()).compareTo(key) > 0) break;
            prev = e;
        }
        if (prev != null) {
            return (Integer)prev.getValue();
        }
        return 0;
    }

    private void complete(Set<K> dataPoints) {
        for (Comparable dp : dataPoints) {
            this.trend.put(dp, this.get(dp));
        }
    }

    public void addTo(DS ds, String seriesName) {
        Map.Entry<K, Integer> p = null;
        for (Map.Entry<K, Integer> e : this.trend.entrySet()) {
            if (p != null) {
                this.add(ds, (Comparable)p.getKey(), (Comparable)e.getKey(), p.getValue(), seriesName);
            }
            p = e;
        }
        if (p != null) {
            this.add(ds, (Comparable)p.getKey(), null, p.getValue(), seriesName);
        }
    }

    protected abstract void add(DS var1, K var2, K var3, int var4, String var5);
}

