<?xml version="1.0" encoding="utf-8"?>
<!-- CityGML Version No. 2.0, February 2012 -->
<!-- CityGML - GML 3.1.1 application schema for 3D city models -->
<!-- International encoding standard of the Open Geospatial Consortium, see http://www.opengeospatial.org/standards/citygml -->
<!-- Jointly developed by the Special Interest Group 3D (SIG 3D) of GDI-DE, see http://www.sig3d.org               -->
<!-- For further information see: http://www.citygml.org -->
<CityModel xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.opengis.net/citygml/2.0"
	xmlns:xAL="urn:oasis:names:tc:ciq:xsdschema:xAL:2.0" xmlns:xlink="http://www.w3.org/1999/xlink"
	xmlns:gml="http://www.opengis.net/gml" xmlns:dem="http://www.opengis.net/citygml/relief/2.0"
	xmlns:bldg="http://www.opengis.net/citygml/building/2.0"
	xsi:schemaLocation="http://www.opengis.net/citygml/building/2.0 http://schemas.opengis.net/citygml/building/2.0/building.xsd http://www.opengis.net/citygml/relief/2.0 http://schemas.opengis.net/citygml/relief/2.0/relief.xsd">
	<gml:name>Simple 3D city model LOD4 without Appearance</gml:name>
	<gml:boundedBy>
		<gml:Envelope srsDimension="3" srsName="urn:ogc:def:crs,crs:EPSG::25832,crs:EPSG::5783">
			<gml:lowerCorner>458868.0 5438343.0 112.0</gml:lowerCorner>
			<gml:upperCorner>458892.0 5438362.0 117.0</gml:upperCorner>
		</gml:Envelope>
	</gml:boundedBy>
	<cityObjectMember>
		<bldg:Building gml:id="GML_7b1a5a6f-ddad-4c3d-a507-3eb9ee0a8e68">
			<gml:name>Example Building LOD4 </gml:name>
			<bldg:function codeSpace="http://www.sig3d.org/codelists/standard/building/2.0/_AbstractBuilding_function.xml">1000</bldg:function>
			<bldg:yearOfConstruction>1985</bldg:yearOfConstruction>
			<bldg:roofType codeSpace="http://www.sig3d.org/codelists/standard/building/2.0/_AbstractBuilding_roofType.xml">1030</bldg:roofType>
			<bldg:measuredHeight uom="#m">5.0</bldg:measuredHeight>
			<bldg:storeysAboveGround>1</bldg:storeysAboveGround>
			<bldg:storeyHeightsAboveGround uom="#m">3.0</bldg:storeyHeightsAboveGround>
			<bldg:boundedBy>
				<bldg:GroundSurface>
					<gml:name>Ground Slab</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_d3981803-d4b0-4b5b-969c-53f657594757">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458875 5438355 112 458885 5438355 112 458885 5438350 112 458875 5438350 112 458875 5438355 112
											</gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
				</bldg:GroundSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:WallSurface>
					<gml:name>Wall South</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:CompositeSurface gml:id="GML_1d350a50-6acc-4d3c-8c28-326ca4305fd1">
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10204_1916_571790_369478">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5 5438350 113.2 458878.5 5438350 114.2 458878.5 5438350.1 114.2 458878.5 5438350.1
														113.2 458878.5 5438350 113.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10205_105_876837_53833">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458875 5438350 112 458885 5438350 112 458885 5438350 115 458875 5438350 115 458875 5438350
														112 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458877 5438350 114.2 458878.5 5438350 114.2 458878.5 5438350 113.2 458877 5438350 113.2
														458877 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458881.5 5438350 114.2 458883 5438350 114.2 458883 5438350 113.2 458881.5 5438350 113.2
														458881.5 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10206_1133_78310_431691">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458881.5 5438350 114.2 458881.5 5438350 113.2 458881.5 5438350.1 113.2 458881.5 5438350.1
														114.2 458881.5 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10207_170_321284_424514">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458883 5438350 114.2 458881.5 5438350 114.2 458881.5 5438350.1 114.2 458883 5438350.1 114.2
														458883 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10208_1773_608580_43387">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10208_1773_608580_43387_0">
													<gml:posList>458878.5 5438350 114.2 458877 5438350 114.2 458877 5438350.1 114.2 458878.5 5438350.14
														114.2 458878.5 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10209_1571_771435_238540">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10209_1571_771435_238540_0">
													<gml:posList>458881.5 5438350 113.2 458883 5438350 113.2 458883 5438350.1 113.2 458881.5 5438350.1 113.2
														458881.5 5438350 113.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10210_599_287520_415766">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10210_599_287520_415766_0">
													<gml:posList>458883 5438350 113.2 458883 5438350 114.2 458883 5438350.1 114.2 458883 5438350.1 113.2
														458883 5438350 113.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10211_1784_120327_382264">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10211_1784_120327_382264_0">
													<gml:posList>458877 5438350 113.2 458878.5 5438350 113.2 458878.5 5438350.1 113.2 458877 5438350.1 113.2
														458877 5438350 113.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID10212_1143_394036_161326">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10212_1143_394036_161326_0">
													<gml:posList>458877 5438350 114.2 458877 5438350 113.2 458877 5438350.1 113.2 458877 5438350.1 114.2
														458877 5438350 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:CompositeSurface>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
					<bldg:opening>
						<bldg:Window gml:id="GML_3b09d6a5-4c24-4847-a8a2-e97475e3de47">
							<gml:name>Window South 1</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_5e07e2cc-c28c-480e-880f-dfdfe287bb9e">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10213_1986_38589_374102_0">
													<gml:posList>458878.5 5438350.1 114.2 458877 5438350.1 114.2 458877 5438350.1 113.2 458878.5 5438350.1
														113.2 458878.5 5438350.1 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:Window>
					</bldg:opening>
					<bldg:opening>
						<bldg:Window gml:id="GML_f75f01cc-c584-4a62-b34a-4a0e2640550d">
							<gml:name>Window South 2</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_d0ea2b6b-7992-4284-9a20-957a6c5c1cea">
											<gml:exterior>
												<gml:LinearRing gml:id="PolyID10214_1496_142050_398240_0">
													<gml:posList>458883 5438350.1 114.2 458881.5 5438350.1 114.2 458881.5 5438350.1 113.2 458883 5438350.1
														113.2 458883 5438350.1 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:Window>
					</bldg:opening>
				</bldg:WallSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:WallSurface>
					<gml:name>Wall North</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_d3909000-2f18-4472-8886-1c127ea67df1">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458885 5438355 112 458875 5438355 112 458875 5438355 115 458885 5438355 115
												458885 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
				</bldg:WallSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:WallSurface>
					<gml:name>Wall East</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:CompositeSurface gml:id="GML_6286ffa9-3811-4796-a92f-3fd037c8e668">
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID48550_1052_759732_38514">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458885 5438353 112.2 458885 5438353 114.2 458884.9 5438353 114.2 458884.9 5438353 112.2
														458885 5438353 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID48551_1224_68120_309441">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458885 5438353 114.2 458885 5438352 114.2 458884.9 5438352 114.2 458884.9 5438353 114.2
														458885 5438353 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID48552_1047_537781_300186">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458885 5438350 112 458885 5438355 112 458885 5438355 115 458885 5438352.5 117 458885
														5438350 115 458885 5438350 112 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458885 5438352 112.2 458885 5438353 112.2 458885 5438353 114.2 458885 5438352 114.2 458885
														5438352 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID48553_202_602233_363079">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458885 5438352 114.2 458885 5438352 112.2 458884.9 5438352 112.2 458884.9 5438352 114.2
														458885 5438352 114.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID48553_202_602233_363800">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458885 5438352 112.2 458885 5438353 112.2 458884.9 5438353 112.2 458884.9 5438352 112.2
														458885 5438352 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:CompositeSurface>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
					<bldg:opening>
						<bldg:Door gml:id="GML_93096bbb-5155-47fb-ae2c-e2f9327f3007">
							<gml:name>Door East</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_8f988da9-22d7-41e5-ae94-880afd46a3c9">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458884.9 5438352 112.2 458884.9 5438353 112.2 458884.9 5438353 114.2 458884.9 5438352 114.2
														458884.9 5438352 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:Door>
					</bldg:opening>
				</bldg:WallSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:WallSurface>
					<gml:name>Wall West</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_5cc4fd92-d5de-4dd8-971e-892c91da2d9f">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438355 112 458875 5438350 112 458875 5438350 115 458875 5438352.5 117
												458875 5438355 115 458875 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
				</bldg:WallSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:RoofSurface>
					<gml:name>Roof North</gml:name>
					<bldg:lod4MultiSurface>
						<gml:MultiSurface>
							<!-- Roof slab -->
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_ec6a8966-58d9-4894-8edd-9aceb91b923f">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458885 5438355 115 458875 5438355 115 458875 5438352.5 117 458885 5438352.5
												117 458885 5438355 115 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<!-- Roof overhanging -->
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_70fa738e-80a4-4774-8a3b-322f037fa482">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458874.6 5438352.5 117 458875 5438352.5 117 458875 5438355 115 458885 5438355 115 458885
												5438352.5 117 458885.4 5438352.5 117 458885.4 5438355.312347524 114.75012198097823 458874.6
												5438355.312347524 114.75012198097823 458874.6 5438352.5 117 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
				</bldg:RoofSurface>
			</bldg:boundedBy>
			<bldg:boundedBy>
				<bldg:RoofSurface>
					<gml:name>Roof South</gml:name>
					<bldg:lod4MultiSurface>
						<!-- Roof slab -->
						<gml:MultiSurface>
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_b41dc792-5da6-4cd9-8f85-247583f305e3">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList srsDimension="3">458875 5438350 115 458885 5438350 115 458885 5438352.5 117 458875 5438352.5
												117 458875 5438350 115 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
							<!-- Roof overhanging -->
							<gml:surfaceMember>
								<gml:Polygon gml:id="GML_db6d8edc-4870-4523-a606-d440f36f8ec8">
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458885.4 5438349.687652476 114.75012198097823 458885.4 5438352.5 117 458885 5438352.5 117
												458885 5438350 115 458875 5438350 115 458875 5438352.5 117 458874.6 5438352.5 117 458874.6
												5438349.687652476 114.75012198097823 458885.4 5438349.687652476 114.75012198097823 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Polygon>
							</gml:surfaceMember>
						</gml:MultiSurface>
					</bldg:lod4MultiSurface>
				</bldg:RoofSurface>
			</bldg:boundedBy>
			<bldg:lod4Solid>
				<gml:Solid>
					<gml:exterior>
						<gml:CompositeSurface>
							<!-- Ground Slab -->
							<gml:surfaceMember xlink:href="#GML_d3981803-d4b0-4b5b-969c-53f657594757"/>
							<!-- Wall South -->
							<gml:surfaceMember xlink:href="#GML_1d350a50-6acc-4d3c-8c28-326ca4305fd1"/>
							<!-- Window South 1 -->
							<gml:surfaceMember xlink:href="#GML_5e07e2cc-c28c-480e-880f-dfdfe287bb9e"/>
							<!-- Window South 2 -->
							<gml:surfaceMember xlink:href="#GML_d0ea2b6b-7992-4284-9a20-957a6c5c1cea"/>
							<!-- Wall North -->
							<gml:surfaceMember xlink:href="#GML_d3909000-2f18-4472-8886-1c127ea67df1"/>
							<!-- Wall East -->
							<gml:surfaceMember xlink:href="#GML_6286ffa9-3811-4796-a92f-3fd037c8e668"/>
							<!-- Door East -->
							<gml:surfaceMember xlink:href="#GML_8f988da9-22d7-41e5-ae94-880afd46a3c9"/>
							<!-- Wall West -->
							<gml:surfaceMember xlink:href="#GML_5cc4fd92-d5de-4dd8-971e-892c91da2d9f"/>
							<!-- Roof North -->
							<gml:surfaceMember xlink:href="#GML_ec6a8966-58d9-4894-8edd-9aceb91b923f"/>
							<!-- Roof South -->
							<gml:surfaceMember xlink:href="#GML_b41dc792-5da6-4cd9-8f85-247583f305e3"/>
						</gml:CompositeSurface>
					</gml:exterior>
				</gml:Solid>
			</bldg:lod4Solid>
			<bldg:interiorRoom>
				<bldg:Room>
					<bldg:lod4Solid>
						<gml:Solid>
							<gml:exterior>
								<gml:CompositeSurface>
									<!-- Floor -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_fa89e511-39b2-46de-9a13-9f4621576a46"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Interior Wall North -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_592ce9fa-0b98-4225-8d22-20eff4f86fc5"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Interior Wall West -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_a9fe597d-c338-43ad-a633-2a0beb273fac"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Interior Wall East -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_eaf1db16-56a3-4b86-ae19-2edbb604636f"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Door East -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="+">
											<gml:baseSurface xlink:href="#GML_8f988da9-22d7-41e5-ae94-880afd46a3c9"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Interior Wall South -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_a718c157-c948-42cf-a786-0ce61044cff9"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Window South 1 -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="+">
											<gml:baseSurface xlink:href="#GML_5e07e2cc-c28c-480e-880f-dfdfe287bb9e"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Window South 2 -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="+">
											<gml:baseSurface xlink:href="#GML_d0ea2b6b-7992-4284-9a20-957a6c5c1cea"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Ceiling North -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_989aa5cf-ee07-4fd8-89b6-500a9d5ba8041"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
									<!-- Ceiling South -->
									<gml:surfaceMember>
										<gml:OrientableSurface orientation="-">
											<gml:baseSurface xlink:href="#GML_98841838-ee0b-402f-ba28-64ed61cb10f8"/>
										</gml:OrientableSurface>
									</gml:surfaceMember>
								</gml:CompositeSurface>
							</gml:exterior>
						</gml:Solid>
					</bldg:lod4Solid>
					<bldg:boundedBy>
						<bldg:InteriorWallSurface>
							<gml:name>Interior Wall North</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_592ce9fa-0b98-4225-8d22-20eff4f86fc5">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458875.2 5438354.8 112.2 458884.8 5438354.8 112.2 458884.8 5438354.8 114.90387503050269
														458875.2 5438354.8 114.90387503050269 458875.2 5438354.8 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:InteriorWallSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:InteriorWallSurface>
							<gml:name>Interior Wall West</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_a9fe597d-c338-43ad-a633-2a0beb273fac">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458875.2 5438350.2 112.2 458875.2 5438354.8 112.2 458875.2 5438354.8 114.90387503050269
														458875.2 5438352.5 116.74387503050269 458875.2 5438350.2 114.90387503050269 458875.2 5438350.2 112.2
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:InteriorWallSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:InteriorWallSurface>
							<gml:name>Interior Wall East</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:CompositeSurface gml:id="GML_eaf1db16-56a3-4b86-ae19-2edbb604636f">
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_ec38f21c-daee-4610-aa55-87b6ac956d3a">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458884.8 5438352 112.2 458884.8 5438352 114.2 458884.9 5438352 114.2 458884.9 5438352
																114 458884.9 5438352 112.2 458884.8 5438352 112.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_7d51f0d1-f3ed-4683-a25c-577bb0f1a537">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458884.8 5438352 114.2 458884.8 5438353 114.2 458884.9 5438353 114.2 458884.9 5438352
																114.2 458884.8 5438352 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_0aa5c970-e574-4ced-9048-80a84b3b6661">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458884.8 5438353 114.2 458884.8 5438353 112.2 458884.9 5438353 112.2 458884.9 5438353
																114 458884.9 5438353 114.2 458884.8 5438353 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_d86e14ef-90d0-4331-b9ba-42fc869639c2">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458884.8 5438354.8 112.2 458884.8 5438353 112.2 458884.8 5438353 114.2 458884.8 5438352
																114.2 458884.8 5438352 112.2 458884.8 5438350.2 112.2 458884.8 5438350.2 114.90387503050269
																458884.8 5438352.5 116.74387503050269 458884.8 5438354.8 114.90387503050269 458884.8 5438354.8
																112.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
										</gml:CompositeSurface>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
							<bldg:opening>
								<bldg:Door>
									<gml:name>Door East</gml:name>
									<bldg:lod4MultiSurface>
										<gml:MultiSurface>
											<gml:surfaceMember>
												<gml:OrientableSurface orientation="-">
													<gml:baseSurface xlink:href="#GML_8f988da9-22d7-41e5-ae94-880afd46a3c9"> </gml:baseSurface>
												</gml:OrientableSurface>
											</gml:surfaceMember>
										</gml:MultiSurface>
									</bldg:lod4MultiSurface>
								</bldg:Door>
							</bldg:opening>
						</bldg:InteriorWallSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:InteriorWallSurface>
							<gml:name>Interior Wall South</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:CompositeSurface gml:id="GML_a718c157-c948-42cf-a786-0ce61044cff9">
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_473580a9-fc2c-4a04-a551-e24a256688a8">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458878.5 5438350.2 114.2 458878.5 5438350.2 113.2 458878.5 5438350.1 113.2 458878.5
																5438350.1 114 458878.5 5438350.1 114.2 458878.5 5438350.2 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_f9f9ee66-75f9-4119-a574-550be589e88c">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458883 5438350.2 114.2 458883 5438350.2 113.2 458883 5438350.1 113.2 458883 5438350.1
																114 458883 5438350.1 114.2 458883 5438350.2 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_e3415d97-1d1f-4edc-aa3d-f58185c1c99d">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458878.5 5438350.2 113.2 458877 5438350.2 113.2 458877 5438350.1 113.2 458878.5
																5438350.1 113.2 458878.5 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_0c892a7e-1c5b-4c12-8b92-949daede3313">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458877 5438350.2 114.2 458878.5 5438350.2 114.2 458878.5 5438350.1 114.2 458877
																5438350.1 114.2 458877 5438350.2 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_a7dc026d-ab34-486c-a406-f4ed3221c729">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458877 5438350.2 113.2 458877 5438350.2 114.2 458877 5438350.1 114.2 458877 5438350.1
																114 458877 5438350.1 113.2 458877 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_bb68f3bc-748d-44c5-a57b-6d346e880c3c">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458883 5438350.2 113.2 458881.5 5438350.2 113.2 458881.5 5438350.1 113.2 458883
																5438350.1 113.2 458883 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_cf0b79ba-f31f-4bae-a10f-5bcc85ce2cf6">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458884.8 5438350.2 112.2 458875.2 5438350.2 112.2 458875.2 5438350.2 114.90387503050269
																458884.8 5438350.2 114.90387503050269 458884.8 5438350.2 112.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
													<gml:interior>
														<gml:LinearRing>
															<gml:posList>458877 5438350.2 113.2 458878.5 5438350.2 113.2 458878.5 5438350.2 114.2 458877
																5438350.2 114.2 458877 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:interior>
													<gml:interior>
														<gml:LinearRing>
															<gml:posList>458883 5438350.2 113.2 458883 5438350.2 114.2 458881.5 5438350.2 114.2 458881.5
																5438350.2 113.2 458883 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:interior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_d717483a-d2b2-4862-92ee-4bea7216f2ab">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458881.5 5438350.2 114.2 458883 5438350.2 114.2 458883 5438350.1 114.2 458881.5
																5438350.1 114.2 458881.5 5438350.2 114.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
											<gml:surfaceMember>
												<gml:Polygon gml:id="GML_73ab206b-c69a-4d13-b498-df812c7a2091">
													<gml:exterior>
														<gml:LinearRing>
															<gml:posList>458881.5 5438350.2 113.2 458881.5 5438350.2 114.2 458881.5 5438350.1 114.2 458881.5
																5438350.1 114 458881.5 5438350.1 113.2 458881.5 5438350.2 113.2 </gml:posList>
														</gml:LinearRing>
													</gml:exterior>
												</gml:Polygon>
											</gml:surfaceMember>
										</gml:CompositeSurface>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
							<bldg:opening>
								<bldg:Window>
									<gml:name>Window South 1</gml:name>
									<bldg:lod4MultiSurface>
										<gml:MultiSurface>
											<gml:surfaceMember>
												<gml:OrientableSurface orientation="-">
													<gml:baseSurface xlink:href="#GML_5e07e2cc-c28c-480e-880f-dfdfe287bb9e"> </gml:baseSurface>
												</gml:OrientableSurface>
											</gml:surfaceMember>
										</gml:MultiSurface>
									</bldg:lod4MultiSurface>
								</bldg:Window>
							</bldg:opening>
							<bldg:opening>
								<bldg:Window>
									<gml:name>Window South 2</gml:name>
									<bldg:lod4MultiSurface>
										<gml:MultiSurface>
											<gml:surfaceMember>
												<gml:OrientableSurface orientation="-">
													<gml:baseSurface xlink:href="#GML_d0ea2b6b-7992-4284-9a20-957a6c5c1cea"> </gml:baseSurface>
												</gml:OrientableSurface>
											</gml:surfaceMember>
										</gml:MultiSurface>
									</bldg:lod4MultiSurface>
								</bldg:Window>
							</bldg:opening>
						</bldg:InteriorWallSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:FloorSurface>
							<gml:name>Floor</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_fa89e511-39b2-46de-9a13-9f4621576a46">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458884.8 5438354.8 112.2 458875.2 5438354.8 112.2 458875.2 5438350.2 112.2 458884.8
														5438350.2 112.2 458884.8 5438352 112.2 458884.9 5438352 112.2 458884.9 5438353 112.2 458884.8 5438353
														112.2 458884.8 5438354.8 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:FloorSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:CeilingSurface>
							<gml:name>Ceiling South</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_989aa5cf-ee07-4fd8-89b6-500a9d5ba8041">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458884.8 5438352.5 116.74387503050269 458884.8 5438350.2 114.90387503050269 458875.2
														5438350.2 114.90387503050269 458875.2 5438352.5 116.74387503050269 458884.8 5438352.5
														116.74387503050269 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:CeilingSurface>
					</bldg:boundedBy>
					<bldg:boundedBy>
						<bldg:CeilingSurface>
							<gml:name>Ceiling North</gml:name>
							<bldg:lod4MultiSurface>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="GML_98841838-ee0b-402f-ba28-64ed61cb10f8">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458875.2 5438352.5 116.74387503050269 458875.2 5438354.8 114.90387503050269 458884.8
														5438354.8 114.90387503050269 458884.8 5438352.5 116.74387503050269 458875.2 5438352.5
														116.74387503050269 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4MultiSurface>
						</bldg:CeilingSurface>
					</bldg:boundedBy>
					<bldg:interiorFurniture>
						<bldg:BuildingFurniture>
							<gml:name>Rocking Chair</gml:name>
							<bldg:function codeSpace="http://www.sig3d.org/codelists/standard/building/2.0/BuildingFurniture_function.xml">1340</bldg:function>
							<bldg:lod4Geometry>
								<gml:MultiSurface>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6359_229_231830_288314">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.40222883835 5438353.865271409 112.58055606508087 458879.36600271705
														5438353.844356248 112.63185315133651 458879.3262933766 5438353.82143005 112.67958913972109
														458879.2833623803 5438353.796643827 112.72344959590235 458879.2374925122 5438353.770160846
														112.76314561346568 458879.18898591463 5438353.742155549 112.79841571692483 458879.13816209783
														5438353.712812405 112.8290275840465 458879.08535583556 5438353.682324695 112.85477957614417
														458879.0309149598 5438353.650893241 112.87550206626103 458878.9751980695 5438353.618725079
														112.89105855649347 458878.91857216873 5438353.586032101 112.90134657709521 458878.8614102493
														5438353.553029651 112.90629836143986 458878.8040888336 5438353.519935116 112.90588129239611
														458878.80136643245 5438353.518363337 112.95748772150878 458878.79808260366 5438353.516467418
														113.00905057093928 458878.7942378659 5438353.514247658 113.06056169729784 458878.78983282635
														5438353.511704407 113.1120129653634 458878.78486818075 5438353.508838067 113.16339624936839
														458878.77934471314 5438353.505649092 113.21470343428207 458878.7732632958 5438353.502137983
														113.2659264170921 458878.7690134431 5438353.49968433 113.30124841121542 458878.75924968533
														5438353.494047222 113.33358981185793 458878.74463740643 5438353.4856108185 113.36074660601252
														458878.72617240913 5438353.474950047 113.38086810303629 458878.7051130525 5438353.462791422
														113.39258305615941 458878.6828944968 5438353.449963533 113.39509311068643 458878.6610308999
														5438353.43734058 113.38822721054937 458878.64101222984 5438353.425782795 113.37245325549617
														458878.6242027259 5438353.416077823 113.34884621449598 458878.61174792796 5438353.408887043
														113.31901486838049 458878.60449660994 5438353.4047004925 113.28499217408885 458878.60294293717
														5438353.403803479 113.24909672201187 458878.60506786353 5438353.4050303055 113.23143572495021
														458878.6099497424 5438353.407848859 113.21526502462896 458878.61725588183 5438353.412067061
														113.20168662755166 458878.6264883805 5438353.417397447 113.19162587903977 458878.6370180588
														5438353.423476759 113.18576840247822 458878.6481273367 5438353.429890704 113.1845133752147
														458878.6590591351 5438353.436202181 113.18794632528323 458878.66906847013 5438353.441981073
														113.19583330280984 458878.67747322213 5438353.446833558 113.20763682330994 458878.68370062107
														5438353.45042895 113.22255249636768 458878.6873262801 5438353.452522225 113.2395638435135
														458878.68810311646 5438353.452970731 113.257511569552 458878.68793156865 5438353.452871688
														113.25995287910392 458878.6872186616 5438353.452460091 113.26225973452737 458878.6860129788
														5438353.451763989 113.2642749274375 458878.6843966855 5438353.450830822 113.26586112576775
														458878.6824799294 5438353.4497241825 113.26691023272323 458878.68039333436 5438353.448519486
														113.26735075339864 458878.67827909824 5438353.447298831 113.26715266703797 458878.6762813029
														5438353.446145404 113.26632947289931 458878.6745360946 5438353.445137807 113.26493727030286
														458878.67316240654 5438353.444344709 113.26307093555483 458878.6722538533 5438353.443820155
														113.26085765628401 458878.6718723512 5438353.443599895 113.25844826381512 458878.6711733724
														5438353.443196339 113.24229933027396 458878.66832563304 5438353.441552196 113.22893792936362
														458878.663681615 5438353.438870971 113.21781472137594 458878.6579903937 5438353.435585142
														113.20982204678101 458878.6521568256 5438353.43221713 113.20522541566303 458878.64674096845
														5438353.429090284 113.20352465552673 458878.6414719458 5438353.426048212 113.20411990277544
														458878.63581051543 5438353.422779584 113.20726925781885 458878.6299452676 5438353.419393281
														113.21366067864275 458878.62470288196 5438353.416366588 113.2234036070236 458878.62094286724
														5438353.414195743 113.23585825253516 458878.61925017443 5438353.413218467 113.24992680721377
														458878.6206495176 5438353.414026378 113.28225668732838 458878.627122916 5438353.417763796
														113.31262943538453 458878.63799433293 5438353.424040412 113.33866831642996 458878.6520903063
														5438353.4321787255 113.358464511525 458878.66793320945 5438353.44132563 113.37094812016958
														458878.684280865 5438353.450763953 113.3760818303744 458878.7006591655 5438353.460219969
														113.3742315558622 458878.7168502742 5438353.469567911 113.36522472425722 458878.73194802075
														5438353.478284598 113.34877255492142 458878.74449654575 5438353.485529493 113.32545122946328
														458878.7531384393 5438353.490518892 113.29682588363047 458878.757164855 5438353.492843544
														113.2633609518305 458878.7632304107 5438353.496345495 113.21227156953222 458878.76872868434
														5438353.499519925 113.16119841000717 458878.77367068495 5438353.50237319 113.11004949849838
														458878.77805563196 5438353.50490484 113.05883291302227 458878.7818828329 5438353.507114476
														113.00755674228215 458878.78515168326 5438353.509001748 112.9562290843926 458878.7878616669
														5438353.5105663575 112.9048580455989 458878.79001235566 5438353.511808058 112.85345173899839
														458878.7916034101 5438353.512726653 112.8020182832574 458878.7926345788 5438353.513321999
														112.75056580133051 458878.79310677823 5438353.513594624 112.6989845124514 458878.79317797086
														5438353.513635727 112.69120769778465 458878.79658170434 5438353.515600873 112.68200099031416
														458878.8013310896 5438353.518342932 112.6723032167059 458878.8069830806 5438353.52160611
														112.66327387433691 458878.8134678683 5438353.525350104 112.6550244866448 458878.82070535776
														5438353.529528671 112.64765694367168 458878.8286061569 5438353.5340901995 112.6412622435972
														458878.8370726814 5438353.538978349 112.63591936879966 458878.8460003592 5438353.544132747
														112.63169431032692 458878.85527892253 5438353.549489728 112.62863925282609 458878.86479376984
														5438353.554983128 112.6267919299992 458878.87442738103 5438353.560545095 112.62617515854582
														458878.8852049237 5438353.566767513 112.62687035956935 458878.92427727294 5438353.589325944
														112.64064054707083 458878.9614129216 5438353.610766221 112.65117916904981 458878.9989958326
														5438353.632464725 112.65933417703286 458879.0369113503 5438353.654355259 112.66508069223536
														458879.0750438046 5438353.676371042 112.66840118355077 458879.1132768633 5438353.6984449085
														112.66928552103333 458879.15149388735 5438353.720509517 112.66773100680198 458879.1895782868
														5438353.742497556 112.66374238327081 458879.227413876 5438353.764341943 112.65733181868121
														458879.2648852286 5438353.785976039 112.6485188699798 458879.3011988588 5438353.806941723
														112.63753583780847 458879.33467054466 5438353.82626661 112.621601456597 458879.3638574264
														5438353.843117664 112.59826922796532 458879.38807432953 5438353.857099299 112.56829790085169
														458879.4062112901 5438353.867570679 112.53306118902809 458879.4174370138 5438353.874051853
														112.4941741413086 458879.4212369779 5438353.876245763 112.45341911697284 458879.4174370138
														5438353.874051853 112.41266409263708 458879.4062112901 5438353.867570679 112.37377704491759
														458879.38807432953 5438353.857099299 112.338540333094 458879.3638574264 5438353.843117664
														112.30856900598037 458879.33467054466 5438353.82626661 112.28523677734867 458879.30116642674
														5438353.806922998 112.26928695666026 458879.25320749444 5438353.779233896 112.25454658649173
														458879.2039783569 5438353.75081144 112.24226131458495 458879.15430123324 5438353.72213034
														112.23267748849505 458879.1042872402 5438353.693254747 112.22581654513318 458879.05404824804
														5438353.664249252 112.22169383092071 458879.0036966304 5438353.635178732 112.22031856746258
														458878.95334501285 5438353.606108211 112.22169383092071 458878.9031060207 5438353.577102716
														112.22581654513318 458878.85309202765 5438353.548227123 112.23267748849504 458878.803414904
														5438353.519546023 112.24226131458495 458878.75418576644 5438353.491123567 112.25454658649173
														458878.7072026764 5438353.463997867 112.26898702763418 458878.67356727673 5438353.44457846
														112.29044805549721 458878.64572303346 5438353.428502579 112.3208993127869 458878.6253802205
														5438353.416757651 112.35843917863587 458878.61383841285 5438353.410093985 112.4006694657734
														458878.6118349445 5438353.408937282 112.44489234524451 458878.61949780455 5438353.413361436
														112.48828269383085 458878.6363374608 5438353.423083816 112.52806857350605 458878.66127813275
														5438353.43748332 112.5617083132216 458878.69272651703 5438353.455640052 112.58705288037572
														458878.728673573 5438353.476394095 112.60248316906705 458878.76682286796 5438353.498419601
														112.60701343464558 458878.80571258335 5438353.520872588 112.60018296794496 458878.8393232734
														5438353.54027773 112.58845999243736 458878.87510180904 5438353.560934477 112.5783494990651
														458878.91129624756 5438353.581831345 112.57045580658537 458878.9478036527 5438353.602908906
														112.56480136451732 458878.98452019813 5438353.624107213 112.56140225399224 458879.0213414625
														5438353.6453659795 112.56026814201922 458879.0581627269 5438353.666624747 112.56140225399224
														458879.0948792723 5438353.687823054 112.56480136451732 458879.13138667744 5438353.708900615
														112.57045580658537 458879.167581116 5438353.729797483 112.5783494990651 458879.2033596516
														5438353.75045423 112.58845999243736 458879.2351676043 5438353.76881856 112.59955419636942
														458879.2622208474 5438353.784437758 112.59768763294127 458879.28871360595 5438353.799733359
														112.58749973876983 458879.31202009163 5438353.813189365 112.56974140284521 458879.33055200596
														5438353.82388877 112.54562282641359 458879.3430464296 5438353.831102429 112.516787650601
														458879.34865188825 5438353.834338742 112.48520094498666 458879.3469863791 5438353.83337716
														112.4530152913587 458879.33816340396 5438353.828283213 112.42242408882254 458879.3227842339
														5438353.819404045 112.39551207727669 458879.30189693404 5438353.807344757 112.37411326583378
														458879.27692493924 5438353.792927169 112.35968594813045 458879.24957004975 5438353.777133816
														112.35321332202591 458879.2379450912 5438353.770422143 112.35401539674758 458879.22689602366
														5438353.764042961 112.35826435900387 458879.21717582276 5438353.758431001 112.36567064903873
														458879.2094469042 5438353.753968707 112.37572954042576 458879.204235981 5438353.75096018
														112.38775553634008 458879.2018981689 5438353.749610443 112.40092908503396 458879.20259278593
														5438353.75001148 112.41435243093428 458879.2062724952 5438353.752135961 112.42711079520106
														458879.21268653054 5438353.755839107 112.43833471639368 458879.221397786 5438353.760868552
														112.44725930283128 458879.23181260394 5438353.76688155 112.45327635869674 458879.2454900487
														5438353.774778226 112.45651267174902 458879.24766004685 5438353.776031076 112.4573793933284
														458879.2495618338 5438353.777129073 112.45886510446343 458879.2510658059 5438353.777997391
														112.4608685563955 458879.25206946994 5438353.778576857 112.4632532171863 458879.2525044278
														5438353.77882798 112.46585657614379 458879.25234103796 5438353.778733647 112.46850121865726
														458879.25159043504 5438353.778300286 112.4710069167099 458879.25030377146 5438353.777557431
														112.47320291112028 458879.2485687312 5438353.776555705 112.47493954849838 458879.24650355434
														5438353.7753633745 112.47609847987682 458879.2442489794 5438353.774061695 112.47660072599738
														458879.24195865175 5438353.772739373 112.47641205961696 458879.2260123901 5438353.763532795
														112.47263890639213 458879.2114552133 5438353.755128205 112.46422864455425 458879.1992791689
														5438353.748098362 112.45175441954896 458879.1903140342 5438353.74292234 112.43606632919572
														458879.18517076823 5438353.739952873 112.41823349092634 458879.1841998762 5438353.739392329
														112.3994711831987 458879.1874675228 5438353.741278905 112.38105802627825 458879.1947510232
														5438353.745484036 112.36424884637995 458879.2055540189 5438353.751721149 112.3501891613354
														458879.2191403037 5438353.759565194 112.33983711544563 458879.23458399466 5438353.768481613
														112.33389818353048 458879.2508326298 5438353.777862767 112.33277709398541 458879.2827251531
														5438353.796275924 112.34032340043507 458879.3118395067 5438353.813085104 112.35714392411081
														458879.3361915956 5438353.827144789 112.38209237412141 458879.354121865 5438353.837496835
														112.41346855482787 458879.3644083968 5438353.843435767 112.44913423136664 458879.3663501809
														5438353.844556856 112.48665884682194 458879.3598148878 5438353.840783703 112.52348516066281
														458879.34524788695 5438353.832373441 112.55710352045942 458879.3236418955 5438353.819899216
														112.58522289054853 458879.2964693259 5438353.804211126 112.60592698232807 458879.26558194396
														5438353.786378288 112.61780484615838 458879.23308467376 5438353.76761598 112.62004702524851
														458879.1987221746 5438353.747776782 112.60806182843826 458879.163855208 5438353.727646329
														112.59820893119143 458879.12858293484 5438353.707281873 112.59051635497017 458879.0930056689
														5438353.686741329 112.58500597732258 458879.0572245912 5438353.666083114 112.58169346966336
														458879.0213414625 5438353.6453659795 112.58058825270458 458878.98545833386 5438353.624648846
														112.58169346966336 458878.94967725616 5438353.603990631 112.58500597732258 458878.9140999902
														5438353.583450087 112.59051635497017 458878.87882771703 5438353.563085631 112.59820893119143
														458878.8439607504 5438353.542955178 112.60806182843826 458878.8095982513 5438353.5231159795
														112.62004702524851 458878.76725258206 5438353.4986676965 112.62748448475781 458878.7246445803
														5438353.474067955 112.62242474344242 458878.68449620466 5438353.45088828 112.6051910365335
														458878.6493722839 5438353.430609475 112.5768843177932 458878.6215166656 5438353.414527026
														112.53931292646365 458878.60270887106 5438353.40366834 112.49487706378141 458878.59415041265
														5438353.398727112 112.44641545913025 458878.5963880368 5438353.400019005 112.3970240213731
														458878.60927879554 5438353.407461489 112.34985806059518 458878.6319991791 5438353.4205791075
														112.30793071507477 458878.66309772414 5438353.438533861 112.27392046072138 458878.7005877391
														5438353.460178731 112.25 458878.75006298866 5438353.48874328 112.23479358365047 458878.80010556086
														5438353.5176353725 112.22230531678953 458878.8506035215 5438353.546790384 112.21256313292353
														458878.90144391777 5438353.5761431 112.20558882317517 458878.9525130309 5438353.605627866
														112.20139798754145 458879.0036966304 5438353.635178732 112.2 458879.05488023 5438353.664729596
														112.20139798754145 458879.1059493431 5438353.694214363 112.20558882317517 458879.1567897394
														5438353.723567079 112.21256313292353 458879.20728770003 5438353.75272209 112.22230531678953
														458879.25733027223 5438353.7816141825 112.23479358365047 458879.3068055218 5438353.810178732 112.25
														458879.3431265917 5438353.831148711 112.26729084625546 458879.3754278656 5438353.84979786
														112.2931127451356 458879.40222883835 5438353.865271409 112.32628216886482 458879.422301107
														5438353.876860139 112.36527882126094 458879.4347246739 5438353.884032888 112.4083153193945
														458879.438930114 5438353.8864609 112.45341911697284 458879.4347246739 5438353.884032888
														112.49852291455119 458879.422301107 5438353.876860139 112.54155941268473 458879.40222883835
														5438353.865271409 112.58055606508087 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458878.80493916274 5438353.520426054 112.88555651117548 458878.8084031956 5438353.522426014
														112.88558171538318 458878.86080613243 5438353.552680864 112.88596299771018 458878.91654191486
														5438353.584859933 112.88113475580225 458878.97175505175 5438353.616737252 112.87110341179341
														458879.0260818573 5438353.648102848 112.8559350415954 458879.0791644836 5438353.678750116
														112.83572955842918 458879.1306532785 5438353.708477186 112.81062005470198 458879.1802090881
														5438353.737088246 112.78077192533503 458879.22750549094 5438353.764394837 112.74638177831623
														458879.27223094826 5438353.790217092 112.70767613965414 458879.31409085594 5438353.814384921
														112.66490996126363 458879.32998436526 5438353.823561043 112.64580381727026 458879.3068055218
														5438353.810178732 112.65683823394569 458879.26887243194 5438353.788278052 112.66831107053583
														458879.2304486264 5438353.766094057 112.67734802820426 458879.191651326 5438353.743694426
														112.68392153756981 458879.1525988911 5438353.721147492 112.68801154458424 458879.11341046053
														5438353.698522041 112.68960557171176 458879.07420558773 5438353.675887097 112.68869875599489
														458879.0351038765 5438353.653311714 112.68529386388984 458878.99622461595 5438353.630864762
														112.67940128282697 458878.9576864164 5438353.608614722 112.67103898952138 458878.91960684774
														5438353.586629473 112.66023249513065 458878.88210208085 5438353.564976085 112.64701476742715
														458878.87442371726 5438353.56054298 112.64651947769566 458878.8667451759 5438353.556109772
														112.64701107996083 458878.8591612963 5438353.551731218 112.64848350233254 458878.8517657485
														5438353.547461396 112.65091855859103 458878.84464987664 5438353.543353045 112.654286172809
														458878.8379015705 5438353.539456909 112.6585447508261 458878.8316041798 5438353.535821109
														112.66364169398781 458878.8258354852 5438353.5324905515 112.66951404880323 458878.820666737
														5438353.529506373 112.67608928449776 458878.81616177555 5438353.526905432 112.68328618885707
														458878.81237624283 5438353.524719854 112.69101587129732 458878.80935689463 5438353.522976632
														112.69918286077291 458878.80888361577 5438353.522703385 112.7508820563776 458878.8078477221
														5438353.522105311 112.80257030180908 458878.80624937726 5438353.521182506 112.85423943387363
														458878.80493916274 5438353.520426054 112.88555651117548 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6360_61_712837_266861">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.65112285665 5438354.008970438 112.64064054707083 458878.6815740885 5438354.026551465
														112.65117916904981 458878.9215740885 5438353.61085927 112.65117916904981 458878.89112285664
														5438353.593278243 112.64064054707083 458878.65112285665 5438354.008970438 112.64064054707083
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6361_1341_423466_226883">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59270887106 5438353.420988848 112.49487706378141 458878.5841504127 5438353.416047621
														112.44641545913025 458878.59415041265 5438353.398727112 112.44641545913025 458878.60270887106
														5438353.40366834 112.49487706378141 458878.59270887106 5438353.420988848 112.49487706378141
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6362_1766_499755_428131">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61024294095 5438353.985368407 112.64651947769566 458878.6039465371 5438353.981733177
														112.64701107996083 458878.8439465371 5438353.5660409825 112.64701107996083 458878.850242941
														5438353.569676213 112.64651947769566 458878.61024294095 5438353.985368407 112.64651947769566
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6363_944_551946_13425">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8374404805 5438354.1165409675 112.66773100680198 458878.86866968794
														5438354.134571159 112.66374238327081 458879.108669688 5438353.718878965 112.66374238327081
														458879.07744048046 5438353.700848774 112.66773100680198 458878.8374404805 5438354.1165409675
														112.66773100680198 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6364_1440_46047_34094">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.647293108 5438354.006759331 112.66023249513065 458878.61653919913 5438353.989003553
														112.64701476742715 458878.8565391991 5438353.57331136 112.64701476742715 458878.887293108
														5438353.591067137 112.66023249513065 458878.647293108 5438354.006759331 112.66023249513065
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6365_1961_149082_341138">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7747514126 5438354.080347418 112.66840118355077 458878.8061025207 5438354.098447988
														112.66928552103333 458879.0461025207 5438353.682755794 112.66928552103333 458879.0147514126
														5438353.6646552235 112.66840118355077 458878.7747514126 5438354.080347418 112.66840118355077
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6366_348_571609_283610">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61653919913 5438353.989003553 112.64701476742715 458878.61024294095
														5438353.985368407 112.64651947769566 458878.850242941 5438353.569676213 112.64651947769566
														458878.8565391991 5438353.57331136 112.64701476742715 458878.61653919913 5438353.989003553
														112.64701476742715 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6367_361_854713_93737">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8061025207 5438354.098447988 112.66928552103333 458878.8374404805 5438354.1165409675
														112.66773100680198 458879.07744048046 5438353.700848774 112.66773100680198 458879.0461025207
														5438353.682755794 112.66928552103333 458878.8061025207 5438354.098447988 112.66928552103333
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6368_1402_219575_339128">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5525683364 5438353.952069959 112.90588129239611 458878.55033596744
														5438353.9507810995 112.95748772150878 458878.79033596743 5438353.535088906 112.95748772150878
														458878.7925683364 5438353.536377764 112.90588129239611 458878.5525683364 5438353.952069959
														112.90588129239611 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6369_1804_262072_33296">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55033596744 5438353.9507810995 112.95748772150878 458878.54764322785
														5438353.9492264455 113.00905057093928 458878.78764322784 5438353.533534252 113.00905057093928
														458878.79033596743 5438353.535088906 112.95748772150878 458878.55033596744 5438353.9507810995
														112.95748772150878 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6370_1858_498024_170534">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54764322785 5438353.9492264455 113.00905057093928 458878.5444905429
														5438353.947406243 113.06056169729784 458878.7844905429 5438353.531714048 113.06056169729784
														458878.78764322784 5438353.533534252 113.00905057093928 458878.54764322785 5438353.9492264455
														113.00905057093928 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6371_1476_568445_216336">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.40222883835 5438353.865271409 112.58055606508087 458879.39222883834
														5438353.882591917 112.58055606508087 458879.36600271705 5438353.844356248 112.63185315133651
														458879.40222883835 5438353.865271409 112.58055606508087 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6372_483_513027_258221">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79571258334 5438353.538193096 112.60018296794496 458878.8293232734 5438353.557598238
														112.58845999243736 458878.8393232734 5438353.54027773 112.58845999243736 458878.80571258335
														5438353.520872588 112.60018296794496 458878.79571258334 5438353.538193096 112.60018296794496
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6373_744_895250_48988">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.75682286796 5438353.515740109 112.60701343464558 458878.79571258334
														5438353.538193096 112.60018296794496 458878.80571258335 5438353.520872588 112.60018296794496
														458878.76682286796 5438353.498419601 112.60701343464558 458878.75682286796 5438353.515740109
														112.60701343464558 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6374_666_260342_151303">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6827265171 5438353.472960561 112.58705288037572 458878.718673573 5438353.493714604
														112.60248316906705 458878.728673573 5438353.476394095 112.60248316906705 458878.69272651703
														5438353.455640052 112.58705288037572 458878.6827265171 5438353.472960561 112.58705288037572
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6375_609_392392_204271">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6512781328 5438353.454803827 112.5617083132216 458878.6827265171 5438353.472960561
														112.58705288037572 458878.69272651703 5438353.455640052 112.58705288037572 458878.66127813275
														5438353.43748332 112.5617083132216 458878.6512781328 5438353.454803827 112.5617083132216
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6376_30_859397_143599">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67449620465 5438353.468208788 112.6051910365335 458878.6393722839 5438353.447929983
														112.5768843177932 458878.6493722839 5438353.430609475 112.5768843177932 458878.68449620466
														5438353.45088828 112.6051910365335 458878.67449620465 5438353.468208788 112.6051910365335
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6377_1521_853414_346509">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.4247246739 5438353.9013533965 112.49852291455119 458879.412301107 5438353.894180647
														112.54155941268473 458879.422301107 5438353.876860139 112.54155941268473 458879.4347246739
														5438353.884032888 112.49852291455119 458879.4247246739 5438353.9013533965 112.49852291455119
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6378_383_153369_89738">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.42893011396 5438353.903781408 112.45341911697284 458879.4247246739
														5438353.9013533965 112.49852291455119 458879.4347246739 5438353.884032888 112.49852291455119
														458879.438930114 5438353.8864609 112.45341911697284 458879.42893011396 5438353.903781408
														112.45341911697284 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6379_1049_14394_312089">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.11858293484 5438353.724602381 112.59051635497017 458879.0830056689 5438353.704061837
														112.58500597732258 458879.0930056689 5438353.686741329 112.58500597732258 458879.12858293484
														5438353.707281873 112.59051635497017 458879.11858293484 5438353.724602381 112.59051635497017
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6380_643_326588_149441">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6393722839 5438353.447929983 112.5768843177932 458878.6115166656 5438353.431847534
														112.53931292646365 458878.6215166656 5438353.414527026 112.53931292646365 458878.6493722839
														5438353.430609475 112.5768843177932 458878.6393722839 5438353.447929983 112.5768843177932
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6381_434_345180_103084">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7995982513 5438353.540436488 112.62004702524851 458878.75725258205 5438353.515988205
														112.62748448475781 458878.76725258206 5438353.4986676965 112.62748448475781 458878.8095982513
														5438353.5231159795 112.62004702524851 458878.7995982513 5438353.540436488 112.62004702524851
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6382_1648_760657_187421">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.71464458026 5438353.491388463 112.62242474344242 458878.67449620465
														5438353.468208788 112.6051910365335 458878.68449620466 5438353.45088828 112.6051910365335
														458878.7246445803 5438353.474067955 112.62242474344242 458878.71464458026 5438353.491388463
														112.62242474344242 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6383_979_150880_141866">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.75725258205 5438353.515988205 112.62748448475781 458878.71464458026
														5438353.491388463 112.62242474344242 458878.7246445803 5438353.474067955 112.62242474344242
														458878.76725258206 5438353.4986676965 112.62748448475781 458878.75725258205 5438353.515988205
														112.62748448475781 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6384_1005_487572_38648">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.153855208 5438353.744966838 112.59820893119143 458879.11858293484 5438353.724602381
														112.59051635497017 458879.12858293484 5438353.707281873 112.59051635497017 458879.163855208
														5438353.727646329 112.59820893119143 458879.153855208 5438353.744966838 112.59820893119143
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6385_134_195609_220770">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.22458399465 5438353.785802121 112.33389818353048 458879.2408326298 5438353.795183275
														112.33277709398541 458879.2508326298 5438353.777862767 112.33277709398541 458879.23458399466
														5438353.768481613 112.33389818353048 458879.22458399465 5438353.785802121 112.33389818353048
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6386_1192_386874_155203">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2091403037 5438353.776885702 112.33983711544563 458879.22458399465 5438353.785802121
														112.33389818353048 458879.23458399466 5438353.768481613 112.33389818353048 458879.2191403037
														5438353.759565194 112.33983711544563 458879.2091403037 5438353.776885702 112.33983711544563
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6387_446_745265_8183">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.19555401895 5438353.769041657 112.3501891613354 458879.2091403037 5438353.776885702
														112.33983711544563 458879.2191403037 5438353.759565194 112.33983711544563 458879.2055540189
														5438353.751721149 112.3501891613354 458879.19555401895 5438353.769041657 112.3501891613354
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6388_781_347362_106079">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1847510232 5438353.7628045445 112.36424884637995 458879.19555401895
														5438353.769041657 112.3501891613354 458879.2055540189 5438353.751721149 112.3501891613354
														458879.1947510232 5438353.745484036 112.36424884637995 458879.1847510232 5438353.7628045445
														112.36424884637995 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6389_43_739714_362792">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1774675228 5438353.758599414 112.38105802627825 458879.1847510232 5438353.7628045445
														112.36424884637995 458879.1947510232 5438353.745484036 112.36424884637995 458879.1874675228
														5438353.741278905 112.38105802627825 458879.1774675228 5438353.758599414 112.38105802627825
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6390_1895_232164_186539">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1741998762 5438353.756712837 112.3994711831987 458879.1774675228 5438353.758599414
														112.38105802627825 458879.1874675228 5438353.741278905 112.38105802627825 458879.1841998762
														5438353.739392329 112.3994711831987 458879.1741998762 5438353.756712837 112.3994711831987
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6391_433_783286_118556">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1887221747 5438353.76509729 112.60806182843826 458879.153855208 5438353.744966838
														112.59820893119143 458879.163855208 5438353.727646329 112.59820893119143 458879.1987221746
														5438353.747776782 112.60806182843826 458879.1887221747 5438353.76509729 112.60806182843826
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6392_1751_508892_349818">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3136418955 5438353.837219724 112.58522289054853 458879.28646932594 5438353.821531634
														112.60592698232807 458879.2964693259 5438353.804211126 112.60592698232807 458879.3236418955
														5438353.819899216 112.58522289054853 458879.3136418955 5438353.837219724 112.58522289054853
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6393_1031_382117_190267">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.335247887 5438353.849693949 112.55710352045942 458879.3136418955 5438353.837219724
														112.58522289054853 458879.3236418955 5438353.819899216 112.58522289054853 458879.34524788695
														5438353.832373441 112.55710352045942 458879.335247887 5438353.849693949 112.55710352045942
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6394_1231_581708_24399">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3498148878 5438353.858104211 112.52348516066281 458879.335247887 5438353.849693949
														112.55710352045942 458879.34524788695 5438353.832373441 112.55710352045942 458879.3598148878
														5438353.840783703 112.52348516066281 458879.3498148878 5438353.858104211 112.52348516066281
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6395_1169_159464_357489">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.35635018086 5438353.861877364 112.48665884682194 458879.3498148878 5438353.858104211
														112.52348516066281 458879.3598148878 5438353.840783703 112.52348516066281 458879.3663501809
														5438353.844556856 112.48665884682194 458879.35635018086 5438353.861877364 112.48665884682194
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6396_361_624569_364149">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3544083968 5438353.860756275 112.44913423136664 458879.35635018086 5438353.861877364
														112.48665884682194 458879.3663501809 5438353.844556856 112.48665884682194 458879.3644083968
														5438353.843435767 112.44913423136664 458879.3544083968 5438353.860756275 112.44913423136664
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6397_716_210153_242528">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.344121865 5438353.854817343 112.41346855482787 458879.3544083968 5438353.860756275
														112.44913423136664 458879.3644083968 5438353.843435767 112.44913423136664 458879.354121865
														5438353.837496835 112.41346855482787 458879.344121865 5438353.854817343 112.41346855482787
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6398_1302_653636_123164">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3261915956 5438353.844465297 112.38209237412141 458879.344121865 5438353.854817343
														112.41346855482787 458879.354121865 5438353.837496835 112.41346855482787 458879.3361915956
														5438353.827144789 112.38209237412141 458879.3261915956 5438353.844465297 112.38209237412141
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6399_178_682565_340956">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8383465836 5438354.117064106 112.68801154458424 458878.80621207045 5438354.098511237
														112.68960557171176 458879.04621207044 5438353.682819043 112.68960557171176 458879.0783465836
														5438353.701371913 112.68801154458424 458878.8383465836 5438354.117064106 112.68801154458424
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6400_1062_839980_102608">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6815740885 5438354.026551465 112.65117916904981 458878.71239207557 5438354.044344237
														112.65933417703286 458878.95239207556 5438353.628652044 112.65933417703286 458878.9215740885
														5438353.61085927 112.65117916904981 458878.6815740885 5438354.026551465 112.65117916904981
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6401_546_38421_330232">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5916634066 5438353.9746415075 112.65091855859103 458878.58582839166 5438353.97127266
														112.654286172809 458878.8258283917 5438353.555580467 112.654286172809 458878.8316634066
														5438353.558949314 112.65091855859103 458878.5916634066 5438353.9746415075 112.65091855859103
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6402_1143_77449_430675">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80621207045 5438354.098511237 112.68960557171176 458878.7740640748 5438354.079950583
														112.68869875599489 458879.0140640748 5438353.664258389 112.68869875599489 458879.04621207044
														5438353.682819043 112.68960557171176 458878.80621207045 5438354.098511237 112.68960557171176
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6403_275_739225_424986">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.71239207557 5438354.044344237 112.65933417703286 458878.74348280014
														5438354.062294476 112.66508069223536 458878.98348280013 5438353.646602281 112.66508069223536
														458878.95239207556 5438353.628652044 112.65933417703286 458878.71239207557 5438354.044344237
														112.65933417703286 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6404_15_847599_38289">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7740640748 5438354.079950583 112.68869875599489 458878.74200067157 5438354.061438768
														112.68529386388984 458878.98200067156 5438353.645746575 112.68529386388984 458879.0140640748
														5438353.664258389 112.68869875599489 458878.7740640748 5438354.079950583 112.68869875599489
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6405_1051_535291_263269">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74348280014 5438354.062294476 112.66508069223536 458878.7747514126 5438354.080347418
														112.66840118355077 458879.0147514126 5438353.6646552235 112.66840118355077 458878.98348280013
														5438353.646602281 112.66508069223536 458878.74348280014 5438354.062294476 112.66508069223536
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6406_1680_481902_350602">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5977277558 5438353.978142762 112.64848350233254 458878.5916634066 5438353.9746415075
														112.65091855859103 458878.8316634066 5438353.558949314 112.65091855859103 458878.8377277558
														5438353.562450567 112.64848350233254 458878.5977277558 5438353.978142762 112.64848350233254
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6407_1691_360085_224875">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74200067157 5438354.061438768 112.68529386388984 458878.7101196779 5438354.043032268
														112.67940128282697 458878.95011967793 5438353.627340075 112.67940128282697 458878.98200067156
														5438353.645746575 112.68529386388984 458878.74200067157 5438354.061438768 112.68529386388984
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6408_1483_882586_237497">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6039465371 5438353.981733177 112.64701107996083 458878.5977277558 5438353.978142762
														112.64848350233254 458878.8377277558 5438353.562450567 112.64848350233254 458878.8439465371
														5438353.5660409825 112.64701107996083 458878.6039465371 5438353.981733177 112.64701107996083
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6409_1462_872380_250026">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86866968794 5438354.134571159 112.66374238327081 458878.89969487115
														5438354.152483556 112.65733181868121 458879.13969487114 5438353.736791363 112.65733181868121
														458879.108669688 5438353.718878965 112.66374238327081 458878.86866968794 5438354.134571159
														112.66374238327081 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6410_1609_794063_355653">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7101196779 5438354.043032268 112.67940128282697 458878.67851835425 5438354.024787235
														112.67103898952138 458878.91851835424 5438353.609095042 112.67103898952138 458878.95011967793
														5438353.627340075 112.67940128282697 458878.7101196779 5438354.043032268 112.67940128282697
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6411_1593_577294_361974">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67851835425 5438354.024787235 112.67103898952138 458878.647293108 5438354.006759331
														112.66023249513065 458878.887293108 5438353.591067137 112.66023249513065 458878.91851835424
														5438353.609095042 112.67103898952138 458878.67851835425 5438354.024787235 112.67103898952138
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6412_749_10675_331181">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2014552133 5438353.772448713 112.46422864455425 458879.1892791689 5438353.76541887
														112.45175441954896 458879.1992791689 5438353.748098362 112.45175441954896 458879.2114552133
														5438353.755128205 112.46422864455425 458879.2014552133 5438353.772448713 112.46422864455425
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6413_208_422566_39802">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2160123901 5438353.780853303 112.47263890639213 458879.2014552133 5438353.772448713
														112.46422864455425 458879.2114552133 5438353.755128205 112.46422864455425 458879.2260123901
														5438353.763532795 112.47263890639213 458879.2160123901 5438353.780853303 112.47263890639213
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6414_1979_303806_142949">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2319586518 5438353.790059881 112.47641205961696 458879.2160123901 5438353.780853303
														112.47263890639213 458879.2260123901 5438353.763532795 112.47263890639213 458879.24195865175
														5438353.772739373 112.47641205961696 458879.2319586518 5438353.790059881 112.47641205961696
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6415_1482_294014_303623">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.23424897936 5438353.791382203 112.47660072599738 458879.2319586518 5438353.790059881
														112.47641205961696 458879.24195865175 5438353.772739373 112.47641205961696 458879.2442489794
														5438353.774061695 112.47660072599738 458879.23424897936 5438353.791382203 112.47660072599738
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6416_1976_482399_57247">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2365035544 5438353.792683883 112.47609847987682 458879.23424897936 5438353.791382203
														112.47660072599738 458879.2442489794 5438353.774061695 112.47660072599738 458879.24650355434
														5438353.7753633745 112.47609847987682 458879.2365035544 5438353.792683883 112.47609847987682
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6417_317_321092_277222">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2385687312 5438353.793876213 112.47493954849838 458879.2365035544 5438353.792683883
														112.47609847987682 458879.24650355434 5438353.7753633745 112.47609847987682 458879.2485687312
														5438353.776555705 112.47493954849838 458879.2385687312 5438353.793876213 112.47493954849838
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6418_299_798824_336627">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24030377145 5438353.794877939 112.47320291112028 458879.2385687312 5438353.793876213
														112.47493954849838 458879.2485687312 5438353.776555705 112.47493954849838 458879.25030377146
														5438353.777557431 112.47320291112028 458879.24030377145 5438353.794877939 112.47320291112028
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6419_1808_345390_149819">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.22308467375 5438353.784936488 112.62004702524851 458879.1887221747 5438353.76509729
														112.60806182843826 458879.1987221746 5438353.747776782 112.60806182843826 458879.23308467376
														5438353.76761598 112.62004702524851 458879.22308467375 5438353.784936488 112.62004702524851
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6420_1580_142138_319736">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.255581944 5438353.803698796 112.61780484615838 458879.22308467375 5438353.784936488
														112.62004702524851 458879.23308467376 5438353.76761598 112.62004702524851 458879.26558194396
														5438353.786378288 112.61780484615838 458879.255581944 5438353.803698796 112.61780484615838
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6421_1138_307317_128501">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.28646932594 5438353.821531634 112.60592698232807 458879.255581944 5438353.803698796
														112.61780484615838 458879.26558194396 5438353.786378288 112.61780484615838 458879.2964693259
														5438353.804211126 112.60592698232807 458879.28646932594 5438353.821531634 112.60592698232807
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6422_1686_199272_428185">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24206946994 5438353.795897366 112.4632532171863 458879.24250442785 5438353.796148488
														112.46585657614379 458879.2525044278 5438353.77882798 112.46585657614379 458879.25206946994
														5438353.778576857 112.4632532171863 458879.24206946994 5438353.795897366 112.4632532171863
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6423_1462_364937_407799">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2410658059 5438353.795317899 112.4608685563955 458879.24206946994 5438353.795897366
														112.4632532171863 458879.25206946994 5438353.778576857 112.4632532171863 458879.2510658059
														5438353.777997391 112.4608685563955 458879.2410658059 5438353.795317899 112.4608685563955
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6424_1654_787190_240917">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.23956183384 5438353.794449581 112.45886510446343 458879.2410658059 5438353.795317899
														112.4608685563955 458879.2510658059 5438353.777997391 112.4608685563955 458879.2495618338
														5438353.777129073 112.45886510446343 458879.23956183384 5438353.794449581 112.45886510446343
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6425_374_417498_32511">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2376600469 5438353.793351583 112.4573793933284 458879.23956183384 5438353.794449581
														112.45886510446343 458879.2495618338 5438353.777129073 112.45886510446343 458879.24766004685
														5438353.776031076 112.4573793933284 458879.2376600469 5438353.793351583 112.4573793933284
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6426_802_327508_369001">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2354900487 5438353.7920987345 112.45651267174902 458879.2376600469 5438353.793351583
														112.4573793933284 458879.24766004685 5438353.776031076 112.4573793933284 458879.2454900487
														5438353.774778226 112.45651267174902 458879.2354900487 5438353.7920987345 112.45651267174902
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6427_699_779647_58620">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.221812604 5438353.784202058 112.45327635869674 458879.2354900487 5438353.7920987345
														112.45651267174902 458879.2454900487 5438353.774778226 112.45651267174902 458879.23181260394
														5438353.76688155 112.45327635869674 458879.221812604 5438353.784202058 112.45327635869674
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6428_1721_396446_67641">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.211397786 5438353.77818906 112.44725930283128 458879.221812604 5438353.784202058
														112.45327635869674 458879.23181260394 5438353.76688155 112.45327635869674 458879.221397786
														5438353.760868552 112.44725930283128 458879.211397786 5438353.77818906 112.44725930283128
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6429_534_630012_186601">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3018395067 5438353.8304056125 112.35714392411081 458879.3261915956 5438353.844465297
														112.38209237412141 458879.3361915956 5438353.827144789 112.38209237412141 458879.3118395067
														5438353.813085104 112.35714392411081 458879.3018395067 5438353.8304056125 112.35714392411081
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6430_1909_527822_425168">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.27272515313 5438353.813596432 112.34032340043507 458879.3018395067
														5438353.8304056125 112.35714392411081 458879.3118395067 5438353.813085104 112.35714392411081
														458879.2827251531 5438353.796275924 112.34032340043507 458879.27272515313 5438353.813596432
														112.34032340043507 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6431_141_422971_171526">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2408326298 5438353.795183275 112.33277709398541 458879.27272515313 5438353.813596432
														112.34032340043507 458879.2827251531 5438353.796275924 112.34032340043507 458879.2508326298
														5438353.777862767 112.33277709398541 458879.2408326298 5438353.795183275 112.33277709398541
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6432_18_17815_236190">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1925927859 5438353.767331989 112.41435243093428 458879.1962724952 5438353.769456469
														112.42711079520106 458879.2062724952 5438353.752135961 112.42711079520106 458879.20259278593
														5438353.75001148 112.41435243093428 458879.1925927859 5438353.767331989 112.41435243093428
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6433_1905_294736_200933">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1918981689 5438353.766930951 112.40092908503396 458879.1925927859 5438353.767331989
														112.41435243093428 458879.20259278593 5438353.75001148 112.41435243093428 458879.2018981689
														5438353.749610443 112.40092908503396 458879.1918981689 5438353.766930951 112.40092908503396
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6434_405_476153_406985">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.194235981 5438353.768280688 112.38775553634008 458879.1918981689 5438353.766930951
														112.40092908503396 458879.2018981689 5438353.749610443 112.40092908503396 458879.204235981
														5438353.75096018 112.38775553634008 458879.194235981 5438353.768280688 112.38775553634008
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6435_608_580382_300655">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1994469042 5438353.771289215 112.37572954042576 458879.194235981 5438353.768280688
														112.38775553634008 458879.204235981 5438353.75096018 112.38775553634008 458879.2094469042
														5438353.753968707 112.37572954042576 458879.1994469042 5438353.771289215 112.37572954042576
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6436_207_804065_423594">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.20717582275 5438353.775751509 112.36567064903873 458879.1994469042 5438353.771289215
														112.37572954042576 458879.2094469042 5438353.753968707 112.37572954042576 458879.21717582276
														5438353.758431001 112.36567064903873 458879.20717582275 5438353.775751509 112.36567064903873
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6437_1503_464927_296646">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.23957004974 5438353.794454324 112.35321332202591 458879.2279450912 5438353.787742651
														112.35401539674758 458879.2379450912 5438353.770422143 112.35401539674758 458879.24957004975
														5438353.777133816 112.35321332202591 458879.23957004974 5438353.794454324 112.35321332202591
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6438_410_251509_312150">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.26692493923 5438353.810247677 112.35968594813045 458879.23957004974
														5438353.794454324 112.35321332202591 458879.24957004975 5438353.777133816 112.35321332202591
														458879.27692493924 5438353.792927169 112.35968594813045 458879.26692493923 5438353.810247677
														112.35968594813045 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6439_1275_503602_67372">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0472245912 5438353.683403622 112.58169346966336 458879.0113414625 5438353.662686488
														112.58058825270458 458879.0213414625 5438353.6453659795 112.58058825270458 458879.0572245912
														5438353.666083114 112.58169346966336 458879.0472245912 5438353.683403622 112.58169346966336
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6440_81_892527_80233">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1751707682 5438353.757273382 112.41823349092634 458879.1741998762 5438353.756712837
														112.3994711831987 458879.1841998762 5438353.739392329 112.3994711831987 458879.18517076823
														5438353.739952873 112.41823349092634 458879.1751707682 5438353.757273382 112.41823349092634
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6441_1634_111785_342358">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.18031403416 5438353.760242848 112.43606632919572 458879.1751707682 5438353.757273382
														112.41823349092634 458879.18517076823 5438353.739952873 112.41823349092634 458879.1903140342
														5438353.74292234 112.43606632919572 458879.18031403416 5438353.760242848 112.43606632919572
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6442_928_91820_21437">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1892791689 5438353.76541887 112.45175441954896 458879.18031403416 5438353.760242848
														112.43606632919572 458879.1903140342 5438353.74292234 112.43606632919572 458879.1992791689
														5438353.748098362 112.45175441954896 458879.1892791689 5438353.76541887 112.45175441954896
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6443_1089_66649_378566">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8339607504 5438353.560275686 112.60806182843826 458878.7995982513 5438353.540436488
														112.62004702524851 458878.8095982513 5438353.5231159795 112.62004702524851 458878.8439607504
														5438353.542955178 112.60806182843826 458878.8339607504 5438353.560275686 112.60806182843826
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6444_675_85427_327063">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86882771703 5438353.580406139 112.59820893119143 458878.8339607504 5438353.560275686
														112.60806182843826 458878.8439607504 5438353.542955178 112.60806182843826 458878.87882771703
														5438353.563085631 112.59820893119143 458878.86882771703 5438353.580406139 112.59820893119143
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6445_54_618110_394379">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6115166656 5438353.431847534 112.53931292646365 458878.59270887106 5438353.420988848
														112.49487706378141 458878.60270887106 5438353.40366834 112.49487706378141 458878.6215166656
														5438353.414527026 112.53931292646365 458878.6115166656 5438353.431847534 112.53931292646365
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6446_985_462993_286625">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9040999902 5438353.6007705955 112.59051635497017 458878.86882771703
														5438353.580406139 112.59820893119143 458878.87882771703 5438353.563085631 112.59820893119143
														458878.9140999902 5438353.583450087 112.59051635497017 458878.9040999902 5438353.6007705955
														112.59051635497017 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6447_841_57077_331655">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0830056689 5438353.704061837 112.58500597732258 458879.0472245912 5438353.683403622
														112.58169346966336 458879.0572245912 5438353.666083114 112.58169346966336 458879.0930056689
														5438353.686741329 112.58500597732258 458879.0830056689 5438353.704061837 112.58500597732258
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6448_1730_448910_402850">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97545833385 5438353.641969354 112.58169346966336 458878.93967725616
														5438353.621311139 112.58500597732258 458878.94967725616 5438353.603990631 112.58500597732258
														458878.98545833386 5438353.624648846 112.58169346966336 458878.97545833385 5438353.641969354
														112.58169346966336 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6449_1402_519912_103917">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.29189693403 5438353.824665265 112.37411326583378 458879.26692493923
														5438353.810247677 112.35968594813045 458879.27692493924 5438353.792927169 112.35968594813045
														458879.30189693404 5438353.807344757 112.37411326583378 458879.29189693403 5438353.824665265
														112.37411326583378 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6450_369_238135_98855">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.31278423394 5438353.836724553 112.39551207727669 458879.29189693403
														5438353.824665265 112.37411326583378 458879.30189693404 5438353.807344757 112.37411326583378
														458879.3227842339 5438353.819404045 112.39551207727669 458879.31278423394 5438353.836724553
														112.39551207727669 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6451_148_495091_294084">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24159043503 5438353.795620794 112.4710069167099 458879.24030377145 5438353.794877939
														112.47320291112028 458879.25030377146 5438353.777557431 112.47320291112028 458879.25159043504
														5438353.778300286 112.4710069167099 458879.24159043503 5438353.795620794 112.4710069167099
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6452_732_412652_211060">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24234103795 5438353.796054155 112.46850121865726 458879.24159043503
														5438353.795620794 112.4710069167099 458879.25159043504 5438353.778300286 112.4710069167099
														458879.25234103796 5438353.778733647 112.46850121865726 458879.24234103795 5438353.796054155
														112.46850121865726 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6453_370_833246_90427">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24250442785 5438353.796148488 112.46585657614379 458879.24234103795
														5438353.796054155 112.46850121865726 458879.25234103796 5438353.778733647 112.46850121865726
														458879.2525044278 5438353.77882798 112.46585657614379 458879.24250442785 5438353.796148488
														112.46585657614379 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6454_1709_684819_309577">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3369863791 5438353.850697668 112.4530152913587 458879.32816340396 5438353.845603721
														112.42242408882254 458879.33816340396 5438353.828283213 112.42242408882254 458879.3469863791
														5438353.83337716 112.4530152913587 458879.3369863791 5438353.850697668 112.4530152913587
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6455_1847_544198_89050">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.33865188824 5438353.85165925 112.48520094498666 458879.3369863791 5438353.850697668
														112.4530152913587 458879.3469863791 5438353.83337716 112.4530152913587 458879.34865188825
														5438353.834338742 112.48520094498666 458879.33865188824 5438353.85165925 112.48520094498666
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6456_1156_435534_113970">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3020200916 5438353.830509873 112.56974140284521 458879.32055200595 5438353.841209278
														112.54562282641359 458879.33055200596 5438353.82388877 112.54562282641359 458879.31202009163
														5438353.813189365 112.56974140284521 458879.3020200916 5438353.830509873 112.56974140284521
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6457_1036_584809_173347">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.27871360594 5438353.817053867 112.58749973876983 458879.3020200916 5438353.830509873
														112.56974140284521 458879.31202009163 5438353.813189365 112.56974140284521 458879.28871360595
														5438353.799733359 112.58749973876983 458879.27871360594 5438353.817053867 112.58749973876983
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6458_551_663531_231314">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.25222084747 5438353.801758266 112.59768763294127 458879.27871360594
														5438353.817053867 112.58749973876983 458879.28871360595 5438353.799733359 112.58749973876983
														458879.2622208474 5438353.784437758 112.59768763294127 458879.25222084747 5438353.801758266
														112.59768763294127 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6459_0_305850_288277">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2251676043 5438353.786139068 112.59955419636942 458879.25222084747 5438353.801758266
														112.59768763294127 458879.2622208474 5438353.784437758 112.59768763294127 458879.2351676043
														5438353.76881856 112.59955419636942 458879.2251676043 5438353.786139068 112.59955419636942
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6460_373_268986_106406">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1933596516 5438353.767774738 112.58845999243736 458879.2251676043 5438353.786139068
														112.59955419636942 458879.2351676043 5438353.76881856 112.59955419636942 458879.2033596516
														5438353.75045423 112.58845999243736 458879.1933596516 5438353.767774738 112.58845999243736
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6461_1091_368333_179650">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.157581116 5438353.747117992 112.5783494990651 458879.1933596516 5438353.767774738
														112.58845999243736 458879.2033596516 5438353.75045423 112.58845999243736 458879.167581116
														5438353.729797483 112.5783494990651 458879.157581116 5438353.747117992 112.5783494990651
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6462_1135_578813_95070">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.20268653053 5438353.773159615 112.43833471639368 458879.211397786 5438353.77818906
														112.44725930283128 458879.221397786 5438353.760868552 112.44725930283128 458879.21268653054
														5438353.755839107 112.43833471639368 458879.20268653053 5438353.773159615 112.43833471639368
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6463_1868_89699_319355">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1962724952 5438353.769456469 112.42711079520106 458879.20268653053 5438353.773159615
														112.43833471639368 458879.21268653054 5438353.755839107 112.43833471639368 458879.2062724952
														5438353.752135961 112.42711079520106 458879.1962724952 5438353.769456469 112.42711079520106
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6464_1318_66764_231374">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.12138667743 5438353.726221123 112.57045580658537 458879.157581116 5438353.747117992
														112.5783494990651 458879.167581116 5438353.729797483 112.5783494990651 458879.13138667744
														5438353.708900615 112.57045580658537 458879.12138667743 5438353.726221123 112.57045580658537
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6465_395_805738_57452">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.08487927226 5438353.7051435625 112.56480136451732 458879.12138667743
														5438353.726221123 112.57045580658537 458879.13138667744 5438353.708900615 112.57045580658537
														458879.0948792723 5438353.687823054 112.56480136451732 458879.08487927226 5438353.7051435625
														112.56480136451732 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6466_1374_583615_195897">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0113414625 5438353.662686488 112.56026814201922 458879.0481627269 5438353.683945255
														112.56140225399224 458879.0581627269 5438353.666624747 112.56140225399224 458879.0213414625
														5438353.6453659795 112.56026814201922 458879.0113414625 5438353.662686488 112.56026814201922
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6467_349_184535_395838">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9745201981 5438353.641427721 112.56140225399224 458879.0113414625 5438353.662686488
														112.56026814201922 458879.0213414625 5438353.6453659795 112.56026814201922 458878.98452019813
														5438353.624107213 112.56140225399224 458878.9745201981 5438353.641427721 112.56140225399224
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6468_1093_514974_165079">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9378036528 5438353.620229414 112.56480136451732 458878.9745201981 5438353.641427721
														112.56140225399224 458878.98452019813 5438353.624107213 112.56140225399224 458878.9478036527
														5438353.602908906 112.56480136451732 458878.9378036528 5438353.620229414 112.56480136451732
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6469_1998_325204_72930">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9012962476 5438353.5991518535 112.57045580658537 458878.9378036528 5438353.620229414
														112.56480136451732 458878.9478036527 5438353.602908906 112.56480136451732 458878.91129624756
														5438353.581831345 112.57045580658537 458878.9012962476 5438353.5991518535 112.57045580658537
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6470_654_411849_175877">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86510180903 5438353.578254985 112.5783494990651 458878.9012962476 5438353.5991518535
														112.57045580658537 458878.91129624756 5438353.581831345 112.57045580658537 458878.87510180904
														5438353.560934477 112.5783494990651 458878.86510180903 5438353.578254985 112.5783494990651
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6471_898_288163_345885">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8293232734 5438353.557598238 112.58845999243736 458878.86510180903 5438353.578254985
														112.5783494990651 458878.87510180904 5438353.560934477 112.5783494990651 458878.8393232734
														5438353.54027773 112.58845999243736 458878.8293232734 5438353.557598238 112.58845999243736
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6472_620_566191_294115">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.21689602366 5438353.78136347 112.35826435900387 458879.20717582275 5438353.775751509
														112.36567064903873 458879.21717582276 5438353.758431001 112.36567064903873 458879.22689602366
														5438353.764042961 112.35826435900387 458879.21689602366 5438353.78136347 112.35826435900387
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6473_295_785888_108067">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2279450912 5438353.787742651 112.35401539674758 458879.21689602366 5438353.78136347
														112.35826435900387 458879.22689602366 5438353.764042961 112.35826435900387 458879.2379450912
														5438353.770422143 112.35401539674758 458879.2279450912 5438353.787742651 112.35401539674758
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6474_1543_404938_276535">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.4247246739 5438353.9013533965 112.4083153193945 458879.42893011396 5438353.903781408
														112.45341911697284 458879.438930114 5438353.8864609 112.45341911697284 458879.4347246739
														5438353.884032888 112.4083153193945 458879.4247246739 5438353.9013533965 112.4083153193945
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6475_367_646724_27541">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.412301107 5438353.894180647 112.36527882126094 458879.4247246739 5438353.9013533965
														112.4083153193945 458879.4347246739 5438353.884032888 112.4083153193945 458879.422301107
														5438353.876860139 112.36527882126094 458879.412301107 5438353.894180647 112.36527882126094
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6476_1796_657999_403647">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.39222883834 5438353.882591917 112.32628216886482 458879.412301107 5438353.894180647
														112.36527882126094 458879.422301107 5438353.876860139 112.36527882126094 458879.40222883835
														5438353.865271409 112.32628216886482 458879.39222883834 5438353.882591917 112.32628216886482
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6477_607_721853_65499">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3654278656 5438353.867118368 112.2931127451356 458879.39222883834 5438353.882591917
														112.32628216886482 458879.40222883835 5438353.865271409 112.32628216886482 458879.3754278656
														5438353.84979786 112.2931127451356 458879.3654278656 5438353.867118368 112.2931127451356
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6478_604_847015_5460">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3331265917 5438353.848469219 112.26729084625546 458879.3654278656 5438353.867118368
														112.2931127451356 458879.3754278656 5438353.84979786 112.2931127451356 458879.3431265917
														5438353.831148711 112.26729084625546 458879.3331265917 5438353.848469219 112.26729084625546
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6479_861_804024_311858">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.29680552176 5438353.82749924 112.25 458879.3331265917 5438353.848469219
														112.26729084625546 458879.3431265917 5438353.831148711 112.26729084625546 458879.3068055218
														5438353.810178732 112.25 458879.29680552176 5438353.82749924 112.25 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6480_402_275132_311914">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2473302722 5438353.798934691 112.23479358365047 458879.29680552176 5438353.82749924
														112.25 458879.3068055218 5438353.810178732 112.25 458879.25733027223 5438353.7816141825
														112.23479358365047 458879.2473302722 5438353.798934691 112.23479358365047 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6481_1000_18033_379428">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1972877 5438353.770042598 112.22230531678953 458879.2473302722 5438353.798934691
														112.23479358365047 458879.25733027223 5438353.7816141825 112.23479358365047 458879.20728770003
														5438353.75272209 112.22230531678953 458879.1972877 5438353.770042598 112.22230531678953 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6482_177_815103_297915">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.93967725616 5438353.621311139 112.58500597732258 458878.9040999902
														5438353.6007705955 112.59051635497017 458878.9140999902 5438353.583450087 112.59051635497017
														458878.94967725616 5438353.603990631 112.58500597732258 458878.93967725616 5438353.621311139
														112.58500597732258 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6483_1829_13654_333062">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0113414625 5438353.662686488 112.58058825270458 458878.97545833385 5438353.641969354
														112.58169346966336 458878.98545833386 5438353.624648846 112.58169346966336 458879.0213414625
														5438353.6453659795 112.58058825270458 458879.0113414625 5438353.662686488 112.58058825270458
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6484_657_501106_425109">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.32816340396 5438353.845603721 112.42242408882254 458879.31278423394
														5438353.836724553 112.39551207727669 458879.3227842339 5438353.819404045 112.39551207727669
														458879.33816340396 5438353.828283213 112.42242408882254 458879.32816340396 5438353.845603721
														112.42242408882254 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6485_356_289936_387054">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0959493431 5438353.711534871 112.20558882317517 458879.1467897394 5438353.740887587
														112.21256313292353 458879.1567897394 5438353.723567079 112.21256313292353 458879.1059493431
														5438353.694214363 112.20558882317517 458879.0959493431 5438353.711534871 112.20558882317517
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6486_0_443926_165346">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.04488023 5438353.682050104 112.20139798754145 458879.0959493431 5438353.711534871
														112.20558882317517 458879.1059493431 5438353.694214363 112.20558882317517 458879.05488023
														5438353.664729596 112.20139798754145 458879.04488023 5438353.682050104 112.20139798754145
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6487_251_442104_319849">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99369663046 5438353.65249924 112.2 458879.04488023 5438353.682050104
														112.20139798754145 458879.05488023 5438353.664729596 112.20139798754145 458879.0036966304
														5438353.635178732 112.2 458878.99369663046 5438353.65249924 112.2 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6488_697_464334_229638">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9425130309 5438353.622948375 112.20139798754145 458878.99369663046 5438353.65249924
														112.2 458879.0036966304 5438353.635178732 112.2 458878.9525130309 5438353.605627866 112.20139798754145
														458878.9425130309 5438353.622948375 112.20139798754145 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6489_1181_369850_67625">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8914439178 5438353.593463608 112.20558882317517 458878.9425130309 5438353.622948375
														112.20139798754145 458878.9525130309 5438353.605627866 112.20139798754145 458878.90144391777
														5438353.5761431 112.20558882317517 458878.8914439178 5438353.593463608 112.20558882317517
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6490_344_539420_266845">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8406035215 5438353.564110892 112.21256313292353 458878.8914439178 5438353.593463608
														112.20558882317517 458878.90144391777 5438353.5761431 112.20558882317517 458878.8506035215
														5438353.546790384 112.21256313292353 458878.8406035215 5438353.564110892 112.21256313292353
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6491_589_95366_254196">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79010556085 5438353.534955881 112.22230531678953 458878.8406035215 5438353.564110892
														112.21256313292353 458878.8506035215 5438353.546790384 112.21256313292353 458878.80010556086
														5438353.5176353725 112.22230531678953 458878.79010556085 5438353.534955881 112.22230531678953
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6492_376_764106_423399">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74006298865 5438353.506063788 112.23479358365047 458878.79010556085
														5438353.534955881 112.22230531678953 458878.80010556086 5438353.5176353725 112.22230531678953
														458878.75006298866 5438353.48874328 112.23479358365047 458878.74006298865 5438353.506063788
														112.23479358365047 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6493_124_8355_21925">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6905877391 5438353.477499239 112.25 458878.74006298865 5438353.506063788
														112.23479358365047 458878.75006298866 5438353.48874328 112.23479358365047 458878.7005877391
														5438353.460178731 112.25 458878.6905877391 5438353.477499239 112.25 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6494_1164_894003_96582">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3330464296 5438353.848422937 112.516787650601 458879.33865188824 5438353.85165925
														112.48520094498666 458879.34865188825 5438353.834338742 112.48520094498666 458879.3430464296
														5438353.831102429 112.516787650601 458879.3330464296 5438353.848422937 112.516787650601 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6495_684_517699_50082">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.32055200595 5438353.841209278 112.54562282641359 458879.3330464296 5438353.848422937
														112.516787650601 458879.3430464296 5438353.831102429 112.516787650601 458879.33055200596
														5438353.82388877 112.54562282641359 458879.32055200595 5438353.841209278 112.54562282641359
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6496_634_69855_194204">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.65309772413 5438353.455854369 112.27392046072138 458878.6905877391 5438353.477499239
														112.25 458878.7005877391 5438353.460178731 112.25 458878.66309772414 5438353.438533861
														112.27392046072138 458878.65309772413 5438353.455854369 112.27392046072138 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6497_1848_272057_35776">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6219991791 5438353.437899616 112.30793071507477 458878.65309772413 5438353.455854369
														112.27392046072138 458878.66309772414 5438353.438533861 112.27392046072138 458878.6319991791
														5438353.4205791075 112.30793071507477 458878.6219991791 5438353.437899616 112.30793071507477
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6498_604_894170_175827">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5992787956 5438353.424781997 112.34985806059518 458878.6219991791 5438353.437899616
														112.30793071507477 458878.6319991791 5438353.4205791075 112.30793071507477 458878.60927879554
														5438353.407461489 112.34985806059518 458878.5992787956 5438353.424781997 112.34985806059518
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6499_1766_704528_225404">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5863880368 5438353.417339513 112.3970240213731 458878.5992787956 5438353.424781997
														112.34985806059518 458878.60927879554 5438353.407461489 112.34985806059518 458878.5963880368
														5438353.400019005 112.3970240213731 458878.5863880368 5438353.417339513 112.3970240213731
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6500_1873_54969_238361">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5841504127 5438353.416047621 112.44641545913025 458878.5863880368 5438353.417339513
														112.3970240213731 458878.5963880368 5438353.400019005 112.3970240213731 458878.59415041265
														5438353.398727112 112.44641545913025 458878.5841504127 5438353.416047621 112.44641545913025
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6501_685_721911_1986">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6674732221 5438353.4641540665 113.20763682330994 458878.67370062106
														5438353.467749457 113.22255249636768 458878.68370062107 5438353.45042895 113.22255249636768
														458878.67747322213 5438353.446833558 113.20763682330994 458878.6674732221 5438353.4641540665
														113.20763682330994 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6502_87_307084_221729">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6590684701 5438353.459301581 113.19583330280984 458878.6674732221 5438353.4641540665
														113.20763682330994 458878.67747322213 5438353.446833558 113.20763682330994 458878.66906847013
														5438353.441981073 113.19583330280984 458878.6590684701 5438353.459301581 113.19583330280984
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6503_1504_418181_283053">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6490591351 5438353.453522689 113.18794632528323 458878.6590684701 5438353.459301581
														113.19583330280984 458878.66906847013 5438353.441981073 113.19583330280984 458878.6590591351
														5438353.436202181 113.18794632528323 458878.6490591351 5438353.453522689 113.18794632528323
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6504_630_439593_397971">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0481627269 5438353.683945255 112.56140225399224 458879.08487927226
														5438353.7051435625 112.56480136451732 458879.0948792723 5438353.687823054 112.56480136451732
														458879.0581627269 5438353.666624747 112.56140225399224 458879.0481627269 5438353.683945255
														112.56140225399224 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6505_661_726151_221599">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61470288195 5438353.433687096 113.2234036070236 458878.6109428673 5438353.4315162515
														113.23585825253516 458878.62094286724 5438353.414195743 113.23585825253516 458878.62470288196
														5438353.416366588 113.2234036070236 458878.61470288195 5438353.433687096 113.2234036070236
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6506_6_658607_402915">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61994526756 5438353.43671379 113.21366067864275 458878.61470288195 5438353.433687096
														113.2234036070236 458878.62470288196 5438353.416366588 113.2234036070236 458878.6299452676
														5438353.419393281 113.21366067864275 458878.61994526756 5438353.43671379 113.21366067864275
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6507_203_312706_72947">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6258105155 5438353.4401000915 113.20726925781885 458878.61994526756 5438353.43671379
														113.21366067864275 458878.6299452676 5438353.419393281 113.21366067864275 458878.63581051543
														5438353.422779584 113.20726925781885 458878.6258105155 5438353.4401000915 113.20726925781885
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6508_1763_615995_258569">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6618723512 5438353.460920403 113.25844826381512 458878.6611733724 5438353.460516847
														113.24229933027396 458878.6711733724 5438353.443196339 113.24229933027396 458878.6718723512
														5438353.443599895 113.25844826381512 458878.6618723512 5438353.460920403 113.25844826381512
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6509_1145_191811_35347">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6622538533 5438353.461140662 113.26085765628401 458878.6618723512 5438353.460920403
														113.25844826381512 458878.6718723512 5438353.443599895 113.25844826381512 458878.6722538533
														5438353.443820155 113.26085765628401 458878.6622538533 5438353.461140662 113.26085765628401
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6510_858_120208_140456">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66316240653 5438353.461665216 113.26307093555483 458878.6622538533 5438353.461140662
														113.26085765628401 458878.6722538533 5438353.443820155 113.26085765628401 458878.67316240654
														5438353.444344709 113.26307093555483 458878.66316240653 5438353.461665216 113.26307093555483
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6511_1663_50864_124778">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6645360946 5438353.462458315 113.26493727030286 458878.66316240653 5438353.461665216
														113.26307093555483 458878.67316240654 5438353.444344709 113.26307093555483 458878.6745360946
														5438353.445137807 113.26493727030286 458878.6645360946 5438353.462458315 113.26493727030286
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6512_1718_481668_386085">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66628130286 5438353.463465912 113.26632947289931 458878.6645360946 5438353.462458315
														113.26493727030286 458878.6745360946 5438353.445137807 113.26493727030286 458878.6762813029
														5438353.446145404 113.26632947289931 458878.66628130286 5438353.463465912 113.26632947289931
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6513_1671_897104_109382">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66827909823 5438353.464619339 113.26715266703797 458878.66628130286
														5438353.463465912 113.26632947289931 458878.6762813029 5438353.446145404 113.26632947289931
														458878.67827909824 5438353.447298831 113.26715266703797 458878.66827909823 5438353.464619339
														113.26715266703797 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6514_234_594683_306612">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67039333435 5438353.465839994 113.26735075339864 458878.66827909823
														5438353.464619339 113.26715266703797 458878.67827909824 5438353.447298831 113.26715266703797
														458878.68039333436 5438353.448519486 113.26735075339864 458878.67039333435 5438353.465839994
														113.26735075339864 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6515_1589_788003_41490">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.718673573 5438353.493714604 112.60248316906705 458878.75682286796 5438353.515740109
														112.60701343464558 458878.76682286796 5438353.498419601 112.60701343464558 458878.728673573
														5438353.476394095 112.60248316906705 458878.718673573 5438353.493714604 112.60248316906705
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6516_396_692231_27380">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.62633746076 5438353.440404324 112.52806857350605 458878.6512781328 5438353.454803827
														112.5617083132216 458878.66127813275 5438353.43748332 112.5617083132216 458878.6363374608
														5438353.423083816 112.52806857350605 458878.62633746076 5438353.440404324 112.52806857350605
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6517_953_284804_67403">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60949780454 5438353.430681944 112.48828269383085 458878.62633746076
														5438353.440404324 112.52806857350605 458878.6363374608 5438353.423083816 112.52806857350605
														458878.61949780455 5438353.413361436 112.48828269383085 458878.60949780454 5438353.430681944
														112.48828269383085 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6518_138_292789_138245">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6018349445 5438353.42625779 112.44489234524451 458878.60949780454 5438353.430681944
														112.48828269383085 458878.61949780455 5438353.413361436 112.48828269383085 458878.6118349445
														5438353.408937282 112.44489234524451 458878.6018349445 5438353.42625779 112.44489234524451
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6519_545_357217_324696">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60383841284 5438353.427414493 112.4006694657734 458878.6018349445 5438353.42625779
														112.44489234524451 458878.6118349445 5438353.408937282 112.44489234524451 458878.61383841285
														5438353.410093985 112.4006694657734 458878.60383841284 5438353.427414493 112.4006694657734
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6520_1646_555977_67176">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61538022046 5438353.434078158 112.35843917863587 458878.60383841284
														5438353.427414493 112.4006694657734 458878.61383841285 5438353.410093985 112.4006694657734
														458878.6253802205 5438353.416757651 112.35843917863587 458878.61538022046 5438353.434078158
														112.35843917863587 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6521_1318_48948_299006">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.63572303345 5438353.445823086 112.3208993127869 458878.61538022046 5438353.434078158
														112.35843917863587 458878.6253802205 5438353.416757651 112.35843917863587 458878.64572303346
														5438353.428502579 112.3208993127869 458878.63572303345 5438353.445823086 112.3208993127869
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6522_1569_516903_303517">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66356727673 5438353.461898969 112.29044805549721 458878.63572303345
														5438353.445823086 112.3208993127869 458878.64572303346 5438353.428502579 112.3208993127869
														458878.67356727673 5438353.44457846 112.29044805549721 458878.66356727673 5438353.461898969
														112.29044805549721 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6523_281_89002_54721">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6972026764 5438353.481318375 112.26898702763418 458878.66356727673 5438353.461898969
														112.29044805549721 458878.67356727673 5438353.44457846 112.29044805549721 458878.7072026764
														5438353.463997867 112.26898702763418 458878.6972026764 5438353.481318375 112.26898702763418
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6524_311_723761_405555">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74418576643 5438353.508444075 112.25454658649173 458878.6972026764 5438353.481318375
														112.26898702763418 458878.7072026764 5438353.463997867 112.26898702763418 458878.75418576644
														5438353.491123567 112.25454658649173 458878.74418576643 5438353.508444075 112.25454658649173
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6525_1147_353275_294497">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.793414904 5438353.536866531 112.24226131458495 458878.74418576643 5438353.508444075
														112.25454658649173 458878.75418576644 5438353.491123567 112.25454658649173 458878.803414904
														5438353.519546023 112.24226131458495 458878.793414904 5438353.536866531 112.24226131458495
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6526_1513_798246_338511">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.84309202764 5438353.565547631 112.23267748849504 458878.793414904 5438353.536866531
														112.24226131458495 458878.803414904 5438353.519546023 112.24226131458495 458878.85309202765
														5438353.548227123 112.23267748849504 458878.84309202764 5438353.565547631 112.23267748849504
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6527_266_518765_328679">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8931060207 5438353.594423224 112.22581654513318 458878.84309202764 5438353.565547631
														112.23267748849504 458878.85309202765 5438353.548227123 112.23267748849504 458878.9031060207
														5438353.577102716 112.22581654513318 458878.8931060207 5438353.594423224 112.22581654513318
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6528_1937_201071_117971">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.94334501284 5438353.623428719 112.22169383092071 458878.8931060207 5438353.594423224
														112.22581654513318 458878.9031060207 5438353.577102716 112.22581654513318 458878.95334501285
														5438353.606108211 112.22169383092071 458878.94334501284 5438353.623428719 112.22169383092071
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6529_702_87464_359913">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99369663046 5438353.65249924 112.22031856746258 458878.94334501284 5438353.623428719
														112.22169383092071 458878.95334501285 5438353.606108211 112.22169383092071 458879.0036966304
														5438353.635178732 112.22031856746258 458878.99369663046 5438353.65249924 112.22031856746258
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6530_1780_563947_9298">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.04404824803 5438353.68156976 112.22169383092071 458878.99369663046 5438353.65249924
														112.22031856746258 458879.0036966304 5438353.635178732 112.22031856746258 458879.05404824804
														5438353.664249252 112.22169383092071 458879.04404824803 5438353.68156976 112.22169383092071
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6531_1678_570406_394337">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0942872402 5438353.710575255 112.22581654513318 458879.04404824803 5438353.68156976
														112.22169383092071 458879.05404824804 5438353.664249252 112.22169383092071 458879.1042872402
														5438353.693254747 112.22581654513318 458879.0942872402 5438353.710575255 112.22581654513318
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6532_994_894188_369606">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.14430123323 5438353.739450848 112.23267748849505 458879.0942872402 5438353.710575255
														112.22581654513318 458879.1042872402 5438353.693254747 112.22581654513318 458879.15430123324
														5438353.72213034 112.23267748849505 458879.14430123323 5438353.739450848 112.23267748849505
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6533_272_473118_417208">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1939783569 5438353.768131948 112.24226131458495 458879.14430123323 5438353.739450848
														112.23267748849505 458879.15430123324 5438353.72213034 112.23267748849505 458879.2039783569
														5438353.75081144 112.24226131458495 458879.1939783569 5438353.768131948 112.24226131458495
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6534_997_787768_426286">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1467897394 5438353.740887587 112.21256313292353 458879.1972877 5438353.770042598
														112.22230531678953 458879.20728770003 5438353.75272209 112.22230531678953 458879.1567897394
														5438353.723567079 112.21256313292353 458879.1467897394 5438353.740887587 112.21256313292353
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6535_814_75080_78747">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3538574264 5438353.860438172 112.30856900598037 458879.32467054465 5438353.843587118
														112.28523677734867 458879.33467054466 5438353.82626661 112.28523677734867 458879.3638574264
														5438353.843117664 112.30856900598037 458879.3538574264 5438353.860438172 112.30856900598037
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6536_795_289683_73266">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3780743295 5438353.874419807 112.338540333094 458879.3538574264 5438353.860438172
														112.30856900598037 458879.3638574264 5438353.843117664 112.30856900598037 458879.38807432953
														5438353.857099299 112.338540333094 458879.3780743295 5438353.874419807 112.338540333094 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6537_1558_28083_4628">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3962112901 5438353.884891187 112.37377704491759 458879.3780743295 5438353.874419807
														112.338540333094 458879.38807432953 5438353.857099299 112.338540333094 458879.4062112901
														5438353.867570679 112.37377704491759 458879.3962112901 5438353.884891187 112.37377704491759
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6538_1926_407018_258867">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.4074370138 5438353.891372361 112.41266409263708 458879.3962112901 5438353.884891187
														112.37377704491759 458879.4062112901 5438353.867570679 112.37377704491759 458879.4174370138
														5438353.874051853 112.41266409263708 458879.4074370138 5438353.891372361 112.41266409263708
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6539_1734_491867_254191">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.4112369779 5438353.893566271 112.45341911697284 458879.4074370138 5438353.891372361
														112.41266409263708 458879.4174370138 5438353.874051853 112.41266409263708 458879.4212369779
														5438353.876245763 112.45341911697284 458879.4112369779 5438353.893566271 112.45341911697284
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6540_1262_327072_17791">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.4074370138 5438353.891372361 112.4941741413086 458879.4112369779 5438353.893566271
														112.45341911697284 458879.4212369779 5438353.876245763 112.45341911697284 458879.4174370138
														5438353.874051853 112.4941741413086 458879.4074370138 5438353.891372361 112.4941741413086
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6541_421_568530_109383">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6314719458 5438353.44336872 113.20411990277544 458878.6258105155 5438353.4401000915
														113.20726925781885 458878.63581051543 5438353.422779584 113.20726925781885 458878.6414719458
														5438353.426048212 113.20411990277544 458878.6314719458 5438353.44336872 113.20411990277544
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6542_876_775990_237134">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.63674096844 5438353.446410792 113.20352465552673 458878.6314719458 5438353.44336872
														113.20411990277544 458878.6414719458 5438353.426048212 113.20411990277544 458878.64674096845
														5438353.429090284 113.20352465552673 458878.63674096844 5438353.446410792 113.20352465552673
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6543_1189_839027_417310">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6421568256 5438353.449537639 113.20522541566303 458878.63674096844 5438353.446410792
														113.20352465552673 458878.64674096845 5438353.429090284 113.20352465552673 458878.6521568256
														5438353.43221713 113.20522541566303 458878.6421568256 5438353.449537639 113.20522541566303
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6544_584_204139_333575">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.65832563303 5438353.458872704 113.22893792936362 458878.653681615 5438353.456191479
														113.21781472137594 458878.663681615 5438353.438870971 113.21781472137594 458878.66832563304
														5438353.441552196 113.22893792936362 458878.65832563303 5438353.458872704 113.22893792936362
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6545_613_548469_46833">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6611733724 5438353.460516847 113.24229933027396 458878.65832563303 5438353.458872704
														113.22893792936362 458878.66832563304 5438353.441552196 113.22893792936362 458878.6711733724
														5438353.443196339 113.24229933027396 458878.6611733724 5438353.460516847 113.24229933027396
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6546_1210_764090_323628">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6724799294 5438353.467044691 113.26691023272323 458878.67039333435 5438353.465839994
														113.26735075339864 458878.68039333436 5438353.448519486 113.26735075339864 458878.6824799294
														5438353.4497241825 113.26691023272323 458878.6724799294 5438353.467044691 113.26691023272323
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6547_1298_854951_57366">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6743966855 5438353.46815133 113.26586112576775 458878.6724799294 5438353.467044691
														113.26691023272323 458878.6824799294 5438353.4497241825 113.26691023272323 458878.6843966855
														5438353.450830822 113.26586112576775 458878.6743966855 5438353.46815133 113.26586112576775
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6548_1509_859809_150015">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67601297883 5438353.469084498 113.2642749274375 458878.6743966855 5438353.46815133
														113.26586112576775 458878.6843966855 5438353.450830822 113.26586112576775 458878.6860129788
														5438353.451763989 113.2642749274375 458878.67601297883 5438353.469084498 113.2642749274375
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6549_1805_258826_103531">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67721866164 5438353.469780599 113.26225973452737 458878.67601297883
														5438353.469084498 113.2642749274375 458878.6860129788 5438353.451763989 113.2642749274375
														458878.6872186616 5438353.452460091 113.26225973452737 458878.67721866164 5438353.469780599
														113.26225973452737 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6550_639_29893_368694">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.24320749443 5438353.796554404 112.25454658649173 458879.1939783569 5438353.768131948
														112.24226131458495 458879.2039783569 5438353.75081144 112.24226131458495 458879.25320749444
														5438353.779233896 112.25454658649173 458879.24320749443 5438353.796554404 112.25454658649173
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6551_256_862745_1509">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.29116642673 5438353.824243506 112.26928695666026 458879.24320749443
														5438353.796554404 112.25454658649173 458879.25320749444 5438353.779233896 112.25454658649173
														458879.30116642674 5438353.806922998 112.26928695666026 458879.29116642673 5438353.824243506
														112.26928695666026 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6552_1742_625841_403891">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.32467054465 5438353.843587118 112.28523677734867 458879.29116642673
														5438353.824243506 112.26928695666026 458879.30116642674 5438353.806922998 112.26928695666026
														458879.33467054466 5438353.82626661 112.28523677734867 458879.32467054465 5438353.843587118
														112.28523677734867 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6553_317_578993_94369">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67793156864 5438353.470192196 113.25995287910392 458878.67721866164
														5438353.469780599 113.26225973452737 458878.6872186616 5438353.452460091 113.26225973452737
														458878.68793156865 5438353.452871688 113.25995287910392 458878.67793156864 5438353.470192196
														113.25995287910392 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6554_1503_823915_364046">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67810311645 5438353.470291239 113.257511569552 458878.67793156864 5438353.470192196
														113.25995287910392 458878.68793156865 5438353.452871688 113.25995287910392 458878.68810311646
														5438353.452970731 113.257511569552 458878.67810311645 5438353.470291239 113.257511569552
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6555_1321_692242_155084">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6270180588 5438353.4407972675 113.18576840247822 458878.6381273367 5438353.447211212
														113.1845133752147 458878.6481273367 5438353.429890704 113.1845133752147 458878.6370180588
														5438353.423476759 113.18576840247822 458878.6270180588 5438353.4407972675 113.18576840247822
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6556_1951_318249_264964">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6164883805 5438353.434717955 113.19162587903977 458878.6270180588 5438353.4407972675
														113.18576840247822 458878.6370180588 5438353.423476759 113.18576840247822 458878.6264883805
														5438353.417397447 113.19162587903977 458878.6164883805 5438353.434717955 113.19162587903977
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6557_1567_153955_175392">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6072558818 5438353.429387569 113.20168662755166 458878.6164883805 5438353.434717955
														113.19162587903977 458878.6264883805 5438353.417397447 113.19162587903977 458878.61725588183
														5438353.412067061 113.20168662755166 458878.6072558818 5438353.429387569 113.20168662755166
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6558_728_76018_207250">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5999497424 5438353.425169367 113.21526502462896 458878.6072558818 5438353.429387569
														113.20168662755166 458878.61725588183 5438353.412067061 113.20168662755166 458878.6099497424
														5438353.407848859 113.21526502462896 458878.5999497424 5438353.425169367 113.21526502462896
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6559_461_485952_99920">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5950678635 5438353.422350814 113.23143572495021 458878.5999497424 5438353.425169367
														113.21526502462896 458878.6099497424 5438353.407848859 113.21526502462896 458878.60506786353
														5438353.4050303055 113.23143572495021 458878.5950678635 5438353.422350814 113.23143572495021
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6560_950_638802_120667">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3962112901 5438353.884891187 112.53306118902809 458879.4074370138 5438353.891372361
														112.4941741413086 458879.4174370138 5438353.874051853 112.4941741413086 458879.4062112901
														5438353.867570679 112.53306118902809 458879.3962112901 5438353.884891187 112.53306118902809
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6561_431_555915_299629">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.87036958016 5438354.135552593 112.68392153756981 458878.8383465836 5438354.117064106
														112.68801154458424 458879.0783465836 5438353.701371913 112.68801154458424 458879.11036958015
														5438353.719860398 112.68392153756981 458878.87036958016 5438354.135552593 112.68392153756981
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6562_1509_238327_68814">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6773262801 5438353.469842733 113.2395638435135 458878.67810311645 5438353.470291239
														113.257511569552 458878.68810311646 5438353.452970731 113.257511569552 458878.6873262801
														5438353.452522225 113.2395638435135 458878.6773262801 5438353.469842733 113.2395638435135
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6563_1104_492116_421892">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6479903937 5438353.45290565 113.20982204678101 458878.6421568256 5438353.449537639
														113.20522541566303 458878.6521568256 5438353.43221713 113.20522541566303 458878.6579903937
														5438353.435585142 113.20982204678101 458878.6479903937 5438353.45290565 113.20982204678101
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6564_1808_71843_309687">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.653681615 5438353.456191479 113.21781472137594 458878.6479903937 5438353.45290565
														113.20982204678101 458878.6579903937 5438353.435585142 113.20982204678101 458878.663681615
														5438353.438870971 113.21781472137594 458878.653681615 5438353.456191479 113.21781472137594
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6565_1096_50549_225967">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67370062106 5438353.467749457 113.22255249636768 458878.6773262801 5438353.469842733
														113.2395638435135 458878.6873262801 5438353.452522225 113.2395638435135 458878.68370062107
														5438353.45042895 113.22255249636768 458878.67370062106 5438353.467749457 113.22255249636768
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6566_1216_406714_117074">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6381273367 5438353.447211212 113.1845133752147 458878.6490591351 5438353.453522689
														113.18794632528323 458878.6590591351 5438353.436202181 113.18794632528323 458878.6481273367
														5438353.429890704 113.1845133752147 458878.6381273367 5438353.447211212 113.1845133752147
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6567_1588_89493_159567">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.89969487115 5438354.152483556 112.65733181868121 458878.93042138026
														5438354.1702235155 112.6485188699798 458879.17042138025 5438353.754531321 112.6485188699798
														458879.13969487114 5438353.736791363 112.65733181868121 458878.89969487115 5438354.152483556
														112.65733181868121 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6568_440_113949_101607">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5802947806 5438353.968077828 112.6585447508261 458878.5751309203 5438353.965096473
														112.66364169398781 458878.81513092026 5438353.549404278 112.66364169398781 458878.8202947806
														5438353.552385635 112.6585447508261 458878.5802947806 5438353.968077828 112.6585447508261
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6569_761_898228_144287">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61908353027 5438353.9904725235 112.62687035956935 458878.65112285665
														5438354.008970438 112.64064054707083 458878.89112285664 5438353.593278243 112.64064054707083
														458878.85908353026 5438353.57478033 112.62687035956935 458878.61908353027 5438353.9904725235
														112.62687035956935 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6570_787_446983_307899">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9021833665 5438354.15392029 112.67734802820426 458878.87036958016 5438354.135552593
														112.68392153756981 458879.11036958015 5438353.719860398 112.68392153756981 458879.14218336646
														5438353.738228097 112.67734802820426 458878.9021833665 5438354.15392029 112.67734802820426
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6571_1580_604352_311416">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6102459453 5438353.985370141 112.62617515854582 458878.61908353027
														5438353.9904725235 112.62687035956935 458878.85908353026 5438353.57478033 112.62687035956935
														458878.8502459453 5438353.569677948 112.62617515854582 458878.6102459453 5438353.985370141
														112.62617515854582 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6572_278_95798_294638">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.93369088706 5438354.172111166 112.66831107053583 458878.9021833665 5438354.15392029
														112.67734802820426 458879.14218336646 5438353.738228097 112.67734802820426 458879.17369088705
														5438353.756418972 112.66831107053583 458878.93369088706 5438354.172111166 112.66831107053583
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6573_326_669701_265223">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.93042138026 5438354.1702235155 112.6485188699798 458878.96019855706
														5438354.187415376 112.63753583780847 458879.20019855705 5438353.771723182 112.63753583780847
														458879.17042138025 5438353.754531321 112.6485188699798 458878.93042138026 5438354.1702235155
														112.6485188699798 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6574_26_869649_129255">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5751309203 5438353.965096473 112.66364169398781 458878.57040059066 5438353.962365415
														112.66951404880323 458878.81040059065 5438353.5466732215 112.66951404880323 458878.81513092026
														5438353.549404278 112.66364169398781 458878.5751309203 5438353.965096473 112.66364169398781
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6575_1306_840524_385129">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6023463841 5438353.980809328 112.6267919299992 458878.6102459453 5438353.985370141
														112.62617515854582 458878.8502459453 5438353.569677948 112.62617515854582 458878.8423463841
														5438353.565117134 112.6267919299992 458878.6023463841 5438353.980809328 112.6267919299992
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6576_1938_546804_110824">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9647960207 5438354.190069723 112.65683823394569 458878.93369088706 5438354.172111166
														112.66831107053583 458879.17369088705 5438353.756418972 112.66831107053583 458879.2047960207
														5438353.7743775295 112.65683823394569 458878.9647960207 5438354.190069723 112.65683823394569
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6577_1503_371883_247580">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96649156394 5438354.191048645 112.6556715779332 458878.9647960207 5438354.190069723
														112.65683823394569 458879.2047960207 5438353.7743775295 112.65683823394569 458879.20649156393
														5438353.775356452 112.6556715779332 458878.96649156394 5438354.191048645 112.6556715779332
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6578_746_3439_335244">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96019855706 5438354.187415376 112.63753583780847 458878.9620507551 5438354.188484743
														112.63702689499502 458879.2020507551 5438353.77279255 112.63702689499502 458879.20019855705
														5438353.771723182 112.63753583780847 458878.96019855706 5438354.187415376 112.63753583780847
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6579_437_712089_412188">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.57040059066 5438353.962365415 112.66951404880323 458878.5661622171 5438353.959918389
														112.67608928449776 458878.80616221716 5438353.544226196 112.67608928449776 458878.81040059065
														5438353.5466732215 112.66951404880323 458878.57040059066 5438353.962365415 112.66951404880323
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6580_1436_469449_221127">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96791490394 5438354.191870411 112.65392671440096 458878.96649156394
														5438354.191048645 112.6556715779332 458879.20649156393 5438353.775356452 112.6556715779332
														458879.20791490393 5438353.7761782175 112.65392671440096 458878.96791490394 5438354.191870411
														112.65392671440096 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6581_610_512481_376053">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9620507551 5438354.188484743 112.63702689499502 458878.96393338363 5438354.18957168
														112.63721034899224 458879.20393338363 5438353.773879485 112.63721034899224 458879.2020507551
														5438353.77279255 112.63702689499502 458878.9620507551 5438354.188484743 112.63702689499502
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6582_1578_419993_136987">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5661622171 5438353.959918389 112.67608928449776 458878.5624681488 5438353.957785618
														112.68328618885707 458878.8024681488 5438353.542093424 112.68328618885707 458878.80616221716
														5438353.544226196 112.67608928449776 458878.5661622171 5438353.959918389 112.67608928449776
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6583_2_282938_205082">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96393338363 5438354.18957168 112.63721034899224 458878.9657181447 5438354.190602112
														112.63807369771341 458879.2057181447 5438353.774909918 112.63807369771341 458879.20393338363
														5438353.773879485 112.63721034899224 458878.96393338363 5438354.18957168 112.63721034899224
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6584_763_476359_1167">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5624681488 5438353.957785618 112.68328618885707 458878.5593640119 5438353.955993444
														112.69101587129732 458878.7993640119 5438353.54030125 112.69101587129732 458878.8024681488
														5438353.542093424 112.68328618885707 458878.5624681488 5438353.957785618 112.68328618885707
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6585_1537_97711_61475">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.56025914487 5438353.956510249 112.6550244866448 458878.56619388616 5438353.959936674
														112.64765694367168 458878.80619388615 5438353.544244479 112.64765694367168 458878.80025914486
														5438353.540818055 112.6550244866448 458878.56025914487 5438353.956510249 112.6550244866448
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6586_1338_80927_170320">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5431758474 5438353.946647203 112.75056580133051 458878.543563051 5438353.9468707545
														112.6989845124514 458878.78356305096 5438353.531178561 112.6989845124514 458878.7831758474
														5438353.530955009 112.75056580133051 458878.5431758474 5438353.946647203 112.75056580133051
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6587_1256_94658_300835">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55494161893 5438353.9534401735 112.66327387433691 458878.56025914487
														5438353.956510249 112.6550244866448 458878.80025914486 5438353.540818055 112.6550244866448
														458878.7949416189 5438353.53774798 112.66327387433691 458878.55494161893 5438353.9534401735
														112.66327387433691 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6588_1020_61274_127726">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5423302891 5438353.946159019 112.8020182832574 458878.5431758474 5438353.946647203
														112.75056580133051 458878.7831758474 5438353.530955009 112.75056580133051 458878.7823302891
														5438353.530466826 112.8020182832574 458878.5423302891 5438353.946159019 112.8020182832574
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6589_1834_104495_335200">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9697124198 5438354.192908207 112.64655823976953 458878.9695821416 5438354.1928329915
														112.64920930343854 458879.2095821416 5438353.777140797 112.64920930343854 458879.2097124198
														5438353.7772160135 112.64655823976953 458878.9697124198 5438354.192908207 112.64655823976953
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6590_809_583139_383404">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79433998215 5438353.537400625 112.85423943387363 458878.7932656063 5438353.536780334
														112.88555651117548 458878.7925683364 5438353.536377764 112.90588129239611 458878.79033596743
														5438353.535088906 112.95748772150878 458878.78764322784 5438353.533534252 113.00905057093928
														458878.7844905429 5438353.531714048 113.06056169729784 458878.78087841044 5438353.529628583
														113.1120129653634 458878.77680740103 5438353.527278185 113.16339624936839 458878.7722781576
														5438353.524663225 113.21470343428207 458878.7672913954 5438353.5217841165 113.2659264170921
														458878.7668307299 5438353.52151815 113.26828828689449 458878.7659516543 5438353.521010616
														113.27040178306404 458878.7647140762 5438353.5202961005 113.27212287432952 458878.76320233446
														5438353.519423296 113.27333427116542 458878.7615194518 5438353.518451683 113.27395341887931
														458878.7597801139 5438353.517447475 113.2739381235777 458878.75810285366 5438353.516479109
														113.27328942761006 458878.7566019737 5438353.515612575 113.27205153853462 458878.75537975656
														5438353.514906928 113.27030881644613 458878.7545194942 5438353.5144102555 113.26818002497495
														458878.75407981214 5438353.514156405 113.26581023774184 458878.75409067393 5438353.514162676
														113.2633609518305 458878.7590644296 5438353.517034275 113.21227156953222 458878.763573014
														5438353.519637307 113.16119841000717 458878.76762545446 5438353.521976985 113.11004949849838
														458878.77122111106 5438353.524052938 113.05883291302227 458878.7743594158 5438353.52586484
														113.00755674228215 458878.7770398731 5438353.527412402 112.9562290843926 458878.77926205966
														5438353.528695382 112.9048580455989 458878.7810256245 5438353.529713577 112.85345173899839
														458878.7823302891 5438353.530466826 112.8020182832574 458878.7831758474 5438353.530955009
														112.75056580133051 458878.78356305096 5438353.531178561 112.6989845124514 458878.78362142894
														5438353.531212266 112.69120769778465 458878.7864124904 5438353.532823686 112.68200099031416
														458878.7903069863 5438353.535072174 112.6723032167059 458878.7949416189 5438353.53774798
														112.66327387433691 458878.80025914486 5438353.540818055 112.6550244866448 458878.80619388615
														5438353.544244479 112.64765694367168 458878.81267254153 5438353.547984933 112.6412622435972
														458878.8196150916 5438353.551993216 112.63591936879966 458878.8269357874 5438353.556219822
														112.63169431032692 458878.8345442093 5438353.560612546 112.62863925282609 458878.8423463841
														5438353.565117134 112.6267919299992 458878.8502459453 5438353.569677948 112.62617515854582
														458878.85908353026 5438353.57478033 112.62687035956935 458878.89112285664 5438353.593278243
														112.64064054707083 458878.9215740885 5438353.61085927 112.65117916904981 458878.95239207556
														5438353.628652044 112.65933417703286 458878.98348280013 5438353.646602281 112.66508069223536
														458879.0147514126 5438353.6646552235 112.66840118355077 458879.0461025207 5438353.682755794
														112.66928552103333 458879.07744048046 5438353.700848774 112.66773100680198 458879.108669688
														5438353.718878965 112.66374238327081 458879.13969487114 5438353.736791363 112.65733181868121
														458879.17042138025 5438353.754531321 112.6485188699798 458879.20019855705 5438353.771723182
														112.63753583780847 458879.2020507551 5438353.77279255 112.63702689499502 458879.20393338363
														5438353.773879485 112.63721034899224 458879.2057181447 5438353.774909918 112.63807369771341
														458879.2072834098 5438353.775813624 112.63955810536993 458879.2085225086 5438353.776529018
														112.64156241203311 458879.2093509987 5438353.777007347 112.64395002751612 458879.2097124198
														5438353.7772160135 112.64655823976953 458879.2095821416 5438353.777140797 112.64920930343854
														458879.2089690424 5438353.776786825 112.65172255291517 458879.20791490393 5438353.7761782175
														112.65392671440096 458879.20649156393 5438353.775356452 112.6556715779332 458879.2047960207
														5438353.7743775295 112.65683823394569 458879.17369088705 5438353.756418972 112.66831107053583
														458879.14218336646 5438353.738228097 112.67734802820426 458879.11036958015 5438353.719860398
														112.68392153756981 458879.0783465836 5438353.701371913 112.68801154458424 458879.04621207044
														5438353.682819043 112.68960557171176 458879.0140640748 5438353.664258389 112.68869875599489
														458878.98200067156 5438353.645746575 112.68529386388984 458878.95011967793 5438353.627340075
														112.67940128282697 458878.91851835424 5438353.609095042 112.67103898952138 458878.887293108
														5438353.591067137 112.66023249513065 458878.8565391991 5438353.57331136 112.64701476742715
														458878.850242941 5438353.569676213 112.64651947769566 458878.8439465371 5438353.5660409825
														112.64701107996083 458878.8377277558 5438353.562450567 112.64848350233254 458878.8316634066
														5438353.558949314 112.65091855859103 458878.8258283917 5438353.555580467 112.654286172809
														458878.8202947806 5438353.552385635 112.6585447508261 458878.81513092026 5438353.549404278
														112.66364169398781 458878.81040059065 5438353.5466732215 112.66951404880323 458878.80616221716
														5438353.544226196 112.67608928449776 458878.8024681488 5438353.542093424 112.68328618885707
														458878.7993640119 5438353.54030125 112.69101587129732 458878.79688814643 5438353.538871808
														112.69918286077291 458878.79650005773 5438353.538647745 112.7508820563776 458878.79565062496
														5438353.538157325 112.80257030180908 458878.79433998215 5438353.537400625 112.85423943387363
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6591_1679_371312_381919">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5945442093 5438353.97630474 112.62863925282609 458878.6023463841 5438353.980809328
														112.6267919299992 458878.8423463841 5438353.565117134 112.6267919299992 458878.8345442093
														5438353.560612546 112.62863925282609 458878.5945442093 5438353.97630474 112.62863925282609
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6592_449_73380_197398">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9689690424 5438354.192479018 112.65172255291517 458878.96791490394 5438354.191870411
														112.65392671440096 458879.20791490393 5438353.7761782175 112.65392671440096 458879.2089690424
														5438353.776786825 112.65172255291517 458878.9689690424 5438354.192479018 112.65172255291517
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6593_174_223848_29782">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5503069863 5438353.950764367 112.6723032167059 458878.55494161893 5438353.9534401735
														112.66327387433691 458878.7949416189 5438353.53774798 112.66327387433691 458878.7903069863
														5438353.535072174 112.6723032167059 458878.5503069863 5438353.950764367 112.6723032167059
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6594_1495_353457_316508">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5410256245 5438353.945405771 112.85345173899839 458878.5423302891 5438353.946159019
														112.8020182832574 458878.7823302891 5438353.530466826 112.8020182832574 458878.7810256245
														5438353.529713577 112.85345173899839 458878.5410256245 5438353.945405771 112.85345173899839
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6595_796_218941_298409">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5464124904 5438353.948515879 112.68200099031416 458878.5503069863 5438353.950764367
														112.6723032167059 458878.7903069863 5438353.535072174 112.6723032167059 458878.7864124904
														5438353.532823686 112.68200099031416 458878.5464124904 5438353.948515879 112.68200099031416
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6596_1874_1762_242526">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53926205966 5438353.944387577 112.9048580455989 458878.5410256245 5438353.945405771
														112.85345173899839 458878.7810256245 5438353.529713577 112.85345173899839 458878.77926205966
														5438353.528695382 112.9048580455989 458878.53926205966 5438353.944387577 112.9048580455989
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6597_245_837199_404793">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54362142895 5438353.946904459 112.69120769778465 458878.5464124904 5438353.948515879
														112.68200099031416 458878.7864124904 5438353.532823686 112.68200099031416 458878.78362142894
														5438353.531212266 112.69120769778465 458878.54362142895 5438353.946904459 112.69120769778465
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6598_360_158383_149225">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5370398731 5438353.943104596 112.9562290843926 458878.53926205966 5438353.944387577
														112.9048580455989 458878.77926205966 5438353.528695382 112.9048580455989 458878.7770398731
														5438353.527412402 112.9562290843926 458878.5370398731 5438353.943104596 112.9562290843926
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6599_278_177041_396967">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.531221111 5438353.939745132 113.05883291302227 458878.53435941576 5438353.941557033
														113.00755674228215 458878.7743594158 5438353.52586484 113.00755674228215 458878.77122111106
														5438353.524052938 113.05883291302227 458878.531221111 5438353.939745132 113.05883291302227
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6600_1775_413395_397078">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.543563051 5438353.9468707545 112.6989845124514 458878.54362142895 5438353.946904459
														112.69120769778465 458878.78362142894 5438353.531212266 112.69120769778465 458878.78356305096
														5438353.531178561 112.6989845124514 458878.543563051 5438353.9468707545 112.6989845124514
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6601_1985_171526_357430">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53435941576 5438353.941557033 113.00755674228215 458878.5370398731 5438353.943104596
														112.9562290843926 458878.7770398731 5438353.527412402 112.9562290843926 458878.7743594158
														5438353.52586484 113.00755674228215 458878.53435941576 5438353.941557033 113.00755674228215
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6602_274_289992_348932">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9695821416 5438354.1928329915 112.64920930343854 458878.9689690424 5438354.192479018
														112.65172255291517 458879.2089690424 5438353.776786825 112.65172255291517 458879.2095821416
														5438353.777140797 112.64920930343854 458878.9695821416 5438354.1928329915 112.64920930343854
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6603_1438_635582_178616">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.56619388616 5438353.959936674 112.64765694367168 458878.57267254154
														5438353.963677127 112.6412622435972 458878.81267254153 5438353.547984933 112.6412622435972
														458878.80619388615 5438353.544244479 112.64765694367168 458878.56619388616 5438353.959936674
														112.64765694367168 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6604_903_331897_380757">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5532656063 5438353.9524725275 112.88555651117548 458878.5525683364 5438353.952069959
														112.90588129239611 458878.7925683364 5438353.536377764 112.90588129239611 458878.7932656063
														5438353.536780334 112.88555651117548 458878.5532656063 5438353.9524725275 112.88555651117548
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6605_1146_450963_328167">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5276254545 5438353.937669179 113.11004949849838 458878.531221111 5438353.939745132
														113.05883291302227 458878.77122111106 5438353.524052938 113.05883291302227 458878.76762545446
														5438353.521976985 113.11004949849838 458878.5276254545 5438353.937669179 113.11004949849838
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6606_1665_894812_417481">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.523573014 5438353.9353295015 113.16119841000717 458878.5276254545 5438353.937669179
														113.11004949849838 458878.76762545446 5438353.521976985 113.11004949849838 458878.763573014
														5438353.519637307 113.16119841000717 458878.523573014 5438353.9353295015 113.16119841000717
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6607_579_48805_86410">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5190644296 5438353.932726469 113.21227156953222 458878.523573014 5438353.9353295015
														113.16119841000717 458878.763573014 5438353.519637307 113.16119841000717 458878.7590644296
														5438353.517034275 113.21227156953222 458878.5190644296 5438353.932726469 113.21227156953222
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6608_1171_587690_314726">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.51409067394 5438353.92985487 113.2633609518305 458878.5190644296 5438353.932726469
														113.21227156953222 458878.7590644296 5438353.517034275 113.21227156953222 458878.75409067393
														5438353.514162676 113.2633609518305 458878.51409067394 5438353.92985487 113.2633609518305
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6609_803_276212_266684">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.51407981215 5438353.929848598 113.26581023774184 458878.51409067394 5438353.92985487
														113.2633609518305 458878.75409067393 5438353.514162676 113.2633609518305 458878.75407981214
														5438353.514156405 113.26581023774184 458878.51407981215 5438353.929848598 113.26581023774184
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6610_1292_86046_146470">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5145194942 5438353.930102449 113.26818002497495 458878.51407981215 5438353.929848598
														113.26581023774184 458878.75407981214 5438353.514156405 113.26581023774184 458878.7545194942
														5438353.5144102555 113.26818002497495 458878.5145194942 5438353.930102449 113.26818002497495
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6611_662_102556_116121">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5153797566 5438353.930599122 113.27030881644613 458878.5145194942 5438353.930102449
														113.26818002497495 458878.7545194942 5438353.5144102555 113.26818002497495 458878.75537975656
														5438353.514906928 113.27030881644613 458878.5153797566 5438353.930599122 113.27030881644613
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6612_1364_683225_150119">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5272913954 5438353.93747631 113.2659264170921 458878.5268307299 5438353.937210345
														113.26828828689449 458878.7668307299 5438353.52151815 113.26828828689449 458878.7672913954
														5438353.5217841165 113.2659264170921 458878.5272913954 5438353.93747631 113.2659264170921
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6613_283_659438_103882">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.58582839166 5438353.97127266 112.654286172809 458878.5802947806 5438353.968077828
														112.6585447508261 458878.8202947806 5438353.552385635 112.6585447508261 458878.8258283917
														5438353.555580467 112.654286172809 458878.58582839166 5438353.97127266 112.654286172809 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6614_681_113879_254222">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5322781576 5438353.940355418 113.21470343428207 458878.5272913954 5438353.93747631
														113.2659264170921 458878.7672913954 5438353.5217841165 113.2659264170921 458878.7722781576
														5438353.524663225 113.21470343428207 458878.5322781576 5438353.940355418 113.21470343428207
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6615_640_679083_283783">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9685225086 5438354.192221212 112.64156241203311 458878.9693509987 5438354.19269954
														112.64395002751612 458879.2093509987 5438353.777007347 112.64395002751612 458879.2085225086
														5438353.776529018 112.64156241203311 458878.9685225086 5438354.192221212 112.64156241203311
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6616_476_242348_386327">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55650005774 5438353.954339939 112.7508820563776 458878.55565062497 5438353.953849519
														112.80257030180908 458878.79565062496 5438353.538157325 112.80257030180908 458878.79650005773
														5438353.538647745 112.7508820563776 458878.55650005774 5438353.954339939 112.7508820563776
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6617_114_266466_3313">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53680740104 5438353.942970378 113.16339624936839 458878.5322781576 5438353.940355418
														113.21470343428207 458878.7722781576 5438353.524663225 113.21470343428207 458878.77680740103
														5438353.527278185 113.16339624936839 458878.53680740104 5438353.942970378 113.16339624936839
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6618_1171_551912_386181">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5444905429 5438353.947406243 113.06056169729784 458878.54087841045 5438353.945320777
														113.1120129653634 458878.78087841044 5438353.529628583 113.1120129653634 458878.7844905429
														5438353.531714048 113.06056169729784 458878.5444905429 5438353.947406243 113.06056169729784
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6619_578_123398_278694">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54087841045 5438353.945320777 113.1120129653634 458878.53680740104 5438353.942970378
														113.16339624936839 458878.77680740103 5438353.527278185 113.16339624936839 458878.78087841044
														5438353.529628583 113.1120129653634 458878.54087841045 5438353.945320777 113.1120129653634
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6620_1722_228692_281154">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55433998216 5438353.953092819 112.85423943387363 458878.5532656063
														5438353.9524725275 112.88555651117548 458878.7932656063 5438353.536780334 112.88555651117548
														458878.79433998215 5438353.537400625 112.85423943387363 458878.55433998216 5438353.953092819
														112.85423943387363 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6621_218_585930_146964">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9657181447 5438354.190602112 112.63807369771341 458878.9672834098 5438354.191505818
														112.63955810536993 458879.2072834098 5438353.775813624 112.63955810536993 458879.2057181447
														5438353.774909918 112.63807369771341 458878.9657181447 5438354.190602112 112.63807369771341
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6622_1142_428264_108665">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9672834098 5438354.191505818 112.63955810536993 458878.9685225086 5438354.192221212
														112.64156241203311 458879.2085225086 5438353.776529018 112.64156241203311 458879.2072834098
														5438353.775813624 112.63955810536993 458878.9672834098 5438354.191505818 112.63955810536993
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6623_45_818508_313587">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5593640119 5438353.955993444 112.69101587129732 458878.55688814644 5438353.954564002
														112.69918286077291 458878.79688814643 5438353.538871808 112.69918286077291 458878.7993640119
														5438353.54030125 112.69101587129732 458878.5593640119 5438353.955993444 112.69101587129732
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6624_499_9330_126937">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55688814644 5438353.954564002 112.69918286077291 458878.55650005774
														5438353.954339939 112.7508820563776 458878.79650005773 5438353.538647745 112.7508820563776
														458878.79688814643 5438353.538871808 112.69918286077291 458878.55688814644 5438353.954564002
														112.69918286077291 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6625_213_558617_169883">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.51660197373 5438353.93130477 113.27205153853462 458878.5153797566 5438353.930599122
														113.27030881644613 458878.75537975656 5438353.514906928 113.27030881644613 458878.7566019737
														5438353.515612575 113.27205153853462 458878.51660197373 5438353.93130477 113.27205153853462
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6626_659_178379_127435">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5181028537 5438353.932171303 113.27328942761006 458878.51660197373 5438353.93130477
														113.27205153853462 458878.7566019737 5438353.515612575 113.27205153853462 458878.75810285366
														5438353.516479109 113.27328942761006 458878.5181028537 5438353.932171303 113.27328942761006
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6627_117_128322_55075">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5197801138 5438353.93313967 113.2739381235777 458878.5181028537 5438353.932171303
														113.27328942761006 458878.75810285366 5438353.516479109 113.27328942761006 458878.7597801139
														5438353.517447475 113.2739381235777 458878.5197801138 5438353.93313967 113.2739381235777
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6628_166_307129_191840">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5215194518 5438353.934143877 113.27395341887931 458878.5197801138 5438353.93313967
														113.2739381235777 458878.7597801139 5438353.517447475 113.2739381235777 458878.7615194518
														5438353.518451683 113.27395341887931 458878.5215194518 5438353.934143877 113.27395341887931
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6629_1867_196791_311424">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9693509987 5438354.19269954 112.64395002751612 458878.9697124198 5438354.192908207
														112.64655823976953 458879.2097124198 5438353.7772160135 112.64655823976953 458879.2093509987
														5438353.777007347 112.64395002751612 458878.9693509987 5438354.19269954 112.64395002751612
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6630_1745_447996_62519">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5232023345 5438353.935115489 113.27333427116542 458878.5215194518 5438353.934143877
														113.27395341887931 458878.7615194518 5438353.518451683 113.27395341887931 458878.76320233446
														5438353.519423296 113.27333427116542 458878.5232023345 5438353.935115489 113.27333427116542
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6631_1735_160916_340561">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5247140762 5438353.935988294 113.27212287432952 458878.5232023345 5438353.935115489
														113.27333427116542 458878.76320233446 5438353.519423296 113.27333427116542 458878.7647140762
														5438353.5202961005 113.27212287432952 458878.5247140762 5438353.935988294 113.27212287432952
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6632_1728_823083_429348">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5259516543 5438353.93670281 113.27040178306404 458878.5247140762 5438353.935988294
														113.27212287432952 458878.7647140762 5438353.5202961005 113.27212287432952 458878.7659516543
														5438353.521010616 113.27040178306404 458878.5259516543 5438353.93670281 113.27040178306404
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6633_560_515850_273838">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5869357874 5438353.971912015 112.63169431032692 458878.5945442093 5438353.97630474
														112.62863925282609 458878.8345442093 5438353.560612546 112.62863925282609 458878.8269357874
														5438353.556219822 112.63169431032692 458878.5869357874 5438353.971912015 112.63169431032692
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6634_471_431376_374175">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5268307299 5438353.937210345 113.26828828689449 458878.5259516543 5438353.93670281
														113.27040178306404 458878.7659516543 5438353.521010616 113.27040178306404 458878.7668307299
														5438353.52151815 113.26828828689449 458878.5268307299 5438353.937210345 113.26828828689449
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6635_580_833716_348609">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5796150916 5438353.96768541 112.63591936879966 458878.5869357874 5438353.971912015
														112.63169431032692 458878.8269357874 5438353.556219822 112.63169431032692 458878.8196150916
														5438353.551993216 112.63591936879966 458878.5796150916 5438353.96768541 112.63591936879966
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6636_1951_411434_280330">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.57267254154 5438353.963677127 112.6412622435972 458878.5796150916 5438353.96768541
														112.63591936879966 458878.8196150916 5438353.551993216 112.63591936879966 458878.81267254153
														5438353.547984933 112.6412622435972 458878.57267254154 5438353.963677127 112.6412622435972
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6637_1398_650454_176619">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55565062497 5438353.953849519 112.80257030180908 458878.55433998216
														5438353.953092819 112.85423943387363 458878.79433998215 5438353.537400625 112.85423943387363
														458878.79565062496 5438353.538157325 112.80257030180908 458878.55565062497 5438353.953849519
														112.80257030180908 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6638_417_215720_60116">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.26417567516 5438353.808660389 112.62922270676458 458879.3239652911 5438353.843179939
														112.6058401801274 458879.33467054466 5438353.82626661 112.621601456597 458879.26417567516
														5438353.808660389 112.62922270676458 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6639_876_364612_195739">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8040888336 5438353.519935116 112.90588129239611 458878.8614102493 5438353.553029651
														112.90629836143986 458878.7925683364 5438353.536377764 112.90588129239611 458878.8040888336
														5438353.519935116 112.90588129239611 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6640_422_70847_5008">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.850008653 5438353.569540947 112.90636409122618 458878.7925683364 5438353.536377764
														112.90588129239611 458878.8614102493 5438353.553029651 112.90629836143986 458878.850008653
														5438353.569540947 112.90636409122618 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6641_1000_785276_336179">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8614102493 5438353.553029651 112.90629836143986 458878.91857216873 5438353.586032101
														112.90134657709521 458878.850008653 5438353.569540947 112.90636409122618 458878.8614102493
														5438353.553029651 112.90629836143986 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6642_912_321624_318271">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9072936978 5438353.602614483 112.9014666865107 458878.850008653 5438353.569540947
														112.90636409122618 458878.91857216873 5438353.586032101 112.90134657709521 458878.9072936978
														5438353.602614483 112.9014666865107 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6643_473_815134_340321">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.91857216873 5438353.586032101 112.90134657709521 458878.9751980695 5438353.618725079
														112.89105855649347 458878.9072936978 5438353.602614483 112.9014666865107 458878.91857216873
														5438353.586032101 112.90134657709521 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6644_1814_369417_387844">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96404613746 5438353.63538052 112.89122133718541 458878.9072936978 5438353.602614483
														112.9014666865107 458878.9751980695 5438353.618725079 112.89105855649347 458878.96404613746
														5438353.63538052 112.89122133718541 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6645_1224_251155_88884">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0750438046 5438353.676371042 112.66840118355077 458879.0147514126 5438353.6646552235
														112.66840118355077 458879.1132768633 5438353.6984449085 112.66928552103333 458879.0750438046
														5438353.676371042 112.66840118355077 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6646_842_98356_211319">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.64101222984 5438353.425782795 113.37245325549617 458878.6610308999 5438353.43734058
														113.38822721054937 458878.63212066236 5438353.443743257 113.3752611278133 458878.64101222984
														5438353.425782795 113.37245325549617 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6647_779_239870_284869">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.65263678075 5438353.455588244 113.39135898517884 458878.63212066236
														5438353.443743257 113.3752611278133 458878.6610308999 5438353.43734058 113.38822721054937
														458878.65263678075 5438353.455588244 113.39135898517884 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6648_4_746377_272153">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6020763072 5438353.42639714 113.32063599421863 458878.61174792796 5438353.408887043
														113.31901486838049 458878.6148754264 5438353.433786715 113.35113883264259 458878.6020763072
														5438353.42639714 113.32063599421863 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6649_1451_800725_186068">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.64101222984 5438353.425782795 113.37245325549617 458878.63212066236
														5438353.443743257 113.3752611278133 458878.6242027259 5438353.416077823 113.34884621449598
														458878.64101222984 5438353.425782795 113.37245325549617 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6650_3_680199_342198">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6148754264 5438353.433786715 113.35113883264259 458878.6242027259 5438353.416077823
														113.34884621449598 458878.63212066236 5438353.443743257 113.3752611278133 458878.6148754264
														5438353.433786715 113.35113883264259 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6651_273_389430_5700">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9751980695 5438353.618725079 112.89105855649347 458879.0309149598 5438353.650893241
														112.87550206626103 458878.96404613746 5438353.63538052 112.89122133718541 458878.9751980695
														5438353.618725079 112.89105855649347 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6652_1806_388133_362699">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0198921467 5438353.667623227 112.8756955288033 458878.96404613746 5438353.63538052
														112.89122133718541 458879.0309149598 5438353.650893241 112.87550206626103 458879.0198921467
														5438353.667623227 112.8756955288033 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6653_1591_720956_105039">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6206495176 5438353.414026378 113.28225668732838 458878.6108370665 5438353.431455167
														113.28386196485128 458878.627122916 5438353.417763796 113.31262943538453 458878.6206495176
														5438353.414026378 113.28225668732838 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6654_1619_673690_294734">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61774389335 5438353.435442826 113.3157177559892 458878.627122916 5438353.417763796
														113.31262943538453 458878.6108370665 5438353.431455167 113.28386196485128 458878.61774389335
														5438353.435442826 113.3157177559892 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6655_1790_797454_225299">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61925017443 5438353.413218467 113.24992680721377 458878.6092501745 5438353.430538975
														113.24992680721377 458878.6206495176 5438353.414026378 113.28225668732838 458878.61925017443
														5438353.413218467 113.24992680721377 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6656_990_335449_388417">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6108370665 5438353.431455167 113.28386196485128 458878.6206495176 5438353.414026378
														113.28225668732838 458878.6092501745 5438353.430538975 113.24992680721377 458878.6108370665
														5438353.431455167 113.28386196485128 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6657_23_504625_397127">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61174792796 5438353.408887043 113.31901486838049 458878.6020763072 5438353.42639714
														113.32063599421863 458878.60449660994 5438353.4047004925 113.28499217408885 458878.61174792796
														5438353.408887043 113.31901486838049 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6658_533_309552_100110">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6608015689 5438353.460302186 113.37674618126793 458878.67798307375 5438353.470221933
														113.38205647234814 458878.66793320945 5438353.44132563 113.37094812016958 458878.6608015689
														5438353.460302186 113.37674618126793 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6659_1557_440347_89248">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.684280865 5438353.450763953 113.3760818303744 458878.66793320945 5438353.44132563
														113.37094812016958 458878.67798307375 5438353.470221933 113.38205647234814 458878.684280865
														5438353.450763953 113.3760818303744 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6660_438_764949_363804">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6441232104 5438353.450672931 113.36371704994695 458878.6608015689 5438353.460302186
														113.37674618126793 458878.6520903063 5438353.4321787255 113.358464511525 458878.6441232104
														5438353.450672931 113.36371704994695 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6661_276_467013_20622">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66793320945 5438353.44132563 113.37094812016958 458878.6520903063 5438353.4321787255
														113.358464511525 458878.6608015689 5438353.460302186 113.37674618126793 458878.66793320945
														5438353.44132563 113.37094812016958 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6662_517_677473_356793">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0309149598 5438353.650893241 112.87550206626103 458879.08535583556 5438353.682324695
														112.85477957614417 458879.0198921467 5438353.667623227 112.8756955288033 458879.0309149598
														5438353.650893241 112.87550206626103 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6663_989_487701_30726">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.07446387095 5438353.699130228 112.854991529011 458879.0198921467 5438353.667623227
														112.8756955288033 458879.08535583556 5438353.682324695 112.85477957614417 458879.07446387095
														5438353.699130228 112.854991529011 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6664_1725_162175_328799">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.08535583556 5438353.682324695 112.85477957614417 458879.13816209783
														5438353.712812405 112.8290275840465 458879.07446387095 5438353.699130228 112.854991529011
														458879.08535583556 5438353.682324695 112.85477957614417 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6665_210_431727_20995">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.12740184925 5438353.729693984 112.82924571391739 458879.07446387095
														5438353.699130228 112.854991529011 458879.13816209783 5438353.712812405 112.8290275840465
														458879.12740184925 5438353.729693984 112.82924571391739 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6666_1972_117655_103109">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.13816209783 5438353.712812405 112.8290275840465 458879.18898591463 5438353.742155549
														112.79841571692483 458879.12740184925 5438353.729693984 112.82924571391739 458879.13816209783
														5438353.712812405 112.8290275840465 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6667_1536_717279_153469">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.178357382 5438353.759113174 112.79862766979167 458879.12740184925 5438353.729693984
														112.82924571391739 458879.18898591463 5438353.742155549 112.79841571692483 458879.178357382
														5438353.759113174 112.79862766979167 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6668_1658_25300_48417">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5945955435 5438353.42207812 113.2858313305717 458878.60449660994 5438353.4047004925
														113.28499217408885 458878.6020763072 5438353.42639714 113.32063599421863 458878.5945955435
														5438353.42207812 113.2858313305717 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6669_914_449327_3372">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3638574264 5438353.843117664 112.59826922796532 458879.3239652911 5438353.843179939
														112.6058401801274 458879.38807432953 5438353.857099299 112.56829790085169 458879.3638574264
														5438353.843117664 112.59826922796532 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6670_1697_239960_83045">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3780743295 5438353.874419807 112.56829790085169 458879.38807432953 5438353.857099299
														112.56829790085169 458879.3239652911 5438353.843179939 112.6058401801274 458879.3780743295
														5438353.874419807 112.56829790085169 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6671_1750_258337_61430">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6610308999 5438353.43734058 113.38822721054937 458878.6828944968 5438353.449963533
														113.39509311068643 458878.65263678075 5438353.455588244 113.39135898517884 458878.6610308999
														5438353.43734058 113.38822721054937 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6672_1390_173608_152707">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67502564203 5438353.468514458 113.39833536236271 458878.65263678075
														5438353.455588244 113.39135898517884 458878.6828944968 5438353.449963533 113.39509311068643
														458878.67502564203 5438353.468514458 113.39833536236271 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6673_1796_321721_341609">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3068055218 5438353.810178732 112.65683823394569 458879.32998436526 5438353.823561043
														112.64580381727026 458879.2047960207 5438353.7743775295 112.65683823394569 458879.3068055218
														5438353.810178732 112.65683823394569 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6674_1196_260498_98478">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.31998436525 5438353.840881551 112.64580381727026 458879.2047960207
														5438353.7743775295 112.65683823394569 458879.32998436526 5438353.823561043 112.64580381727026
														458879.31998436525 5438353.840881551 112.64580381727026 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6675_1716_238417_1334">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.31409085594 5438353.814384921 112.66490996126363 458879.3040290111 5438353.831669723
														112.66494262081224 458879.32998436526 5438353.823561043 112.64580381727026 458879.31409085594
														5438353.814384921 112.66490996126363 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6676_479_619977_53376">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.31998436525 5438353.840881551 112.64580381727026 458879.32998436526
														5438353.823561043 112.64580381727026 458879.3040290111 5438353.831669723 112.66494262081224
														458879.31998436525 5438353.840881551 112.64580381727026 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6677_1913_684860_335200">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.26201335 5438353.80741197 112.70777399228336 458879.3040290111 5438353.831669723
														112.66494262081224 458879.27223094826 5438353.790217092 112.70767613965414 458879.26201335
														5438353.80741197 112.70777399228336 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6678_954_503717_74954">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.31409085594 5438353.814384921 112.66490996126363 458879.27223094826
														5438353.790217092 112.70767613965414 458879.3040290111 5438353.831669723 112.66494262081224
														458879.31409085594 5438353.814384921 112.66490996126363 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6679_757_646928_295404">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2171280738 5438353.781497443 112.74653002483012 458879.26201335 5438353.80741197
														112.70777399228336 458879.22750549094 5438353.764394837 112.74638177831623 458879.2171280738
														5438353.781497443 112.74653002483012 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6680_727_88223_26268">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.27223094826 5438353.790217092 112.70767613965414 458879.22750549094
														5438353.764394837 112.74638177831623 458879.26201335 5438353.80741197 112.70777399228336
														458879.27223094826 5438353.790217092 112.70767613965414 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6681_1628_841636_31338">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.18898591463 5438353.742155549 112.79841571692483 458879.2374925122 5438353.770160846
														112.76314561346568 458879.178357382 5438353.759113174 112.79862766979167 458879.18898591463
														5438353.742155549 112.79841571692483 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6682_1355_659913_203265">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.22699482803 5438353.787194016 112.76333907600796 458879.178357382 5438353.759113174
														112.79862766979167 458879.2374925122 5438353.770160846 112.76314561346568 458879.22699482803
														5438353.787194016 112.76333907600796 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6683_835_149665_218246">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1696688393 5438353.754096841 112.78095543459591 458879.2171280738 5438353.781497443
														112.74653002483012 458879.1802090881 5438353.737088246 112.78077192533503 458879.1696688393
														5438353.754096841 112.78095543459591 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6684_1572_712902_442">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.22750549094 5438353.764394837 112.74638177831623 458879.1802090881 5438353.737088246
														112.78077192533503 458879.2171280738 5438353.781497443 112.74653002483012 458879.22750549094
														5438353.764394837 112.74638177831623 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6685_650_326782_424403">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.119948258 5438353.72539065 112.81082346329837 458879.1696688393 5438353.754096841
														112.78095543459591 458879.1306532785 5438353.708477186 112.81062005470198 458879.119948258
														5438353.72539065 112.81082346329837 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6686_614_393267_320432">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1802090881 5438353.737088246 112.78077192533503 458879.1306532785 5438353.708477186
														112.81062005470198 458879.1696688393 5438353.754096841 112.78095543459591 458879.1802090881
														5438353.737088246 112.78077192533503 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6687_1476_451545_334936">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06829383643 5438353.695567956 112.83593737187378 458879.119948258 5438353.72539065
														112.81082346329837 458879.0791644836 5438353.678750116 112.83572955842918 458879.06829383643
														5438353.695567956 112.83593737187378 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6688_1832_877900_255662">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1306532785 5438353.708477186 112.81062005470198 458879.0791644836 5438353.678750116
														112.83572955842918 458879.119948258 5438353.72539065 112.81082346329837 458879.1306532785
														5438353.708477186 112.81062005470198 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6689_1328_49255_67573">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7690134431 5438353.49968433 113.30124841121542 458878.7630032221 5438353.519308338
														113.30208756769826 458878.75924968533 5438353.494047222 113.33358981185793 458878.7690134431
														5438353.49968433 113.30124841121542 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6690_1637_876622_392499">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7530665011 5438353.513571369 113.33521093769607 458878.75924968533 5438353.494047222
														113.33358981185793 458878.7630032221 5438353.519308338 113.30208756769826 458878.7530665011
														5438353.513571369 113.33521093769607 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6691_1549_387205_301128">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7732632958 5438353.502137983 113.2659264170921 458878.7672913954 5438353.5217841165
														113.2659264170921 458878.7690134431 5438353.49968433 113.30124841121542 458878.7732632958
														5438353.502137983 113.2659264170921 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6692_254_658057_132958">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7630032221 5438353.519308338 113.30208756769826 458878.7690134431 5438353.49968433
														113.30124841121542 458878.7672913954 5438353.5217841165 113.2659264170921 458878.7630032221
														5438353.519308338 113.30208756769826 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6693_1084_275168_306267">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60294293717 5438353.403803479 113.24909672201187 458878.60449660994
														5438353.4047004925 113.28499217408885 458878.59294293716 5438353.421123987 113.24909672201187
														458878.60294293717 5438353.403803479 113.24909672201187 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6694_1787_403121_224234">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5945955435 5438353.42207812 113.2858313305717 458878.59294293716 5438353.421123987
														113.24909672201187 458878.60449660994 5438353.4047004925 113.28499217408885 458878.5945955435
														5438353.42207812 113.2858313305717 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6695_1158_561750_170723">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6828944968 5438353.449963533 113.39509311068643 458878.7051130525 5438353.462791422
														113.39258305615941 458878.67502564203 5438353.468514458 113.39833536236271 458878.6828944968
														5438353.449963533 113.39509311068643 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6696_1436_585958_12663">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.69776148226 5438353.481641002 113.39571483078887 458878.67502564203
														5438353.468514458 113.39833536236271 458878.7051130525 5438353.462791422 113.39258305615941
														458878.69776148226 5438353.481641002 113.39571483078887 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6697_49_414555_110719">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7051130525 5438353.462791422 113.39258305615941 458878.72617240913 5438353.474950047
														113.38086810303629 458878.69776148226 5438353.481641002 113.39571483078887 458878.7051130525
														5438353.462791422 113.39258305615941 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6698_1752_132336_429171">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7192948915 5438353.494073322 113.38367597535342 458878.69776148226 5438353.481641002
														113.39571483078887 458878.72617240913 5438353.474950047 113.38086810303629 458878.7192948915
														5438353.494073322 113.38367597535342 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6699_1100_227062_81073">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.84928618365 5438353.569123829 112.88603443560677 458878.90518015367
														5438353.601394228 112.88126303750263 458878.86080613243 5438353.552680864 112.88596299771018
														458878.84928618365 5438353.569123829 112.88603443560677 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6700_1968_510461_173815">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.91654191486 5438353.584859933 112.88113475580225 458878.86080613243
														5438353.552680864 112.88596299771018 458878.90518015367 5438353.601394228 112.88126303750263
														458878.91654191486 5438353.584859933 112.88113475580225 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6701_1557_814596_52837">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7967391636 5438353.538785793 112.88558614489173 458878.84928618365 5438353.569123829
														112.88603443560677 458878.8084031956 5438353.522426014 112.88558171538318 458878.7967391636
														5438353.538785793 112.88558614489173 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6702_26_774037_112486">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86080613243 5438353.552680864 112.88596299771018 458878.8084031956 5438353.522426014
														112.88558171538318 458878.84928618365 5438353.569123829 112.88603443560677 458878.86080613243
														5438353.552680864 112.88596299771018 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6703_1904_532115_179197">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.75924968533 5438353.494047222 113.33358981185793 458878.7530665011 5438353.513571369
														113.33521093769607 458878.74463740643 5438353.4856108185 113.36074660601252 458878.75924968533
														5438353.494047222 113.33358981185793 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6704_604_106691_379353">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7381584035 5438353.504964176 113.36303922415914 458878.74463740643
														5438353.4856108185 113.36074660601252 458878.7530665011 5438353.513571369 113.33521093769607
														458878.7381584035 5438353.504964176 113.36303922415914 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6705_165_303067_378222">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2833623803 5438353.796643827 112.72344959590235 458879.3262933766 5438353.82143005
														112.67958913972109 458879.2729938151 5438353.813751544 112.72361237659429 458879.2833623803
														5438353.796643827 112.72344959590235 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6706_556_36391_92366">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7410168669 5438353.50661451 113.32860878698193 458878.74449654575 5438353.485529493
														113.32545122946328 458878.7279275872 5438353.499057411 113.35315394047863 458878.7410168669
														5438353.50661451 113.32860878698193 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6707_1575_778631_46206">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7121369501 5438353.489940682 113.37049980102183 458878.7279275872 5438353.499057411
														113.35315394047863 458878.7168502742 5438353.469567911 113.36522472425722 458878.7121369501
														5438353.489940682 113.37049980102183 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6708_1574_609552_264213">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.73194802075 5438353.478284598 113.34877255492142 458878.7168502742 5438353.469567911
														113.36522472425722 458878.7279275872 5438353.499057411 113.35315394047863 458878.73194802075
														5438353.478284598 113.34877255492142 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6709_1122_843030_329930">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.69517131 5438353.480145565 113.38003438537927 458878.7121369501 5438353.489940682
														113.37049980102183 458878.7006591655 5438353.460219969 113.3742315558622 458878.69517131
														5438353.480145565 113.38003438537927 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6710_220_150275_340413">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7168502742 5438353.469567911 113.36522472425722 458878.7006591655 5438353.460219969
														113.3742315558622 458878.7121369501 5438353.489940682 113.37049980102183 458878.7168502742
														5438353.469567911 113.36522472425722 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6711_314_627639_271892">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67798307375 5438353.470221933 113.38205647234814 458878.69517131 5438353.480145565
														113.38003438537927 458878.684280865 5438353.450763953 113.3760818303744 458878.67798307375
														5438353.470221933 113.38205647234814 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6712_1385_427632_179275">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6242027259 5438353.416077823 113.34884621449598 458878.6148754264 5438353.433786715
														113.35113883264259 458878.61174792796 5438353.408887043 113.31901486838049 458878.6242027259
														5438353.416077823 113.34884621449598 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6713_678_538486_282056">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7006591655 5438353.460219969 113.3742315558622 458878.684280865 5438353.450763953
														113.3760818303744 458878.69517131 5438353.480145565 113.38003438537927 458878.7006591655
														5438353.460219969 113.3742315558622 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6714_320_555250_168687">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.63799433293 5438353.424040412 113.33866831642996 458878.62925225083
														5438353.442087179 113.34300221744502 458878.6520903063 5438353.4321787255 113.358464511525
														458878.63799433293 5438353.424040412 113.33866831642996 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6715_1740_157200_145618">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6441232104 5438353.450672931 113.36371704994695 458878.6520903063 5438353.4321787255
														113.358464511525 458878.62925225083 5438353.442087179 113.34300221744502 458878.6441232104
														5438353.450672931 113.36371704994695 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6716_888_261991_188723">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.627122916 5438353.417763796 113.31262943538453 458878.61774389335 5438353.435442826
														113.3157177559892 458878.63799433293 5438353.424040412 113.33866831642996 458878.627122916
														5438353.417763796 113.31262943538453 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6717_1338_850982_122548">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.62925225083 5438353.442087179 113.34300221744502 458878.63799433293
														5438353.424040412 113.33866831642996 458878.61774389335 5438353.435442826 113.3157177559892
														458878.62925225083 5438353.442087179 113.34300221744502 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6718_923_99371_288905">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3160513503 5438353.838610824 112.6797092491366 458879.2729938151 5438353.813751544
														112.72361237659429 458879.3262933766 5438353.82143005 112.67958913972109 458879.3160513503
														5438353.838610824 112.6797092491366 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6719_461_680854_372617">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.36600271705 5438353.844356248 112.63185315133651 458879.35588381614
														5438353.8616081085 112.63191888112283 458879.3262933766 5438353.82143005 112.67958913972109
														458879.36600271705 5438353.844356248 112.63185315133651 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6720_226_684977_362662">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3160513503 5438353.838610824 112.6797092491366 458879.3262933766 5438353.82143005
														112.67958913972109 458879.35588381614 5438353.8616081085 112.63191888112283 458879.3160513503
														5438353.838610824 112.6797092491366 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6721_1859_641688_43419">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7932656063 5438353.536780334 112.88555651117548 458878.7967391636 5438353.538785793
														112.88558614489173 458878.80493916274 5438353.520426054 112.88555651117548 458878.7932656063
														5438353.536780334 112.88555651117548 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6722_1965_441841_218795">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8084031956 5438353.522426014 112.88558171538318 458878.80493916274 5438353.520426054
														112.88555651117548 458878.7967391636 5438353.538785793 112.88558614489173 458878.8084031956
														5438353.522426014 112.88558171538318 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6723_1656_850857_54947">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.35588381614 5438353.8616081085 112.63191888112283 458879.36600271705
														5438353.844356248 112.63185315133651 458879.39222883834 5438353.882591917 112.58055606508087
														458879.35588381614 5438353.8616081085 112.63191888112283 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6724_1677_467335_74644">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.72617240913 5438353.474950047 113.38086810303629 458878.74463740643
														5438353.4856108185 113.36074660601252 458878.7192948915 5438353.494073322 113.38367597535342
														458878.72617240913 5438353.474950047 113.38086810303629 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6725_1863_311122_32098">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7381584035 5438353.504964176 113.36303922415914 458878.7192948915 5438353.494073322
														113.38367597535342 458878.74463740643 5438353.4856108185 113.36074660601252 458878.7381584035
														5438353.504964176 113.36303922415914 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6726_1910_395704_55647">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2374925122 5438353.770160846 112.76314561346568 458879.2833623803 5438353.796643827
														112.72344959590235 458879.22699482803 5438353.787194016 112.76333907600796 458879.2374925122
														5438353.770160846 112.76314561346568 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6727_332_647671_392125">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2729938151 5438353.813751544 112.72361237659429 458879.22699482803 5438353.787194016
														112.76333907600796 458879.2833623803 5438353.796643827 112.72344959590235 458879.2729938151
														5438353.813751544 112.72361237659429 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6728_500_652962_50811">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.01504581963 5438353.664825199 112.85613173638644 458879.06829383643
														5438353.695567956 112.83593737187378 458879.0260818573 5438353.648102848 112.8559350415954
														458879.01504581963 5438353.664825199 112.85613173638644 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6729_1197_595822_1303">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0791644836 5438353.678750116 112.83572955842918 458879.0260818573 5438353.648102848
														112.8559350415954 458879.06829383643 5438353.695567956 112.83593737187378 458879.0791644836
														5438353.678750116 112.83572955842918 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6730_221_862488_193994">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.96055494924 5438353.63336488 112.87127353766703 458879.01504581963 5438353.664825199
														112.85613173638644 458878.97175505175 5438353.616737252 112.87110341179341 458878.96055494924
														5438353.63336488 112.87127353766703 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6731_108_713548_394134">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0260818573 5438353.648102848 112.8559350415954 458878.97175505175 5438353.616737252
														112.87110341179341 458879.01504581963 5438353.664825199 112.85613173638644 458879.0260818573
														5438353.648102848 112.8559350415954 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6732_233_192718_383852">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.90518015367 5438353.601394228 112.88126303750263 458878.96055494924 5438353.63336488
														112.87127353766703 458878.91654191486 5438353.584859933 112.88113475580225 458878.90518015367
														5438353.601394228 112.88126303750263 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6733_682_201375_364618">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97175505175 5438353.616737252 112.87110341179341 458878.91654191486
														5438353.584859933 112.88113475580225 458878.96055494924 5438353.63336488 112.87127353766703
														458878.97175505175 5438353.616737252 112.87110341179341 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6734_146_170091_94875">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.757164855 5438353.492843544 113.2633609518305 458878.7531384393 5438353.490518892
														113.29682588363047 458878.75409067393 5438353.514162676 113.2633609518305 458878.757164855
														5438353.492843544 113.2633609518305 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6735_400_131764_179429">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74998539575 5438353.511792492 113.29851411223173 458878.75409067393
														5438353.514162676 113.2633609518305 458878.7531384393 5438353.490518892 113.29682588363047
														458878.74998539575 5438353.511792492 113.29851411223173 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6736_699_179357_285774">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74449654575 5438353.485529493 113.32545122946328 458878.7410168669 5438353.50661451
														113.32860878698193 458878.7531384393 5438353.490518892 113.29682588363047 458878.74449654575
														5438353.485529493 113.32545122946328 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6737_258_32915_405270">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74998539575 5438353.511792492 113.29851411223173 458878.7531384393 5438353.490518892
														113.29682588363047 458878.7410168669 5438353.50661451 113.32860878698193 458878.74998539575
														5438353.511792492 113.29851411223173 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6738_1511_887905_4994">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.73194802075 5438353.478284598 113.34877255492142 458878.7279275872 5438353.499057411
														113.35315394047863 458878.74449654575 5438353.485529493 113.32545122946328 458878.73194802075
														5438353.478284598 113.34877255492142 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6739_321_851222_154143">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.3638574264 5438353.843117664 112.59826922796532 458879.33467054466 5438353.82626661
														112.621601456597 458879.3239652911 5438353.843179939 112.6058401801274 458879.3638574264
														5438353.843117664 112.59826922796532 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6740_1913_456368_392267">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.20019855705 5438353.771723182 112.63753583780847 458879.26417567516
														5438353.808660389 112.62922270676458 458879.3011988588 5438353.806941723 112.63753583780847
														458879.20019855705 5438353.771723182 112.63753583780847 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6741_1071_360697_74762">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.33467054466 5438353.82626661 112.621601456597 458879.3011988588 5438353.806941723
														112.63753583780847 458879.26417567516 5438353.808660389 112.62922270676458 458879.33467054466
														5438353.82626661 112.621601456597 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6742_447_806297_257655">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0147514126 5438353.6646552235 112.66840118355077 458879.0750438046 5438353.676371042
														112.66840118355077 458878.98348280013 5438353.646602281 112.66508069223536 458879.0147514126
														5438353.6646552235 112.66840118355077 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6743_449_660043_367447">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0369113503 5438353.654355259 112.66508069223536 458878.98348280013 5438353.646602281
														112.66508069223536 458879.0750438046 5438353.676371042 112.66840118355077 458879.0369113503
														5438353.654355259 112.66508069223536 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6744_70_659211_338448">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8591612963 5438353.551731218 112.64848350233254 458878.8667451759 5438353.556109772
														112.64701107996083 458878.8377277558 5438353.562450567 112.64848350233254 458878.8591612963
														5438353.551731218 112.64848350233254 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6745_1498_59174_82702">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8379015705 5438353.539456909 112.6585447508261 458878.84464987664 5438353.543353045
														112.654286172809 458878.8202947806 5438353.552385635 112.6585447508261 458878.8379015705
														5438353.539456909 112.6585447508261 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6746_1991_377753_161690">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8258283917 5438353.555580467 112.654286172809 458878.8202947806 5438353.552385635
														112.6585447508261 458878.84464987664 5438353.543353045 112.654286172809 458878.8258283917
														5438353.555580467 112.654286172809 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6747_1525_836979_358278">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.38807432953 5438353.857099299 112.56829790085169 458879.3780743295 5438353.874419807
														112.56829790085169 458879.3962112901 5438353.884891187 112.53306118902809 458879.4062112901
														5438353.867570679 112.53306118902809 458879.38807432953 5438353.857099299 112.56829790085169
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6748_1966_762412_73341">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8517657485 5438353.547461396 112.65091855859103 458878.8591612963 5438353.551731218
														112.64848350233254 458878.8316634066 5438353.558949314 112.65091855859103 458878.8517657485
														5438353.547461396 112.65091855859103 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6749_1262_551358_107548">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8377277558 5438353.562450567 112.64848350233254 458878.8316634066 5438353.558949314
														112.65091855859103 458878.8591612963 5438353.551731218 112.64848350233254 458878.8377277558
														5438353.562450567 112.64848350233254 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6750_865_744047_279007">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8439465371 5438353.5660409825 112.64701107996083 458878.8377277558 5438353.562450567
														112.64848350233254 458878.8667451759 5438353.556109772 112.64701107996083 458878.8439465371
														5438353.5660409825 112.64701107996083 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6751_299_146807_330502">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8667451759 5438353.556109772 112.64701107996083 458878.87442371726 5438353.56054298
														112.64651947769566 458878.8439465371 5438353.5660409825 112.64701107996083 458878.8667451759
														5438353.556109772 112.64701107996083 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6752_1982_226312_148853">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.850242941 5438353.569676213 112.64651947769566 458878.8439465371 5438353.5660409825
														112.64701107996083 458878.87442371726 5438353.56054298 112.64651947769566 458878.850242941
														5438353.569676213 112.64651947769566 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6753_1026_165739_321667">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9576864164 5438353.608614722 112.67103898952138 458878.99622461595 5438353.630864762
														112.67940128282697 458878.91851835424 5438353.609095042 112.67103898952138 458878.9576864164
														5438353.608614722 112.67103898952138 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6754_627_761220_132035">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95011967793 5438353.627340075 112.67940128282697 458878.91851835424
														5438353.609095042 112.67103898952138 458878.99622461595 5438353.630864762 112.67940128282697
														458878.95011967793 5438353.627340075 112.67940128282697 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6755_1009_788781_98789">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80136643245 5438353.518363337 112.95748772150878 458878.79033596743
														5438353.535088906 112.95748772150878 458878.79808260366 5438353.516467418 113.00905057093928
														458878.80136643245 5438353.518363337 112.95748772150878 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6756_1441_426889_195403">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78764322784 5438353.533534252 113.00905057093928 458878.79808260366
														5438353.516467418 113.00905057093928 458878.79033596743 5438353.535088906 112.95748772150878
														458878.78764322784 5438353.533534252 113.00905057093928 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6757_1046_69062_66914">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86479376984 5438353.554983128 112.6267919299992 458878.8423463841 5438353.565117134
														112.6267919299992 458878.87442738103 5438353.560545095 112.62617515854582 458878.86479376984
														5438353.554983128 112.6267919299992 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6758_813_612432_31765">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8502459453 5438353.569677948 112.62617515854582 458878.87442738103 5438353.560545095
														112.62617515854582 458878.8423463841 5438353.565117134 112.6267919299992 458878.8502459453
														5438353.569677948 112.62617515854582 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6759_350_34461_391556">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.85527892253 5438353.549489728 112.62863925282609 458878.8345442093 5438353.560612546
														112.62863925282609 458878.86479376984 5438353.554983128 112.6267919299992 458878.85527892253
														5438353.549489728 112.62863925282609 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6760_1797_621673_222267">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8423463841 5438353.565117134 112.6267919299992 458878.86479376984 5438353.554983128
														112.6267919299992 458878.8345442093 5438353.560612546 112.62863925282609 458878.8423463841
														5438353.565117134 112.6267919299992 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6761_865_668559_118762">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8460003592 5438353.544132747 112.63169431032692 458878.8269357874 5438353.556219822
														112.63169431032692 458878.85527892253 5438353.549489728 112.62863925282609 458878.8460003592
														5438353.544132747 112.63169431032692 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6762_999_474271_256141">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8345442093 5438353.560612546 112.62863925282609 458878.85527892253 5438353.549489728
														112.62863925282609 458878.8269357874 5438353.556219822 112.63169431032692 458878.8345442093
														5438353.560612546 112.62863925282609 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6763_234_10312_229579">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5247140762 5438353.935988294 113.27212287432952 458878.5232023345 5438353.935115489
														113.27333427116542 458878.5215194518 5438353.934143877 113.27395341887931 458878.5197801138
														5438353.93313967 113.2739381235777 458878.5181028537 5438353.932171303 113.27328942761006
														458878.51660197373 5438353.93130477 113.27205153853462 458878.5153797566 5438353.930599122
														113.27030881644613 458878.5145194942 5438353.930102449 113.26818002497495 458878.51407981215
														5438353.929848598 113.26581023774184 458878.51409067394 5438353.92985487 113.2633609518305
														458878.5190644296 5438353.932726469 113.21227156953222 458878.523573014 5438353.9353295015
														113.16119841000717 458878.5276254545 5438353.937669179 113.11004949849838 458878.531221111
														5438353.939745132 113.05883291302227 458878.53435941576 5438353.941557033 113.00755674228215
														458878.5370398731 5438353.943104596 112.9562290843926 458878.53926205966 5438353.944387577
														112.9048580455989 458878.5410256245 5438353.945405771 112.85345173899839 458878.5423302891
														5438353.946159019 112.8020182832574 458878.5431758474 5438353.946647203 112.75056580133051
														458878.543563051 5438353.9468707545 112.6989845124514 458878.54362142895 5438353.946904459
														112.69120769778465 458878.5464124904 5438353.948515879 112.68200099031416 458878.5503069863
														5438353.950764367 112.6723032167059 458878.55494161893 5438353.9534401735 112.66327387433691
														458878.56025914487 5438353.956510249 112.6550244866448 458878.56619388616 5438353.959936674
														112.64765694367168 458878.57267254154 5438353.963677127 112.6412622435972 458878.5796150916
														5438353.96768541 112.63591936879966 458878.5869357874 5438353.971912015 112.63169431032692
														458878.5945442093 5438353.97630474 112.62863925282609 458878.6023463841 5438353.980809328
														112.6267919299992 458878.6102459453 5438353.985370141 112.62617515854582 458878.61908353027
														5438353.9904725235 112.62687035956935 458878.65112285665 5438354.008970438 112.64064054707083
														458878.6815740885 5438354.026551465 112.65117916904981 458878.71239207557 5438354.044344237
														112.65933417703286 458878.74348280014 5438354.062294476 112.66508069223536 458878.7747514126
														5438354.080347418 112.66840118355077 458878.8061025207 5438354.098447988 112.66928552103333
														458878.8374404805 5438354.1165409675 112.66773100680198 458878.86866968794 5438354.134571159
														112.66374238327081 458878.89969487115 5438354.152483556 112.65733181868121 458878.93042138026
														5438354.1702235155 112.6485188699798 458878.96019855706 5438354.187415376 112.63753583780847
														458878.9620507551 5438354.188484743 112.63702689499502 458878.96393338363 5438354.18957168
														112.63721034899224 458878.9657181447 5438354.190602112 112.63807369771341 458878.9672834098
														5438354.191505818 112.63955810536993 458878.9685225086 5438354.192221212 112.64156241203311
														458878.9693509987 5438354.19269954 112.64395002751612 458878.9697124198 5438354.192908207
														112.64655823976953 458878.9695821416 5438354.1928329915 112.64920930343854 458878.9689690424
														5438354.192479018 112.65172255291517 458878.96791490394 5438354.191870411 112.65392671440096
														458878.96649156394 5438354.191048645 112.6556715779332 458878.9647960207 5438354.190069723
														112.65683823394569 458878.93369088706 5438354.172111166 112.66831107053583 458878.9021833665
														5438354.15392029 112.67734802820426 458878.87036958016 5438354.135552593 112.68392153756981
														458878.8383465836 5438354.117064106 112.68801154458424 458878.80621207045 5438354.098511237
														112.68960557171176 458878.7740640748 5438354.079950583 112.68869875599489 458878.74200067157
														5438354.061438768 112.68529386388984 458878.7101196779 5438354.043032268 112.67940128282697
														458878.67851835425 5438354.024787235 112.67103898952138 458878.647293108 5438354.006759331
														112.66023249513065 458878.61653919913 5438353.989003553 112.64701476742715 458878.61024294095
														5438353.985368407 112.64651947769566 458878.6039465371 5438353.981733177 112.64701107996083
														458878.5977277558 5438353.978142762 112.64848350233254 458878.5916634066 5438353.9746415075
														112.65091855859103 458878.58582839166 5438353.97127266 112.654286172809 458878.5802947806
														5438353.968077828 112.6585447508261 458878.5751309203 5438353.965096473 112.66364169398781
														458878.57040059066 5438353.962365415 112.66951404880323 458878.5661622171 5438353.959918389
														112.67608928449776 458878.5624681488 5438353.957785618 112.68328618885707 458878.5593640119
														5438353.955993444 112.69101587129732 458878.55688814644 5438353.954564002 112.69918286077291
														458878.55650005774 5438353.954339939 112.7508820563776 458878.55565062497 5438353.953849519
														112.80257030180908 458878.55433998216 5438353.953092819 112.85423943387363 458878.5532656063
														5438353.9524725275 112.88555651117548 458878.5525683364 5438353.952069959 112.90588129239611
														458878.55033596744 5438353.9507810995 112.95748772150878 458878.54764322785 5438353.9492264455
														113.00905057093928 458878.5444905429 5438353.947406243 113.06056169729784 458878.54087841045
														5438353.945320777 113.1120129653634 458878.53680740104 5438353.942970378 113.16339624936839
														458878.5322781576 5438353.940355418 113.21470343428207 458878.5272913954 5438353.93747631
														113.2659264170921 458878.5268307299 5438353.937210345 113.26828828689449 458878.5259516543
														5438353.93670281 113.27040178306404 458878.5247140762 5438353.935988294 113.27212287432952
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6764_1217_354844_318196">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.422301107 5438353.876860139 112.54155941268473 458879.412301107 5438353.894180647
														112.54155941268473 458879.39222883834 5438353.882591917 112.58055606508087 458879.40222883835
														5438353.865271409 112.58055606508087 458879.422301107 5438353.876860139 112.54155941268473
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6765_622_265718_340547">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.62094286724 5438353.414195743 113.23585825253516 458878.6109428673
														5438353.4315162515 113.23585825253516 458878.6092501745 5438353.430538975 113.24992680721377
														458878.61925017443 5438353.413218467 113.24992680721377 458878.62094286724 5438353.414195743
														113.23585825253516 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6766_819_690376_425362">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8040888336 5438353.519935116 112.90588129239611 458878.7925683364 5438353.536377764
														112.90588129239611 458878.80136643245 5438353.518363337 112.95748772150878 458878.8040888336
														5438353.519935116 112.90588129239611 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6767_1959_721287_10477">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79033596743 5438353.535088906 112.95748772150878 458878.80136643245
														5438353.518363337 112.95748772150878 458878.7925683364 5438353.536377764 112.90588129239611
														458878.79033596743 5438353.535088906 112.95748772150878 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6768_1936_741770_160685">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8852049237 5438353.566767513 112.62687035956935 458878.85908353026 5438353.57478033
														112.62687035956935 458878.92427727294 5438353.589325944 112.64064054707083 458878.8852049237
														5438353.566767513 112.62687035956935 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6769_334_738807_227670">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.89112285664 5438353.593278243 112.64064054707083 458878.92427727294
														5438353.589325944 112.64064054707083 458878.85908353026 5438353.57478033 112.62687035956935
														458878.89112285664 5438353.593278243 112.64064054707083 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6770_1862_84362_260195">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99622461595 5438353.630864762 112.67940128282697 458879.0351038765 5438353.653311714
														112.68529386388984 458878.95011967793 5438353.627340075 112.67940128282697 458878.99622461595
														5438353.630864762 112.67940128282697 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6771_870_610393_386635">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.98200067156 5438353.645746575 112.68529386388984 458878.95011967793
														5438353.627340075 112.67940128282697 458879.0351038765 5438353.653311714 112.68529386388984
														458878.98200067156 5438353.645746575 112.68529386388984 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6772_1913_375678_346461">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8370726814 5438353.538978349 112.63591936879966 458878.8196150916 5438353.551993216
														112.63591936879966 458878.8460003592 5438353.544132747 112.63169431032692 458878.8370726814
														5438353.538978349 112.63591936879966 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6773_320_9428_232036">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8269357874 5438353.556219822 112.63169431032692 458878.8460003592 5438353.544132747
														112.63169431032692 458878.8196150916 5438353.551993216 112.63591936879966 458878.8269357874
														5438353.556219822 112.63169431032692 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6774_49_709342_108888">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8286061569 5438353.5340901995 112.6412622435972 458878.81267254153 5438353.547984933
														112.6412622435972 458878.8370726814 5438353.538978349 112.63591936879966 458878.8286061569
														5438353.5340901995 112.6412622435972 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6775_300_353538_111119">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8196150916 5438353.551993216 112.63591936879966 458878.8370726814 5438353.538978349
														112.63591936879966 458878.81267254153 5438353.547984933 112.6412622435972 458878.8196150916
														5438353.551993216 112.63591936879966 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6776_1029_657711_11854">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.82070535776 5438353.529528671 112.64765694367168 458878.80619388615
														5438353.544244479 112.64765694367168 458878.8286061569 5438353.5340901995 112.6412622435972
														458878.82070535776 5438353.529528671 112.64765694367168 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6777_1228_103212_401886">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.81267254153 5438353.547984933 112.6412622435972 458878.8286061569 5438353.5340901995
														112.6412622435972 458878.80619388615 5438353.544244479 112.64765694367168 458878.81267254153
														5438353.547984933 112.6412622435972 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6778_1043_722091_217380">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79317797086 5438353.513635727 112.69120769778465 458878.78362142894
														5438353.531212266 112.69120769778465 458878.79658170434 5438353.515600873 112.68200099031416
														458878.79317797086 5438353.513635727 112.69120769778465 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6779_329_169403_219946">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7864124904 5438353.532823686 112.68200099031416 458878.79658170434 5438353.515600873
														112.68200099031416 458878.78362142894 5438353.531212266 112.69120769778465 458878.7864124904
														5438353.532823686 112.68200099031416 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6780_143_254532_201971">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60294293717 5438353.403803479 113.24909672201187 458878.59294293716
														5438353.421123987 113.24909672201187 458878.5950678635 5438353.422350814 113.23143572495021
														458878.60506786353 5438353.4050303055 113.23143572495021 458878.60294293717 5438353.403803479
														113.24909672201187 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6781_540_491014_232559">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.81616177555 5438353.526905432 112.68328618885707 458878.8024681488 5438353.542093424
														112.68328618885707 458878.81237624283 5438353.524719854 112.69101587129732 458878.81616177555
														5438353.526905432 112.68328618885707 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6782_299_448799_290724">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7993640119 5438353.54030125 112.69101587129732 458878.81237624283 5438353.524719854
														112.69101587129732 458878.8024681488 5438353.542093424 112.68328618885707 458878.7993640119
														5438353.54030125 112.69101587129732 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6783_1041_275973_258944">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.820666737 5438353.529506373 112.67608928449776 458878.80616221716 5438353.544226196
														112.67608928449776 458878.81616177555 5438353.526905432 112.68328618885707 458878.820666737
														5438353.529506373 112.67608928449776 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6784_931_157221_217122">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8024681488 5438353.542093424 112.68328618885707 458878.81616177555 5438353.526905432
														112.68328618885707 458878.80616221716 5438353.544226196 112.67608928449776 458878.8024681488
														5438353.542093424 112.68328618885707 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6785_1365_550917_268486">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.76872868434 5438353.499519925 113.16119841000717 458878.763573014 5438353.519637307
														113.16119841000717 458878.77367068495 5438353.50237319 113.11004949849838 458878.76872868434
														5438353.499519925 113.16119841000717 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6786_1341_229417_379778">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.76762545446 5438353.521976985 113.11004949849838 458878.77367068495 5438353.50237319
														113.11004949849838 458878.763573014 5438353.519637307 113.16119841000717 458878.76762545446
														5438353.521976985 113.11004949849838 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6787_1019_712114_402842">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7632304107 5438353.496345495 113.21227156953222 458878.7590644296 5438353.517034275
														113.21227156953222 458878.76872868434 5438353.499519925 113.16119841000717 458878.7632304107
														5438353.496345495 113.21227156953222 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6788_1247_309962_22303">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.763573014 5438353.519637307 113.16119841000717 458878.76872868434 5438353.499519925
														113.16119841000717 458878.7590644296 5438353.517034275 113.21227156953222 458878.763573014
														5438353.519637307 113.16119841000717 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6789_618_177824_372977">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.757164855 5438353.492843544 113.2633609518305 458878.75409067393 5438353.514162676
														113.2633609518305 458878.7632304107 5438353.496345495 113.21227156953222 458878.757164855
														5438353.492843544 113.2633609518305 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6790_1560_409114_364813">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7590644296 5438353.517034275 113.21227156953222 458878.7632304107 5438353.496345495
														113.21227156953222 458878.75409067393 5438353.514162676 113.2633609518305 458878.7590644296
														5438353.517034275 113.21227156953222 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6791_825_100440_63846">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8258354852 5438353.5324905515 112.66951404880323 458878.81040059065
														5438353.5466732215 112.66951404880323 458878.820666737 5438353.529506373 112.67608928449776
														458878.8258354852 5438353.5324905515 112.66951404880323 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6792_185_764014_345215">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80616221716 5438353.544226196 112.67608928449776 458878.820666737 5438353.529506373
														112.67608928449776 458878.81040059065 5438353.5466732215 112.66951404880323 458878.80616221716
														5438353.544226196 112.67608928449776 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6793_279_659692_109153">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8258354852 5438353.5324905515 112.66951404880323 458878.8316041798 5438353.535821109
														112.66364169398781 458878.81040059065 5438353.5466732215 112.66951404880323 458878.8258354852
														5438353.5324905515 112.66951404880323 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6794_571_132041_179197">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.81513092026 5438353.549404278 112.66364169398781 458878.81040059065
														5438353.5466732215 112.66951404880323 458878.8316041798 5438353.535821109 112.66364169398781
														458878.81513092026 5438353.549404278 112.66364169398781 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6795_1671_82266_197629">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8316041798 5438353.535821109 112.66364169398781 458878.8379015705 5438353.539456909
														112.6585447508261 458878.81513092026 5438353.549404278 112.66364169398781 458878.8316041798
														5438353.535821109 112.66364169398781 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6796_1191_212792_234147">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8202947806 5438353.552385635 112.6585447508261 458878.81513092026 5438353.549404278
														112.66364169398781 458878.8379015705 5438353.539456909 112.6585447508261 458878.8202947806
														5438353.552385635 112.6585447508261 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6797_1942_162967_209591">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0351038765 5438353.653311714 112.68529386388984 458879.07420558773 5438353.675887097
														112.68869875599489 458878.98200067156 5438353.645746575 112.68529386388984 458879.0351038765
														5438353.653311714 112.68529386388984 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6798_610_868862_87359">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0140640748 5438353.664258389 112.68869875599489 458878.98200067156 5438353.645746575
														112.68529386388984 458879.07420558773 5438353.675887097 112.68869875599489 458879.0140640748
														5438353.664258389 112.68869875599489 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6799_1070_518405_397596">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.07420558773 5438353.675887097 112.68869875599489 458879.11341046053
														5438353.698522041 112.68960557171176 458879.0140640748 5438353.664258389 112.68869875599489
														458879.07420558773 5438353.675887097 112.68869875599489 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6800_561_680866_212037">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.04621207044 5438353.682819043 112.68960557171176 458879.0140640748 5438353.664258389
														112.68869875599489 458879.11341046053 5438353.698522041 112.68960557171176 458879.04621207044
														5438353.682819043 112.68960557171176 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6801_1406_858071_355524">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.11341046053 5438353.698522041 112.68960557171176 458879.1525988911 5438353.721147492
														112.68801154458424 458879.04621207044 5438353.682819043 112.68960557171176 458879.11341046053
														5438353.698522041 112.68960557171176 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6802_636_419422_185092">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0783465836 5438353.701371913 112.68801154458424 458879.04621207044 5438353.682819043
														112.68960557171176 458879.1525988911 5438353.721147492 112.68801154458424 458879.0783465836
														5438353.701371913 112.68801154458424 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6803_84_757542_211780">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1525988911 5438353.721147492 112.68801154458424 458879.191651326 5438353.743694426
														112.68392153756981 458879.0783465836 5438353.701371913 112.68801154458424 458879.1525988911
														5438353.721147492 112.68801154458424 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6804_1494_884027_252334">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.11036958015 5438353.719860398 112.68392153756981 458879.0783465836 5438353.701371913
														112.68801154458424 458879.191651326 5438353.743694426 112.68392153756981 458879.11036958015
														5438353.719860398 112.68392153756981 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6805_1773_401201_53753">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.77367068495 5438353.50237319 113.11004949849838 458878.76762545446 5438353.521976985
														113.11004949849838 458878.77805563196 5438353.50490484 113.05883291302227 458878.77367068495
														5438353.50237319 113.11004949849838 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6806_288_765223_301740">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.191651326 5438353.743694426 112.68392153756981 458879.2304486264 5438353.766094057
														112.67734802820426 458879.11036958015 5438353.719860398 112.68392153756981 458879.191651326
														5438353.743694426 112.68392153756981 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6807_873_92937_185469">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.14218336646 5438353.738228097 112.67734802820426 458879.11036958015
														5438353.719860398 112.68392153756981 458879.2304486264 5438353.766094057 112.67734802820426
														458879.14218336646 5438353.738228097 112.67734802820426 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6808_467_716419_79861">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79310677823 5438353.513594624 112.6989845124514 458878.78356305096 5438353.531178561
														112.6989845124514 458878.79317797086 5438353.513635727 112.69120769778465 458878.79310677823
														5438353.513594624 112.6989845124514 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6809_164_360837_24841">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78362142894 5438353.531212266 112.69120769778465 458878.79317797086
														5438353.513635727 112.69120769778465 458878.78356305096 5438353.531178561 112.6989845124514
														458878.78362142894 5438353.531212266 112.69120769778465 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6810_948_827978_2110">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7926345788 5438353.513321999 112.75056580133051 458878.7831758474 5438353.530955009
														112.75056580133051 458878.79310677823 5438353.513594624 112.6989845124514 458878.7926345788
														5438353.513321999 112.75056580133051 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6811_775_622072_272669">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78356305096 5438353.531178561 112.6989845124514 458878.79310677823 5438353.513594624
														112.6989845124514 458878.7831758474 5438353.530955009 112.75056580133051 458878.78356305096
														5438353.531178561 112.6989845124514 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6812_979_148021_50592">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1132768633 5438353.6984449085 112.66928552103333 458879.0461025207 5438353.682755794
														112.66928552103333 458879.15149388735 5438353.720509517 112.66773100680198 458879.1132768633
														5438353.6984449085 112.66928552103333 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6813_1322_58614_97133">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.07744048046 5438353.700848774 112.66773100680198 458879.15149388735
														5438353.720509517 112.66773100680198 458879.0461025207 5438353.682755794 112.66928552103333
														458879.07744048046 5438353.700848774 112.66773100680198 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6814_36_749012_62674">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.84464987664 5438353.543353045 112.654286172809 458878.8517657485 5438353.547461396
														112.65091855859103 458878.8258283917 5438353.555580467 112.654286172809 458878.84464987664
														5438353.543353045 112.654286172809 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6815_1621_699746_108877">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8316634066 5438353.558949314 112.65091855859103 458878.8258283917 5438353.555580467
														112.654286172809 458878.8517657485 5438353.547461396 112.65091855859103 458878.8316634066
														5438353.558949314 112.65091855859103 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6816_591_734978_296885">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.87442738103 5438353.560545095 112.62617515854582 458878.8502459453 5438353.569677948
														112.62617515854582 458878.8852049237 5438353.566767513 112.62687035956935 458878.87442738103
														5438353.560545095 112.62617515854582 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6817_1548_894276_362158">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.85908353026 5438353.57478033 112.62687035956935 458878.8852049237 5438353.566767513
														112.62687035956935 458878.8502459453 5438353.569677948 112.62617515854582 458878.85908353026
														5438353.57478033 112.62687035956935 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6818_1444_254627_43932">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78486818075 5438353.508838067 113.16339624936839 458878.77680740103
														5438353.527278185 113.16339624936839 458878.77934471314 5438353.505649092 113.21470343428207
														458878.78486818075 5438353.508838067 113.16339624936839 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6819_1845_450866_224218">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7722781576 5438353.524663225 113.21470343428207 458878.77934471314 5438353.505649092
														113.21470343428207 458878.77680740103 5438353.527278185 113.16339624936839 458878.7722781576
														5438353.524663225 113.21470343428207 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6820_1564_356781_417580">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78983282635 5438353.511704407 113.1120129653634 458878.78087841044 5438353.529628583
														113.1120129653634 458878.78486818075 5438353.508838067 113.16339624936839 458878.78983282635
														5438353.511704407 113.1120129653634 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6821_1066_824248_53933">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.77680740103 5438353.527278185 113.16339624936839 458878.78486818075
														5438353.508838067 113.16339624936839 458878.78087841044 5438353.529628583 113.1120129653634
														458878.77680740103 5438353.527278185 113.16339624936839 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6822_1788_93934_420351">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7942378659 5438353.514247658 113.06056169729784 458878.7844905429 5438353.531714048
														113.06056169729784 458878.78983282635 5438353.511704407 113.1120129653634 458878.7942378659
														5438353.514247658 113.06056169729784 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6823_793_4949_23752">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78087841044 5438353.529628583 113.1120129653634 458878.78983282635 5438353.511704407
														113.1120129653634 458878.7844905429 5438353.531714048 113.06056169729784 458878.78087841044
														5438353.529628583 113.1120129653634 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6824_665_276626_174879">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79808260366 5438353.516467418 113.00905057093928 458878.78764322784
														5438353.533534252 113.00905057093928 458878.7942378659 5438353.514247658 113.06056169729784
														458878.79808260366 5438353.516467418 113.00905057093928 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6825_382_348648_269451">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7844905429 5438353.531714048 113.06056169729784 458878.7942378659 5438353.514247658
														113.06056169729784 458878.78764322784 5438353.533534252 113.00905057093928 458878.7844905429
														5438353.531714048 113.06056169729784 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6826_1984_842886_52743">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2304486264 5438353.766094057 112.67734802820426 458879.26887243194 5438353.788278052
														112.66831107053583 458879.14218336646 5438353.738228097 112.67734802820426 458879.2304486264
														5438353.766094057 112.67734802820426 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6827_1504_59056_329255">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.17369088705 5438353.756418972 112.66831107053583 458879.14218336646
														5438353.738228097 112.67734802820426 458879.26887243194 5438353.788278052 112.66831107053583
														458879.17369088705 5438353.756418972 112.66831107053583 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6828_1407_531426_399561">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.26887243194 5438353.788278052 112.66831107053583 458879.3068055218 5438353.810178732
														112.65683823394569 458879.17369088705 5438353.756418972 112.66831107053583 458879.26887243194
														5438353.788278052 112.66831107053583 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6829_1567_539196_128622">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2047960207 5438353.7743775295 112.65683823394569 458879.17369088705
														5438353.756418972 112.66831107053583 458879.3068055218 5438353.810178732 112.65683823394569
														458879.2047960207 5438353.7743775295 112.65683823394569 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6830_851_250317_158141">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80624937726 5438353.521182506 112.85423943387363 458878.79433998215
														5438353.537400625 112.85423943387363 458878.80493916274 5438353.520426054 112.88555651117548
														458878.80624937726 5438353.521182506 112.85423943387363 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6831_1419_718318_281534">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7932656063 5438353.536780334 112.88555651117548 458878.80493916274 5438353.520426054
														112.88555651117548 458878.79433998215 5438353.537400625 112.85423943387363 458878.7932656063
														5438353.536780334 112.88555651117548 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6832_1309_750725_176996">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8078477221 5438353.522105311 112.80257030180908 458878.79565062496 5438353.538157325
														112.80257030180908 458878.80624937726 5438353.521182506 112.85423943387363 458878.8078477221
														5438353.522105311 112.80257030180908 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6833_329_340518_285327">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79433998215 5438353.537400625 112.85423943387363 458878.80624937726
														5438353.521182506 112.85423943387363 458878.79565062496 5438353.538157325 112.80257030180908
														458878.79433998215 5438353.537400625 112.85423943387363 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6834_1233_797466_210550">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80888361577 5438353.522703385 112.7508820563776 458878.79650005773 5438353.538647745
														112.7508820563776 458878.8078477221 5438353.522105311 112.80257030180908 458878.80888361577
														5438353.522703385 112.7508820563776 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6835_1105_227214_140631">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79565062496 5438353.538157325 112.80257030180908 458878.8078477221 5438353.522105311
														112.80257030180908 458878.79650005773 5438353.538647745 112.7508820563776 458878.79565062496
														5438353.538157325 112.80257030180908 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6836_1928_331963_75528">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80935689463 5438353.522976632 112.69918286077291 458878.79688814643
														5438353.538871808 112.69918286077291 458878.80888361577 5438353.522703385 112.7508820563776
														458878.80935689463 5438353.522976632 112.69918286077291 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6837_1128_86156_321205">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79650005773 5438353.538647745 112.7508820563776 458878.80888361577 5438353.522703385
														112.7508820563776 458878.79688814643 5438353.538871808 112.69918286077291 458878.79650005773
														5438353.538647745 112.7508820563776 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6838_1125_9216_162360">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.81237624283 5438353.524719854 112.69101587129732 458878.7993640119 5438353.54030125
														112.69101587129732 458878.80935689463 5438353.522976632 112.69918286077291 458878.81237624283
														5438353.524719854 112.69101587129732 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6839_1799_114889_134960">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79688814643 5438353.538871808 112.69918286077291 458878.80935689463
														5438353.522976632 112.69918286077291 458878.7993640119 5438353.54030125 112.69101587129732
														458878.79688814643 5438353.538871808 112.69918286077291 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6840_609_553818_204145">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.15149388735 5438353.720509517 112.66773100680198 458879.07744048046
														5438353.700848774 112.66773100680198 458879.1895782868 5438353.742497556 112.66374238327081
														458879.15149388735 5438353.720509517 112.66773100680198 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6841_117_477194_136824">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.108669688 5438353.718878965 112.66374238327081 458879.1895782868 5438353.742497556
														112.66374238327081 458879.07744048046 5438353.700848774 112.66773100680198 458879.108669688
														5438353.718878965 112.66374238327081 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6842_189_558316_107858">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9989958326 5438353.632464725 112.65933417703286 458878.95239207556 5438353.628652044
														112.65933417703286 458879.0369113503 5438353.654355259 112.66508069223536 458878.9989958326
														5438353.632464725 112.65933417703286 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6843_144_798518_55946">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.98348280013 5438353.646602281 112.66508069223536 458879.0369113503 5438353.654355259
														112.66508069223536 458878.95239207556 5438353.628652044 112.65933417703286 458878.98348280013
														5438353.646602281 112.66508069223536 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6844_339_172312_385238">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9614129216 5438353.610766221 112.65117916904981 458878.9215740885 5438353.61085927
														112.65117916904981 458878.9989958326 5438353.632464725 112.65933417703286 458878.9614129216
														5438353.610766221 112.65117916904981 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6845_531_139401_250704">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95239207556 5438353.628652044 112.65933417703286 458878.9989958326 5438353.632464725
														112.65933417703286 458878.9215740885 5438353.61085927 112.65117916904981 458878.95239207556
														5438353.628652044 112.65933417703286 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6846_1274_674241_148520">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.92427727294 5438353.589325944 112.64064054707083 458878.89112285664
														5438353.593278243 112.64064054707083 458878.9614129216 5438353.610766221 112.65117916904981
														458878.92427727294 5438353.589325944 112.64064054707083 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6847_1202_743090_139302">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9215740885 5438353.61085927 112.65117916904981 458878.9614129216 5438353.610766221
														112.65117916904981 458878.89112285664 5438353.593278243 112.64064054707083 458878.9215740885
														5438353.61085927 112.65117916904981 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6848_1166_54894_6131">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.88210208085 5438353.564976085 112.64701476742715 458878.91960684774
														5438353.586629473 112.66023249513065 458878.8565391991 5438353.57331136 112.64701476742715
														458878.88210208085 5438353.564976085 112.64701476742715 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6849_1424_64593_310918">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.887293108 5438353.591067137 112.66023249513065 458878.8565391991 5438353.57331136
														112.64701476742715 458878.91960684774 5438353.586629473 112.66023249513065 458878.887293108
														5438353.591067137 112.66023249513065 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6850_334_320026_297657">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0461025207 5438353.682755794 112.66928552103333 458879.1132768633 5438353.6984449085
														112.66928552103333 458879.0147514126 5438353.6646552235 112.66840118355077 458879.0461025207
														5438353.682755794 112.66928552103333 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6851_1679_895441_11050">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1895782868 5438353.742497556 112.66374238327081 458879.108669688 5438353.718878965
														112.66374238327081 458879.227413876 5438353.764341943 112.65733181868121 458879.1895782868
														5438353.742497556 112.66374238327081 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6852_1956_657458_341328">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.13969487114 5438353.736791363 112.65733181868121 458879.227413876 5438353.764341943
														112.65733181868121 458879.108669688 5438353.718878965 112.66374238327081 458879.13969487114
														5438353.736791363 112.65733181868121 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6853_70_523107_156039">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.91960684774 5438353.586629473 112.66023249513065 458878.9576864164 5438353.608614722
														112.67103898952138 458878.887293108 5438353.591067137 112.66023249513065 458878.91960684774
														5438353.586629473 112.66023249513065 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6854_609_513309_22665">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.91851835424 5438353.609095042 112.67103898952138 458878.887293108 5438353.591067137
														112.66023249513065 458878.9576864164 5438353.608614722 112.67103898952138 458878.91851835424
														5438353.609095042 112.67103898952138 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6855_1296_481323_365268">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79658170434 5438353.515600873 112.68200099031416 458878.7864124904 5438353.532823686
														112.68200099031416 458878.8013310896 5438353.518342932 112.6723032167059 458878.79658170434
														5438353.515600873 112.68200099031416 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6856_1307_441461_176362">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7903069863 5438353.535072174 112.6723032167059 458878.8013310896 5438353.518342932
														112.6723032167059 458878.7864124904 5438353.532823686 112.68200099031416 458878.7903069863
														5438353.535072174 112.6723032167059 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6857_936_355489_360202">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7916034101 5438353.512726653 112.8020182832574 458878.7823302891 5438353.530466826
														112.8020182832574 458878.7926345788 5438353.513321999 112.75056580133051 458878.7916034101
														5438353.512726653 112.8020182832574 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6858_1428_619296_415946">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7831758474 5438353.530955009 112.75056580133051 458878.7926345788 5438353.513321999
														112.75056580133051 458878.7823302891 5438353.530466826 112.8020182832574 458878.7831758474
														5438353.530955009 112.75056580133051 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6859_1527_728018_40038">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7818828329 5438353.507114476 113.00755674228215 458878.7743594158 5438353.52586484
														113.00755674228215 458878.78515168326 5438353.509001748 112.9562290843926 458878.7818828329
														5438353.507114476 113.00755674228215 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6860_1129_299188_248414">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7770398731 5438353.527412402 112.9562290843926 458878.78515168326 5438353.509001748
														112.9562290843926 458878.7743594158 5438353.52586484 113.00755674228215 458878.7770398731
														5438353.527412402 112.9562290843926 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6861_1720_796619_108552">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.77805563196 5438353.50490484 113.05883291302227 458878.77122111106 5438353.524052938
														113.05883291302227 458878.7818828329 5438353.507114476 113.00755674228215 458878.77805563196
														5438353.50490484 113.05883291302227 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6862_912_523027_124158">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7743594158 5438353.52586484 113.00755674228215 458878.7818828329 5438353.507114476
														113.00755674228215 458878.77122111106 5438353.524052938 113.05883291302227 458878.7743594158
														5438353.52586484 113.00755674228215 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6863_1752_748833_349735">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.77122111106 5438353.524052938 113.05883291302227 458878.77805563196 5438353.50490484
														113.05883291302227 458878.76762545446 5438353.521976985 113.11004949849838 458878.77122111106
														5438353.524052938 113.05883291302227 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6864_422_850369_59554">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79001235566 5438353.511808058 112.85345173899839 458878.7810256245 5438353.529713577
														112.85345173899839 458878.7916034101 5438353.512726653 112.8020182832574 458878.79001235566
														5438353.511808058 112.85345173899839 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6865_1689_751956_400417">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7823302891 5438353.530466826 112.8020182832574 458878.7916034101 5438353.512726653
														112.8020182832574 458878.7810256245 5438353.529713577 112.85345173899839 458878.7823302891
														5438353.530466826 112.8020182832574 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6866_367_110142_69976">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7878616669 5438353.5105663575 112.9048580455989 458878.77926205966 5438353.528695382
														112.9048580455989 458878.79001235566 5438353.511808058 112.85345173899839 458878.7878616669
														5438353.5105663575 112.9048580455989 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6867_694_574821_422966">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7732632958 5438353.502137983 113.2659264170921 458878.77934471314 5438353.505649092
														113.21470343428207 458878.7672913954 5438353.5217841165 113.2659264170921 458878.7732632958
														5438353.502137983 113.2659264170921 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6868_580_614354_66217">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7722781576 5438353.524663225 113.21470343428207 458878.7672913954 5438353.5217841165
														113.2659264170921 458878.77934471314 5438353.505649092 113.21470343428207 458878.7722781576
														5438353.524663225 113.21470343428207 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6869_1127_320337_1187">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.07744048046 5438353.700848774 112.66773100680198 458879.0461025207 5438353.682755794
														112.66928552103333 458879.0147514126 5438353.6646552235 112.66840118355077 458878.98348280013
														5438353.646602281 112.66508069223536 458878.95239207556 5438353.628652044 112.65933417703286
														458878.9215740885 5438353.61085927 112.65117916904981 458878.89112285664 5438353.593278243
														112.64064054707083 458878.85908353026 5438353.57478033 112.62687035956935 458878.8502459453
														5438353.569677948 112.62617515854582 458878.8423463841 5438353.565117134 112.6267919299992
														458878.8345442093 5438353.560612546 112.62863925282609 458878.8269357874 5438353.556219822
														112.63169431032692 458878.8196150916 5438353.551993216 112.63591936879966 458878.81267254153
														5438353.547984933 112.6412622435972 458878.80619388615 5438353.544244479 112.64765694367168
														458878.80025914486 5438353.540818055 112.6550244866448 458878.7949416189 5438353.53774798
														112.66327387433691 458878.7903069863 5438353.535072174 112.6723032167059 458878.7864124904
														5438353.532823686 112.68200099031416 458878.78362142894 5438353.531212266 112.69120769778465
														458878.78356305096 5438353.531178561 112.6989845124514 458878.7831758474 5438353.530955009
														112.75056580133051 458878.7823302891 5438353.530466826 112.8020182832574 458878.7810256245
														5438353.529713577 112.85345173899839 458878.77926205966 5438353.528695382 112.9048580455989
														458878.7770398731 5438353.527412402 112.9562290843926 458878.7743594158 5438353.52586484
														113.00755674228215 458878.77122111106 5438353.524052938 113.05883291302227 458878.76762545446
														5438353.521976985 113.11004949849838 458878.763573014 5438353.519637307 113.16119841000717
														458878.7590644296 5438353.517034275 113.21227156953222 458878.75409067393 5438353.514162676
														113.2633609518305 458878.74998539575 5438353.511792492 113.29851411223173 458878.7410168669
														5438353.50661451 113.32860878698193 458878.7279275872 5438353.499057411 113.35315394047863
														458878.7121369501 5438353.489940682 113.37049980102183 458878.69517131 5438353.480145565
														113.38003438537927 458878.67798307375 5438353.470221933 113.38205647234814 458878.6608015689
														5438353.460302186 113.37674618126793 458878.6441232104 5438353.450672931 113.36371704994695
														458878.62925225083 5438353.442087179 113.34300221744502 458878.61774389335 5438353.435442826
														113.3157177559892 458878.6108370665 5438353.431455167 113.28386196485128 458878.6092501745
														5438353.430538975 113.24992680721377 458878.6109428673 5438353.4315162515 113.23585825253516
														458878.61470288195 5438353.433687096 113.2234036070236 458878.61994526756 5438353.43671379
														113.21366067864275 458878.6258105155 5438353.4401000915 113.20726925781885 458878.6314719458
														5438353.44336872 113.20411990277544 458878.63674096844 5438353.446410792 113.20352465552673
														458878.6421568256 5438353.449537639 113.20522541566303 458878.6479903937 5438353.45290565
														113.20982204678101 458878.653681615 5438353.456191479 113.21781472137594 458878.65832563303
														5438353.458872704 113.22893792936362 458878.6611733724 5438353.460516847 113.24229933027396
														458878.6618723512 5438353.460920403 113.25844826381512 458878.6622538533 5438353.461140662
														113.26085765628401 458878.66316240653 5438353.461665216 113.26307093555483 458878.6645360946
														5438353.462458315 113.26493727030286 458878.66628130286 5438353.463465912 113.26632947289931
														458878.66827909823 5438353.464619339 113.26715266703797 458878.67039333435 5438353.465839994
														113.26735075339864 458878.6724799294 5438353.467044691 113.26691023272323 458878.6743966855
														5438353.46815133 113.26586112576775 458878.67601297883 5438353.469084498 113.2642749274375
														458878.67721866164 5438353.469780599 113.26225973452737 458878.67793156864 5438353.470192196
														113.25995287910392 458878.67810311645 5438353.470291239 113.257511569552 458878.6773262801
														5438353.469842733 113.2395638435135 458878.67370062106 5438353.467749457 113.22255249636768
														458878.6674732221 5438353.4641540665 113.20763682330994 458878.6590684701 5438353.459301581
														113.19583330280984 458878.6490591351 5438353.453522689 113.18794632528323 458878.6381273367
														5438353.447211212 113.1845133752147 458878.6270180588 5438353.4407972675 113.18576840247822
														458878.6164883805 5438353.434717955 113.19162587903977 458878.6072558818 5438353.429387569
														113.20168662755166 458878.5999497424 5438353.425169367 113.21526502462896 458878.5950678635
														5438353.422350814 113.23143572495021 458878.59294293716 5438353.421123987 113.24909672201187
														458878.5945955435 5438353.42207812 113.2858313305717 458878.6020763072 5438353.42639714
														113.32063599421863 458878.6148754264 5438353.433786715 113.35113883264259 458878.63212066236
														5438353.443743257 113.3752611278133 458878.65263678075 5438353.455588244 113.39135898517884
														458878.67502564203 5438353.468514458 113.39833536236271 458878.69776148226 5438353.481641002
														113.39571483078887 458878.7192948915 5438353.494073322 113.38367597535342 458878.7381584035
														5438353.504964176 113.36303922415914 458878.7530665011 5438353.513571369 113.33521093769607
														458878.7630032221 5438353.519308338 113.30208756769826 458878.7672913954 5438353.5217841165
														113.2659264170921 458878.7722781576 5438353.524663225 113.21470343428207 458878.77680740103
														5438353.527278185 113.16339624936839 458878.78087841044 5438353.529628583 113.1120129653634
														458878.7844905429 5438353.531714048 113.06056169729784 458878.78764322784 5438353.533534252
														113.00905057093928 458878.79033596743 5438353.535088906 112.95748772150878 458878.7925683364
														5438353.536377764 112.90588129239611 458878.850008653 5438353.569540947 112.90636409122618
														458878.9072936978 5438353.602614483 112.9014666865107 458878.96404613746 5438353.63538052
														112.89122133718541 458879.0198921467 5438353.667623227 112.8756955288033 458879.07446387095
														5438353.699130228 112.854991529011 458879.12740184925 5438353.729693984 112.82924571391739
														458879.178357382 5438353.759113174 112.79862766979167 458879.22699482803 5438353.787194016
														112.76333907600796 458879.2729938151 5438353.813751544 112.72361237659429 458879.3160513503
														5438353.838610824 112.6797092491366 458879.35588381614 5438353.8616081085 112.63191888112283
														458879.39222883834 5438353.882591917 112.58055606508087 458879.412301107 5438353.894180647
														112.54155941268473 458879.4247246739 5438353.9013533965 112.49852291455119 458879.42893011396
														5438353.903781408 112.45341911697284 458879.4247246739 5438353.9013533965 112.4083153193945
														458879.412301107 5438353.894180647 112.36527882126094 458879.39222883834 5438353.882591917
														112.32628216886482 458879.3654278656 5438353.867118368 112.2931127451356 458879.3331265917
														5438353.848469219 112.26729084625546 458879.29680552176 5438353.82749924 112.25 458879.2473302722
														5438353.798934691 112.23479358365047 458879.1972877 5438353.770042598 112.22230531678953
														458879.1467897394 5438353.740887587 112.21256313292353 458879.0959493431 5438353.711534871
														112.20558882317517 458879.04488023 5438353.682050104 112.20139798754145 458878.99369663046
														5438353.65249924 112.2 458878.9425130309 5438353.622948375 112.20139798754145 458878.8914439178
														5438353.593463608 112.20558882317517 458878.8406035215 5438353.564110892 112.21256313292353
														458878.79010556085 5438353.534955881 112.22230531678953 458878.74006298865 5438353.506063788
														112.23479358365047 458878.6905877391 5438353.477499239 112.25 458878.65309772413 5438353.455854369
														112.27392046072138 458878.6219991791 5438353.437899616 112.30793071507477 458878.5992787956
														5438353.424781997 112.34985806059518 458878.5863880368 5438353.417339513 112.3970240213731
														458878.5841504127 5438353.416047621 112.44641545913025 458878.59270887106 5438353.420988848
														112.49487706378141 458878.6115166656 5438353.431847534 112.53931292646365 458878.6393722839
														5438353.447929983 112.5768843177932 458878.67449620465 5438353.468208788 112.6051910365335
														458878.71464458026 5438353.491388463 112.62242474344242 458878.75725258205 5438353.515988205
														112.62748448475781 458878.7995982513 5438353.540436488 112.62004702524851 458878.8339607504
														5438353.560275686 112.60806182843826 458878.86882771703 5438353.580406139 112.59820893119143
														458878.9040999902 5438353.6007705955 112.59051635497017 458878.93967725616 5438353.621311139
														112.58500597732258 458878.97545833385 5438353.641969354 112.58169346966336 458879.0113414625
														5438353.662686488 112.58058825270458 458879.0472245912 5438353.683403622 112.58169346966336
														458879.0830056689 5438353.704061837 112.58500597732258 458879.11858293484 5438353.724602381
														112.59051635497017 458879.153855208 5438353.744966838 112.59820893119143 458879.1887221747
														5438353.76509729 112.60806182843826 458879.22308467375 5438353.784936488 112.62004702524851
														458879.255581944 5438353.803698796 112.61780484615838 458879.28646932594 5438353.821531634
														112.60592698232807 458879.3136418955 5438353.837219724 112.58522289054853 458879.335247887
														5438353.849693949 112.55710352045942 458879.3498148878 5438353.858104211 112.52348516066281
														458879.35635018086 5438353.861877364 112.48665884682194 458879.3544083968 5438353.860756275
														112.44913423136664 458879.344121865 5438353.854817343 112.41346855482787 458879.3261915956
														5438353.844465297 112.38209237412141 458879.3018395067 5438353.8304056125 112.35714392411081
														458879.27272515313 5438353.813596432 112.34032340043507 458879.2408326298 5438353.795183275
														112.33277709398541 458879.22458399465 5438353.785802121 112.33389818353048 458879.2091403037
														5438353.776885702 112.33983711544563 458879.19555401895 5438353.769041657 112.3501891613354
														458879.1847510232 5438353.7628045445 112.36424884637995 458879.1774675228 5438353.758599414
														112.38105802627825 458879.1741998762 5438353.756712837 112.3994711831987 458879.1751707682
														5438353.757273382 112.41823349092634 458879.18031403416 5438353.760242848 112.43606632919572
														458879.1892791689 5438353.76541887 112.45175441954896 458879.2014552133 5438353.772448713
														112.46422864455425 458879.2160123901 5438353.780853303 112.47263890639213 458879.2319586518
														5438353.790059881 112.47641205961696 458879.23424897936 5438353.791382203 112.47660072599738
														458879.2365035544 5438353.792683883 112.47609847987682 458879.2385687312 5438353.793876213
														112.47493954849838 458879.24030377145 5438353.794877939 112.47320291112028 458879.24159043503
														5438353.795620794 112.4710069167099 458879.24234103795 5438353.796054155 112.46850121865726
														458879.24250442785 5438353.796148488 112.46585657614379 458879.24206946994 5438353.795897366
														112.4632532171863 458879.2410658059 5438353.795317899 112.4608685563955 458879.23956183384
														5438353.794449581 112.45886510446343 458879.2376600469 5438353.793351583 112.4573793933284
														458879.2354900487 5438353.7920987345 112.45651267174902 458879.221812604 5438353.784202058
														112.45327635869674 458879.211397786 5438353.77818906 112.44725930283128 458879.20268653053
														5438353.773159615 112.43833471639368 458879.1962724952 5438353.769456469 112.42711079520106
														458879.1925927859 5438353.767331989 112.41435243093428 458879.1918981689 5438353.766930951
														112.40092908503396 458879.194235981 5438353.768280688 112.38775553634008 458879.1994469042
														5438353.771289215 112.37572954042576 458879.20717582275 5438353.775751509 112.36567064903873
														458879.21689602366 5438353.78136347 112.35826435900387 458879.2279450912 5438353.787742651
														112.35401539674758 458879.23957004974 5438353.794454324 112.35321332202591 458879.26692493923
														5438353.810247677 112.35968594813045 458879.29189693403 5438353.824665265 112.37411326583378
														458879.31278423394 5438353.836724553 112.39551207727669 458879.32816340396 5438353.845603721
														112.42242408882254 458879.3369863791 5438353.850697668 112.4530152913587 458879.33865188824
														5438353.85165925 112.48520094498666 458879.3330464296 5438353.848422937 112.516787650601
														458879.32055200595 5438353.841209278 112.54562282641359 458879.3020200916 5438353.830509873
														112.56974140284521 458879.27871360594 5438353.817053867 112.58749973876983 458879.25222084747
														5438353.801758266 112.59768763294127 458879.2251676043 5438353.786139068 112.59955419636942
														458879.1933596516 5438353.767774738 112.58845999243736 458879.157581116 5438353.747117992
														112.5783494990651 458879.12138667743 5438353.726221123 112.57045580658537 458879.08487927226
														5438353.7051435625 112.56480136451732 458879.0481627269 5438353.683945255 112.56140225399224
														458879.0113414625 5438353.662686488 112.56026814201922 458878.9745201981 5438353.641427721
														112.56140225399224 458878.9378036528 5438353.620229414 112.56480136451732 458878.9012962476
														5438353.5991518535 112.57045580658537 458878.86510180903 5438353.578254985 112.5783494990651
														458878.8293232734 5438353.557598238 112.58845999243736 458878.79571258334 5438353.538193096
														112.60018296794496 458878.75682286796 5438353.515740109 112.60701343464558 458878.718673573
														5438353.493714604 112.60248316906705 458878.6827265171 5438353.472960561 112.58705288037572
														458878.6512781328 5438353.454803827 112.5617083132216 458878.62633746076 5438353.440404324
														112.52806857350605 458878.60949780454 5438353.430681944 112.48828269383085 458878.6018349445
														5438353.42625779 112.44489234524451 458878.60383841284 5438353.427414493 112.4006694657734
														458878.61538022046 5438353.434078158 112.35843917863587 458878.63572303345 5438353.445823086
														112.3208993127869 458878.66356727673 5438353.461898969 112.29044805549721 458878.6972026764
														5438353.481318375 112.26898702763418 458878.74418576643 5438353.508444075 112.25454658649173
														458878.793414904 5438353.536866531 112.24226131458495 458878.84309202764 5438353.565547631
														112.23267748849504 458878.8931060207 5438353.594423224 112.22581654513318 458878.94334501284
														5438353.623428719 112.22169383092071 458878.99369663046 5438353.65249924 112.22031856746258
														458879.04404824803 5438353.68156976 112.22169383092071 458879.0942872402 5438353.710575255
														112.22581654513318 458879.14430123323 5438353.739450848 112.23267748849505 458879.1939783569
														5438353.768131948 112.24226131458495 458879.24320749443 5438353.796554404 112.25454658649173
														458879.29116642673 5438353.824243506 112.26928695666026 458879.32467054465 5438353.843587118
														112.28523677734867 458879.3538574264 5438353.860438172 112.30856900598037 458879.3780743295
														5438353.874419807 112.338540333094 458879.3962112901 5438353.884891187 112.37377704491759
														458879.4074370138 5438353.891372361 112.41266409263708 458879.4112369779 5438353.893566271
														112.45341911697284 458879.4074370138 5438353.891372361 112.4941741413086 458879.3962112901
														5438353.884891187 112.53306118902809 458879.3780743295 5438353.874419807 112.56829790085169
														458879.3239652911 5438353.843179939 112.6058401801274 458879.26417567516 5438353.808660389
														112.62922270676458 458879.20019855705 5438353.771723182 112.63753583780847 458879.17042138025
														5438353.754531321 112.6485188699798 458879.13969487114 5438353.736791363 112.65733181868121
														458879.108669688 5438353.718878965 112.66374238327081 458879.07744048046 5438353.700848774
														112.66773100680198 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458878.98200067156 5438353.645746575 112.68529386388984 458879.0140640748 5438353.664258389
														112.68869875599489 458879.04621207044 5438353.682819043 112.68960557171176 458879.0783465836
														5438353.701371913 112.68801154458424 458879.11036958015 5438353.719860398 112.68392153756981
														458879.14218336646 5438353.738228097 112.67734802820426 458879.17369088705 5438353.756418972
														112.66831107053583 458879.2047960207 5438353.7743775295 112.65683823394569 458879.31998436525
														5438353.840881551 112.64580381727026 458879.3040290111 5438353.831669723 112.66494262081224
														458879.26201335 5438353.80741197 112.70777399228336 458879.2171280738 5438353.781497443
														112.74653002483012 458879.1696688393 5438353.754096841 112.78095543459591 458879.119948258
														5438353.72539065 112.81082346329837 458879.06829383643 5438353.695567956 112.83593737187378
														458879.01504581963 5438353.664825199 112.85613173638644 458878.96055494924 5438353.63336488
														112.87127353766703 458878.90518015367 5438353.601394228 112.88126303750263 458878.84928618365
														5438353.569123829 112.88603443560677 458878.7967391636 5438353.538785793 112.88558614489173
														458878.7932656063 5438353.536780334 112.88555651117548 458878.79433998215 5438353.537400625
														112.85423943387363 458878.79565062496 5438353.538157325 112.80257030180908 458878.79650005773
														5438353.538647745 112.7508820563776 458878.79688814643 5438353.538871808 112.69918286077291
														458878.7993640119 5438353.54030125 112.69101587129732 458878.8024681488 5438353.542093424
														112.68328618885707 458878.80616221716 5438353.544226196 112.67608928449776 458878.81040059065
														5438353.5466732215 112.66951404880323 458878.81513092026 5438353.549404278 112.66364169398781
														458878.8202947806 5438353.552385635 112.6585447508261 458878.8258283917 5438353.555580467
														112.654286172809 458878.8316634066 5438353.558949314 112.65091855859103 458878.8377277558
														5438353.562450567 112.64848350233254 458878.8439465371 5438353.5660409825 112.64701107996083
														458878.850242941 5438353.569676213 112.64651947769566 458878.8565391991 5438353.57331136
														112.64701476742715 458878.887293108 5438353.591067137 112.66023249513065 458878.91851835424
														5438353.609095042 112.67103898952138 458878.95011967793 5438353.627340075 112.67940128282697
														458878.98200067156 5438353.645746575 112.68529386388984 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6870_1409_658490_387801">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.87442371726 5438353.56054298 112.64651947769566 458878.88210208085 5438353.564976085
														112.64701476742715 458878.850242941 5438353.569676213 112.64651947769566 458878.87442371726
														5438353.56054298 112.64651947769566 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6871_999_802622_426170">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8565391991 5438353.57331136 112.64701476742715 458878.850242941 5438353.569676213
														112.64651947769566 458878.88210208085 5438353.564976085 112.64701476742715 458878.8565391991
														5438353.57331136 112.64701476742715 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6872_1076_572822_53819">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.227413876 5438353.764341943 112.65733181868121 458879.13969487114 5438353.736791363
														112.65733181868121 458879.2648852286 5438353.785976039 112.6485188699798 458879.227413876
														5438353.764341943 112.65733181868121 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6873_739_222429_416722">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.17042138025 5438353.754531321 112.6485188699798 458879.2648852286 5438353.785976039
														112.6485188699798 458879.13969487114 5438353.736791363 112.65733181868121 458879.17042138025
														5438353.754531321 112.6485188699798 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6874_574_359203_99692">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7810256245 5438353.529713577 112.85345173899839 458878.79001235566 5438353.511808058
														112.85345173899839 458878.77926205966 5438353.528695382 112.9048580455989 458878.7810256245
														5438353.529713577 112.85345173899839 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6875_1564_374842_372258">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78515168326 5438353.509001748 112.9562290843926 458878.7770398731 5438353.527412402
														112.9562290843926 458878.7878616669 5438353.5105663575 112.9048580455989 458878.78515168326
														5438353.509001748 112.9562290843926 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6876_1388_21709_277671">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.77926205966 5438353.528695382 112.9048580455989 458878.7878616669 5438353.5105663575
														112.9048580455989 458878.7770398731 5438353.527412402 112.9562290843926 458878.77926205966
														5438353.528695382 112.9048580455989 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6877_794_751769_45894">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8134678683 5438353.525350104 112.6550244866448 458878.80025914486 5438353.540818055
														112.6550244866448 458878.82070535776 5438353.529528671 112.64765694367168 458878.8134678683
														5438353.525350104 112.6550244866448 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6878_650_92277_387808">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80619388615 5438353.544244479 112.64765694367168 458878.82070535776
														5438353.529528671 112.64765694367168 458878.80025914486 5438353.540818055 112.6550244866448
														458878.80619388615 5438353.544244479 112.64765694367168 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6879_1412_120687_331739">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8069830806 5438353.52160611 112.66327387433691 458878.7949416189 5438353.53774798
														112.66327387433691 458878.8134678683 5438353.525350104 112.6550244866448 458878.8069830806
														5438353.52160611 112.66327387433691 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6880_1152_764463_38521">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.80025914486 5438353.540818055 112.6550244866448 458878.8134678683 5438353.525350104
														112.6550244866448 458878.7949416189 5438353.53774798 112.66327387433691 458878.80025914486
														5438353.540818055 112.6550244866448 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6881_1799_172251_331905">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8013310896 5438353.518342932 112.6723032167059 458878.7903069863 5438353.535072174
														112.6723032167059 458878.8069830806 5438353.52160611 112.66327387433691 458878.8013310896
														5438353.518342932 112.6723032167059 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6882_1121_191043_423117">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7949416189 5438353.53774798 112.66327387433691 458878.8069830806 5438353.52160611
														112.66327387433691 458878.7903069863 5438353.535072174 112.6723032167059 458878.7949416189
														5438353.53774798 112.66327387433691 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6883_550_294584_21979">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.2648852286 5438353.785976039 112.6485188699798 458879.17042138025 5438353.754531321
														112.6485188699798 458879.3011988588 5438353.806941723 112.63753583780847 458879.2648852286
														5438353.785976039 112.6485188699798 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6884_1304_646490_200799">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.20019855705 5438353.771723182 112.63753583780847 458879.3011988588 5438353.806941723
														112.63753583780847 458879.17042138025 5438353.754531321 112.6485188699798 458879.20019855705
														5438353.771723182 112.63753583780847 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6885_1857_529781_16710">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.37718960666 5438353.873909012 113.18332709292629 458878.3882988845 5438353.880322957
														113.18207206566278 458878.3982988845 5438353.863002449 113.18207206566278 458878.3871896066
														5438353.856588504 113.18332709292629 458878.37718960666 5438353.873909012 113.18332709292629
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6886_1502_603863_118211">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.38164349366 5438353.876480466 113.2016785932235 458878.3759820633 5438353.873211837
														113.20482794826692 458878.3859820633 5438353.855891329 113.20482794826692 458878.3916434936
														5438353.859159958 113.2016785932235 458878.38164349366 5438353.876480466 113.2016785932235
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6887_37_120952_106539">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.50733640283 5438353.92595529 113.26091964227858 458878.50330998713 5438353.923630637
														113.29438457407855 458878.50426222174 5438353.947274421 113.26091964227858 458878.50733640283
														5438353.92595529 113.26091964227858 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6888_1572_731248_371767">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3494503434 5438353.857893742 112.34741675104325 458878.37217072694 5438353.871011361
														112.30548940552285 458878.3821707269 5438353.853690852 112.30548940552285 458878.3594503434
														5438353.840573234 112.34741675104325 458878.3494503434 5438353.857893742 112.34741675104325
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6889_1683_309980_188601">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.35742742964 5438353.862499314 113.19924531799974 458878.3666599283 5438353.8678297
														113.18918456948785 458878.3766599283 5438353.850509192 113.18918456948785 458878.36742742965
														5438353.845178806 113.19924531799974 458878.35742742964 5438353.862499314 113.19924531799974
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6890_1451_701803_219738">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5337345988 5438353.964290306 112.69654320289947 458878.54327832604 5438353.946706369
														112.69654320289947 458878.53334739524 5438353.964066754 112.74812449177858 458878.5337345988
														5438353.964290306 112.69654320289947 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6891_1093_452386_152486">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3610086143 5438353.864566912 113.28142065529935 458878.3708210654 5438353.847138123
														113.27981537777646 458878.3594217223 5438353.86365072 113.24748549766184 458878.3610086143
														5438353.864566912 113.28142065529935 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6892_160_878995_120290">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5428061266 5438353.946433744 112.74812449177858 458878.53334739524 5438353.964066754
														112.74812449177858 458878.54327832604 5438353.946706369 112.69654320289947 458878.5428061266
														5438353.946433744 112.74812449177858 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6893_1479_607394_343869">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61527335684 5438354.01136673 112.57590818951317 458878.6514677954 5438354.032263598
														112.56801449703344 458878.66146779543 5438354.01494309 112.56801449703344 458878.62527335685
														5438353.9940462215 112.57590818951317 458878.61527335684 5438354.01136673 112.57590818951317
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6894_525_501623_259990">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4014496806 5438353.887915573 112.55926700366967 458878.4328980649 5438353.9060723055
														112.5846115708238 458878.44289806485 5438353.888751797 112.5846115708238 458878.4114496806
														5438353.870595065 112.55926700366967 458878.4014496806 5438353.887915573 112.55926700366967
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6895_538_576028_174428">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.83552738343 5438354.11543644 112.85233826659224 458878.88833364565 5438354.14592415
														112.82658627449457 458878.8246354188 5438354.132241973 112.85255021945907 458878.83552738343
														5438354.11543644 112.85233826659224 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6896_777_544516_255210">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.41845064604 5438353.897731084 113.26471135748603 458878.4164528507 5438353.896577657
														113.2638881633474 458878.4264528507 5438353.879257149 113.2638881633474 458878.42845064605
														5438353.880410576 113.26471135748603 458878.41845064604 5438353.897731084 113.26471135748603
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6897_942_850532_146630">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99047531926 5438354.227989684 112.47076160156834 458878.988740279 5438354.226987958
														112.47249823894646 458878.998740279 5438354.20966745 112.47249823894646 458879.0004753193
														5438354.210669176 112.47076160156834 458878.99047531926 5438354.227989684 112.47076160156834
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6898_828_260889_90816">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3666599283 5438353.8678297 113.18918456948785 458878.37718960666 5438353.873909012
														113.18332709292629 458878.3871896066 5438353.856588504 113.18332709292629 458878.3766599283
														5438353.850509192 113.18918456948785 458878.3666599283 5438353.8678297 113.18918456948785
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6899_969_201296_237839">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.36487442976 5438353.866798841 113.22096229747167 458878.3611144151 5438353.864627996
														113.23341694298324 458878.3711144151 5438353.847307488 113.23341694298324 458878.3748744298
														5438353.849478334 113.22096229747167 458878.36487442976 5438353.866798841 113.22096229747167
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6900_1313_705633_208604">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0701559131 5438354.273993296 112.64336250771833 458879.0801559131 5438354.256672788
														112.64336250771833 458879.0542005589 5438354.264781468 112.66250131126031 458879.0701559131
														5438354.273993296 112.64336250771833 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6901_1495_563919_305719">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3596693524 5438353.863793689 112.48584138427893 458878.3765090086 5438353.873516069
														112.52562726395412 458878.3865090086 5438353.856195561 112.52562726395412 458878.36966935236
														5438353.846473181 112.48584138427893 458878.3596693524 5438353.863793689 112.48584138427893
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6902_1007_888359_364569">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39923068293 5438353.886634434 113.18550501573131 458878.40924001793
														5438353.892413327 113.1933919932579 458878.41924001794 5438353.875092818 113.1933919932579
														458878.40923068294 5438353.8693139255 113.18550501573131 458878.39923068293 5438353.886634434
														113.18550501573131 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6903_1545_749144_163555">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5074241299 5438353.94909995 112.62504317520589 458878.4648161281 5438353.924500208
														112.6199834338905 458878.4748161281 5438353.9071797 112.6199834338905 458878.5174241299
														5438353.931779441 112.62504317520589 458878.5074241299 5438353.94909995 112.62504317520589
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6904_614_896909_387691">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.90402675583 5438354.1780785825 112.59576762163951 458878.86875448265
														5438354.157714126 112.58807504541825 458878.87875448266 5438354.140393618 112.58807504541825
														458878.91402675584 5438354.160758074 112.59576762163951 458878.90402675583 5438354.1780785825
														112.59576762163951 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6905_1678_171390_355130">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6432775685 5438354.027534969 112.22337523558126 458878.59326357545 5438353.998659377
														112.23023617894311 458878.60326357546 5438353.981338869 112.23023617894311 458878.6532775685
														5438354.010214461 112.22337523558126 458878.6432775685 5438354.027534969 112.22337523558126
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6906_462_721448_412200">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.353114485 5438353.836915224 113.24665541245994 458878.35466815775 5438353.837812237
														113.28255086453691 458878.343114485 5438353.854235732 113.24665541245994 458878.353114485
														5438353.836915224 113.24665541245994 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6907_299_327286_156144">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9388937225 5438354.198209035 112.60562051888634 458878.90402675583
														5438354.1780785825 112.59576762163951 458878.91402675584 5438354.160758074 112.59576762163951
														458878.9488937225 5438354.180888527 112.60562051888634 458878.9388937225 5438354.198209035
														112.60562051888634 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6908_190_442625_57368">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7115844694 5438354.043877966 112.64873785949788 458878.6717456364 5438354.043971015
														112.64873785949788 458878.7491673804 5438354.0655764695 112.65689286748093 458878.7115844694
														5438354.043877966 112.64873785949788 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6909_740_65594_269793">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9897415976 5438354.227566069 112.35077201247398 458878.978116639 5438354.220854396
														112.35157408719566 458878.988116639 5438354.203533889 112.35157408719566 458878.99974159756
														5438354.210245561 112.35077201247398 458878.9897415976 5438354.227566069 112.35077201247398
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6910_743_296411_302078">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4164528507 5438353.896577657 113.2638881633474 458878.4147076424 5438353.89557006
														113.26249596075094 458878.4247076424 5438353.878249552 113.26249596075094 458878.4264528507
														5438353.879257149 113.2638881633474 458878.4164528507 5438353.896577657 113.2638881633474
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6911_1166_745156_70882">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8588412358 5438354.15199071 112.66130107371889 458878.9397498346 5438354.175609301
														112.66130107371889 458878.8276120283 5438354.133960519 112.66528969725006 458878.8588412358
														5438354.15199071 112.66130107371889 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6912_1646_705005_43420">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7700636945 5438354.100734973 112.87325421925138 458878.7142176853 5438354.0684922645
														112.88878002763349 458878.7810865076 5438354.084004986 112.87306075670911 458878.7700636945
														5438354.100734973 112.87325421925138 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6913_1744_157669_74827">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54588413116 5438353.971304841 112.59774165839302 458878.5794948212 5438353.990709983
														112.58601868288544 458878.5894948212 5438353.973389475 112.58601868288544 458878.5558841312
														5438353.953984333 112.59774165839302 458878.54588413116 5438353.971304841 112.59774165839302
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6914_69_747019_323985">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.35012129024 5438353.858281112 113.21282371507703 458878.35742742964
														5438353.862499314 113.19924531799974 458878.36742742965 5438353.845178806 113.19924531799974
														458878.3601212902 5438353.840960605 113.21282371507703 458878.35012129024 5438353.858281112
														113.21282371507703 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6915_39_549628_137919">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97325622156 5438354.218048234 112.61760571569658 458878.9388937225 5438354.198209035
														112.60562051888634 458878.9488937225 5438354.180888527 112.60562051888634 458878.9832562216
														5438354.200727725 112.61760571569658 458878.97325622156 5438354.218048234 112.61760571569658
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6916_0_683556_35148">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5794948212 5438353.990709983 112.58601868288544 458878.61527335684 5438354.01136673
														112.57590818951317 458878.62527335685 5438353.9940462215 112.57590818951317 458878.5894948212
														5438353.973389475 112.58601868288544 458878.5794948212 5438353.990709983 112.58601868288544
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6917_1720_335225_322813">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.50942123314 5438353.927158967 113.331148502306 458878.5032380489 5438353.946683114
														113.33276962814415 458878.49480895424 5438353.918722563 113.35830529646058 458878.50942123314
														5438353.927158967 113.331148502306 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6918_8_19843_24682">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5417749579 5438353.945838398 112.79957697370547 458878.5325018369 5438353.963578571
														112.79957697370547 458878.5428061266 5438353.946433744 112.74812449177858 458878.5417749579
														5438353.945838398 112.79957697370547 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6919_22_555186_414021">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.48832995136 5438353.938075921 113.36059791460721 458878.49480895424
														5438353.918722563 113.35830529646058 458878.5032380489 5438353.946683114 113.33276962814415
														458878.48832995136 5438353.938075921 113.36059791460721 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6920_134_601367_9289">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0335339281 5438354.229755572 112.72100828635042 458879.07646492443 5438354.254541795
														112.67714783016916 458879.0231653629 5438354.246863289 112.72117106704236 458879.0335339281
														5438354.229755572 112.72100828635042 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6921_1898_93964_137181">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4109731167 5438353.893413931 113.374304871716 458878.42815462156 5438353.903333678
														113.37961516279621 458878.41810475726 5438353.874437375 113.36850681061764 458878.4109731167
														5438353.893413931 113.374304871716 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6922_1751_717716_9524">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9397498346 5438354.175609301 112.66130107371889 458878.8588412358 5438354.15199071
														112.66130107371889 458878.9775854238 5438354.197453689 112.65489050912929 458878.9397498346
														5438354.175609301 112.66130107371889 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6923_733_105649_388703">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7762534051 5438354.081214593 112.85349373204347 458878.7219265996 5438354.049848997
														112.86866210224148 458878.76521736744 5438354.097936945 112.85369042683452 458878.7762534051
														5438354.081214593 112.85349373204347 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6924_1264_250662_272537">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.36791544116 5438353.868554571 113.31327644643728 458878.3772944638 5438353.850875541
														113.31018812583261 458878.3610086143 5438353.864566912 113.28142065529935 458878.36791544116
														5438353.868554571 113.31327644643728 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6925_933_73445_147127">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3694217223 5438353.8463302115 113.24748549766184 458878.3594217223 5438353.86365072
														113.24748549766184 458878.3708210654 5438353.847138123 113.27981537777646 458878.3694217223
														5438353.8463302115 113.24748549766184 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6926_1189_392210_65558">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7321722194 5438354.07885832 112.68285255433791 458878.70029122574 5438354.06045182
														112.67695997327504 458878.78527542436 5438354.0864234585 112.68285255433791 458878.7321722194
														5438354.07885832 112.68285255433791 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6927_528_634155_251530">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5872442292 5438353.972090094 112.63347805924773 458878.5697866394 5438353.985104961
														112.63347805924773 458878.59617190703 5438353.977244492 112.629253000775 458878.5872442292
														5438353.972090094 112.63347805924773 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6928_1127_486788_315634">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54675325215 5438353.948712618 112.67955968076224 458878.53658403823
														5438353.9659354305 112.67955968076224 458878.5515026374 5438353.951454677 112.66986190715397
														458878.54675325215 5438353.948712618 112.67955968076224 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6929_1350_152212_198920">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5404785341 5438353.968183919 112.66986190715397 458878.5515026374 5438353.951454677
														112.66986190715397 458878.53658403823 5438353.9659354305 112.67955968076224 458878.5404785341
														5438353.968183919 112.66986190715397 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6930_319_597734_362650">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4911884147 5438353.939726255 113.32616747743 458878.49466809356 5438353.918641238
														113.32300991991135 458878.47809913504 5438353.932169156 113.35071263092671 458878.4911884147
														5438353.939726255 113.32616747743 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6931_686_494812_285300">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9719841518 5438354.217313803 112.45083504914481 458878.9856615965 5438354.225210479
														112.4540713621971 458878.99566159653 5438354.207889971 112.4540713621971 458878.98198415176
														5438354.199993296 112.45083504914481 458878.9719841518 5438354.217313803 112.45083504914481
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6932_1721_450966_313383">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53379297675 5438353.964324011 112.68876638823272 458878.5433495187 5438353.946747472
														112.68876638823272 458878.5337345988 5438353.964290306 112.69654320289947 458878.53379297675
														5438353.964324011 112.68876638823272 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6933_478_403844_425710">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.412043899 5438353.894032148 113.2560069542632 458878.4113449202 5438353.893628592
														113.23985802072202 458878.42134492023 5438353.8763080835 113.23985802072202 458878.422043899
														5438353.87671164 113.2560069542632 458878.412043899 5438353.894032148 113.2560069542632 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6934_633_884859_146943">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53334739524 5438353.964066754 112.74812449177858 458878.5428061266 5438353.946433744
														112.74812449177858 458878.5325018369 5438353.963578571 112.79957697370547 458878.53334739524
														5438353.964066754 112.74812449177858 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6935_1834_351477_388273">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7810865076 5438354.084004986 112.87306075670911 458878.83552738343 5438354.11543644
														112.85233826659224 458878.7700636945 5438354.100734973 112.87325421925138 458878.7810865076
														5438354.084004986 112.87306075670911 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6936_681_30704_323898">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.860541128 5438354.152972143 112.68148022801789 458878.8285181314 5438354.134483658
														112.68557023503231 458878.94182287383 5438354.1768061705 112.68148022801789 458878.860541128
														5438354.152972143 112.68148022801789 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6937_1619_154757_299476">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3619194758 5438353.841998788 113.31657355882856 458878.352247855 5438353.859508885
														113.31819468466671 458878.35466815775 5438353.837812237 113.28255086453691 458878.3619194758
														5438353.841998788 113.31657355882856 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6938_790_398070_423307">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.689848804 5438354.054422884 112.58256466777065 458878.654271538 5438354.03388234
														112.58807504541825 458878.66427153803 5438354.016561832 112.58807504541825 458878.699848804
														5438354.037102376 112.58256466777065 458878.689848804 5438354.054422884 112.58256466777065
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6939_1550_886930_33900">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0150567764 5438354.219087784 112.64607756042787 458878.9205929281 5438354.187643066
														112.64607756042787 458879.05137040664 5438354.240053468 112.63509452825654 458879.0150567764
														5438354.219087784 112.64607756042787 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6940_200_490106_194604">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.64129440445 5438354.026389989 112.6381992375189 458878.67444882076 5438354.022437689
														112.6381992375189 458878.6092550781 5438354.007892075 112.62442905001742 458878.64129440445
														5438354.026389989 112.6381992375189 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6941_301_37831_384391">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0832981395 5438354.281580964 112.26484953670353 458879.1155994134 5438354.300230113
														112.29067143558367 458879.1255994134 5438354.282909605 112.29067143558367 458879.0932981395
														5438354.264260456 112.26484953670353 458879.0832981395 5438354.281580964 112.26484953670353
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6942_1618_571710_355165">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39118377765 5438353.85889454 113.37001194594424 458878.4112024477 5438353.870452325
														113.38578590099745 458878.3822922102 5438353.876855002 113.37281981826137 458878.39118377765
														5438353.85889454 113.37001194594424 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6943_782_664755_186330">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.988740279 5438354.226987958 112.47249823894646 458878.9866751022 5438354.225795628
														112.4736571703249 458878.99667510215 5438354.208475119 112.4736571703249 458878.998740279
														5438354.20966745 112.47249823894646 458878.988740279 5438354.226987958 112.47249823894646
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6944_1286_269430_265780">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.38589458126 5438353.878934832 112.31845800323498 458878.3655517683 5438353.867189904
														112.35599786908395 458878.3755517683 5438353.849869396 112.35599786908395 458878.3958945813
														5438353.861614324 112.31845800323498 458878.38589458126 5438353.878934832 112.31845800323498
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6945_438_840164_23848">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5878993036 5438353.995562313 112.64604219278061 458878.58183495444 5438353.992061059
														112.6484772490391 458878.6093328441 5438353.984842963 112.64604219278061 458878.5878993036
														5438353.995562313 112.64604219278061 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6946_46_697794_299579">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9661839379 5438354.213965048 112.47019759684021 458878.9516267611 5438354.205560458
														112.46178733500233 458878.9616267611 5438354.18823995 112.46178733500233 458878.9761839379
														5438354.19664454 112.47019759684021 458878.9661839379 5438354.213965048 112.47019759684021
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6947_911_392784_96641">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0701559131 5438354.273993296 112.64336250771833 458878.9549675685 5438354.207489274
														112.65439692439376 458879.0801559131 5438354.256672788 112.64336250771833 458879.0701559131
														5438354.273993296 112.64336250771833 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6948_260_321864_406007">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06426240375 5438354.247496666 112.6624686517117 458879.0542005589 5438354.264781468
														112.66250131126031 458879.0801559131 5438354.256672788 112.64336250771833 458879.06426240375
														5438354.247496666 112.6624686517117 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6949_977_71943_255453">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8293360314 5438354.111861862 112.83328824887725 458878.7762534051 5438354.081214593
														112.85349373204347 458878.81846538424 5438354.128679701 112.83349606232185 458878.8293360314
														5438354.111861862 112.83328824887725 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6950_968_94632_313167">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8276120283 5438354.133960519 112.66528969725006 458878.79627406853 5438354.115867539
														112.6668442114814 458878.7649229604 5438354.097766968 112.66595987399884 458878.73365434794
														5438354.079714027 112.66263938268344 458878.7025636234 5438354.061763789 112.65689286748093
														458878.6717456364 5438354.043971015 112.64873785949788 458878.64129440445 5438354.026389989
														112.6381992375189 458878.6092550781 5438354.007892075 112.62442905001742 458878.6004174931
														5438354.002789693 112.6237338489939 458878.5925179319 5438353.998228879 112.62435062044727
														458878.58471575717 5438353.993724291 112.62619794327416 458878.5771073352 5438353.989331567
														112.629253000775 458878.5697866394 5438353.985104961 112.63347805924773 458878.56284408934
														5438353.981096678 112.63882093404527 458878.556365434 5438353.977356224 112.64521563411975
														458878.5504306927 5438353.9739298 112.65258317709288 458878.54511316673 5438353.970859725
														112.66083256478498 458878.5404785341 5438353.968183919 112.66986190715397 458878.53658403823
														5438353.9659354305 112.67955968076224 458878.53379297675 5438353.964324011 112.68876638823272
														458878.5337345988 5438353.964290306 112.69654320289947 458878.53334739524 5438353.964066754
														112.74812449177858 458878.5325018369 5438353.963578571 112.79957697370547 458878.5311971723
														5438353.962825322 112.85101042944646 458878.5294336075 5438353.961807127 112.90241673604697
														458878.52721142093 5438353.960524147 112.95378777484068 458878.5245309636 5438353.9589765845
														113.00511543273023 458878.5213926589 5438353.957164683 113.05639160347034 458878.5177970023
														5438353.95508873 113.10760818894647 458878.5137445618 5438353.952749053 113.15875710045525
														458878.5092359774 5438353.95014602 113.2098302599803 458878.50426222174 5438353.947274421
														113.26091964227858 458878.50015694357 5438353.944904238 113.2960728026798 458878.4911884147
														5438353.939726255 113.32616747743 458878.47809913504 5438353.932169156 113.35071263092671
														458878.462308498 5438353.923052427 113.36805849146991 458878.4453428578 5438353.91325731
														113.37759307582735 458878.42815462156 5438353.903333678 113.37961516279621 458878.4109731167
														5438353.893413931 113.374304871716 458878.39429475826 5438353.883784676 113.36127574039503
														458878.37942379864 5438353.875198924 113.3405609078931 458878.36791544116 5438353.868554571
														113.31327644643728 458878.3610086143 5438353.864566912 113.28142065529935 458878.3594217223
														5438353.86365072 113.24748549766184 458878.3611144151 5438353.864627996 113.23341694298324
														458878.36487442976 5438353.866798841 113.22096229747167 458878.3701168154 5438353.8698255345
														113.21121936909082 458878.3759820633 5438353.873211837 113.20482794826692 458878.38164349366
														5438353.876480466 113.2016785932235 458878.38691251626 5438353.879522537 113.20108334597481
														458878.3923283734 5438353.8826493835 113.20278410611111 458878.39816194155 5438353.886017396
														113.20738073722909 458878.40385316283 5438353.889303224 113.21537341182403 458878.40849718084
														5438353.891984449 113.2264966198117 458878.4113449202 5438353.893628592 113.23985802072202
														458878.412043899 5438353.894032148 113.2560069542632 458878.4124254011 5438353.894252408
														113.25841634673209 458878.41333395434 5438353.894776962 113.2606296260029 458878.4147076424
														5438353.89557006 113.26249596075094 458878.4164528507 5438353.896577657 113.2638881633474
														458878.41845064604 5438353.897731084 113.26471135748603 458878.42056488216 5438353.898951739
														113.26490944384672 458878.4226514773 5438353.900156436 113.2644689231713 458878.4245682333
														5438353.901263075 113.26341981621583 458878.42618452664 5438353.9021962425 113.26183361788558
														458878.42739020945 5438353.902892344 113.25981842497545 458878.42810311645 5438353.903303941
														113.257511569552 458878.4282746643 5438353.903402984 113.25507026000005 458878.4274978279
														5438353.902954478 113.23712253396157 458878.42387216893 5438353.900861203 113.22011118681575
														458878.41764476994 5438353.897265812 113.20519551375801 458878.40924001793 5438353.892413327
														113.1933919932579 458878.39923068293 5438353.886634434 113.18550501573131 458878.3882988845
														5438353.880322957 113.18207206566278 458878.37718960666 5438353.873909012 113.18332709292629
														458878.3666599283 5438353.8678297 113.18918456948785 458878.35742742964 5438353.862499314
														113.19924531799974 458878.35012129024 5438353.858281112 113.21282371507703 458878.34523941134
														5438353.855462559 113.22899441539827 458878.343114485 5438353.854235732 113.24665541245994
														458878.3447670914 5438353.8551898645 113.28339002101975 458878.352247855 5438353.859508885
														113.31819468466671 458878.3650469742 5438353.86689846 113.34869752309066 458878.3822922102
														5438353.876855002 113.37281981826137 458878.4028083286 5438353.888699989 113.38891767562691
														458878.42519718984 5438353.901626203 113.39589405281079 458878.4479330301 5438353.914752747
														113.39327352123693 458878.46946643933 5438353.927185067 113.38123466580148 458878.48832995136
														5438353.938075921 113.36059791460721 458878.5032380489 5438353.946683114 113.33276962814415
														458878.51317476993 5438353.952420083 113.29964625814634 458878.5174629432 5438353.954895861
														113.26348510754019 458878.5224497054 5438353.95777497 113.21226212473014 458878.52697894885
														5438353.96038993 113.16095493981646 458878.53104995825 5438353.962740328 113.10957165581146
														458878.5346620907 5438353.964825793 113.05812038774591 458878.53781477565 5438353.966645997
														113.00660926138735 458878.54050751525 5438353.968200651 112.95504641195686 458878.54273988423
														5438353.96948951 112.90343998284419 458878.6001802008 5438354.002652692 112.90392278167425
														458878.6574652457 5438354.035726228 112.89902537695877 458878.7142176853 5438354.0684922645
														112.88878002763349 458878.7700636945 5438354.100734973 112.87325421925138 458878.8246354188
														5438354.132241973 112.85255021945907 458878.87757339706 5438354.162805729 112.82680440436546
														458878.9285289299 5438354.192224919 112.79618636023974 458878.97716637584 5438354.220305761
														112.76089776645604 458879.0231653629 5438354.246863289 112.72117106704236 458879.06622289813
														5438354.271722569 112.67726793958466 458879.10605536395 5438354.294719853 112.6294775715709
														458879.14240038616 5438354.315703662 112.57811475552894 458879.16247265483 5438354.327292392
														112.53911810313281 458879.1748962217 5438354.334465141 112.49608160499926 458879.1791016618
														5438354.336893153 112.45097780742091 458879.1748962217 5438354.334465141 112.40587400984258
														458879.16247265483 5438354.327292392 112.36283751170902 458879.14240038616 5438354.315703662
														112.3238408593129 458879.1155994134 5438354.300230113 112.29067143558367 458879.0832981395
														5438354.281580964 112.26484953670353 458879.0469770696 5438354.260610985 112.24755869044807
														458878.99750182003 5438354.232046436 112.23235227409854 458878.94745924783 5438354.203154343
														112.2198640072376 458878.8969612872 5438354.173999332 112.21012182337161 458878.8461208909
														5438354.144646616 112.20314751362325 458878.7950517778 5438354.115161849 112.19895667798953
														458878.7438681783 5438354.085610985 112.19755869044807 458878.6926845787 5438354.0560601195
														112.19895667798953 458878.64161546563 5438354.026575353 112.20314751362325 458878.5907750693
														5438353.997222637 112.21012182337161 458878.54027710866 5438353.968067626 112.2198640072376
														458878.49023453646 5438353.939175533 112.23235227409854 458878.4407592869 5438353.910610984
														112.24755869044807 458878.40326927194 5438353.888966114 112.27147915116946 458878.37217072694
														5438353.871011361 112.30548940552285 458878.3494503434 5438353.857893742 112.34741675104325
														458878.3365595846 5438353.850451258 112.39458271182116 458878.3343219605 5438353.8491593655
														112.44397414957832 458878.34288041893 5438353.854100593 112.49243575422949 458878.3616882134
														5438353.864959279 112.53687161691172 458878.3895438317 5438353.881041728 112.57444300824127
														458878.42466775246 5438353.901320533 112.60274972698157 458878.4648161281 5438353.924500208
														112.6199834338905 458878.5074241299 5438353.94909995 112.62504317520589 458878.5497697991
														5438353.9735482335 112.61760571569658 458878.5841322982 5438353.993387431 112.60562051888634
														458878.61899926484 5438354.013517884 112.59576762163951 458878.654271538 5438354.03388234
														112.58807504541825 458878.689848804 5438354.054422884 112.58256466777065 458878.72562988166
														5438354.075081099 112.57925216011144 458878.76151301036 5438354.0957982335 112.57814694315266
														458878.797396139 5438354.116515367 112.57925216011144 458878.8331772167 5438354.137173582
														112.58256466777065 458878.86875448265 5438354.157714126 112.58807504541825 458878.90402675583
														5438354.1780785825 112.59576762163951 458878.9388937225 5438354.198209035 112.60562051888634
														458878.97325622156 5438354.218048234 112.61760571569658 458879.00575349183 5438354.236810541
														112.61536353660645 458879.03664087376 5438354.254643379 112.60348567277614 458879.0638134433
														5438354.270331469 112.58278158099661 458879.0854194348 5438354.282805694 112.55466221090748
														458879.0999864356 5438354.291215956 112.52104385111089 458879.1065217287 5438354.294989109
														112.48421753727 458879.10457994463 5438354.29386802 112.44669292181471 458879.0942934128
														5438354.287929088 112.41102724527593 458879.0763631434 5438354.277577043 112.37965106456948
														458879.05201105453 5438354.263517357 112.35470261455889 458879.02289670094 5438354.246708177
														112.33788209088314 458878.9910041776 5438354.22829502 112.33033578443348 458878.97475554247
														5438354.218913866 112.33145687397855 458878.95931185153 5438354.209997447 112.3373958058937
														458878.94572556676 5438354.202153402 112.34774785178346 458878.934922571 5438354.195916289
														112.36180753682802 458878.9276390706 5438354.1917111585 112.37861671672633 458878.9243714241
														5438354.189824582 112.39702987364677 458878.9253423161 5438354.1903851265 112.41579218137441
														458878.930485582 5438354.193354593 112.4336250196438 458878.9394507167 5438354.198530615
														112.44931310999703 458878.9516267611 5438354.205560458 112.46178733500233 458878.9661839379
														5438354.213965048 112.47019759684021 458878.9821301996 5438354.223171627 112.47397075006503
														458878.9844205272 5438354.224493948 112.47415941644546 458878.9866751022 5438354.225795628
														112.4736571703249 458878.988740279 5438354.226987958 112.47249823894646 458878.99047531926
														5438354.227989684 112.47076160156834 458878.99176198284 5438354.228732539 112.46856560715797
														458878.99251258577 5438354.2291659005 112.46605990910534 458878.99267597566 5438354.229260233
														112.46341526659186 458878.99224101775 5438354.2290091105 112.46081190763438 458878.9912373537
														5438354.228429644 112.45842724684357 458878.98973338166 5438354.227561326 112.4564237949115
														458878.9878315947 5438354.226463329 112.45493808377647 458878.9856615965 5438354.225210479
														112.4540713621971 458878.9719841518 5438354.217313803 112.45083504914481 458878.9615693338
														5438354.211300805 112.44481799327936 458878.95285807835 5438354.20627136 112.43589340684175
														458878.946444043 5438354.202568214 112.42466948564913 458878.9427643338 5438354.2004437335
														112.41191112138236 458878.9420697167 5438354.200042696 112.39848777548204 458878.9444075288
														5438354.201392433 112.38531422678815 458878.949618452 5438354.20440096 112.37328823087384
														458878.95734737056 5438354.208863254 112.36322933948681 458878.9670675715 5438354.2144752145
														112.35582304945194 458878.978116639 5438354.220854396 112.35157408719566 458878.9897415976
														5438354.227566069 112.35077201247398 458879.01709648704 5438354.243359422 112.35724463857852
														458879.04206848185 5438354.25777701 112.37167195628186 458879.06295578176 5438354.269836298
														112.39307076772476 458879.0783349518 5438354.278715466 112.41998277927061 458879.08715792693
														5438354.283809413 112.45057398180677 458879.08882343606 5438354.284770995 112.48275963543473
														458879.08321797743 5438354.281534682 112.51434634104907 458879.07072355377 5438354.274321023
														112.54318151686166 458879.05219163943 5438354.263621618 112.56730009329327 458879.0288851538
														5438354.250165612 112.58505842921791 458879.0023923953 5438354.234870011 112.59524632338934
														458878.9753391521 5438354.219250813 112.5971128868175 458878.9435311995 5438354.200886483
														112.58601868288544 458878.9077526638 5438354.1802297365 112.57590818951317 458878.87155822524
														5438354.159332868 112.56801449703344 458878.8350508201 5438354.138255307 112.5623600549654
														458878.79833427473 5438354.117057 112.55896094444031 458878.76151301036 5438354.0957982335
														112.5578268324673 458878.72469174594 5438354.074539466 112.55896094444031 458878.6879752006
														5438354.053341159 112.5623600549654 458878.6514677954 5438354.032263598 112.56801449703344
														458878.61527335684 5438354.01136673 112.57590818951317 458878.5794948212 5438353.990709983
														112.58601868288544 458878.54588413116 5438353.971304841 112.59774165839302 458878.5069944158
														5438353.948851854 112.60457212509365 458878.4688451208 5438353.9268263485 112.60004185951513
														458878.4328980649 5438353.9060723055 112.5846115708238 458878.4014496806 5438353.887915573
														112.55926700366967 458878.3765090086 5438353.873516069 112.52562726395412 458878.3596693524
														5438353.863793689 112.48584138427893 458878.3520064923 5438353.859369535 112.44245103569258
														458878.35400996066 5438353.860526238 112.39822815622148 458878.3655517683 5438353.867189904
														112.35599786908395 458878.38589458126 5438353.878934832 112.31845800323498 458878.41373882454
														5438353.8950107135 112.28800674594528 458878.4473742242 5438353.91443012 112.26654571808225
														458878.4943573143 5438353.94155582 112.2521052769398 458878.5435864518 5438353.969978276
														112.23982000503302 458878.59326357545 5438353.998659377 112.23023617894311 458878.6432775685
														5438354.027534969 112.22337523558126 458878.69351656065 5438354.056540465 112.21925252136879
														458878.7438681783 5438354.085610985 112.21787725791066 458878.7942197959 5438354.114681505
														112.21925252136879 458878.844458788 5438354.1436870005 112.22337523558126 458878.89447278104
														5438354.172562593 112.23023617894313 458878.9441499047 5438354.201243693 112.23982000503302
														458878.99337904225 5438354.229666149 112.2521052769398 458879.04133797454 5438354.257355251
														112.26684564710834 458879.0748420925 5438354.276698863 112.28279546779674 458879.1040289742
														5438354.293549917 112.30612769642845 458879.12824587733 5438354.307531552 112.33609902354207
														458879.1463828379 5438354.318002932 112.37133573536566 458879.1576085616 5438354.324484106
														112.41022278308514 458879.1614085257 5438354.326678016 112.45097780742091 458879.1576085616
														5438354.324484106 112.49173283175668 458879.1463828379 5438354.318002932 112.53061987947616
														458879.12824587733 5438354.307531552 112.56585659129976 458879.0741368389 5438354.276291684
														112.60339887057547 458879.014347223 5438354.241772134 112.62678139721265 458878.95037010486
														5438354.204834928 112.63509452825654 458878.9205929281 5438354.187643066 112.64607756042787
														458878.88986641896 5438354.169903108 112.65489050912929 458878.8588412358 5438354.15199071
														112.66130107371889 458878.8276120283 5438354.133960519 112.66528969725006 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458878.7321722194 5438354.07885832 112.68285255433791 458878.7642356226 5438354.097370134
														112.68625744644296 458878.79638361826 5438354.115930788 112.68716426215984 458878.8285181314
														5438354.134483658 112.68557023503231 458878.860541128 5438354.152972143 112.68148022801789
														458878.8923549143 5438354.171339842 112.67490671865234 458878.92386243486 5438354.189530717
														112.66586976098391 458878.9549675685 5438354.207489274 112.65439692439376 458879.0701559131
														5438354.273993296 112.64336250771833 458879.0542005589 5438354.264781468 112.66250131126031
														458879.01218489784 5438354.240523715 112.70533268273144 458878.9672996216 5438354.214609189
														112.7440887152782 458878.9198403871 5438354.187208586 112.77851412504398 458878.8701198058
														5438354.158502395 112.80838215374645 458878.81846538424 5438354.128679701 112.83349606232185
														458878.76521736744 5438354.097936945 112.85369042683452 458878.71072649705 5438354.066476626
														112.86883222811511 458878.6553517015 5438354.034505973 112.87882172795071 458878.59945773147
														5438354.002235575 112.88359312605485 458878.5469107114 5438353.971897538 112.8831448353398
														458878.5434371541 5438353.969892079 112.88311520162355 458878.54451153 5438353.97051237
														112.85179812432169 458878.5458221728 5438353.97126907 112.80012899225716 458878.54667160555
														5438353.971759491 112.74844074682568 458878.54705969424 5438353.971983553 112.69674155122098
														458878.5495355598 5438353.973412995 112.6885745617454 458878.55263969663 5438353.975205169
														112.68084487930514 458878.556333765 5438353.977337941 112.67364797494583 458878.56057213846
														5438353.979784966 112.66707273925131 458878.5653024681 5438353.982516023 112.66120038443588
														458878.5704663284 5438353.98549738 112.65610344127417 458878.5759999395 5438353.988692212
														112.65184486325707 458878.58183495444 5438353.992061059 112.6484772490391 458878.5878993036
														5438353.995562313 112.64604219278061 458878.59411808493 5438353.999152727 112.6445697704089
														458878.6004144888 5438354.002787958 112.64407816814373 458878.60671074694 5438354.006423105
														112.64457345787522 458878.6374646558 5438354.024178882 112.65779118557873 458878.6686899021
														5438354.042206787 112.66859767996945 458878.70029122574 5438354.06045182 112.67695997327504
														458878.7321722194 5438354.07885832 112.68285255433791 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6951_201_156929_300927">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42618452664 5438353.9021962425 113.26183361788558 458878.4245682333
														5438353.901263075 113.26341981621583 458878.4345682333 5438353.883942568 113.26341981621583
														458878.43618452665 5438353.884875734 113.26183361788558 458878.42618452664 5438353.9021962425
														113.26183361788558 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6952_342_772779_186908">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.46946643933 5438353.927185067 113.38123466580148 458878.4479330301 5438353.914752747
														113.39327352123693 458878.476343957 5438353.908061792 113.37842679348436 458878.46946643933
														5438353.927185067 113.38123466580148 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6953_82_348425_226665">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7950517778 5438354.115161849 112.19895667798953 458878.8461208909 5438354.144646616
														112.20314751362325 458878.85612089093 5438354.127326108 112.20314751362325 458878.8050517778
														5438354.097841341 112.19895667798953 458878.7950517778 5438354.115161849 112.19895667798953
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6954_1816_343696_98858">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7438681783 5438354.085610985 112.19755869044807 458878.7950517778 5438354.115161849
														112.19895667798953 458878.8050517778 5438354.097841341 112.19895667798953 458878.7538681783
														5438354.068290477 112.19755869044807 458878.7438681783 5438354.085610985 112.19755869044807
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6955_1123_305928_154660">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9420697167 5438354.200042696 112.39848777548204 458878.9427643338 5438354.2004437335
														112.41191112138236 458878.95276433375 5438354.183123225 112.41191112138236 458878.9520697167
														5438354.182722188 112.39848777548204 458878.9420697167 5438354.200042696 112.39848777548204
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6956_215_361338_337092">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3650469742 5438353.86689846 113.34869752309066 458878.3743742737 5438353.849189568
														113.34640490494405 458878.3822922102 5438353.876855002 113.37281981826137 458878.3650469742
														5438353.86689846 113.34869752309066 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6957_228_550397_46112">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4344524128 5438353.883875698 113.37364052082247 458878.41810475726 5438353.874437375
														113.36850681061764 458878.42815462156 5438353.903333678 113.37961516279621 458878.4344524128
														5438353.883875698 113.37364052082247 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6958_1753_560750_366617">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4245682333 5438353.901263075 113.26341981621583 458878.4226514773 5438353.900156436
														113.2644689231713 458878.4326514772 5438353.882835927 113.2644689231713 458878.4345682333
														5438353.883942568 113.26341981621583 458878.4245682333 5438353.901263075 113.26341981621583
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6959_778_484658_289553">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4147076424 5438353.89557006 113.26249596075094 458878.41333395434 5438353.894776962
														113.2606296260029 458878.42333395435 5438353.877456454 113.2606296260029 458878.4247076424
														5438353.878249552 113.26249596075094 458878.4147076424 5438353.89557006 113.26249596075094
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6960_1574_227960_164542">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3708210654 5438353.847138123 113.27981537777646 458878.3610086143 5438353.864566912
														113.28142065529935 458878.3772944638 5438353.850875541 113.31018812583261 458878.3708210654
														5438353.847138123 113.27981537777646 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6961_960_702956_59465">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8923549143 5438354.171339842 112.67490671865234 458878.860541128 5438354.152972143
														112.68148022801789 458878.9806201742 5438354.199205803 112.67490671865234 458878.8923549143
														5438354.171339842 112.67490671865234 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6962_1451_112006_102648">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1140289742 5438354.276229409 112.59582791841339 458879.0848420925 5438354.259378355
														112.61916014704508 458879.0741368389 5438354.276291684 112.60339887057547 458879.1140289742
														5438354.276229409 112.59582791841339 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6963_218_777818_370131">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5663333234 5438353.960017177 112.68084487930514 458878.55263969663 5438353.975205169
														112.68084487930514 458878.56254779064 5438353.957831599 112.6885745617454 458878.5663333234
														5438353.960017177 112.68084487930514 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6964_1159_426321_218024">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5495355598 5438353.973412995 112.6885745617454 458878.56254779064 5438353.957831599
														112.6885745617454 458878.55263969663 5438353.975205169 112.68084487930514 458878.5495355598
														5438353.973412995 112.6885745617454 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6965_20_839315_419511">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1065217287 5438354.294989109 112.48421753727 458879.0999864356 5438354.291215956
														112.52104385111089 458879.1099864356 5438354.273895448 112.52104385111089 458879.1165217287
														5438354.277668602 112.48421753727 458879.1065217287 5438354.294989109 112.48421753727 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6966_1170_655830_354775">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8276120283 5438354.133960519 112.66528969725006 458878.9016654352 5438354.153621263
														112.66528969725006 458878.79627406853 5438354.115867539 112.6668442114814 458878.8276120283
														5438354.133960519 112.66528969725006 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6967_1623_473405_274840">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.52343484363 5438353.935249729 113.26348510754019 458878.5174629432 5438353.954895861
														113.26348510754019 458878.5191849909 5438353.932796075 113.2988071016635 458878.52343484363
														5438353.935249729 113.26348510754019 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6968_1030_120487_404246">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.353114485 5438353.836915224 113.24665541245994 458878.343114485 5438353.854235732
														113.24665541245994 458878.34523941134 5438353.855462559 113.22899441539827 458878.35523941135
														5438353.83814205 113.22899441539827 458878.353114485 5438353.836915224 113.24665541245994
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6969_523_461413_381201">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3895438317 5438353.881041728 112.57444300824127 458878.3616882134 5438353.864959279
														112.53687161691172 458878.37168821343 5438353.847638771 112.53687161691172 458878.3995438317
														5438353.86372122 112.57444300824127 458878.3895438317 5438353.881041728 112.57444300824127
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6970_765_99673_332962">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.34523941134 5438353.855462559 113.22899441539827 458878.35012129024
														5438353.858281112 113.21282371507703 458878.3601212902 5438353.840960605 113.21282371507703
														458878.35523941135 5438353.83814205 113.22899441539827 458878.34523941134 5438353.855462559
														113.22899441539827 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6971_1986_274194_374067">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0023923953 5438354.234870011 112.59524632338934 458879.0288851538 5438354.250165612
														112.58505842921791 458879.0388851538 5438354.232845104 112.58505842921791 458879.0123923953
														5438354.217549503 112.59524632338934 458879.0023923953 5438354.234870011 112.59524632338934
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6972_1553_703633_86939">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0569770696 5438354.2432904765 112.65439692439376 458879.0801559131 5438354.256672788
														112.64336250771833 458878.9549675685 5438354.207489274 112.65439692439376 458879.0569770696
														5438354.2432904765 112.65439692439376 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6973_1399_495598_83251">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.476343957 5438353.908061792 113.37842679348436 458878.49480895424 5438353.918722563
														113.35830529646058 458878.46946643933 5438353.927185067 113.38123466580148 458878.476343957
														5438353.908061792 113.37842679348436 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6974_1622_198635_344950">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.04206848185 5438354.25777701 112.37167195628186 458879.01709648704 5438354.243359422
														112.35724463857852 458879.02709648705 5438354.226038914 112.35724463857852 458879.05206848186
														5438354.240456502 112.37167195628186 458879.04206848185 5438354.25777701 112.37167195628186
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6975_188_36528_143227">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97475554247 5438354.218913866 112.33145687397855 458878.9910041776 5438354.22829502
														112.33033578443348 458879.0010041776 5438354.210974513 112.33033578443348 458878.9847555425
														5438354.201593358 112.33145687397855 458878.97475554247 5438354.218913866 112.33145687397855
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6976_1500_534300_272844">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3759820633 5438353.873211837 113.20482794826692 458878.3701168154 5438353.8698255345
														113.21121936909082 458878.3801168154 5438353.852505026 113.21121936909082 458878.3859820633
														5438353.855891329 113.20482794826692 458878.3759820633 5438353.873211837 113.20482794826692
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6977_539_283562_276691">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.41373882454 5438353.8950107135 112.28800674594528 458878.38589458126
														5438353.878934832 112.31845800323498 458878.3958945813 5438353.861614324 112.31845800323498
														458878.42373882455 5438353.877690205 112.28800674594528 458878.41373882454 5438353.8950107135
														112.28800674594528 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6978_1118_382612_403930">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5069944158 5438353.948851854 112.60457212509365 458878.54588413116 5438353.971304841
														112.59774165839302 458878.5558841312 5438353.953984333 112.59774165839302 458878.5169944158
														5438353.9315313455 112.60457212509365 458878.5069944158 5438353.948851854 112.60457212509365
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6979_1350_265433_89789">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54667160555 5438353.971759491 112.74844074682568 458878.5590551636 5438353.95581513
														112.74844074682568 458878.54705969424 5438353.971983553 112.69674155122098 458878.54667160555
														5438353.971759491 112.74844074682568 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6980_1963_779389_19029">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95734737056 5438354.208863254 112.36322933948681 458878.949618452 5438354.20440096
														112.37328823087384 458878.959618452 5438354.187080452 112.37328823087384 458878.9673473706
														5438354.191542746 112.36322933948681 458878.95734737056 5438354.208863254 112.36322933948681
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6981_1433_765436_429650">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55952844244 5438353.956088378 112.69674155122098 458878.54705969424
														5438353.971983553 112.69674155122098 458878.5590551636 5438353.95581513 112.74844074682568
														458878.55952844244 5438353.956088378 112.69674155122098 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6982_139_181917_94438">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.63537647156 5438353.999879258 112.62442905001742 458878.6092550781 5438354.007892075
														112.62442905001742 458878.67444882076 5438354.022437689 112.6381992375189 458878.63537647156
														5438353.999879258 112.62442905001742 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6983_1384_191736_267182">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4113449202 5438353.893628592 113.23985802072202 458878.40849718084 5438353.891984449
														113.2264966198117 458878.41849718085 5438353.874663941 113.2264966198117 458878.42134492023
														5438353.8763080835 113.23985802072202 458878.4113449202 5438353.893628592 113.23985802072202
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6984_198_829347_203407">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4226514773 5438353.900156436 113.2644689231713 458878.42056488216 5438353.898951739
														113.26490944384672 458878.4305648822 5438353.881631232 113.26490944384672 458878.4326514772
														5438353.882835927 113.2644689231713 458878.4226514773 5438353.900156436 113.2644689231713
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6985_1493_520013_3974">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.10457994463 5438354.29386802 112.44669292181471 458879.1065217287 5438354.294989109
														112.48421753727 458879.1165217287 5438354.277668602 112.48421753727 458879.11457994463
														5438354.276547512 112.44669292181471 458879.10457994463 5438354.29386802 112.44669292181471
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6986_1917_147335_171112">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.98973338166 5438354.227561326 112.4564237949115 458878.9912373537 5438354.228429644
														112.45842724684357 458879.0012373537 5438354.211109136 112.45842724684357 458878.9997333817
														5438354.210240818 112.4564237949115 458878.98973338166 5438354.227561326 112.4564237949115
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6987_1407_97520_247970">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39429475826 5438353.883784676 113.36127574039503 458878.4109731167 5438353.893413931
														113.374304871716 458878.4022618541 5438353.86529047 113.35602320197307 458878.39429475826
														5438353.883784676 113.36127574039503 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6988_917_341239_172576">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.41810475726 5438353.874437375 113.36850681061764 458878.4022618541 5438353.86529047
														113.35602320197307 458878.4109731167 5438353.893413931 113.374304871716 458878.41810475726
														5438353.874437375 113.36850681061764 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6989_1484_785587_181074">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5435864518 5438353.969978276 112.23982000503302 458878.4943573143 5438353.94155582
														112.2521052769398 458878.50435731426 5438353.924235312 112.2521052769398 458878.5535864518
														5438353.952657768 112.23982000503302 458878.5435864518 5438353.969978276 112.23982000503302
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6990_425_624043_268683">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4552846003 5438353.895903167 113.39014174660748 458878.476343957 5438353.908061792
														113.37842679348436 458878.4479330301 5438353.914752747 113.39327352123693 458878.4552846003
														5438353.895903167 113.39014174660748 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6991_1262_822086_386398">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.08715792693 5438354.283809413 112.45057398180677 458879.0783349518 5438354.278715466
														112.41998277927061 458879.0883349518 5438354.261394958 112.41998277927061 458879.09715792693
														5438354.266488905 112.45057398180677 458879.08715792693 5438354.283809413 112.45057398180677
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6992_498_353443_402414">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6514677954 5438354.032263598 112.56801449703344 458878.6879752006 5438354.053341159
														112.5623600549654 458878.6979752006 5438354.0360206505 112.5623600549654 458878.66146779543
														5438354.01494309 112.56801449703344 458878.6514677954 5438354.032263598 112.56801449703344
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6993_1993_477380_82121">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5585747434 5438353.95553776 112.88314040583125 458878.55511071055 5438353.953537799
														112.88311520162355 458878.5469107114 5438353.971897538 112.8831448353398 458878.5585747434
														5438353.95553776 112.88314040583125 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6994_1780_523835_333067">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.88833364565 5438354.14592415 112.82658627449457 458878.93915746244 5438354.175267295
														112.79597440737291 458878.87757339706 5438354.162805729 112.82680440436546 458878.88833364565
														5438354.14592415 112.82658627449457 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6995_1883_686542_299698">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53503972856 5438353.941949812 113.16095493981646 458878.52697894885 5438353.96038993
														113.16095493981646 458878.52951626095 5438353.938760837 113.21226212473014 458878.53503972856
														5438353.941949812 113.16095493981646 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6996_263_770068_96206">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0288851538 5438354.250165612 112.58505842921791 458879.05219163943 5438354.263621618
														112.56730009329327 458879.06219163944 5438354.24630111 112.56730009329327 458879.0388851538
														5438354.232845104 112.58505842921791 458879.0288851538 5438354.250165612 112.58505842921791
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6997_602_408407_8728">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5590551636 5438353.95581513 112.74844074682568 458878.54667160555 5438353.971759491
														112.74844074682568 458878.55801926995 5438353.955217057 112.80012899225716 458878.5590551636
														5438353.95581513 112.74844074682568 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6998_1832_276846_80968">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8246354188 5438354.132241973 112.85255021945907 458878.7700636945 5438354.100734973
														112.87325421925138 458878.83552738343 5438354.11543644 112.85233826659224 458878.8246354188
														5438354.132241973 112.85255021945907 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID6999_488_473343_57888">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4479330301 5438353.914752747 113.39327352123693 458878.42519718984 5438353.901626203
														113.39589405281079 458878.4552846003 5438353.895903167 113.39014174660748 458878.4479330301
														5438353.914752747 113.39327352123693 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7000_63_361874_50356">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99267597566 5438354.229260233 112.46341526659186 458878.99251258577
														5438354.2291659005 112.46605990910534 458879.0025125858 5438354.211845392 112.46605990910534
														458879.0026759757 5438354.211939725 112.46341526659186 458878.99267597566 5438354.229260233
														112.46341526659186 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7001_1723_18743_73279">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5759999395 5438353.988692212 112.65184486325707 458878.5704663284 5438353.98549738
														112.65610344127417 458878.59482142445 5438353.97646479 112.65184486325707 458878.5759999395
														5438353.988692212 112.65184486325707 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7002_1504_540629_79597">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.13824587734 5438354.290211044 112.56585659129976 458879.12824587733
														5438354.307531552 112.56585659129976 458879.1463828379 5438354.318002932 112.53061987947616
														458879.1563828379 5438354.300682424 112.53061987947616 458879.13824587734 5438354.290211044
														112.56585659129976 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7003_1871_78906_298957">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5497697991 5438353.9735482335 112.61760571569658 458878.5074241299 5438353.94909995
														112.62504317520589 458878.5174241299 5438353.931779441 112.62504317520589 458878.5597697991
														5438353.956227725 112.61760571569658 458878.5497697991 5438353.9735482335 112.61760571569658
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7004_1797_297057_86611">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.934922571 5438354.195916289 112.36180753682802 458878.94572556676 5438354.202153402
														112.34774785178346 458878.9557255667 5438354.184832894 112.34774785178346 458878.944922571
														5438354.178595781 112.36180753682802 458878.934922571 5438354.195916289 112.36180753682802
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7005_784_286217_130121">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0783349518 5438354.278715466 112.41998277927061 458879.06295578176 5438354.269836298
														112.39307076772476 458879.07295578176 5438354.25251579 112.39307076772476 458879.0883349518
														5438354.261394958 112.41998277927061 458879.0783349518 5438354.278715466 112.41998277927061
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7006_1604_675061_51133">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8461208909 5438354.144646616 112.20314751362325 458878.8969612872 5438354.173999332
														112.21012182337161 458878.9069612872 5438354.156678824 112.21012182337161 458878.85612089093
														5438354.127326108 112.20314751362325 458878.8461208909 5438354.144646616 112.20314751362325
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7007_1824_562218_55288">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.52384223276 5438353.935484935 113.10760818894647 458878.5177970023 5438353.95508873
														113.10760818894647 458878.5282271798 5438353.938016585 113.05639160347034 458878.52384223276
														5438353.935484935 113.10760818894647 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7008_233_177219_102470">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.94182287383 5438354.1768061705 112.68148022801789 458878.9806201742
														5438354.199205803 112.67490671865234 458878.860541128 5438354.152972143 112.68148022801789
														458878.94182287383 5438354.1768061705 112.68148022801789 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7009_149_608624_416324">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0763631434 5438354.277577043 112.37965106456948 458879.0942934128 5438354.287929088
														112.41102724527593 458879.1042934128 5438354.27060858 112.41102724527593 458879.0863631434
														5438354.260256534 112.37965106456948 458879.0763631434 5438354.277577043 112.37965106456948
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7010_1202_882554_145771">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9276390706 5438354.1917111585 112.37861671672633 458878.934922571 5438354.195916289
														112.36180753682802 458878.944922571 5438354.178595781 112.36180753682802 458878.9376390706
														5438354.17439065 112.37861671672633 458878.9276390706 5438354.1917111585 112.37861671672633
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7011_1401_426208_413111">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4648161281 5438353.924500208 112.6199834338905 458878.42466775246 5438353.901320533
														112.60274972698157 458878.4346677525 5438353.884000025 112.60274972698157 458878.4748161281
														5438353.9071797 112.6199834338905 458878.4648161281 5438353.924500208 112.6199834338905 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7012_1501_211485_212953">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4282746643 5438353.903402984 113.25507026000005 458878.42810311645 5438353.903303941
														113.257511569552 458878.43810311646 5438353.885983433 113.257511569552 458878.4382746643
														5438353.886082476 113.25507026000005 458878.4282746643 5438353.903402984 113.25507026000005
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7013_327_621845_246281">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0942934128 5438354.287929088 112.41102724527593 458879.10457994463 5438354.29386802
														112.44669292181471 458879.11457994463 5438354.276547512 112.44669292181471 458879.1042934128
														5438354.27060858 112.41102724527593 458879.0942934128 5438354.287929088 112.41102724527593
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7014_856_578430_114231">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1155994134 5438354.300230113 112.29067143558367 458879.14240038616 5438354.315703662
														112.3238408593129 458879.15240038617 5438354.298383154 112.3238408593129 458879.1255994134
														5438354.282909605 112.29067143558367 458879.1155994134 5438354.300230113 112.29067143558367
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7015_679_131486_16363">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.51317476993 5438353.952420083 113.29964625814634 458878.5191849909 5438353.932796075
														113.2988071016635 458878.5174629432 5438353.954895861 113.26348510754019 458878.51317476993
														5438353.952420083 113.29964625814634 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7016_1340_39699_24834">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.40849718084 5438353.891984449 113.2264966198117 458878.40385316283 5438353.889303224
														113.21537341182403 458878.41385316284 5438353.871982716 113.21537341182403 458878.41849718085
														5438353.874663941 113.2264966198117 458878.40849718084 5438353.891984449 113.2264966198117
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7017_853_201467_380037">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.87757339706 5438354.162805729 112.82680440436546 458878.8246354188 5438354.132241973
														112.85255021945907 458878.88833364565 5438354.14592415 112.82658627449457 458878.87757339706
														5438354.162805729 112.82680440436546 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7018_1605_578846_267310">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.467021822 5438353.902679656 113.36278341470529 458878.4508307133 5438353.893331715
														113.37179024631025 458878.462308498 5438353.923052427 113.36805849146991 458878.467021822
														5438353.902679656 113.36278341470529 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7019_207_523096_36072">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55801926995 5438353.955217057 112.80012899225716 458878.5458221728 5438353.97126907
														112.80012899225716 458878.5564209251 5438353.954294251 112.85179812432169 458878.55801926995
														5438353.955217057 112.80012899225716 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7020_1118_610214_148296">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7491673804 5438354.0655764695 112.65689286748093 458878.7025636234 5438354.061763789
														112.65689286748093 458878.7870828982 5438354.087467004 112.66263938268344 458878.7491673804
														5438354.0655764695 112.65689286748093 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7021_1221_128100_55427">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53104995825 5438353.962740328 113.10957165581146 458878.54000437416
														5438353.944816152 113.10957165581146 458878.5346620907 5438353.964825793 113.05812038774591
														458878.53104995825 5438353.962740328 113.10957165581146 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7022_1378_98761_377548">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5482541515 5438353.9495791625 113.00660926138735 458878.53781477565
														5438353.966645997 113.00660926138735 458878.5444094137 5438353.947359403 113.05812038774591
														458878.5482541515 5438353.9495791625 113.00660926138735 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7023_151_184941_50392">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5346620907 5438353.964825793 113.05812038774591 458878.5444094137 5438353.947359403
														113.05812038774591 458878.53781477565 5438353.966645997 113.00660926138735 458878.5346620907
														5438353.964825793 113.05812038774591 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7024_99_760278_281715">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55426038144 5438353.953046861 112.90343998284419 458878.61158179713
														5438353.986141396 112.90385705188794 458878.54273988423 5438353.96948951 112.90343998284419
														458878.55426038144 5438353.953046861 112.90343998284419 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7025_1986_522232_280857">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6001802008 5438354.002652692 112.90392278167425 458878.54273988423 5438353.96948951
														112.90343998284419 458878.61158179713 5438353.986141396 112.90385705188794 458878.6001802008
														5438354.002652692 112.90392278167425 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7026_316_776994_2981">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61158179713 5438353.986141396 112.90385705188794 458878.66874371655
														5438354.019143846 112.89890526754328 458878.6001802008 5438354.002652692 112.90392278167425
														458878.61158179713 5438353.986141396 112.90385705188794 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7027_846_61085_106114">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.87155822524 5438354.159332868 112.56801449703344 458878.9077526638
														5438354.1802297365 112.57590818951317 458878.91775266383 5438354.162909228 112.57590818951317
														458878.88155822525 5438354.14201236 112.56801449703344 458878.87155822524 5438354.159332868
														112.56801449703344 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7028_53_407854_190233">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8350508201 5438354.138255307 112.5623600549654 458878.87155822524 5438354.159332868
														112.56801449703344 458878.88155822525 5438354.14201236 112.56801449703344 458878.8450508201
														5438354.120934799 112.5623600549654 458878.8350508201 5438354.138255307 112.5623600549654
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7029_1014_634184_90701">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99176198284 5438354.228732539 112.46856560715797 458878.99047531926
														5438354.227989684 112.47076160156834 458879.0004753193 5438354.210669176 112.47076160156834
														458879.00176198285 5438354.211412031 112.46856560715797 458878.99176198284 5438354.228732539
														112.46856560715797 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7030_687_16395_392959">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99251258577 5438354.2291659005 112.46605990910534 458878.99176198284
														5438354.228732539 112.46856560715797 458879.00176198285 5438354.211412031 112.46856560715797
														458879.0025125858 5438354.211845392 112.46605990910534 458878.99251258577 5438354.2291659005
														112.46605990910534 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7031_157_870850_128067">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5320543807 5438353.9402262205 113.00511543273023 458878.5245309636
														5438353.9589765845 113.00511543273023 458878.5353232311 5438353.942113493 112.95378777484068
														458878.5320543807 5438353.9402262205 113.00511543273023 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7032_1043_304371_292548">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.52721142093 5438353.960524147 112.95378777484068 458878.5353232311 5438353.942113493
														112.95378777484068 458878.5245309636 5438353.9589765845 113.00511543273023 458878.52721142093
														5438353.960524147 112.95378777484068 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7033_1440_449791_392869">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5282271798 5438353.938016585 113.05639160347034 458878.5213926589 5438353.957164683
														113.05639160347034 458878.5320543807 5438353.9402262205 113.00511543273023 458878.5282271798
														5438353.938016585 113.05639160347034 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7034_1868_759985_132323">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5245309636 5438353.9589765845 113.00511543273023 458878.5320543807
														5438353.9402262205 113.00511543273023 458878.5213926589 5438353.957164683 113.05639160347034
														458878.5245309636 5438353.9589765845 113.00511543273023 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7035_23_545638_72514">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5213926589 5438353.957164683 113.05639160347034 458878.5282271798 5438353.938016585
														113.05639160347034 458878.5177970023 5438353.95508873 113.10760818894647 458878.5213926589
														5438353.957164683 113.05639160347034 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7036_222_102715_409036">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6093328441 5438353.984842963 112.64604219278061 458878.6169167238 5438353.989221517
														112.6445697704089 458878.5878993036 5438353.995562313 112.64604219278061 458878.6093328441
														5438353.984842963 112.64604219278061 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7037_770_880632_8147">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55426038144 5438353.953046861 112.90343998284419 458878.54273988423 5438353.96948951
														112.90343998284419 458878.55153798026 5438353.951475082 112.95504641195686 458878.55426038144
														5438353.953046861 112.90343998284419 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7038_840_774903_17902">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54050751525 5438353.968200651 112.95504641195686 458878.55153798026
														5438353.951475082 112.95504641195686 458878.54273988423 5438353.96948951 112.90343998284419
														458878.54050751525 5438353.968200651 112.95504641195686 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7039_212_68264_61334">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0469770696 5438354.260610985 112.24755869044807 458879.0832981395 5438354.281580964
														112.26484953670353 458879.0932981395 5438354.264260456 112.26484953670353 458879.0569770696
														5438354.2432904765 112.24755869044807 458879.0469770696 5438354.260610985 112.24755869044807
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7040_1097_769400_32081">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99750182003 5438354.232046436 112.23235227409854 458879.0469770696 5438354.260610985
														112.24755869044807 458879.0569770696 5438354.2432904765 112.24755869044807 458879.00750182004
														5438354.214725927 112.23235227409854 458878.99750182003 5438354.232046436 112.23235227409854
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7041_56_94838_72768">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.576007033 5438353.965602296 112.66707273925131 458878.56057213846 5438353.979784966
														112.66707273925131 458878.5708382848 5438353.962618118 112.67364797494583 458878.576007033
														5438353.965602296 112.66707273925131 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7042_1253_55309_16795">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.556333765 5438353.977337941 112.67364797494583 458878.5708382848 5438353.962618118
														112.67364797494583 458878.56057213846 5438353.979784966 112.66707273925131 458878.556333765
														5438353.977337941 112.67364797494583 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7043_1174_356158_177742">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.576007033 5438353.965602296 112.66707273925131 458878.5817757276 5438353.968932854
														112.66120038443588 458878.56057213846 5438353.979784966 112.66707273925131 458878.576007033
														5438353.965602296 112.66707273925131 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7044_567_610128_26871">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5653024681 5438353.982516023 112.66120038443588 458878.56057213846 5438353.979784966
														112.66707273925131 458878.5817757276 5438353.968932854 112.66120038443588 458878.5653024681
														5438353.982516023 112.66120038443588 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7045_321_686653_399822">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5817757276 5438353.968932854 112.66120038443588 458878.5880731183 5438353.9725686535
														112.65610344127417 458878.5653024681 5438353.982516023 112.66120038443588 458878.5817757276
														5438353.968932854 112.66120038443588 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7046_1746_841067_74855">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9670675715 5438354.2144752145 112.35582304945194 458878.95734737056
														5438354.208863254 112.36322933948681 458878.9673473706 5438354.191542746 112.36322933948681
														458878.9770675715 5438354.197154706 112.35582304945194 458878.9670675715 5438354.2144752145
														112.35582304945194 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7047_1364_732254_191296">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.978116639 5438354.220854396 112.35157408719566 458878.9670675715 5438354.2144752145
														112.35582304945194 458878.9770675715 5438354.197154706 112.35582304945194 458878.988116639
														5438354.203533889 112.35157408719566 458878.978116639 5438354.220854396 112.35157408719566
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7048_1365_115588_211584">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8969612872 5438354.173999332 112.21012182337161 458878.94745924783 5438354.203154343
														112.2198640072376 458878.95745924784 5438354.185833835 112.2198640072376 458878.9069612872
														5438354.156678824 112.21012182337161 458878.8969612872 5438354.173999332 112.21012182337161
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7049_1301_620172_72624">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1040289742 5438354.293549917 112.30612769642845 458879.0748420925 5438354.276698863
														112.28279546779674 458879.0848420925 5438354.259378355 112.28279546779674 458879.1140289742
														5438354.276229409 112.30612769642845 458879.1040289742 5438354.293549917 112.30612769642845
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7050_1162_608992_58377">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.12824587733 5438354.307531552 112.33609902354207 458879.1040289742 5438354.293549917
														112.30612769642845 458879.1140289742 5438354.276229409 112.30612769642845 458879.13824587734
														5438354.290211044 112.33609902354207 458879.12824587733 5438354.307531552 112.33609902354207
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7051_837_424888_5839">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8331772167 5438354.137173582 112.58256466777065 458878.797396139 5438354.116515367
														112.57925216011144 458878.807396139 5438354.099194859 112.57925216011144 458878.8431772167
														5438354.119853074 112.58256466777065 458878.8331772167 5438354.137173582 112.58256466777065
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7052_967_456827_271378">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.72562988166 5438354.075081099 112.57925216011144 458878.689848804 5438354.054422884
														112.58256466777065 458878.699848804 5438354.037102376 112.58256466777065 458878.7356298817
														5438354.057760591 112.57925216011144 458878.72562988166 5438354.075081099 112.57925216011144
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7053_1643_809270_110461">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9806201742 5438354.199205803 112.67490671865234 458879.01904397975 5438354.221389797
														112.66586976098391 458878.8923549143 5438354.171339842 112.67490671865234 458878.9806201742
														5438354.199205803 112.67490671865234 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7054_1516_880536_187192">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.92386243486 5438354.189530717 112.66586976098391 458878.8923549143 5438354.171339842
														112.67490671865234 458879.01904397975 5438354.221389797 112.66586976098391 458878.92386243486
														5438354.189530717 112.66586976098391 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7055_51_744561_285250">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.01904397975 5438354.221389797 112.66586976098391 458879.0569770696
														5438354.2432904765 112.65439692439376 458878.92386243486 5438354.189530717 112.66586976098391
														458879.01904397975 5438354.221389797 112.66586976098391 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7056_596_641654_43675">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9549675685 5438354.207489274 112.65439692439376 458878.92386243486 5438354.189530717
														112.66586976098391 458879.0569770696 5438354.2432904765 112.65439692439376 458878.9549675685
														5438354.207489274 112.65439692439376 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7057_1320_605167_357081">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4028083286 5438353.888699989 113.38891767562691 458878.3822922102 5438353.876855002
														113.37281981826137 458878.4112024477 5438353.870452325 113.38578590099745 458878.4028083286
														5438353.888699989 113.38891767562691 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7058_977_399081_207245">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.352247855 5438353.859508885 113.31819468466671 458878.3619194758 5438353.841998788
														113.31657355882856 458878.3650469742 5438353.86689846 113.34869752309066 458878.352247855
														5438353.859508885 113.31819468466671 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7059_1382_228556_67199">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9077526638 5438354.1802297365 112.57590818951317 458878.9435311995 5438354.200886483
														112.58601868288544 458878.9535311994 5438354.183565975 112.58601868288544 458878.91775266383
														5438354.162909228 112.57590818951317 458878.9077526638 5438354.1802297365 112.57590818951317
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7060_1715_603324_311067">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95285807835 5438354.20627136 112.43589340684175 458878.9615693338 5438354.211300805
														112.44481799327936 458878.9715693338 5438354.193980297 112.44481799327936 458878.96285807836
														5438354.188950852 112.43589340684175 458878.95285807835 5438354.20627136 112.43589340684175
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7061_1134_154782_216689">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.946444043 5438354.202568214 112.42466948564913 458878.95285807835 5438354.20627136
														112.43589340684175 458878.96285807836 5438354.188950852 112.43589340684175 458878.956444043
														5438354.185247706 112.42466948564913 458878.946444043 5438354.202568214 112.42466948564913
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7062_1777_678344_386820">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5401839035 5438353.944919803 112.85101042944646 458878.5311971723 5438353.962825322
														112.85101042944646 458878.5417749579 5438353.945838398 112.79957697370547 458878.5401839035
														5438353.944919803 112.85101042944646 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7063_563_533858_117491">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5325018369 5438353.963578571 112.79957697370547 458878.5417749579 5438353.945838398
														112.79957697370547 458878.5311971723 5438353.962825322 112.85101042944646 458878.5325018369
														5438353.963578571 112.79957697370547 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7064_853_451659_245450">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5380332147 5438353.943678102 112.90241673604697 458878.5294336075 5438353.961807127
														112.90241673604697 458878.5401839035 5438353.944919803 112.85101042944646 458878.5380332147
														5438353.943678102 112.90241673604697 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7065_241_809373_256124">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.52343484363 5438353.935249729 113.26348510754019 458878.52951626095
														5438353.938760837 113.21226212473014 458878.5174629432 5438353.954895861 113.26348510754019
														458878.52343484363 5438353.935249729 113.26348510754019 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7066_1623_407719_405401">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1576085616 5438354.324484106 112.49173283175668 458879.1614085257 5438354.326678016
														112.45097780742091 458879.1714085257 5438354.309357508 112.45097780742091 458879.16760856163
														5438354.307163598 112.49173283175668 458879.1576085616 5438354.324484106 112.49173283175668
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7067_791_650374_32976">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1463828379 5438354.318002932 112.53061987947616 458879.1576085616 5438354.324484106
														112.49173283175668 458879.16760856163 5438354.307163598 112.49173283175668 458879.1563828379
														5438354.300682424 112.53061987947616 458879.1463828379 5438354.318002932 112.53061987947616
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7068_1863_839716_129116">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3882988845 5438353.880322957 113.18207206566278 458878.39923068293 5438353.886634434
														113.18550501573131 458878.40923068294 5438353.8693139255 113.18550501573131 458878.3982988845
														5438353.863002449 113.18207206566278 458878.3882988845 5438353.880322957 113.18207206566278
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7069_501_661570_196208">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5294336075 5438353.961807127 112.90241673604697 458878.5380332147 5438353.943678102
														112.90241673604697 458878.52721142093 5438353.960524147 112.95378777484068 458878.5294336075
														5438353.961807127 112.90241673604697 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7070_1883_251646_384100">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5636394161 5438353.958461849 112.65258317709288 458878.5504306927 5438353.9739298
														112.65258317709288 458878.5708769056 5438353.962640416 112.64521563411975 458878.5636394161
														5438353.958461849 112.65258317709288 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7071_1455_649000_53842">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.556365434 5438353.977356224 112.64521563411975 458878.5708769056 5438353.962640416
														112.64521563411975 458878.5504306927 5438353.9739298 112.65258317709288 458878.556365434
														5438353.977356224 112.64521563411975 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7072_1829_276164_261774">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5571546284 5438353.954717856 112.66083256478498 458878.54511316673 5438353.970859725
														112.66083256478498 458878.5636394161 5438353.958461849 112.65258317709288 458878.5571546284
														5438353.954717856 112.66083256478498 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7073_416_162497_288806">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5504306927 5438353.9739298 112.65258317709288 458878.5636394161 5438353.958461849
														112.65258317709288 458878.54511316673 5438353.970859725 112.66083256478498 458878.5504306927
														5438353.9739298 112.65258317709288 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7074_842_192282_286428">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5515026374 5438353.951454677 112.66986190715397 458878.5404785341 5438353.968183919
														112.66986190715397 458878.5571546284 5438353.954717856 112.66083256478498 458878.5515026374
														5438353.951454677 112.66986190715397 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7075_417_174361_49630">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.67444882076 5438354.022437689 112.6381992375189 458878.64129440445 5438354.026389989
														112.6381992375189 458878.7115844694 5438354.043877966 112.64873785949788 458878.67444882076
														5438354.022437689 112.6381992375189 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7076_1405_332938_92086">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6717456364 5438354.043971015 112.64873785949788 458878.7115844694 5438354.043877966
														112.64873785949788 458878.64129440445 5438354.026389989 112.6381992375189 458878.6717456364
														5438354.043971015 112.64873785949788 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7077_113_175649_101479">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.63227362866 5438353.998087831 112.64457345787522 458878.6697783956 5438354.019741218
														112.65779118557873 458878.60671074694 5438354.006423105 112.64457345787522 458878.63227362866
														5438353.998087831 112.64457345787522 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7078_501_564745_99782">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6374646558 5438354.024178882 112.65779118557873 458878.60671074694 5438354.006423105
														112.64457345787522 458878.6697783956 5438354.019741218 112.65779118557873 458878.6374646558
														5438354.024178882 112.65779118557873 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7079_1012_498982_91969">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53781477565 5438353.966645997 113.00660926138735 458878.5482541515
														5438353.9495791625 113.00660926138735 458878.54050751525 5438353.968200651 112.95504641195686
														458878.53781477565 5438353.966645997 113.00660926138735 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7080_787_595410_25462">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61496531765 5438353.988094873 112.62435062044727 458878.5925179319 5438353.998228879
														112.62435062044727 458878.62459892884 5438353.99365684 112.6237338489939 458878.61496531765
														5438353.988094873 112.62435062044727 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7081_680_310389_109246">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6004174931 5438354.002789693 112.6237338489939 458878.62459892884 5438353.99365684
														112.6237338489939 458878.5925179319 5438353.998228879 112.62435062044727 458878.6004174931
														5438354.002789693 112.6237338489939 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7082_873_829217_274176">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60545047035 5438353.982601473 112.62619794327416 458878.58471575717
														5438353.993724291 112.62619794327416 458878.61496531765 5438353.988094873 112.62435062044727
														458878.60545047035 5438353.982601473 112.62619794327416 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7083_722_597630_370293">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7649229604 5438354.097766968 112.66595987399884 458878.8252153524 5438354.109482787
														112.66595987399884 458878.73365434794 5438354.079714027 112.66263938268344 458878.7649229604
														5438354.097766968 112.66595987399884 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7084_1410_232230_274203">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.17247265484 5438354.309971884 112.53911810313281 458879.16247265483
														5438354.327292392 112.53911810313281 458879.14240038616 5438354.315703662 112.57811475552894
														458879.15240038617 5438354.298383154 112.57811475552894 458879.17247265484 5438354.309971884
														112.53911810313281 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7085_1935_808595_374973">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.08321797743 5438354.281534682 112.51434634104907 458879.08882343606
														5438354.284770995 112.48275963543473 458879.09882343607 5438354.267450487 112.48275963543473
														458879.09321797743 5438354.264214174 112.51434634104907 458879.08321797743 5438354.281534682
														112.51434634104907 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7086_1484_569126_73843">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.07072355377 5438354.274321023 112.54318151686166 458879.08321797743
														5438354.281534682 112.51434634104907 458879.09321797743 5438354.264214174 112.51434634104907
														458879.0807235538 5438354.257000515 112.54318151686166 458879.07072355377 5438354.274321023
														112.54318151686166 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7087_245_185513_151406">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.40326927194 5438353.888966114 112.27147915116946 458878.4407592869 5438353.910610984
														112.24755869044807 458878.45075928693 5438353.893290477 112.24755869044807 458878.41326927195
														5438353.871645606 112.27147915116946 458878.40326927194 5438353.888966114 112.27147915116946
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7088_186_366073_401889">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59482142445 5438353.97646479 112.65184486325707 458878.60193729633 5438353.980573141
														112.6484772490391 458878.5759999395 5438353.988692212 112.65184486325707 458878.59482142445
														5438353.97646479 112.65184486325707 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7089_1731_861147_245008">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5841322982 5438353.993387431 112.60562051888634 458878.5497697991 5438353.9735482335
														112.61760571569658 458878.5597697991 5438353.956227725 112.61760571569658 458878.5941322982
														5438353.976066923 112.60562051888634 458878.5841322982 5438353.993387431 112.60562051888634
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7090_1223_129306_92727">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.61899926484 5438354.013517884 112.59576762163951 458878.5841322982 5438353.993387431
														112.60562051888634 458878.5941322982 5438353.976066923 112.60562051888634 458878.62899926485
														5438353.9961973755 112.59576762163951 458878.61899926484 5438354.013517884 112.59576762163951
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7091_84_205308_132320">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1748962217 5438354.334465141 112.49608160499926 458879.16247265483 5438354.327292392
														112.53911810313281 458879.17247265484 5438354.309971884 112.53911810313281 458879.18489622173
														5438354.317144633 112.49608160499926 458879.1748962217 5438354.334465141 112.49608160499926
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7092_775_355846_43732">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1791016618 5438354.336893153 112.45097780742091 458879.1748962217 5438354.334465141
														112.49608160499926 458879.18489622173 5438354.317144633 112.49608160499926 458879.1891016618
														5438354.319572645 112.45097780742091 458879.1791016618 5438354.336893153 112.45097780742091
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7093_1084_231094_299310">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4508307133 5438353.893331715 113.37179024631025 458878.4344524128 5438353.883875698
														113.37364052082247 458878.4453428578 5438353.91325731 113.37759307582735 458878.4508307133
														5438353.893331715 113.37179024631025 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7094_1600_841153_416043">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3881658808 5438353.8571521565 113.33622700687803 458878.37942379864
														5438353.875198924 113.3405609078931 458878.4022618541 5438353.86529047 113.35602320197307
														458878.3881658808 5438353.8571521565 113.33622700687803 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7095_1199_159881_111594">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39429475826 5438353.883784676 113.36127574039503 458878.4022618541 5438353.86529047
														113.35602320197307 458878.37942379864 5438353.875198924 113.3405609078931 458878.39429475826
														5438353.883784676 113.36127574039503 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7096_1664_866272_219180">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3772944638 5438353.850875541 113.31018812583261 458878.36791544116 5438353.868554571
														113.31327644643728 458878.3881658808 5438353.8571521565 113.33622700687803 458878.3772944638
														5438353.850875541 113.31018812583261 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7097_1614_619125_6679">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.69351656065 5438354.056540465 112.21925252136879 458878.6432775685 5438354.027534969
														112.22337523558126 458878.6532775685 5438354.010214461 112.22337523558126 458878.70351656066
														5438354.039219957 112.21925252136879 458878.69351656065 5438354.056540465 112.21925252136879
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7098_1833_706121_106737">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7438681783 5438354.085610985 112.21787725791066 458878.69351656065 5438354.056540465
														112.21925252136879 458878.70351656066 5438354.039219957 112.21925252136879 458878.7538681783
														5438354.068290477 112.21787725791066 458878.7438681783 5438354.085610985 112.21787725791066
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7099_1103_655735_318922">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.41764476994 5438353.897265812 113.20519551375801 458878.42387216893
														5438353.900861203 113.22011118681575 458878.4338721689 5438353.883540695 113.22011118681575
														458878.42764476995 5438353.879945304 113.20519551375801 458878.41764476994 5438353.897265812
														113.20519551375801 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7100_1603_774135_205474">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.40924001793 5438353.892413327 113.1933919932579 458878.41764476994 5438353.897265812
														113.20519551375801 458878.42764476995 5438353.879945304 113.20519551375801 458878.41924001794
														5438353.875092818 113.1933919932579 458878.40924001793 5438353.892413327 113.1933919932579
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7101_1725_76558_325166">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5224497054 5438353.95777497 113.21226212473014 458878.52951626095 5438353.938760837
														113.21226212473014 458878.52697894885 5438353.96038993 113.16095493981646 458878.5224497054
														5438353.95777497 113.21226212473014 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7102_1821_380089_24729">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54000437416 5438353.944816152 113.10957165581146 458878.53104995825
														5438353.962740328 113.10957165581146 458878.53503972856 5438353.941949812 113.16095493981646
														458878.54000437416 5438353.944816152 113.10957165581146 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7103_1219_372467_418630">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.52697894885 5438353.96038993 113.16095493981646 458878.53503972856 5438353.941949812
														113.16095493981646 458878.53104995825 5438353.962740328 113.10957165581146 458878.52697894885
														5438353.96038993 113.16095493981646 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7104_1672_459153_87875">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5224497054 5438353.95777497 113.21226212473014 458878.5174629432 5438353.954895861
														113.26348510754019 458878.52951626095 5438353.938760837 113.21226212473014 458878.5224497054
														5438353.95777497 113.21226212473014 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7105_866_760602_392387">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7078579642 5438354.041726467 112.66859767996945 458878.74639616377 5438354.063976507
														112.67695997327504 458878.6686899021 5438354.042206787 112.66859767996945 458878.7078579642
														5438354.041726467 112.66859767996945 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7106_1724_706013_370530">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.70029122574 5438354.06045182 112.67695997327504 458878.6686899021 5438354.042206787
														112.66859767996945 458878.74639616377 5438354.063976507 112.67695997327504 458878.70029122574
														5438354.06045182 112.67695997327504 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7107_1601_566368_385216">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55153798026 5438353.951475082 112.95504641195686 458878.54050751525
														5438353.968200651 112.95504641195686 458878.5482541515 5438353.9495791625 113.00660926138735
														458878.55153798026 5438353.951475082 112.95504641195686 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7108_1004_348480_382884">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42739020945 5438353.902892344 113.25981842497545 458878.42618452664
														5438353.9021962425 113.26183361788558 458878.43618452665 5438353.884875734 113.26183361788558
														458878.43739020946 5438353.885571836 113.25981842497545 458878.42739020945 5438353.902892344
														113.25981842497545 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7109_11_70293_16883">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99337904225 5438354.229666149 112.2521052769398 458878.9441499047 5438354.201243693
														112.23982000503302 458878.9541499047 5438354.183923185 112.23982000503302 458879.00337904226
														5438354.212345641 112.2521052769398 458878.99337904225 5438354.229666149 112.2521052769398
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7110_1437_539174_369105">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.35400996066 5438353.860526238 112.39822815622148 458878.3520064923 5438353.859369535
														112.44245103569258 458878.36200649233 5438353.842049027 112.44245103569258 458878.3640099607
														5438353.8432057295 112.39822815622148 458878.35400996066 5438353.860526238 112.39822815622148
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7111_1780_639183_237230">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3655517683 5438353.867189904 112.35599786908395 458878.35400996066 5438353.860526238
														112.39822815622148 458878.3640099607 5438353.8432057295 112.39822815622148 458878.3755517683
														5438353.849869396 112.35599786908395 458878.3655517683 5438353.867189904 112.35599786908395
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7112_561_807924_85116">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97716637584 5438354.220305761 112.76089776645604 458878.9285289299 5438354.192224919
														112.79618636023974 458878.98766406 5438354.203272591 112.76070430391375 458878.97716637584
														5438354.220305761 112.76089776645604 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7113_1527_398716_261409">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9198403871 5438354.187208586 112.77851412504398 458878.9672996216 5438354.214609189
														112.7440887152782 458878.9303806359 5438354.170199991 112.7783306157831 458878.9198403871
														5438354.187208586 112.77851412504398 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7114_1180_843877_427685">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.97767703875 5438354.197506582 112.74394046876431 458878.9303806359 5438354.170199991
														112.7783306157831 458878.9672996216 5438354.214609189 112.7440887152782 458878.97767703875
														5438354.197506582 112.74394046876431 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7115_171_155973_258069">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.76151301036 5438354.0957982335 112.5578268324673 458878.79833427473 5438354.117057
														112.55896094444031 458878.80833427474 5438354.099736492 112.55896094444031 458878.7715130103
														5438354.078477725 112.5578268324673 458878.76151301036 5438354.0957982335 112.5578268324673
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7116_1628_101024_306680">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.72469174594 5438354.074539466 112.55896094444031 458878.76151301036
														5438354.0957982335 112.5578268324673 458878.7715130103 5438354.078477725 112.5578268324673
														458878.73469174595 5438354.057218958 112.55896094444031 458878.72469174594 5438354.074539466
														112.55896094444031 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7117_692_387449_47331">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7942197959 5438354.114681505 112.21925252136879 458878.7438681783 5438354.085610985
														112.21787725791066 458878.7538681783 5438354.068290477 112.21787725791066 458878.80421979585
														5438354.0973609965 112.21925252136879 458878.7942197959 5438354.114681505 112.21925252136879
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7118_1102_793651_395758">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.844458788 5438354.1436870005 112.22337523558126 458878.7942197959 5438354.114681505
														112.21925252136879 458878.80421979585 5438354.0973609965 112.21925252136879 458878.854458788
														5438354.126366492 112.22337523558126 458878.844458788 5438354.1436870005 112.22337523558126
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7119_947_826846_108095">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1748962217 5438354.334465141 112.40587400984258 458879.1791016618 5438354.336893153
														112.45097780742091 458879.1891016618 5438354.319572645 112.45097780742091 458879.18489622173
														5438354.317144633 112.40587400984258 458879.1748962217 5438354.334465141 112.40587400984258
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7120_1888_697122_408658">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.16247265483 5438354.327292392 112.36283751170902 458879.1748962217 5438354.334465141
														112.40587400984258 458879.18489622173 5438354.317144633 112.40587400984258 458879.17247265484
														5438354.309971884 112.36283751170902 458879.16247265483 5438354.327292392 112.36283751170902
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7121_1546_542914_77930">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59411808493 5438353.999152727 112.6445697704089 458878.5878993036 5438353.995562313
														112.64604219278061 458878.6169167238 5438353.989221517 112.6445697704089 458878.59411808493
														5438353.999152727 112.6445697704089 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7122_96_325659_329718">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6169167238 5438353.989221517 112.6445697704089 458878.6245952651 5438353.993654725
														112.64407816814373 458878.59411808493 5438353.999152727 112.6445697704089 458878.6169167238
														5438353.989221517 112.6445697704089 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7123_1301_34645_273717">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6004144888 5438354.002787958 112.64407816814373 458878.59411808493 5438353.999152727
														112.6445697704089 458878.6245952651 5438353.993654725 112.64407816814373 458878.6004144888
														5438354.002787958 112.64407816814373 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7124_814_211878_352125">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.11617426487 5438354.277467993 112.62941184178459 458879.10605536395
														5438354.294719853 112.6294775715709 458879.07646492443 5438354.254541795 112.67714783016916
														458879.11617426487 5438354.277467993 112.62941184178459 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7125_1814_314832_282071">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06622289813 5438354.271722569 112.67726793958466 458879.07646492443
														5438354.254541795 112.67714783016916 458879.10605536395 5438354.294719853 112.6294775715709
														458879.06622289813 5438354.271722569 112.67726793958466 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7126_625_223845_358056">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.71072649705 5438354.066476626 112.86883222811511 458878.76521736744
														5438354.097936945 112.85369042683452 458878.7219265996 5438354.049848997 112.86866210224148
														458878.71072649705 5438354.066476626 112.86883222811511 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7127_561_886608_190136">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8252153524 5438354.109482787 112.66595987399884 458878.7649229604 5438354.097766968
														112.66595987399884 458878.8634484111 5438354.131556653 112.6668442114814 458878.8252153524
														5438354.109482787 112.66595987399884 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7128_1212_195795_177634">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7253696173 5438354.051836825 112.88861724694155 458878.7810865076 5438354.084004986
														112.87306075670911 458878.7142176853 5438354.0684922645 112.88878002763349 458878.7253696173
														5438354.051836825 112.88861724694155 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7129_828_17386_12455">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.10605536395 5438354.294719853 112.6294775715709 458879.11617426487 5438354.277467993
														112.62941184178459 458879.14240038616 5438354.315703662 112.57811475552894 458879.10605536395
														5438354.294719853 112.6294775715709 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7130_1196_265613_396270">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1614085257 5438354.326678016 112.45097780742091 458879.1576085616 5438354.324484106
														112.41022278308514 458879.16760856163 5438354.307163598 112.41022278308514 458879.1714085257
														5438354.309357508 112.45097780742091 458879.1614085257 5438354.326678016 112.45097780742091
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7131_625_134131_276953">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9878315947 5438354.226463329 112.45493808377647 458878.98973338166 5438354.227561326
														112.4564237949115 458878.9997333817 5438354.210240818 112.4564237949115 458878.9978315947
														5438354.209142821 112.45493808377647 458878.9878315947 5438354.226463329 112.45493808377647
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7132_939_314461_343759">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3923283734 5438353.8826493835 113.20278410611111 458878.38691251626
														5438353.879522537 113.20108334597481 458878.39691251627 5438353.862202029 113.20108334597481
														458878.4023283734 5438353.865328875 113.20278410611111 458878.3923283734 5438353.8826493835
														113.20278410611111 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7133_1161_107835_298726">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.88986641896 5438354.169903108 112.65489050912929 458878.9775854238 5438354.197453689
														112.65489050912929 458878.8588412358 5438354.15199071 112.66130107371889 458878.88986641896
														5438354.169903108 112.65489050912929 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7134_6_215552_49814">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.94572556676 5438354.202153402 112.34774785178346 458878.95931185153
														5438354.209997447 112.3373958058937 458878.96931185154 5438354.192676939 112.3373958058937
														458878.9557255667 5438354.184832894 112.34774785178346 458878.94572556676 5438354.202153402
														112.34774785178346 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7135_1599_379260_99209">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95931185153 5438354.209997447 112.3373958058937 458878.97475554247 5438354.218913866
														112.33145687397855 458878.9847555425 5438354.201593358 112.33145687397855 458878.96931185154
														5438354.192676939 112.3373958058937 458878.95931185153 5438354.209997447 112.3373958058937
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7136_472_855144_113811">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6686899021 5438354.042206787 112.66859767996945 458878.6374646558 5438354.024178882
														112.65779118557873 458878.7078579642 5438354.041726467 112.66859767996945 458878.6686899021
														5438354.042206787 112.66859767996945 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7137_1297_426032_207719">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06426240375 5438354.247496666 112.6624686517117 458879.0224024961 5438354.223328837
														112.70523483010221 458879.0542005589 5438354.264781468 112.66250131126031 458879.06426240375
														5438354.247496666 112.6624686517117 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7138_1551_218272_202144">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.930485582 5438354.193354593 112.4336250196438 458878.9253423161 5438354.1903851265
														112.41579218137441 458878.93534231605 5438354.173064618 112.41579218137441 458878.940485582
														5438354.1760340845 112.4336250196438 458878.930485582 5438354.193354593 112.4336250196438
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7139_1358_434880_38609">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9844205272 5438354.224493948 112.47415941644546 458878.9821301996 5438354.223171627
														112.47397075006503 458878.99213019956 5438354.205851119 112.47397075006503 458878.9944205272
														5438354.20717344 112.47415941644546 458878.9844205272 5438354.224493948 112.47415941644546
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7140_641_285125_82648">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.41333395434 5438353.894776962 113.2606296260029 458878.4124254011 5438353.894252408
														113.25841634673209 458878.4224254011 5438353.8769319 113.25841634673209 458878.42333395435
														5438353.877456454 113.2606296260029 458878.41333395434 5438353.894776962 113.2606296260029
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7141_935_241157_410512">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06295578176 5438354.269836298 112.39307076772476 458879.04206848185 5438354.25777701
														112.37167195628186 458879.05206848186 5438354.240456502 112.37167195628186 458879.07295578176
														5438354.25251579 112.39307076772476 458879.06295578176 5438354.269836298 112.39307076772476
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7142_1943_222538_139082">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9856615965 5438354.225210479 112.4540713621971 458878.9878315947 5438354.226463329
														112.45493808377647 458878.9978315947 5438354.209142821 112.45493808377647 458878.99566159653
														5438354.207889971 112.4540713621971 458878.9856615965 5438354.225210479 112.4540713621971
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7143_1015_38897_34336">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.04133797454 5438354.257355251 112.26684564710834 458878.99337904225
														5438354.229666149 112.2521052769398 458879.00337904226 5438354.212345641 112.2521052769398
														458879.05133797455 5438354.240034743 112.26684564710834 458879.04133797454 5438354.257355251
														112.26684564710834 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7144_1115_753186_339446">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0748420925 5438354.276698863 112.28279546779674 458879.04133797454 5438354.257355251
														112.26684564710834 458879.05133797455 5438354.240034743 112.26684564710834 458879.0848420925
														5438354.259378355 112.28279546779674 458879.0748420925 5438354.276698863 112.28279546779674
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7145_1681_694406_356384">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.58183495444 5438353.992061059 112.6484772490391 458878.5759999395 5438353.988692212
														112.65184486325707 458878.60193729633 5438353.980573141 112.6484772490391 458878.58183495444
														5438353.992061059 112.6484772490391 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7146_393_351342_321877">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0854194348 5438354.282805694 112.55466221090748 458879.0638134433 5438354.270331469
														112.58278158099661 458879.0738134433 5438354.253010961 112.58278158099661 458879.0954194348
														5438354.265485186 112.55466221090748 458879.0854194348 5438354.282805694 112.55466221090748
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7147_570_620595_326027">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.15240038617 5438354.298383154 112.57811475552894 458879.14240038616
														5438354.315703662 112.57811475552894 458879.11617426487 5438354.277467993 112.62941184178459
														458879.15240038617 5438354.298383154 112.57811475552894 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7148_1030_377272_288647">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54511316673 5438353.970859725 112.66083256478498 458878.5571546284 5438353.954717856
														112.66083256478498 458878.5404785341 5438353.968183919 112.66986190715397 458878.54511316673
														5438353.970859725 112.66083256478498 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7149_1478_498977_218186">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42810311645 5438353.903303941 113.257511569552 458878.42739020945 5438353.902892344
														113.25981842497545 458878.43739020946 5438353.885571836 113.25981842497545 458878.43810311646
														5438353.885983433 113.257511569552 458878.42810311645 5438353.903303941 113.257511569552
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7150_1430_392032_81625">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4274978279 5438353.902954478 113.23712253396157 458878.4282746643 5438353.903402984
														113.25507026000005 458878.4382746643 5438353.886082476 113.25507026000005 458878.4374978279
														5438353.88563397 113.23712253396157 458878.4274978279 5438353.902954478 113.23712253396157
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7151_592_729995_325443">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39816194155 5438353.886017396 113.20738073722909 458878.3923283734
														5438353.8826493835 113.20278410611111 458878.4023283734 5438353.865328875 113.20278410611111
														458878.4081619415 5438353.868696888 113.20738073722909 458878.39816194155 5438353.886017396
														113.20738073722909 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7152_1875_824297_113752">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0848420925 5438354.259378355 112.61916014704508 458879.05137040664 5438354.240053468
														112.63509452825654 458879.014347223 5438354.241772134 112.62678139721265 458879.0848420925
														5438354.259378355 112.61916014704508 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7153_153_879664_3820">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0638134433 5438354.270331469 112.58278158099661 458879.03664087376 5438354.254643379
														112.60348567277614 458879.0466408737 5438354.237322871 112.60348567277614 458879.0738134433
														5438354.253010961 112.58278158099661 458879.0638134433 5438354.270331469 112.58278158099661
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7154_343_745642_9200">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.01709648704 5438354.243359422 112.35724463857852 458878.9897415976 5438354.227566069
														112.35077201247398 458878.99974159756 5438354.210245561 112.35077201247398 458879.02709648705
														5438354.226038914 112.35724463857852 458879.01709648704 5438354.243359422 112.35724463857852
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7155_910_366295_405170">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5907750693 5438353.997222637 112.21012182337161 458878.64161546563 5438354.026575353
														112.20314751362325 458878.6516154656 5438354.009254845 112.20314751362325 458878.6007750693
														5438353.979902129 112.21012182337161 458878.5907750693 5438353.997222637 112.21012182337161
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7156_1562_691674_156282">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3447670914 5438353.8551898645 113.28339002101975 458878.343114485 5438353.854235732
														113.24665541245994 458878.35466815775 5438353.837812237 113.28255086453691 458878.3447670914
														5438353.8551898645 113.28339002101975 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7157_367_146895_230060">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9775854238 5438354.197453689 112.65489050912929 458878.88986641896 5438354.169903108
														112.65489050912929 458879.0150567764 5438354.219087784 112.64607756042787 458878.9775854238
														5438354.197453689 112.65489050912929 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7158_1982_711087_171522">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9205929281 5438354.187643066 112.64607756042787 458879.0150567764 5438354.219087784
														112.64607756042787 458878.88986641896 5438354.169903108 112.65489050912929 458878.9205929281
														5438354.187643066 112.64607756042787 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7159_701_534391_426068">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9753391521 5438354.219250813 112.5971128868175 458879.0023923953 5438354.234870011
														112.59524632338934 458879.0123923953 5438354.217549503 112.59524632338934 458878.9853391521
														5438354.201930306 112.5971128868175 458878.9753391521 5438354.219250813 112.5971128868175
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7160_181_15795_382809">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9435311995 5438354.200886483 112.58601868288544 458878.9753391521 5438354.219250813
														112.5971128868175 458878.9853391521 5438354.201930306 112.5971128868175 458878.9535311994
														5438354.183565975 112.58601868288544 458878.9435311995 5438354.200886483 112.58601868288544
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7161_126_165826_267402">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4112024477 5438353.870452325 113.38578590099745 458878.4330660446 5438353.883075278
														113.3926518011345 458878.4028083286 5438353.888699989 113.38891767562691 458878.4112024477
														5438353.870452325 113.38578590099745 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7162_1665_665030_191455">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42519718984 5438353.901626203 113.39589405281079 458878.4028083286 5438353.888699989
														113.38891767562691 458878.4330660446 5438353.883075278 113.3926518011345 458878.42519718984
														5438353.901626203 113.39589405281079 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7163_624_570119_171296">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.37942379864 5438353.875198924 113.3405609078931 458878.3881658808 5438353.8571521565
														113.33622700687803 458878.36791544116 5438353.868554571 113.31327644643728 458878.37942379864
														5438353.875198924 113.3405609078931 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7164_1814_85518_291980">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.06622289813 5438354.271722569 112.67726793958466 458879.0231653629 5438354.246863289
														112.72117106704236 458879.07646492443 5438354.254541795 112.67714783016916 458879.06622289813
														5438354.271722569 112.67726793958466 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7165_230_90527_86947">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79638361826 5438354.115930788 112.68716426215984 458878.7642356226 5438354.097370134
														112.68625744644296 458878.86358200834 5438354.131633786 112.68716426215984 458878.79638361826
														5438354.115930788 112.68716426215984 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7166_1712_318938_224698">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86358200834 5438354.131633786 112.68716426215984 458878.902770439 5438354.1542592365
														112.68557023503231 458878.79638361826 5438354.115930788 112.68716426215984 458878.86358200834
														5438354.131633786 112.68716426215984 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7167_1034_743822_190036">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8285181314 5438354.134483658 112.68557023503231 458878.79638361826 5438354.115930788
														112.68716426215984 458878.902770439 5438354.1542592365 112.68557023503231 458878.8285181314
														5438354.134483658 112.68557023503231 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7168_494_162366_201980">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.902770439 5438354.1542592365 112.68557023503231 458878.94182287383
														5438354.1768061705 112.68148022801789 458878.8285181314 5438354.134483658 112.68557023503231
														458878.902770439 5438354.1542592365 112.68557023503231 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7169_415_691445_221415">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5704663284 5438353.98549738 112.65610344127417 458878.5653024681 5438353.982516023
														112.66120038443588 458878.5880731183 5438353.9725686535 112.65610344127417 458878.5704663284
														5438353.98549738 112.65610344127417 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7170_280_776680_149736">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.78527542436 5438354.0864234585 112.68285255433791 458878.82437713554
														5438354.108998842 112.68625744644296 458878.7321722194 5438354.07885832 112.68285255433791
														458878.78527542436 5438354.0864234585 112.68285255433791 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7171_93_852790_396764">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7642356226 5438354.097370134 112.68625744644296 458878.7321722194 5438354.07885832
														112.68285255433791 458878.82437713554 5438354.108998842 112.68625744644296 458878.7642356226
														5438354.097370134 112.68625744644296 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7172_955_750801_1681">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.82437713554 5438354.108998842 112.68625744644296 458878.86358200834
														5438354.131633786 112.68716426215984 458878.7642356226 5438354.097370134 112.68625744644296
														458878.82437713554 5438354.108998842 112.68625744644296 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7173_235_498552_325982">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6697783956 5438354.019741218 112.65779118557873 458878.7078579642 5438354.041726467
														112.66859767996945 458878.6374646558 5438354.024178882 112.65779118557873 458878.6697783956
														5438354.019741218 112.65779118557873 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7174_425_782337_64909">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59326357545 5438353.998659377 112.23023617894311 458878.5435864518 5438353.969978276
														112.23982000503302 458878.5535864518 5438353.952657768 112.23982000503302 458878.60326357546
														5438353.981338869 112.23023617894311 458878.59326357545 5438353.998659377 112.23023617894311
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7175_255_111215_154372">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7025636234 5438354.061763789 112.65689286748093 458878.7491673804 5438354.0655764695
														112.65689286748093 458878.6717456364 5438354.043971015 112.64873785949788 458878.7025636234
														5438354.061763789 112.65689286748093 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7176_585_702965_357177">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.12824587733 5438354.307531552 112.56585659129976 458879.13824587734
														5438354.290211044 112.56585659129976 458879.0741368389 5438354.276291684 112.60339887057547
														458879.12824587733 5438354.307531552 112.56585659129976 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7177_1039_780821_123013">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.48211956856 5438353.911396343 113.3463312453695 458878.467021822 5438353.902679656
														113.36278341470529 458878.47809913504 5438353.932169156 113.35071263092671 458878.48211956856
														5438353.911396343 113.3463312453695 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7178_107_499235_349260">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9866751022 5438354.225795628 112.4736571703249 458878.9844205272 5438354.224493948
														112.47415941644546 458878.9944205272 5438354.20717344 112.47415941644546 458878.99667510215
														5438354.208475119 112.4736571703249 458878.9866751022 5438354.225795628 112.4736571703249
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7179_944_24564_151514">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5434371541 5438353.969892079 112.88311520162355 458878.55511071055 5438353.953537799
														112.88311520162355 458878.54451153 5438353.97051237 112.85179812432169 458878.5434371541
														5438353.969892079 112.88311520162355 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7180_1351_795166_421588">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.49023453646 5438353.939175533 112.23235227409854 458878.54027710866
														5438353.968067626 112.2198640072376 458878.5502771087 5438353.950747117 112.2198640072376
														458878.5002345365 5438353.921855025 112.23235227409854 458878.49023453646 5438353.939175533
														112.23235227409854 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7181_1298_564839_95405">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.94745924783 5438354.203154343 112.2198640072376 458878.99750182003 5438354.232046436
														112.23235227409854 458879.00750182004 5438354.214725927 112.23235227409854 458878.95745924784
														5438354.185833835 112.2198640072376 458878.94745924783 5438354.203154343 112.2198640072376
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7182_1537_282173_14942">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59945773147 5438354.002235575 112.88359312605485 458878.6553517015 5438354.034505973
														112.87882172795071 458878.6109776803 5438353.985792609 112.88352168815825 458878.59945773147
														5438354.002235575 112.88359312605485 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7183_855_347571_372250">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.38691251626 5438353.879522537 113.20108334597481 458878.38164349366
														5438353.876480466 113.2016785932235 458878.3916434936 5438353.859159958 113.2016785932235
														458878.39691251627 5438353.862202029 113.20108334597481 458878.38691251626 5438353.879522537
														113.20108334597481 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7184_1541_33040_149217">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42056488216 5438353.898951739 113.26490944384672 458878.41845064604
														5438353.897731084 113.26471135748603 458878.42845064605 5438353.880410576 113.26471135748603
														458878.4305648822 5438353.881631232 113.26490944384672 458878.42056488216 5438353.898951739
														113.26490944384672 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7185_29_10746_341504">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4688451208 5438353.9268263485 112.60004185951513 458878.5069944158 5438353.948851854
														112.60457212509365 458878.5169944158 5438353.9315313455 112.60457212509365 458878.4788451208
														5438353.90950584 112.60004185951513 458878.4688451208 5438353.9268263485 112.60004185951513
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7186_759_502711_83469">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54027710866 5438353.968067626 112.2198640072376 458878.5907750693 5438353.997222637
														112.21012182337161 458878.6007750693 5438353.979902129 112.21012182337161 458878.5502771087
														5438353.950747117 112.2198640072376 458878.54027710866 5438353.968067626 112.2198640072376
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7187_863_348545_167984">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.99224101775 5438354.2290091105 112.46081190763438 458878.99267597566
														5438354.229260233 112.46341526659186 458879.0026759757 5438354.211939725 112.46341526659186
														458879.00224101776 5438354.211688602 112.46081190763438 458878.99224101775 5438354.2290091105
														112.46081190763438 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7188_1244_781065_333633">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.62459892884 5438353.99365684 112.6237338489939 458878.6004174931 5438354.002789693
														112.6237338489939 458878.63537647156 5438353.999879258 112.62442905001742 458878.62459892884
														5438353.99365684 112.6237338489939 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7189_1592_324515_173955">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6092550781 5438354.007892075 112.62442905001742 458878.63537647156 5438353.999879258
														112.62442905001742 458878.6004174931 5438354.002789693 112.6237338489939 458878.6092550781
														5438354.007892075 112.62442905001742 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7190_390_574249_271736">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5134019585 5438353.92945724 113.2098302599803 458878.5092359774 5438353.95014602
														113.2098302599803 458878.51890023215 5438353.93263167 113.15875710045525 458878.5134019585
														5438353.92945724 113.2098302599803 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7191_1381_345469_316674">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9444075288 5438354.201392433 112.38531422678815 458878.9420697167 5438354.200042696
														112.39848777548204 458878.9520697167 5438354.182722188 112.39848777548204 458878.9544075288
														5438354.184071925 112.38531422678815 458878.9444075288 5438354.201392433 112.38531422678815
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7192_12_274403_254598">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.949618452 5438354.20440096 112.37328823087384 458878.9444075288 5438354.201392433
														112.38531422678815 458878.9544075288 5438354.184071925 112.38531422678815 458878.959618452
														5438354.187080452 112.37328823087384 458878.949618452 5438354.20440096 112.37328823087384
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7193_298_495658_318476">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95037010486 5438354.204834928 112.63509452825654 458879.05137040664
														5438354.240053468 112.63509452825654 458878.9205929281 5438354.187643066 112.64607756042787
														458878.95037010486 5438354.204834928 112.63509452825654 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7194_531_808982_76389">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3701168154 5438353.8698255345 113.21121936909082 458878.36487442976
														5438353.866798841 113.22096229747167 458878.3748744298 5438353.849478334 113.22096229747167
														458878.3801168154 5438353.852505026 113.21121936909082 458878.3701168154 5438353.8698255345
														113.21121936909082 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7195_981_290864_163626">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.48832995136 5438353.938075921 113.36059791460721 458878.46946643933
														5438353.927185067 113.38123466580148 458878.49480895424 5438353.918722563 113.35830529646058
														458878.48832995136 5438353.938075921 113.36059791460721 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7196_990_640636_135722">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3616882134 5438353.864959279 112.53687161691172 458878.34288041893 5438353.854100593
														112.49243575422949 458878.3528804189 5438353.836780085 112.49243575422949 458878.37168821343
														5438353.847638771 112.53687161691172 458878.3616882134 5438353.864959279 112.53687161691172
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7197_260_777639_152573">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5092359774 5438353.95014602 113.2098302599803 458878.5134019585 5438353.92945724
														113.2098302599803 458878.50426222174 5438353.947274421 113.26091964227858 458878.5092359774
														5438353.95014602 113.2098302599803 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7198_1681_674257_391734">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.98766406 5438354.203272591 112.76070430391375 458879.0335339281 5438354.229755572
														112.72100828635042 458878.97716637584 5438354.220305761 112.76089776645604 458878.98766406
														5438354.203272591 112.76070430391375 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7199_14_505968_238997">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.654271538 5438354.03388234 112.58807504541825 458878.61899926484 5438354.013517884
														112.59576762163951 458878.62899926485 5438353.9961973755 112.59576762163951 458878.66427153803
														5438354.016561832 112.58807504541825 458878.654271538 5438354.03388234 112.58807504541825
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7200_559_138358_233165">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3711144151 5438353.847307488 113.23341694298324 458878.3611144151 5438353.864627996
														113.23341694298324 458878.3594217223 5438353.86365072 113.24748549766184 458878.3694217223
														5438353.8463302115 113.24748549766184 458878.3711144151 5438353.847307488 113.23341694298324
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7201_1141_675717_312428">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.15240038617 5438354.298383154 112.57811475552894 458879.11617426487
														5438354.277467993 112.62941184178459 458879.07646492443 5438354.254541795 112.67714783016916
														458879.0335339281 5438354.229755572 112.72100828635042 458878.98766406 5438354.203272591
														112.76070430391375 458878.93915746244 5438354.175267295 112.79597440737291 458878.88833364565
														5438354.14592415 112.82658627449457 458878.83552738343 5438354.11543644 112.85233826659224
														458878.7810865076 5438354.084004986 112.87306075670911 458878.7253696173 5438354.051836825
														112.88861724694155 458878.66874371655 5438354.019143846 112.89890526754328 458878.61158179713
														5438353.986141396 112.90385705188794 458878.55426038144 5438353.953046861 112.90343998284419
														458878.55153798026 5438353.951475082 112.95504641195686 458878.5482541515 5438353.9495791625
														113.00660926138735 458878.5444094137 5438353.947359403 113.05812038774591 458878.54000437416
														5438353.944816152 113.10957165581146 458878.53503972856 5438353.941949812 113.16095493981646
														458878.52951626095 5438353.938760837 113.21226212473014 458878.52343484363 5438353.935249729
														113.26348510754019 458878.5191849909 5438353.932796075 113.2988071016635 458878.50942123314
														5438353.927158967 113.331148502306 458878.49480895424 5438353.918722563 113.35830529646058
														458878.476343957 5438353.908061792 113.37842679348436 458878.4552846003 5438353.895903167
														113.39014174660748 458878.4330660446 5438353.883075278 113.3926518011345 458878.4112024477
														5438353.870452325 113.38578590099745 458878.39118377765 5438353.85889454 113.37001194594424
														458878.3743742737 5438353.849189568 113.34640490494405 458878.3619194758 5438353.841998788
														113.31657355882856 458878.35466815775 5438353.837812237 113.28255086453691 458878.353114485
														5438353.836915224 113.24665541245994 458878.35523941135 5438353.83814205 113.22899441539827
														458878.3601212902 5438353.840960605 113.21282371507703 458878.36742742965 5438353.845178806
														113.19924531799974 458878.3766599283 5438353.850509192 113.18918456948785 458878.3871896066
														5438353.856588504 113.18332709292629 458878.3982988845 5438353.863002449 113.18207206566278
														458878.40923068294 5438353.8693139255 113.18550501573131 458878.41924001794 5438353.875092818
														113.1933919932579 458878.42764476995 5438353.879945304 113.20519551375801 458878.4338721689
														5438353.883540695 113.22011118681575 458878.4374978279 5438353.88563397 113.23712253396157
														458878.4382746643 5438353.886082476 113.25507026000005 458878.43810311646 5438353.885983433
														113.257511569552 458878.43739020946 5438353.885571836 113.25981842497545 458878.43618452665
														5438353.884875734 113.26183361788558 458878.4345682333 5438353.883942568 113.26341981621583
														458878.4326514772 5438353.882835927 113.2644689231713 458878.4305648822 5438353.881631232
														113.26490944384672 458878.42845064605 5438353.880410576 113.26471135748603 458878.4264528507
														5438353.879257149 113.2638881633474 458878.4247076424 5438353.878249552 113.26249596075094
														458878.42333395435 5438353.877456454 113.2606296260029 458878.4224254011 5438353.8769319
														113.25841634673209 458878.422043899 5438353.87671164 113.2560069542632 458878.42134492023
														5438353.8763080835 113.23985802072202 458878.41849718085 5438353.874663941 113.2264966198117
														458878.41385316284 5438353.871982716 113.21537341182403 458878.4081619415 5438353.868696888
														113.20738073722909 458878.4023283734 5438353.865328875 113.20278410611111 458878.39691251627
														5438353.862202029 113.20108334597481 458878.3916434936 5438353.859159958 113.2016785932235
														458878.3859820633 5438353.855891329 113.20482794826692 458878.3801168154 5438353.852505026
														113.21121936909082 458878.3748744298 5438353.849478334 113.22096229747167 458878.3711144151
														5438353.847307488 113.23341694298324 458878.3694217223 5438353.8463302115 113.24748549766184
														458878.3708210654 5438353.847138123 113.27981537777646 458878.3772944638 5438353.850875541
														113.31018812583261 458878.3881658808 5438353.8571521565 113.33622700687803 458878.4022618541
														5438353.86529047 113.35602320197307 458878.41810475726 5438353.874437375 113.36850681061764
														458878.4344524128 5438353.883875698 113.37364052082247 458878.4508307133 5438353.893331715
														113.37179024631025 458878.467021822 5438353.902679656 113.36278341470529 458878.48211956856
														5438353.911396343 113.3463312453695 458878.49466809356 5438353.918641238 113.32300991991135
														458878.50330998713 5438353.923630637 113.29438457407855 458878.50733640283 5438353.92595529
														113.26091964227858 458878.5134019585 5438353.92945724 113.2098302599803 458878.51890023215
														5438353.93263167 113.15875710045525 458878.52384223276 5438353.935484935 113.10760818894647
														458878.5282271798 5438353.938016585 113.05639160347034 458878.5320543807 5438353.9402262205
														113.00511543273023 458878.5353232311 5438353.942113493 112.95378777484068 458878.5380332147
														5438353.943678102 112.90241673604697 458878.5401839035 5438353.944919803 112.85101042944646
														458878.5417749579 5438353.945838398 112.79957697370547 458878.5428061266 5438353.946433744
														112.74812449177858 458878.54327832604 5438353.946706369 112.69654320289947 458878.5433495187
														5438353.946747472 112.68876638823272 458878.54675325215 5438353.948712618 112.67955968076224
														458878.5515026374 5438353.951454677 112.66986190715397 458878.5571546284 5438353.954717856
														112.66083256478498 458878.5636394161 5438353.958461849 112.65258317709288 458878.5708769056
														5438353.962640416 112.64521563411975 458878.5787777048 5438353.967201944 112.63882093404527
														458878.5872442292 5438353.972090094 112.63347805924773 458878.59617190703 5438353.977244492
														112.629253000775 458878.60545047035 5438353.982601473 112.62619794327416 458878.61496531765
														5438353.988094873 112.62435062044727 458878.62459892884 5438353.99365684 112.6237338489939
														458878.63537647156 5438353.999879258 112.62442905001742 458878.67444882076 5438354.022437689
														112.6381992375189 458878.7115844694 5438354.043877966 112.64873785949788 458878.7491673804
														5438354.0655764695 112.65689286748093 458878.7870828982 5438354.087467004 112.66263938268344
														458878.8252153524 5438354.109482787 112.66595987399884 458878.8634484111 5438354.131556653
														112.6668442114814 458878.9016654352 5438354.153621263 112.66528969725006 458878.9397498346
														5438354.175609301 112.66130107371889 458878.9775854238 5438354.197453689 112.65489050912929
														458879.0150567764 5438354.219087784 112.64607756042787 458879.05137040664 5438354.240053468
														112.63509452825654 458879.0848420925 5438354.259378355 112.61916014704508 458879.1140289742
														5438354.276229409 112.59582791841339 458879.13824587734 5438354.290211044 112.56585659129976
														458879.1563828379 5438354.300682424 112.53061987947616 458879.16760856163 5438354.307163598
														112.49173283175668 458879.1714085257 5438354.309357508 112.45097780742091 458879.16760856163
														5438354.307163598 112.41022278308514 458879.1563828379 5438354.300682424 112.37133573536566
														458879.13824587734 5438354.290211044 112.33609902354207 458879.1140289742 5438354.276229409
														112.30612769642845 458879.0848420925 5438354.259378355 112.28279546779674 458879.05133797455
														5438354.240034743 112.26684564710834 458879.00337904226 5438354.212345641 112.2521052769398
														458878.9541499047 5438354.183923185 112.23982000503302 458878.90447278105 5438354.1552420845
														112.23023617894313 458878.854458788 5438354.126366492 112.22337523558126 458878.80421979585
														5438354.0973609965 112.21925252136879 458878.7538681783 5438354.068290477 112.21787725791066
														458878.70351656066 5438354.039219957 112.21925252136879 458878.6532775685 5438354.010214461
														112.22337523558126 458878.60326357546 5438353.981338869 112.23023617894311 458878.5535864518
														5438353.952657768 112.23982000503302 458878.50435731426 5438353.924235312 112.2521052769398
														458878.4573742242 5438353.897109612 112.26654571808225 458878.42373882455 5438353.877690205
														112.28800674594528 458878.3958945813 5438353.861614324 112.31845800323498 458878.3755517683
														5438353.849869396 112.35599786908395 458878.3640099607 5438353.8432057295 112.39822815622148
														458878.36200649233 5438353.842049027 112.44245103569258 458878.36966935236 5438353.846473181
														112.48584138427893 458878.3865090086 5438353.856195561 112.52562726395412 458878.4114496806
														5438353.870595065 112.55926700366967 458878.44289806485 5438353.888751797 112.5846115708238
														458878.4788451208 5438353.90950584 112.60004185951513 458878.5169944158 5438353.9315313455
														112.60457212509365 458878.5558841312 5438353.953984333 112.59774165839302 458878.5894948212
														5438353.973389475 112.58601868288544 458878.62527335685 5438353.9940462215 112.57590818951317
														458878.66146779543 5438354.01494309 112.56801449703344 458878.6979752006 5438354.0360206505
														112.5623600549654 458878.73469174595 5438354.057218958 112.55896094444031 458878.7715130103
														5438354.078477725 112.5578268324673 458878.80833427474 5438354.099736492 112.55896094444031
														458878.8450508201 5438354.120934799 112.5623600549654 458878.88155822525 5438354.14201236
														112.56801449703344 458878.91775266383 5438354.162909228 112.57590818951317 458878.9535311994
														5438354.183565975 112.58601868288544 458878.9853391521 5438354.201930306 112.5971128868175
														458879.0123923953 5438354.217549503 112.59524632338934 458879.0388851538 5438354.232845104
														112.58505842921791 458879.06219163944 5438354.24630111 112.56730009329327 458879.0807235538
														5438354.257000515 112.54318151686166 458879.09321797743 5438354.264214174 112.51434634104907
														458879.09882343607 5438354.267450487 112.48275963543473 458879.09715792693 5438354.266488905
														112.45057398180677 458879.0883349518 5438354.261394958 112.41998277927061 458879.07295578176
														5438354.25251579 112.39307076772476 458879.05206848186 5438354.240456502 112.37167195628186
														458879.02709648705 5438354.226038914 112.35724463857852 458878.99974159756 5438354.210245561
														112.35077201247398 458878.988116639 5438354.203533889 112.35157408719566 458878.9770675715
														5438354.197154706 112.35582304945194 458878.9673473706 5438354.191542746 112.36322933948681
														458878.959618452 5438354.187080452 112.37328823087384 458878.9544075288 5438354.184071925
														112.38531422678815 458878.9520697167 5438354.182722188 112.39848777548204 458878.95276433375
														5438354.183123225 112.41191112138236 458878.956444043 5438354.185247706 112.42466948564913
														458878.96285807836 5438354.188950852 112.43589340684175 458878.9715693338 5438354.193980297
														112.44481799327936 458878.98198415176 5438354.199993296 112.45083504914481 458878.99566159653
														5438354.207889971 112.4540713621971 458878.9978315947 5438354.209142821 112.45493808377647
														458878.9997333817 5438354.210240818 112.4564237949115 458879.0012373537 5438354.211109136
														112.45842724684357 458879.00224101776 5438354.211688602 112.46081190763438 458879.0026759757
														5438354.211939725 112.46341526659186 458879.0025125858 5438354.211845392 112.46605990910534
														458879.00176198285 5438354.211412031 112.46856560715797 458879.0004753193 5438354.210669176
														112.47076160156834 458878.998740279 5438354.20966745 112.47249823894646 458878.99667510215
														5438354.208475119 112.4736571703249 458878.9944205272 5438354.20717344 112.47415941644546
														458878.99213019956 5438354.205851119 112.47397075006503 458878.9761839379 5438354.19664454
														112.47019759684021 458878.9616267611 5438354.18823995 112.46178733500233 458878.9494507167
														5438354.181210108 112.44931310999703 458878.940485582 5438354.1760340845 112.4336250196438
														458878.93534231605 5438354.173064618 112.41579218137441 458878.934371424 5438354.172504074
														112.39702987364677 458878.9376390706 5438354.17439065 112.37861671672633 458878.944922571
														5438354.178595781 112.36180753682802 458878.9557255667 5438354.184832894 112.34774785178346
														458878.96931185154 5438354.192676939 112.3373958058937 458878.9847555425 5438354.201593358
														112.33145687397855 458879.0010041776 5438354.210974513 112.33033578443348 458879.03289670095
														5438354.229387669 112.33788209088314 458879.06201105454 5438354.246196849 112.35470261455889
														458879.0863631434 5438354.260256534 112.37965106456948 458879.1042934128 5438354.27060858
														112.41102724527593 458879.11457994463 5438354.276547512 112.44669292181471 458879.1165217287
														5438354.277668602 112.48421753727 458879.1099864356 5438354.273895448 112.52104385111089
														458879.0954194348 5438354.265485186 112.55466221090748 458879.0738134433 5438354.253010961
														112.58278158099661 458879.0466408737 5438354.237322871 112.60348567277614 458879.01575349184
														5438354.219490033 112.61536353660645 458878.9832562216 5438354.200727725 112.61760571569658
														458878.9488937225 5438354.180888527 112.60562051888634 458878.91402675584 5438354.160758074
														112.59576762163951 458878.87875448266 5438354.140393618 112.58807504541825 458878.8431772167
														5438354.119853074 112.58256466777065 458878.807396139 5438354.099194859 112.57925216011144
														458878.7715130103 5438354.078477725 112.57814694315266 458878.7356298817 5438354.057760591
														112.57925216011144 458878.699848804 5438354.037102376 112.58256466777065 458878.66427153803
														5438354.016561832 112.58807504541825 458878.62899926485 5438353.9961973755 112.59576762163951
														458878.5941322982 5438353.976066923 112.60562051888634 458878.5597697991 5438353.956227725
														112.61760571569658 458878.5174241299 5438353.931779441 112.62504317520589 458878.4748161281
														5438353.9071797 112.6199834338905 458878.4346677525 5438353.884000025 112.60274972698157
														458878.3995438317 5438353.86372122 112.57444300824127 458878.37168821343 5438353.847638771
														112.53687161691172 458878.3528804189 5438353.836780085 112.49243575422949 458878.3443219605
														5438353.831838857 112.44397414957832 458878.3465595846 5438353.83313075 112.39458271182116
														458878.3594503434 5438353.840573234 112.34741675104325 458878.3821707269 5438353.853690852
														112.30548940552285 458878.41326927195 5438353.871645606 112.27147915116946 458878.45075928693
														5438353.893290477 112.24755869044807 458878.5002345365 5438353.921855025 112.23235227409854
														458878.5502771087 5438353.950747117 112.2198640072376 458878.6007750693 5438353.979902129
														112.21012182337161 458878.6516154656 5438354.009254845 112.20314751362325 458878.7026845787
														5438354.038739611 112.19895667798953 458878.7538681783 5438354.068290477 112.19755869044807
														458878.8050517778 5438354.097841341 112.19895667798953 458878.85612089093 5438354.127326108
														112.20314751362325 458878.9069612872 5438354.156678824 112.21012182337161 458878.95745924784
														5438354.185833835 112.2198640072376 458879.00750182004 5438354.214725927 112.23235227409854
														458879.0569770696 5438354.2432904765 112.24755869044807 458879.0932981395 5438354.264260456
														112.26484953670353 458879.1255994134 5438354.282909605 112.29067143558367 458879.15240038617
														5438354.298383154 112.3238408593129 458879.17247265484 5438354.309971884 112.36283751170902
														458879.18489622173 5438354.317144633 112.40587400984258 458879.1891016618 5438354.319572645
														112.45097780742091 458879.18489622173 5438354.317144633 112.49608160499926 458879.17247265484
														5438354.309971884 112.53911810313281 458879.15240038617 5438354.298383154 112.57811475552894
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
											<gml:interior>
												<gml:LinearRing>
													<gml:posList>458878.55511071055 5438353.953537799 112.88311520162355 458878.5585747434 5438353.95553776
														112.88314040583125 458878.6109776803 5438353.985792609 112.88352168815825 458878.6667134627
														5438354.017971678 112.87869344625032 458878.7219265996 5438354.049848997 112.86866210224148
														458878.7762534051 5438354.081214593 112.85349373204347 458878.8293360314 5438354.111861862
														112.83328824887725 458878.8808248263 5438354.141588931 112.80817874515006 458878.9303806359
														5438354.170199991 112.7783306157831 458878.97767703875 5438354.197506582 112.74394046876431
														458879.0224024961 5438354.223328837 112.70523483010221 458879.06426240375 5438354.247496666
														112.6624686517117 458879.0801559131 5438354.256672788 112.64336250771833 458879.0569770696
														5438354.2432904765 112.65439692439376 458879.01904397975 5438354.221389797 112.66586976098391
														458878.9806201742 5438354.199205803 112.67490671865234 458878.94182287383 5438354.1768061705
														112.68148022801789 458878.902770439 5438354.1542592365 112.68557023503231 458878.86358200834
														5438354.131633786 112.68716426215984 458878.82437713554 5438354.108998842 112.68625744644296
														458878.78527542436 5438354.0864234585 112.68285255433791 458878.74639616377 5438354.063976507
														112.67695997327504 458878.7078579642 5438354.041726467 112.66859767996945 458878.6697783956
														5438354.019741218 112.65779118557873 458878.63227362866 5438353.998087831 112.64457345787522
														458878.6245952651 5438353.993654725 112.64407816814373 458878.6169167238 5438353.989221517
														112.6445697704089 458878.6093328441 5438353.984842963 112.64604219278061 458878.60193729633
														5438353.980573141 112.6484772490391 458878.59482142445 5438353.97646479 112.65184486325707
														458878.5880731183 5438353.9725686535 112.65610344127417 458878.5817757276 5438353.968932854
														112.66120038443588 458878.576007033 5438353.965602296 112.66707273925131 458878.5708382848
														5438353.962618118 112.67364797494583 458878.5663333234 5438353.960017177 112.68084487930514
														458878.56254779064 5438353.957831599 112.6885745617454 458878.55952844244 5438353.956088378
														112.69674155122098 458878.5590551636 5438353.95581513 112.74844074682568 458878.55801926995
														5438353.955217057 112.80012899225716 458878.5564209251 5438353.954294251 112.85179812432169
														458878.55511071055 5438353.953537799 112.88311520162355 </gml:posList>
												</gml:LinearRing>
											</gml:interior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7202_600_70863_15844">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4473742242 5438353.91443012 112.26654571808225 458878.41373882454 5438353.8950107135
														112.28800674594528 458878.42373882455 5438353.877690205 112.28800674594528 458878.4573742242
														5438353.897109612 112.26654571808225 458878.4473742242 5438353.91443012 112.26654571808225
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7203_1392_249835_252502">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5311971723 5438353.962825322 112.85101042944646 458878.5401839035 5438353.944919803
														112.85101042944646 458878.5294336075 5438353.961807127 112.90241673604697 458878.5311971723
														5438353.962825322 112.85101042944646 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7204_213_869145_239884">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5434371541 5438353.969892079 112.88311520162355 458878.5469107114 5438353.971897538
														112.8831448353398 458878.55511071055 5438353.953537799 112.88311520162355 458878.5434371541
														5438353.969892079 112.88311520162355 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7205_725_247816_368084">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0231653629 5438354.246863289 112.72117106704236 458878.97716637584 5438354.220305761
														112.76089776645604 458879.0335339281 5438354.229755572 112.72100828635042 458879.0231653629
														5438354.246863289 112.72117106704236 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7206_393_814610_172130">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5353232311 5438353.942113493 112.95378777484068 458878.52721142093 5438353.960524147
														112.95378777484068 458878.5380332147 5438353.943678102 112.90241673604697 458878.5353232311
														5438353.942113493 112.95378777484068 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7207_1996_883687_28146">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.76521736744 5438354.097936945 112.85369042683452 458878.81846538424
														5438354.128679701 112.83349606232185 458878.7762534051 5438354.081214593 112.85349373204347
														458878.76521736744 5438354.097936945 112.85369042683452 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7208_177_31995_73593">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.462308498 5438353.923052427 113.36805849146991 458878.47809913504 5438353.932169156
														113.35071263092671 458878.467021822 5438353.902679656 113.36278341470529 458878.462308498
														5438353.923052427 113.36805849146991 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7209_1709_632633_27459">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9243714241 5438354.189824582 112.39702987364677 458878.9276390706 5438354.1917111585
														112.37861671672633 458878.9376390706 5438354.17439065 112.37861671672633 458878.934371424
														5438354.172504074 112.39702987364677 458878.9243714241 5438354.189824582 112.39702987364677
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7210_1739_399907_327724">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.86875448265 5438354.157714126 112.58807504541825 458878.8331772167 5438354.137173582
														112.58256466777065 458878.8431772167 5438354.119853074 112.58256466777065 458878.87875448266
														5438354.140393618 112.58807504541825 458878.86875448265 5438354.157714126 112.58807504541825
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7211_699_154169_323719">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4943573143 5438353.94155582 112.2521052769398 458878.4473742242 5438353.91443012
														112.26654571808225 458878.4573742242 5438353.897109612 112.26654571808225 458878.50435731426
														5438353.924235312 112.2521052769398 458878.4943573143 5438353.94155582 112.2521052769398
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7212_48_368891_417307">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9394507167 5438354.198530615 112.44931310999703 458878.930485582 5438354.193354593
														112.4336250196438 458878.940485582 5438354.1760340845 112.4336250196438 458878.9494507167
														5438354.181210108 112.44931310999703 458878.9394507167 5438354.198530615 112.44931310999703
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7213_1600_862022_129686">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7219265996 5438354.049848997 112.86866210224148 458878.6667134627 5438354.017971678
														112.87869344625032 458878.71072649705 5438354.066476626 112.86883222811511 458878.7219265996
														5438354.049848997 112.86866210224148 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7214_1864_296625_45795">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9912373537 5438354.228429644 112.45842724684357 458878.99224101775
														5438354.2290091105 112.46081190763438 458879.00224101776 5438354.211688602 112.46081190763438
														458879.0012373537 5438354.211109136 112.45842724684357 458878.9912373537 5438354.228429644
														112.45842724684357 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7215_147_224324_213077">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3365595846 5438353.850451258 112.39458271182116 458878.3494503434 5438353.857893742
														112.34741675104325 458878.3594503434 5438353.840573234 112.34741675104325 458878.3465595846
														5438353.83313075 112.39458271182116 458878.3365595846 5438353.850451258 112.39458271182116
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7216_453_569066_167998">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3343219605 5438353.8491593655 112.44397414957832 458878.3365595846 5438353.850451258
														112.39458271182116 458878.3465595846 5438353.83313075 112.39458271182116 458878.3443219605
														5438353.831838857 112.44397414957832 458878.3343219605 5438353.8491593655 112.44397414957832
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7217_1621_417486_113619">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8634484111 5438354.131556653 112.6668442114814 458878.79627406853 5438354.115867539
														112.6668442114814 458878.9016654352 5438354.153621263 112.66528969725006 458878.8634484111
														5438354.131556653 112.6668442114814 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7218_1392_885904_245432">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9910041776 5438354.22829502 112.33033578443348 458879.02289670094 5438354.246708177
														112.33788209088314 458879.03289670095 5438354.229387669 112.33788209088314 458879.0010041776
														5438354.210974513 112.33033578443348 458878.9910041776 5438354.22829502 112.33033578443348
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7219_18_305797_119134">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.37217072694 5438353.871011361 112.30548940552285 458878.40326927194
														5438353.888966114 112.27147915116946 458878.41326927195 5438353.871645606 112.27147915116946
														458878.3821707269 5438353.853690852 112.30548940552285 458878.37217072694 5438353.871011361
														112.30548940552285 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7220_758_478646_379836">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54705969424 5438353.971983553 112.69674155122098 458878.55952844244
														5438353.956088378 112.69674155122098 458878.5495355598 5438353.973412995 112.6885745617454
														458878.54705969424 5438353.971983553 112.69674155122098 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7221_1948_495332_253031">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60193729633 5438353.980573141 112.6484772490391 458878.6093328441 5438353.984842963
														112.64604219278061 458878.58183495444 5438353.992061059 112.6484772490391 458878.60193729633
														5438353.980573141 112.6484772490391 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7222_408_729159_170709">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3520064923 5438353.859369535 112.44245103569258 458878.3596693524 5438353.863793689
														112.48584138427893 458878.36966935236 5438353.846473181 112.48584138427893 458878.36200649233
														5438353.842049027 112.44245103569258 458878.3520064923 5438353.859369535 112.44245103569258
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7223_629_342405_74895">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.73365434794 5438354.079714027 112.66263938268344 458878.7870828982 5438354.087467004
														112.66263938268344 458878.7025636234 5438354.061763789 112.65689286748093 458878.73365434794
														5438354.079714027 112.66263938268344 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7224_1413_57544_369086">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.56254779064 5438353.957831599 112.6885745617454 458878.5495355598 5438353.973412995
														112.6885745617454 458878.55952844244 5438353.956088378 112.69674155122098 458878.56254779064
														5438353.957831599 112.6885745617454 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7225_1718_616278_57710">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.14240038616 5438354.315703662 112.3238408593129 458879.16247265483 5438354.327292392
														112.36283751170902 458879.17247265484 5438354.309971884 112.36283751170902 458879.15240038617
														5438354.298383154 112.3238408593129 458879.14240038616 5438354.315703662 112.3238408593129
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7226_1195_395051_15207">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4453428578 5438353.91325731 113.37759307582735 458878.462308498 5438353.923052427
														113.36805849146991 458878.4508307133 5438353.893331715 113.37179024631025 458878.4453428578
														5438353.91325731 113.37759307582735 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7227_1517_129572_359876">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5137445618 5438353.952749053 113.15875710045525 458878.51890023215 5438353.93263167
														113.15875710045525 458878.5092359774 5438353.95014602 113.2098302599803 458878.5137445618
														5438353.952749053 113.15875710045525 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7228_1177_557496_37920">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.34288041893 5438353.854100593 112.49243575422949 458878.3343219605
														5438353.8491593655 112.44397414957832 458878.3443219605 5438353.831838857 112.44397414957832
														458878.3528804189 5438353.836780085 112.49243575422949 458878.34288041893 5438353.854100593
														112.49243575422949 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7229_1975_811937_265894">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.014347223 5438354.241772134 112.62678139721265 458879.0741368389 5438354.276291684
														112.60339887057547 458879.0848420925 5438354.259378355 112.61916014704508 458879.014347223
														5438354.241772134 112.62678139721265 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7230_42_507156_89364">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6926845787 5438354.0560601195 112.19895667798953 458878.7438681783 5438354.085610985
														112.19755869044807 458878.7538681783 5438354.068290477 112.19755869044807 458878.7026845787
														5438354.038739611 112.19895667798953 458878.6926845787 5438354.0560601195 112.19895667798953
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7231_1347_89458_133735">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.93915746244 5438354.175267295 112.79597440737291 458878.98766406 5438354.203272591
														112.76070430391375 458878.9285289299 5438354.192224919 112.79618636023974 458878.93915746244
														5438354.175267295 112.79597440737291 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7232_377_43163_286643">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9672996216 5438354.214609189 112.7440887152782 458879.01218489784 5438354.240523715
														112.70533268273144 458878.97767703875 5438354.197506582 112.74394046876431 458878.9672996216
														5438354.214609189 112.7440887152782 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7233_1139_586810_205297">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.64161546563 5438354.026575353 112.20314751362325 458878.6926845787
														5438354.0560601195 112.19895667798953 458878.7026845787 5438354.038739611 112.19895667798953
														458878.6516154656 5438354.009254845 112.20314751362325 458878.64161546563 5438354.026575353
														112.20314751362325 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7234_1369_515992_367359">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.74639616377 5438354.063976507 112.67695997327504 458878.78527542436
														5438354.0864234585 112.68285255433791 458878.70029122574 5438354.06045182 112.67695997327504
														458878.74639616377 5438354.063976507 112.67695997327504 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7235_90_849876_114168">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.02289670094 5438354.246708177 112.33788209088314 458879.05201105453
														5438354.263517357 112.35470261455889 458879.06201105454 5438354.246196849 112.35470261455889
														458879.03289670095 5438354.229387669 112.33788209088314 458879.02289670094 5438354.246708177
														112.33788209088314 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7236_1459_524730_176035">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9427643338 5438354.2004437335 112.41191112138236 458878.946444043 5438354.202568214
														112.42466948564913 458878.956444043 5438354.185247706 112.42466948564913 458878.95276433375
														5438354.183123225 112.41191112138236 458878.9427643338 5438354.2004437335 112.41191112138236
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7237_520_540295_208718">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.95037010486 5438354.204834928 112.63509452825654 458879.014347223 5438354.241772134
														112.62678139721265 458879.05137040664 5438354.240053468 112.63509452825654 458878.95037010486
														5438354.204834928 112.63509452825654 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7238_260_24486_378178">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4407592869 5438353.910610984 112.24755869044807 458878.49023453646 5438353.939175533
														112.23235227409854 458878.5002345365 5438353.921855025 112.23235227409854 458878.45075928693
														5438353.893290477 112.24755869044807 458878.4407592869 5438353.910610984 112.24755869044807
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7239_1125_609934_67882">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54327832604 5438353.946706369 112.69654320289947 458878.5337345988 5438353.964290306
														112.69654320289947 458878.5433495187 5438353.946747472 112.68876638823272 458878.54327832604
														5438353.946706369 112.69654320289947 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7240_302_333072_92892">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.40385316283 5438353.889303224 113.21537341182403 458878.39816194155
														5438353.886017396 113.20738073722909 458878.4081619415 5438353.868696888 113.20738073722909
														458878.41385316284 5438353.871982716 113.21537341182403 458878.40385316283 5438353.889303224
														113.21537341182403 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7241_1704_874228_235280">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42387216893 5438353.900861203 113.22011118681575 458878.4274978279 5438353.902954478
														113.23712253396157 458878.4374978279 5438353.88563397 113.23712253396157 458878.4338721689
														5438353.883540695 113.22011118681575 458878.42387216893 5438353.900861203 113.22011118681575
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7242_214_252927_90502">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.76151301036 5438354.0957982335 112.57814694315266 458878.72562988166
														5438354.075081099 112.57925216011144 458878.7356298817 5438354.057760591 112.57925216011144
														458878.7715130103 5438354.078477725 112.57814694315266 458878.76151301036 5438354.0957982335
														112.57814694315266 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7243_1853_104812_152375">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9821301996 5438354.223171627 112.47397075006503 458878.9661839379 5438354.213965048
														112.47019759684021 458878.9761839379 5438354.19664454 112.47019759684021 458878.99213019956
														5438354.205851119 112.47397075006503 458878.9821301996 5438354.223171627 112.47397075006503
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7244_161_91987_282847">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9615693338 5438354.211300805 112.44481799327936 458878.9719841518 5438354.217313803
														112.45083504914481 458878.98198415176 5438354.199993296 112.45083504914481 458878.9715693338
														5438354.193980297 112.44481799327936 458878.9615693338 5438354.211300805 112.44481799327936
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7245_1996_228255_420791">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79833427473 5438354.117057 112.55896094444031 458878.8350508201 5438354.138255307
														112.5623600549654 458878.8450508201 5438354.120934799 112.5623600549654 458878.80833427474
														5438354.099736492 112.55896094444031 458878.79833427473 5438354.117057 112.55896094444031
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7246_1627_175650_331494">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7870828982 5438354.087467004 112.66263938268344 458878.73365434794 5438354.079714027
														112.66263938268344 458878.8252153524 5438354.109482787 112.66595987399884 458878.7870828982
														5438354.087467004 112.66263938268344 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7247_1074_880480_389220">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0224024961 5438354.223328837 112.70523483010221 458878.97767703875 5438354.197506582
														112.74394046876431 458879.01218489784 5438354.240523715 112.70533268273144 458879.0224024961
														5438354.223328837 112.70523483010221 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7248_1418_549715_277571">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6879752006 5438354.053341159 112.5623600549654 458878.72469174594 5438354.074539466
														112.55896094444031 458878.73469174595 5438354.057218958 112.55896094444031 458878.6979752006
														5438354.0360206505 112.5623600549654 458878.6879752006 5438354.053341159 112.5623600549654
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7249_633_292008_373467">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42815462156 5438353.903333678 113.37961516279621 458878.4453428578 5438353.91325731
														113.37759307582735 458878.4344524128 5438353.883875698 113.37364052082247 458878.42815462156
														5438353.903333678 113.37961516279621 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7250_98_726968_273209">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.79627406853 5438354.115867539 112.6668442114814 458878.8634484111 5438354.131556653
														112.6668442114814 458878.7649229604 5438354.097766968 112.66595987399884 458878.79627406853
														5438354.115867539 112.6668442114814 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7251_209_681214_86525">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6553517015 5438354.034505973 112.87882172795071 458878.71072649705 5438354.066476626
														112.86883222811511 458878.6667134627 5438354.017971678 112.87869344625032 458878.6553517015
														5438354.034505973 112.87882172795071 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7252_796_358631_388149">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4330660446 5438353.883075278 113.3926518011345 458878.4552846003 5438353.895903167
														113.39014174660748 458878.42519718984 5438353.901626203 113.39589405281079 458878.4330660446
														5438353.883075278 113.3926518011345 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7253_514_333611_122175">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.08882343606 5438354.284770995 112.48275963543473 458879.08715792693
														5438354.283809413 112.45057398180677 458879.09715792693 5438354.266488905 112.45057398180677
														458879.09882343607 5438354.267450487 112.48275963543473 458879.08882343606 5438354.284770995
														112.48275963543473 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7254_1718_543241_233305">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.42466775246 5438353.901320533 112.60274972698157 458878.3895438317 5438353.881041728
														112.57444300824127 458878.3995438317 5438353.86372122 112.57444300824127 458878.4346677525
														5438353.884000025 112.60274972698157 458878.42466775246 5438353.901320533 112.60274972698157
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7255_1523_755894_202534">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.39118377765 5438353.85889454 113.37001194594424 458878.3822922102 5438353.876855002
														113.37281981826137 458878.3743742737 5438353.849189568 113.34640490494405 458878.39118377765
														5438353.85889454 113.37001194594424 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7256_640_279451_103365">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.01218489784 5438354.240523715 112.70533268273144 458879.0542005589 5438354.264781468
														112.66250131126031 458879.0224024961 5438354.223328837 112.70523483010221 458879.01218489784
														5438354.240523715 112.70533268273144 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7257_916_663183_388148">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9516267611 5438354.205560458 112.46178733500233 458878.9394507167 5438354.198530615
														112.44931310999703 458878.9494507167 5438354.181210108 112.44931310999703 458878.9616267611
														5438354.18823995 112.46178733500233 458878.9516267611 5438354.205560458 112.46178733500233
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7258_1697_660703_160608">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.60671074694 5438354.006423105 112.64457345787522 458878.6004144888 5438354.002787958
														112.64407816814373 458878.63227362866 5438353.998087831 112.64457345787522 458878.60671074694
														5438354.006423105 112.64457345787522 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7259_941_49967_101607">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6245952651 5438353.993654725 112.64407816814373 458878.63227362866 5438353.998087831
														112.64457345787522 458878.6004144888 5438354.002787958 112.64407816814373 458878.6245952651
														5438353.993654725 112.64407816814373 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7260_1842_794905_387681">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5444094137 5438353.947359403 113.05812038774591 458878.5346620907 5438353.964825793
														113.05812038774591 458878.54000437416 5438353.944816152 113.10957165581146 458878.5444094137
														5438353.947359403 113.05812038774591 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7261_688_534602_253578">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1463828379 5438354.318002932 112.37133573536566 458879.12824587733 5438354.307531552
														112.33609902354207 458879.13824587734 5438354.290211044 112.33609902354207 458879.1563828379
														5438354.300682424 112.37133573536566 458879.1463828379 5438354.318002932 112.37133573536566
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7262_316_39995_222004">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1576085616 5438354.324484106 112.41022278308514 458879.1463828379 5438354.318002932
														112.37133573536566 458879.1563828379 5438354.300682424 112.37133573536566 458879.16760856163
														5438354.307163598 112.41022278308514 458879.1576085616 5438354.324484106 112.41022278308514
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7263_693_836673_270306">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.56284408934 5438353.981096678 112.63882093404527 458878.5787777048 5438353.967201944
														112.63882093404527 458878.556365434 5438353.977356224 112.64521563411975 458878.56284408934
														5438353.981096678 112.63882093404527 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7264_32_559501_225786">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5433495187 5438353.946747472 112.68876638823272 458878.53379297675 5438353.964324011
														112.68876638823272 458878.54675325215 5438353.948712618 112.67955968076224 458878.5433495187
														5438353.946747472 112.68876638823272 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7265_189_830934_195886">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.53658403823 5438353.9659354305 112.67955968076224 458878.54675325215
														5438353.948712618 112.67955968076224 458878.53379297675 5438353.964324011 112.68876638823272
														458878.53658403823 5438353.9659354305 112.67955968076224 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7266_1030_436836_365422">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8701198058 5438354.158502395 112.80838215374645 458878.9198403871 5438354.187208586
														112.77851412504398 458878.8808248263 5438354.141588931 112.80817874515006 458878.8701198058
														5438354.158502395 112.80838215374645 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7267_1789_312156_227498">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9303806359 5438354.170199991 112.7783306157831 458878.8808248263 5438354.141588931
														112.80817874515006 458878.9198403871 5438354.187208586 112.77851412504398 458878.9303806359
														5438354.170199991 112.7783306157831 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7268_234_556713_264370">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.81846538424 5438354.128679701 112.83349606232185 458878.8701198058 5438354.158502395
														112.80838215374645 458878.8293360314 5438354.111861862 112.83328824887725 458878.81846538424
														5438354.128679701 112.83349606232185 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7269_397_521495_353375">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.8808248263 5438354.141588931 112.80817874515006 458878.8293360314 5438354.111861862
														112.83328824887725 458878.8701198058 5438354.158502395 112.80838215374645 458878.8808248263
														5438354.141588931 112.80817874515006 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7270_1958_854935_241751">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.50015694357 5438353.944904238 113.2960728026798 458878.50426222174 5438353.947274421
														113.26091964227858 458878.50330998713 5438353.923630637 113.29438457407855 458878.50015694357
														5438353.944904238 113.2960728026798 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7271_1717_138532_254928">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.49466809356 5438353.918641238 113.32300991991135 458878.4911884147 5438353.939726255
														113.32616747743 458878.50330998713 5438353.923630637 113.29438457407855 458878.49466809356
														5438353.918641238 113.32300991991135 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7272_1308_795782_200026">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.50015694357 5438353.944904238 113.2960728026798 458878.50330998713 5438353.923630637
														113.29438457407855 458878.4911884147 5438353.939726255 113.32616747743 458878.50015694357
														5438353.944904238 113.2960728026798 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7273_1333_583383_310138">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.48211956856 5438353.911396343 113.3463312453695 458878.47809913504 5438353.932169156
														113.35071263092671 458878.49466809356 5438353.918641238 113.32300991991135 458878.48211956856
														5438353.911396343 113.3463312453695 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7274_242_160170_171904">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6574652457 5438354.035726228 112.89902537695877 458878.6001802008 5438354.002652692
														112.90392278167425 458878.66874371655 5438354.019143846 112.89890526754328 458878.6574652457
														5438354.035726228 112.89902537695877 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7275_1717_881786_274234">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.66874371655 5438354.019143846 112.89890526754328 458878.7253696173 5438354.051836825
														112.88861724694155 458878.6574652457 5438354.035726228 112.89902537695877 458878.66874371655
														5438354.019143846 112.89890526754328 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7276_1306_782498_16834">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.7142176853 5438354.0684922645 112.88878002763349 458878.6574652457 5438354.035726228
														112.89902537695877 458878.7253696173 5438354.051836825 112.88861724694155 458878.7142176853
														5438354.0684922645 112.88878002763349 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7277_1056_280550_38804">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.89447278104 5438354.172562593 112.23023617894313 458878.844458788 5438354.1436870005
														112.22337523558126 458878.854458788 5438354.126366492 112.22337523558126 458878.90447278105
														5438354.1552420845 112.23023617894313 458878.89447278104 5438354.172562593 112.23023617894313
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7278_710_832214_298552">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9441499047 5438354.201243693 112.23982000503302 458878.89447278104 5438354.172562593
														112.23023617894313 458878.90447278105 5438354.1552420845 112.23023617894313 458878.9541499047
														5438354.183923185 112.23982000503302 458878.9441499047 5438354.201243693 112.23982000503302
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7279_1863_761828_369898">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.797396139 5438354.116515367 112.57925216011144 458878.76151301036 5438354.0957982335
														112.57814694315266 458878.7715130103 5438354.078477725 112.57814694315266 458878.807396139
														5438354.099194859 112.57925216011144 458878.797396139 5438354.116515367 112.57925216011144
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7280_1892_511448_394776">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9253423161 5438354.1903851265 112.41579218137441 458878.9243714241 5438354.189824582
														112.39702987364677 458878.934371424 5438354.172504074 112.39702987364677 458878.93534231605
														5438354.173064618 112.41579218137441 458878.9253423161 5438354.1903851265 112.41579218137441
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7281_19_512372_247153">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.00575349183 5438354.236810541 112.61536353660645 458878.97325622156
														5438354.218048234 112.61760571569658 458878.9832562216 5438354.200727725 112.61760571569658
														458879.01575349184 5438354.219490033 112.61536353660645 458879.00575349183 5438354.236810541
														112.61536353660645 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7282_382_599281_326855">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.03664087376 5438354.254643379 112.60348567277614 458879.00575349183
														5438354.236810541 112.61536353660645 458879.01575349184 5438354.219490033 112.61536353660645
														458879.0466408737 5438354.237322871 112.60348567277614 458879.03664087376 5438354.254643379
														112.60348567277614 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7283_530_859538_270298">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9285289299 5438354.192224919 112.79618636023974 458878.87757339706 5438354.162805729
														112.82680440436546 458878.93915746244 5438354.175267295 112.79597440737291 458878.9285289299
														5438354.192224919 112.79618636023974 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7284_118_227158_179657">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3447670914 5438353.8551898645 113.28339002101975 458878.35466815775
														5438353.837812237 113.28255086453691 458878.352247855 5438353.859508885 113.31819468466671
														458878.3447670914 5438353.8551898645 113.28339002101975 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7285_399_146015_91515">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.1140289742 5438354.276229409 112.59582791841339 458879.0741368389 5438354.276291684
														112.60339887057547 458879.13824587734 5438354.290211044 112.56585659129976 458879.1140289742
														5438354.276229409 112.59582791841339 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7286_687_841057_308407">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5925179319 5438353.998228879 112.62435062044727 458878.61496531765 5438353.988094873
														112.62435062044727 458878.58471575717 5438353.993724291 112.62619794327416 458878.5925179319
														5438353.998228879 112.62435062044727 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7287_658_620009_294755">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.59617190703 5438353.977244492 112.629253000775 458878.5771073352 5438353.989331567
														112.629253000775 458878.60545047035 5438353.982601473 112.62619794327416 458878.59617190703
														5438353.977244492 112.629253000775 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7288_774_542611_211960">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.58471575717 5438353.993724291 112.62619794327416 458878.60545047035
														5438353.982601473 112.62619794327416 458878.5771073352 5438353.989331567 112.629253000775
														458878.58471575717 5438353.993724291 112.62619794327416 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7289_1688_810519_398871">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5771073352 5438353.989331567 112.629253000775 458878.59617190703 5438353.977244492
														112.629253000775 458878.5697866394 5438353.985104961 112.63347805924773 458878.5771073352
														5438353.989331567 112.629253000775 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7290_1243_195871_381309">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5787777048 5438353.967201944 112.63882093404527 458878.56284408934 5438353.981096678
														112.63882093404527 458878.5872442292 5438353.972090094 112.63347805924773 458878.5787777048
														5438353.967201944 112.63882093404527 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7291_721_463110_23839">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5697866394 5438353.985104961 112.63347805924773 458878.5872442292 5438353.972090094
														112.63347805924773 458878.56284408934 5438353.981096678 112.63882093404527 458878.5697866394
														5438353.985104961 112.63347805924773 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7292_191_411597_169507">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5708769056 5438353.962640416 112.64521563411975 458878.556365434 5438353.977356224
														112.64521563411975 458878.5787777048 5438353.967201944 112.63882093404527 458878.5708769056
														5438353.962640416 112.64521563411975 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7293_1917_456384_329520">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5708382848 5438353.962618118 112.67364797494583 458878.556333765 5438353.977337941
														112.67364797494583 458878.5663333234 5438353.960017177 112.68084487930514 458878.5708382848
														5438353.962618118 112.67364797494583 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7294_508_210909_49328">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.55263969663 5438353.975205169 112.68084487930514 458878.5663333234 5438353.960017177
														112.68084487930514 458878.556333765 5438353.977337941 112.67364797494583 458878.55263969663
														5438353.975205169 112.68084487930514 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7295_1623_529220_149478">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.51890023215 5438353.93263167 113.15875710045525 458878.5137445618 5438353.952749053
														113.15875710045525 458878.52384223276 5438353.935484935 113.10760818894647 458878.51890023215
														5438353.93263167 113.15875710045525 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7296_1312_602184_150110">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5177970023 5438353.95508873 113.10760818894647 458878.52384223276 5438353.935484935
														113.10760818894647 458878.5137445618 5438353.952749053 113.15875710045525 458878.5177970023
														5438353.95508873 113.10760818894647 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7297_1649_542988_198774">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3743742737 5438353.849189568 113.34640490494405 458878.3650469742 5438353.86689846
														113.34869752309066 458878.3619194758 5438353.841998788 113.31657355882856 458878.3743742737
														5438353.849189568 113.34640490494405 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7298_1356_174949_380405">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6667134627 5438354.017971678 112.87869344625032 458878.6109776803 5438353.985792609
														112.88352168815825 458878.6553517015 5438354.034505973 112.87882172795071 458878.6667134627
														5438354.017971678 112.87869344625032 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7299_624_50069_211844">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5469107114 5438353.971897538 112.8831448353398 458878.59945773147 5438354.002235575
														112.88359312605485 458878.5585747434 5438353.95553776 112.88314040583125 458878.5469107114
														5438353.971897538 112.8831448353398 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7300_1029_74651_152195">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.6109776803 5438353.985792609 112.88352168815825 458878.5585747434 5438353.95553776
														112.88314040583125 458878.59945773147 5438354.002235575 112.88359312605485 458878.6109776803
														5438353.985792609 112.88352168815825 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7301_312_82892_204494">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5880731183 5438353.9725686535 112.65610344127417 458878.59482142445 5438353.97646479
														112.65184486325707 458878.5704663284 5438353.98549738 112.65610344127417 458878.5880731183
														5438353.9725686535 112.65610344127417 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7302_1882_355417_338932">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5564209251 5438353.954294251 112.85179812432169 458878.54451153 5438353.97051237
														112.85179812432169 458878.55511071055 5438353.953537799 112.88311520162355 458878.5564209251
														5438353.954294251 112.85179812432169 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7303_1925_756155_350551">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.0999864356 5438354.291215956 112.52104385111089 458879.0854194348 5438354.282805694
														112.55466221090748 458879.0954194348 5438354.265485186 112.55466221090748 458879.1099864356
														5438354.273895448 112.52104385111089 458879.0999864356 5438354.291215956 112.52104385111089
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7304_1732_848961_275539">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5458221728 5438353.97126907 112.80012899225716 458878.55801926995 5438353.955217057
														112.80012899225716 458878.54667160555 5438353.971759491 112.74844074682568 458878.5458221728
														5438353.97126907 112.80012899225716 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7305_808_780681_90385">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.50733640283 5438353.92595529 113.26091964227858 458878.50426222174 5438353.947274421
														113.26091964227858 458878.5134019585 5438353.92945724 113.2098302599803 458878.50733640283
														5438353.92595529 113.26091964227858 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7306_1166_28498_304663">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.05201105453 5438354.263517357 112.35470261455889 458879.0763631434 5438354.277577043
														112.37965106456948 458879.0863631434 5438354.260256534 112.37965106456948 458879.06201105454
														5438354.246196849 112.35470261455889 458879.05201105453 5438354.263517357 112.35470261455889
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7307_358_500872_29038">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458879.05219163943 5438354.263621618 112.56730009329327 458879.07072355377
														5438354.274321023 112.54318151686166 458879.0807235538 5438354.257000515 112.54318151686166
														458879.06219163944 5438354.24630111 112.56730009329327 458879.05219163943 5438354.263621618
														112.56730009329327 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7308_600_124708_331683">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4124254011 5438353.894252408 113.25841634673209 458878.412043899 5438353.894032148
														113.2560069542632 458878.422043899 5438353.87671164 113.2560069542632 458878.4224254011
														5438353.8769319 113.25841634673209 458878.4124254011 5438353.894252408 113.25841634673209
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7309_584_549189_562">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.4328980649 5438353.9060723055 112.5846115708238 458878.4688451208 5438353.9268263485
														112.60004185951513 458878.4788451208 5438353.90950584 112.60004185951513 458878.44289806485
														5438353.888751797 112.5846115708238 458878.4328980649 5438353.9060723055 112.5846115708238
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7310_826_671597_279709">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5191849909 5438353.932796075 113.2988071016635 458878.51317476993 5438353.952420083
														113.29964625814634 458878.50942123314 5438353.927158967 113.331148502306 458878.5191849909
														5438353.932796075 113.2988071016635 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7311_327_520664_120132">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.5032380489 5438353.946683114 113.33276962814415 458878.50942123314 5438353.927158967
														113.331148502306 458878.51317476993 5438353.952420083 113.29964625814634 458878.5032380489
														5438353.946683114 113.33276962814415 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7312_139_310336_420955">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.9016654352 5438354.153621263 112.66528969725006 458878.8276120283 5438354.133960519
														112.66528969725006 458878.9397498346 5438354.175609301 112.66130107371889 458878.9016654352
														5438354.153621263 112.66528969725006 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7313_1993_758021_321999">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.54451153 5438353.97051237 112.85179812432169 458878.5564209251 5438353.954294251
														112.85179812432169 458878.5458221728 5438353.97126907 112.80012899225716 458878.54451153
														5438353.97051237 112.85179812432169 </gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
									<gml:surfaceMember>
										<gml:Polygon gml:id="PolyID7314_60_381725_427108">
											<gml:exterior>
												<gml:LinearRing>
													<gml:posList>458878.3765090086 5438353.873516069 112.52562726395412 458878.4014496806 5438353.887915573
														112.55926700366967 458878.4114496806 5438353.870595065 112.55926700366967 458878.3865090086
														5438353.856195561 112.52562726395412 458878.3765090086 5438353.873516069 112.52562726395412
													</gml:posList>
												</gml:LinearRing>
											</gml:exterior>
										</gml:Polygon>
									</gml:surfaceMember>
								</gml:MultiSurface>
							</bldg:lod4Geometry>
						</bldg:BuildingFurniture>
					</bldg:interiorFurniture>
				</bldg:Room>
			</bldg:interiorRoom>
			<bldg:address>
				<Address>
					<xalAddress>
						<xAL:AddressDetails>
							<xAL:Country>
								<xAL:CountryName>Germany</xAL:CountryName>
								<xAL:Locality Type="Town">
									<xAL:LocalityName>Eggenstein-Leopoldshafen</xAL:LocalityName>
									<xAL:Thoroughfare Type="Street">
										<xAL:ThoroughfareNumber>1</xAL:ThoroughfareNumber>
										<xAL:ThoroughfareName>Hermann-von-Helmholtz-Platz</xAL:ThoroughfareName>
									</xAL:Thoroughfare>
									<xAL:PostalCode>
										<xAL:PostalCodeNumber>76344</xAL:PostalCodeNumber>
									</xAL:PostalCode>
								</xAL:Locality>
							</xAL:Country>
						</xAL:AddressDetails>
					</xalAddress>
					<multiPoint>
						<gml:MultiPoint>
							<gml:pointMember>
								<gml:Point>
									<gml:pos srsDimension="3">458880.0 5438352.6 112.0 </gml:pos>
								</gml:Point>
							</gml:pointMember>
						</gml:MultiPoint>
					</multiPoint>
				</Address>
			</bldg:address>
		</bldg:Building>
	</cityObjectMember>
	<cityObjectMember>
		<dem:ReliefFeature gml:id="GML_6bb30328-7599-4500-90ef-766fde6aa67b">
			<gml:name>Example TIN LOD4</gml:name>
			<dem:lod>3</dem:lod>
			<dem:reliefComponent>
				<dem:TINRelief gml:id="GUID_04D4DsNGv1MfvYu5O3lkcW">
					<gml:name>Ground</gml:name>
					<dem:lod>3</dem:lod>
					<dem:tin>
						<gml:TriangulatedSurface gml:id="ground">
							<gml:trianglePatches>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438362 112 458875 5438355 112 458883 5438362 114 458868 5438362 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458875 5438355 112 458885 5438355 112 458883 5438362 114 458875 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458883 5438362 114 458885 5438355 112 458892 5438362 112 458883 5438362 114 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458885 5438355 112 458885 5438350 112 458892 5438362 112 458885 5438355 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458885 5438350 112 458892 5438343 112 458892 5438362 112 458885 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458875 5438350 112 458892 5438343 112 458885 5438350 112 458875 5438350 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458892 5438343 112 458875 5438350 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458875 5438350 112 458875 5438355 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
								<gml:Triangle>
									<gml:exterior>
										<gml:LinearRing>
											<gml:posList>458868 5438343 112 458875 5438355 112 458868 5438362 112 458868 5438343 112 </gml:posList>
										</gml:LinearRing>
									</gml:exterior>
								</gml:Triangle>
							</gml:trianglePatches>
						</gml:TriangulatedSurface>
					</dem:tin>
				</dem:TINRelief>
			</dem:reliefComponent>
		</dem:ReliefFeature>
	</cityObjectMember>
</CityModel>
