/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.LinkedList;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.CoordType;
import net.opengis.gml.v_3_1_1.DirectPositionType;
import net.opengis.gml.v_3_1_1.LineStringPropertyType;
import net.opengis.gml.v_3_1_1.LineStringType;
import net.opengis.gml.v_3_1_1.PointPropertyType;
import net.opengis.gml.v_3_1_1.PointType;
import org.jvnet.jaxb2_commons.locator.ItemObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.PropertyObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractGML311ToJTSConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSConverterInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSCoordinateConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSPointConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GML311ToJTSLineStringConverter
extends AbstractGML311ToJTSConverter<LineStringType, LineStringPropertyType, LineString> {
    private final GML311ToJTSCoordinateConverter coordinateConverter;
    private final GML311ToJTSConverterInterface<PointType, PointPropertyType, Point> pointConverter;

    public GML311ToJTSLineStringConverter(GeometryFactory geometryFactory, GML311ToJTSSRIDConverterInterface sridConverter, GML311ToJTSCoordinateConverter coordinateConverter, GML311ToJTSConverterInterface<PointType, PointPropertyType, Point> pointConverter) {
        super(geometryFactory, sridConverter);
        this.coordinateConverter = coordinateConverter;
        this.pointConverter = new GML311ToJTSPointConverter(geometryFactory, sridConverter, coordinateConverter);
    }

    @Override
    protected LineString doCreateGeometry(ObjectLocator locator, LineStringType lineStringType) throws ConversionFailedException {
        if (lineStringType.isSetPosOrPointPropertyOrPointRep()) {
            LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
            PropertyObjectLocator fieldLocator = locator.property("PosOrPointPropertyOrPointRep", (Object)lineStringType.getPosOrPointPropertyOrPointRep());
            for (int index = 0; index < lineStringType.getPosOrPointPropertyOrPointRep().size(); ++index) {
                JAXBElement item = (JAXBElement)lineStringType.getPosOrPointPropertyOrPointRep().get(index);
                ItemObjectLocator itemLocator = fieldLocator.item(index, (Object)item);
                Object value = item.getValue();
                PropertyObjectLocator itemValueLocator = itemLocator.property("value", value);
                if (value instanceof PointPropertyType) {
                    coordinates.add(this.pointConverter.createGeometry((ObjectLocator)itemValueLocator, (PointPropertyType)value).getCoordinate());
                    continue;
                }
                if (value instanceof CoordType) {
                    coordinates.add(this.coordinateConverter.createCoordinate((ObjectLocator)itemValueLocator, (CoordType)value));
                    continue;
                }
                if (value instanceof DirectPositionType) {
                    coordinates.add(this.coordinateConverter.createCoordinate((ObjectLocator)itemValueLocator, (DirectPositionType)value));
                    continue;
                }
                throw new ConversionFailedException((ObjectLocator)itemLocator, "Unexpected type.");
            }
            Coordinate[] coordinatesArray = coordinates.toArray(new Coordinate[coordinates.size()]);
            return this.getGeometryFactory().createLineString(coordinatesArray);
        }
        if (lineStringType.isSetPosList()) {
            Coordinate[] coordinates = this.coordinateConverter.createCoordinates((ObjectLocator)locator.property("posList", (Object)lineStringType.getPosList()), lineStringType.getPosList());
            return this.getGeometryFactory().createLineString(coordinates);
        }
        if (lineStringType.isSetCoordinates()) {
            Coordinate[] coordinates = this.coordinateConverter.createCoordinates((ObjectLocator)locator.property("coordinates", (Object)lineStringType.getCoordinates()), lineStringType.getCoordinates());
            return this.getGeometryFactory().createLineString(coordinates);
        }
        throw new ConversionFailedException(locator);
    }

    @Override
    public LineString createGeometry(ObjectLocator locator, LineStringPropertyType lineStringPropertyType) throws ConversionFailedException {
        if (lineStringPropertyType.isSetLineString()) {
            return (LineString)this.createGeometry((ObjectLocator)locator.property("lineString", (Object)lineStringPropertyType.getLineString()), lineStringPropertyType.getLineString());
        }
        throw new ConversionFailedException(locator, "Expected [LineString] element.");
    }
}

