/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ogc.gml.v_3_1_1.jts;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import net.opengis.gml.v_3_1_1.AbstractRingPropertyType;
import net.opengis.gml.v_3_1_1.AbstractRingType;
import net.opengis.gml.v_3_1_1.LinearRingPropertyType;
import net.opengis.gml.v_3_1_1.LinearRingType;
import net.opengis.gml.v_3_1_1.PolygonPropertyType;
import net.opengis.gml.v_3_1_1.PolygonType;
import org.jvnet.jaxb2_commons.locator.ItemObjectLocator;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.PropertyObjectLocator;
import org.jvnet.ogc.gml.v_3_1_1.jts.AbstractGML311ToJTSConverter;
import org.jvnet.ogc.gml.v_3_1_1.jts.ConversionFailedException;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSConverterInterface;
import org.jvnet.ogc.gml.v_3_1_1.jts.GML311ToJTSSRIDConverterInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GML311ToJTSPolygonConverter
extends AbstractGML311ToJTSConverter<PolygonType, PolygonPropertyType, Polygon> {
    private final GML311ToJTSConverterInterface<LinearRingType, LinearRingPropertyType, LinearRing> linearRingConverter;

    public GML311ToJTSPolygonConverter(GeometryFactory geometryFactory, GML311ToJTSSRIDConverterInterface sridConverter, GML311ToJTSConverterInterface<LinearRingType, LinearRingPropertyType, LinearRing> linearRingConverter) {
        super(geometryFactory, sridConverter);
        this.linearRingConverter = linearRingConverter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Polygon doCreateGeometry(ObjectLocator locator, PolygonType polygonType) throws ConversionFailedException {
        LinearRing[] holes;
        LinearRing shell;
        if (polygonType.isSetExterior()) {
            AbstractRingType abstractRingType = (AbstractRingType)((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing().getValue();
            if (!(abstractRingType instanceof LinearRingType)) throw new ConversionFailedException((ObjectLocator)locator.property("exterior", (Object)polygonType.getExterior()).property("value", polygonType.getExterior().getValue()).property("ring", (Object)((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing()), "Only linear rings are supported.");
            shell = this.linearRingConverter.createGeometry((ObjectLocator)locator.property("exterior", (Object)polygonType.getExterior()).property("value", polygonType.getExterior().getValue()).property("ring", (Object)((AbstractRingPropertyType)polygonType.getExterior().getValue()).getRing()).property("value", (Object)abstractRingType), (LinearRingPropertyType)((LinearRingType)abstractRingType));
        } else {
            shell = null;
        }
        if (polygonType.isSetInterior()) {
            PropertyObjectLocator interiorObjectLocator = locator.property("interior", (Object)polygonType.getInterior());
            ArrayList<LinearRing> holesList = new ArrayList<LinearRing>(polygonType.getInterior().size());
            for (int index = 0; index < polygonType.getInterior().size(); ++index) {
                JAXBElement ringElement = (JAXBElement)polygonType.getInterior().get(index);
                ItemObjectLocator entryLocator = interiorObjectLocator.item(index, (Object)ringElement);
                AbstractRingType abstractRingType = (AbstractRingType)((AbstractRingPropertyType)ringElement.getValue()).getRing().getValue();
                if (!(abstractRingType instanceof LinearRingType)) {
                    throw new ConversionFailedException((ObjectLocator)entryLocator, "Only linear rings are supported.");
                }
                holesList.add(this.linearRingConverter.createGeometry((ObjectLocator)entryLocator.property("value", ringElement.getValue()).property("ring", (Object)((AbstractRingPropertyType)ringElement.getValue()).getRing()).property("value", ((AbstractRingPropertyType)ringElement.getValue()).getRing().getValue()), (LinearRingPropertyType)((LinearRingType)abstractRingType)));
            }
            holes = holesList.toArray(new LinearRing[holesList.size()]);
            return this.getGeometryFactory().createPolygon(shell, holes);
        } else {
            holes = null;
        }
        return this.getGeometryFactory().createPolygon(shell, holes);
    }

    @Override
    public Polygon createGeometry(ObjectLocator locator, PolygonPropertyType polygonPropertyType) throws ConversionFailedException {
        if (polygonPropertyType.isSetPolygon()) {
            return (Polygon)this.createGeometry((ObjectLocator)locator.property("polygon", (Object)polygonPropertyType.getPolygon()), polygonPropertyType.getPolygon());
        }
        throw new ConversionFailedException(locator, "Expected [Polygon] element.");
    }
}

