var TJS_1_0_Module_Factory = function () {
  var TJS_1_0 = {
    n: 'TJS_1_0',
    dens: 'http:\/\/www.opengis.net\/tjs\/1.0',
    deps: ['OWS_1_1_0'],
    tis: [{
        ln: 'GDAS.Framework',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'describeDatasetsRequest',
            rq: true,
            en: 'DescribeDatasetsRequest',
            ti: '.DescribeDatasetsRequest'
          }, {
            n: 'dataset',
            rq: true,
            en: 'Dataset',
            ti: '.GDAS.Framework.Dataset'
          }]
      }, {
        ln: 'Ordinal.Classes',
        tn: null,
        ps: [{
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'value',
            rq: true,
            col: true,
            en: 'Value',
            ti: '.Ordinal.Classes.Value'
          }]
      }, {
        ln: 'GetDataRequest',
        tn: null,
        ps: [{
            n: 'href',
            rq: true,
            an: {
              lp: 'href',
              ns: 'http:\/\/www.w3.org\/1999\/xlink'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeDatasetsRequest',
        tn: null,
        ps: [{
            n: 'href',
            rq: true,
            an: {
              lp: 'href',
              ns: 'http:\/\/www.w3.org\/1999\/xlink'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinDataResponse',
        tn: null,
        ps: [{
            n: 'status',
            rq: true,
            en: 'Status',
            ti: '.JoinDataResponse.Status'
          }, {
            n: 'dataInputs',
            rq: true,
            en: 'DataInputs',
            ti: '.JoinDataResponse.DataInputs'
          }, {
            n: 'joinedOutputs',
            rq: true,
            en: 'JoinedOutputs',
            ti: '.JoinDataResponse.JoinedOutputs'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinDataResponse.JoinedOutputs',
        tn: null,
        ps: [{
            n: 'output',
            rq: true,
            col: true,
            en: 'Output',
            ti: '.JoinDataResponse.JoinedOutputs.Output'
          }]
      }, {
        ln: 'BoundingCoordinates',
        tn: null,
        ps: [{
            n: 'north',
            rq: true,
            en: 'North',
            ti: 'Decimal'
          }, {
            n: 'south',
            rq: true,
            en: 'South',
            ti: 'Decimal'
          }, {
            n: 'east',
            rq: true,
            en: 'East',
            ti: 'Decimal'
          }, {
            n: 'west',
            rq: true,
            en: 'West',
            ti: 'Decimal'
          }]
      }, {
        ln: 'Count',
        tn: null,
        ps: [{
            n: 'uom',
            rq: true,
            en: 'UOM',
            ti: '.UOM'
          }, {
            n: 'uncertainty',
            en: 'Uncertainty',
            ti: '.Uncertainty'
          }, {
            n: 'exceptions',
            en: 'Exceptions',
            ti: '.MeasureCountExceptions'
          }]
      }, {
        ln: 'OutputStylingsType',
        ps: [{
            n: 'styling',
            rq: true,
            col: true,
            en: 'Styling',
            ti: '.Styling'
          }]
      }, {
        ln: 'JoinData.AttributeData.GetDataXML',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'attributes',
            en: 'Attributes'
          }, {
            n: 'linkageKeys',
            en: 'LinkageKeys'
          }, {
            n: 'getDataHost',
            an: {
              lp: 'getDataHost'
            },
            t: 'a'
          }, {
            n: 'language',
            an: {
              lp: 'language'
            },
            t: 'a'
          }]
      }, {
        ln: 'GDAS',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            en: 'Framework',
            ti: '.GDAS.Framework'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeDatasets',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'frameworkURI',
            en: 'FrameworkURI'
          }, {
            n: 'datasetURI',
            en: 'DatasetURI'
          }]
      }, {
        ln: 'Uncertainty',
        tn: null,
        ps: [{
            n: 'value',
            t: 'v'
          }, {
            n: 'gaussian',
            rq: true,
            an: {
              lp: 'gaussian'
            },
            t: 'a'
          }]
      }, {
        ln: 'Measure',
        tn: null,
        ps: [{
            n: 'uom',
            rq: true,
            en: 'UOM',
            ti: '.UOM'
          }, {
            n: 'uncertainty',
            en: 'Uncertainty',
            ti: '.Uncertainty'
          }, {
            n: 'exceptions',
            en: 'Exceptions',
            ti: '.MeasureCountExceptions'
          }]
      }, {
        ln: 'RequestBaseType',
        ps: [{
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'language',
            an: {
              lp: 'language'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeFrameworkKeyType.Rowset',
        tn: null,
        ps: [{
            n: 'row',
            rq: true,
            col: true,
            en: 'Row',
            ti: '.DescribeFrameworkKeyType.Rowset.Row'
          }]
      }, {
        ln: 'JoinDataResponse.DataInputs',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            en: 'Framework',
            ti: '.FrameworkDatasetDescribeDataType'
          }]
      }, {
        ln: 'Ordinal',
        tn: null,
        ps: [{
            n: 'classes',
            en: 'Classes',
            ti: '.Ordinal.Classes'
          }, {
            n: 'exceptions',
            en: 'Exceptions',
            ti: '.NominalOrdinalExceptions'
          }]
      }, {
        ln: 'JoinDataResponse.JoinedOutputs.Output.ExceptionReport',
        tn: null,
        ps: [{
            n: 'exception',
            rq: true,
            en: {
              lp: 'Exception',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            },
            ti: 'OWS_1_1_0.ExceptionType'
          }]
      }, {
        ln: 'DescribeFrameworkKeyType.Rowset.Row',
        tn: null,
        ps: [{
            n: 'k',
            rq: true,
            col: true,
            en: 'K',
            ti: '.K'
          }, {
            n: 'title',
            en: 'Title'
          }]
      }, {
        ln: 'DescribeFrameworkKeyType',
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'rowset',
            rq: true,
            en: 'Rowset',
            ti: '.DescribeFrameworkKeyType.Rowset'
          }]
      }, {
        ln: 'FrameworkDatasetDescribeDataType.Dataset',
        tn: null,
        ps: [{
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'describeDataRequest',
            rq: true,
            en: 'DescribeDataRequest',
            ti: '.DescribeDataRequest'
          }, {
            n: 'columnset',
            rq: true,
            en: 'Columnset',
            ti: '.Columnset'
          }]
      }, {
        ln: 'ReferenceDate',
        tn: null,
        ps: [{
            n: 'value',
            t: 'v'
          }, {
            n: 'startDate',
            an: {
              lp: 'startDate'
            },
            t: 'a'
          }]
      }, {
        ln: 'MeasureCountExceptions',
        ps: [{
            n: '_null',
            rq: true,
            col: true,
            en: 'Null',
            ti: '.MeasureCountExceptions.Null'
          }]
      }, {
        ln: 'Values',
        tn: null,
        ps: [{
            n: 'nominal',
            rq: true,
            en: 'Nominal',
            ti: '.Nominal'
          }, {
            n: 'ordinal',
            rq: true,
            en: 'Ordinal',
            ti: '.Ordinal'
          }, {
            n: 'count',
            rq: true,
            en: 'Count',
            ti: '.Count'
          }, {
            n: 'measure',
            rq: true,
            en: 'Measure',
            ti: '.Measure'
          }]
      }, {
        ln: 'NominalOrdinalExceptions',
        ps: [{
            n: '_null',
            rq: true,
            col: true,
            en: 'Null',
            ti: '.NominalOrdinalExceptions.Null'
          }]
      }, {
        ln: 'Mechanism',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract'
          }, {
            n: 'reference',
            rq: true,
            en: 'Reference'
          }]
      }, {
        ln: 'Columnset.FrameworkKey',
        tn: null,
        ps: [{
            n: 'column',
            rq: true,
            col: true,
            en: 'Column',
            ti: '.Columnset.FrameworkKey.Column'
          }, {
            n: 'relationship',
            rq: true,
            an: {
              lp: 'relationship'
            },
            t: 'a'
          }, {
            n: 'complete',
            rq: true,
            an: {
              lp: 'complete'
            },
            t: 'a'
          }]
      }, {
        ln: 'Columnset',
        tn: null,
        ps: [{
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.Columnset.FrameworkKey'
          }, {
            n: 'attributes',
            rq: true,
            en: 'Attributes',
            ti: '.Columnset.Attributes'
          }]
      }, {
        ln: 'Columnset.Attributes',
        tn: null,
        ps: [{
            n: 'column',
            rq: true,
            col: true,
            en: 'Column',
            ti: '.Columnset.Attributes.Column'
          }]
      }, {
        ln: 'Rowset',
        tn: null,
        ps: [{
            n: 'row',
            rq: true,
            col: true,
            en: 'Row',
            ti: '.Rowset.Row'
          }]
      }, {
        ln: 'JoinDataResponse.JoinedOutputs.Output',
        tn: null,
        ps: [{
            n: 'mechanism',
            rq: true,
            en: 'Mechanism',
            ti: '.Mechanism'
          }, {
            n: 'resource',
            rq: true,
            en: 'Resource',
            ti: '.JoinDataResponse.JoinedOutputs.Output.Resource'
          }, {
            n: 'exceptionReport',
            rq: true,
            en: 'ExceptionReport',
            ti: '.JoinDataResponse.JoinedOutputs.Output.ExceptionReport'
          }]
      }, {
        ln: 'JoinDataResponse.JoinedOutputs.Output.Resource.Parameter',
        tn: null,
        ps: [{
            n: 'value',
            t: 'v'
          }, {
            n: 'name',
            rq: true,
            an: {
              lp: 'name'
            },
            t: 'a'
          }]
      }, {
        ln: 'Ordinal.Classes.Value',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'rank',
            rq: true,
            ti: 'Integer',
            an: {
              lp: 'rank'
            },
            t: 'a'
          }, {
            n: 'color',
            an: {
              lp: 'color'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinAbilities.OutputStylings',
        tn: null,
        bti: '.OutputStylingsType'
      }, {
        ln: 'K',
        tn: null,
        ps: [{
            n: 'value',
            t: 'v'
          }, {
            n: 'aid',
            an: {
              lp: 'aid'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinAbilities',
        tn: null,
        ps: [{
            n: 'spatialFrameworks',
            rq: true,
            en: 'SpatialFrameworks',
            ti: '.SpatialFrameworks'
          }, {
            n: 'attributeLimit',
            rq: true,
            en: 'AttributeLimit',
            ti: 'Integer'
          }, {
            n: 'outputMechanisms',
            rq: true,
            en: 'OutputMechanisms',
            ti: '.OutputMechanismsType'
          }, {
            n: 'outputStylings',
            en: 'OutputStylings',
            ti: '.JoinAbilities.OutputStylings'
          }, {
            n: 'classificationSchemaURL',
            en: 'ClassificationSchemaURL',
            ti: 'AnyType'
          }, {
            n: 'updateSupported',
            rq: true,
            ti: 'Boolean',
            an: {
              lp: 'updateSupported'
            },
            t: 'a'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'FrameworkDescriptions.Framework',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'describeDatasetsRequest',
            rq: true,
            en: 'DescribeDatasetsRequest',
            ti: '.DescribeDatasetsRequest'
          }]
      }, {
        ln: 'TjsCapabilitiesType.Languages',
        tn: null,
        ps: [{
            n: 'language',
            rq: true,
            col: true,
            en: {
              lp: 'Language',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            }
          }]
      }, {
        ln: 'Nominal',
        tn: null,
        ps: [{
            n: 'classes',
            en: 'Classes',
            ti: '.Nominal.Classes'
          }, {
            n: 'exceptions',
            en: 'Exceptions',
            ti: '.NominalOrdinalExceptions'
          }]
      }, {
        ln: 'UOM',
        tn: null,
        ps: [{
            n: 'shortForm',
            rq: true,
            en: 'ShortForm',
            ti: 'AnyType'
          }, {
            n: 'longForm',
            rq: true,
            en: 'LongForm',
            ti: 'AnyType'
          }, {
            n: 'reference',
            an: {
              lp: 'reference',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            },
            t: 'a'
          }]
      }, {
        ln: 'GetCapabilities',
        tn: null,
        ps: [{
            n: 'acceptVersions',
            en: 'AcceptVersions',
            ti: '.GetCapabilities.AcceptVersions'
          }, {
            n: 'sections',
            en: 'Sections',
            ti: 'OWS_1_1_0.SectionsType'
          }, {
            n: 'acceptFormats',
            en: 'AcceptFormats',
            ti: 'OWS_1_1_0.AcceptFormatsType'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'language',
            an: {
              lp: 'language'
            },
            t: 'a'
          }, {
            n: 'updateSequence',
            an: {
              lp: 'updateSequence'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeKey',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }]
      }, {
        ln: 'JoinDataResponse.Status.Failed',
        tn: null
      }, {
        ln: 'FrameworkDescriptions',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            col: true,
            en: 'Framework',
            ti: '.FrameworkDescriptions.Framework'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinData',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'attributeData',
            rq: true,
            en: 'AttributeData',
            ti: '.JoinData.AttributeData'
          }, {
            n: 'mapStyling',
            en: 'MapStyling',
            ti: '.JoinData.MapStyling'
          }, {
            n: 'classificationURL',
            en: 'ClassificationURL',
            ti: 'AnyType'
          }, {
            n: 'update',
            an: {
              lp: 'update'
            },
            t: 'a'
          }]
      }, {
        ln: 'Dataset',
        tn: null,
        ps: [{
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'columnset',
            rq: true,
            en: 'Columnset',
            ti: '.Columnset'
          }, {
            n: 'rowset',
            rq: true,
            en: 'Rowset',
            ti: '.Rowset'
          }]
      }, {
        ln: 'Styling',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract'
          }, {
            n: 'reference',
            rq: true,
            en: 'Reference'
          }, {
            n: 'schema',
            en: 'Schema'
          }]
      }, {
        ln: 'GetData',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'attributes',
            en: 'Attributes'
          }, {
            n: 'linkageKeys',
            en: 'LinkageKeys'
          }, {
            n: 'filterColumn',
            en: 'FilterColumn',
            ti: 'AnyType'
          }, {
            n: 'filterValue',
            en: 'FilterValue',
            ti: 'AnyType'
          }, {
            n: 'xsl',
            en: 'XSL',
            ti: 'AnyType'
          }, {
            n: 'aid',
            ti: 'Boolean',
            an: {
              lp: 'aid'
            },
            t: 'a'
          }]
      }, {
        ln: 'FrameworkDatasetDescribeDataType',
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'describeDatasetsRequest',
            rq: true,
            en: 'DescribeDatasetsRequest',
            ti: '.DescribeDatasetsRequest'
          }, {
            n: 'dataset',
            rq: true,
            col: true,
            en: 'Dataset',
            ti: '.FrameworkDatasetDescribeDataType.Dataset'
          }]
      }, {
        ln: 'Nominal.Classes.Value',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'color',
            an: {
              lp: 'color'
            },
            t: 'a'
          }]
      }, {
        ln: 'TjsCapabilitiesType',
        tn: 'tjsCapabilitiesType',
        ps: [{
            n: 'serviceIdentification',
            en: {
              lp: 'ServiceIdentification',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            },
            ti: 'OWS_1_1_0.ServiceIdentification'
          }, {
            n: 'serviceProvider',
            en: {
              lp: 'ServiceProvider',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            },
            ti: 'OWS_1_1_0.ServiceProvider'
          }, {
            n: 'operationsMetadata',
            en: {
              lp: 'OperationsMetadata',
              ns: 'http:\/\/www.opengis.net\/ows\/1.1'
            },
            ti: 'OWS_1_1_0.OperationsMetadata'
          }, {
            n: 'languages',
            en: 'Languages',
            ti: '.TjsCapabilitiesType.Languages'
          }, {
            n: 'wsdl',
            en: 'WSDL',
            ti: '.TjsCapabilitiesType.WSDL'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'updateSequence',
            an: {
              lp: 'updateSequence'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeFrameworks',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'frameworkURI',
            en: 'FrameworkURI'
          }]
      }, {
        ln: 'MeasureCountExceptions.Null',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }]
      }, {
        ln: 'JoinData.MapStyling',
        tn: null,
        ps: [{
            n: 'stylingIdentifier',
            rq: true,
            en: 'StylingIdentifier',
            ti: 'AnyType'
          }, {
            n: 'stylingURL',
            rq: true,
            en: 'StylingURL'
          }]
      }, {
        ln: 'TjsCapabilitiesType.WSDL',
        tn: null,
        ps: [{
            n: 'href',
            rq: true,
            an: {
              lp: 'href',
              ns: 'http:\/\/www.w3.org\/1999\/xlink'
            },
            t: 'a'
          }]
      }, {
        ln: 'JoinDataResponse.JoinedOutputs.Output.Resource',
        tn: null,
        ps: [{
            n: 'url',
            rq: true,
            en: 'URL',
            ti: 'AnyType'
          }, {
            n: 'parameter',
            mno: 0,
            col: true,
            en: 'Parameter',
            ti: '.JoinDataResponse.JoinedOutputs.Output.Resource.Parameter'
          }]
      }, {
        ln: 'Columnset.Attributes.Column',
        tn: null,
        ps: [{
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'values',
            rq: true,
            en: 'Values',
            ti: '.Values'
          }, {
            n: 'getDataRequest',
            rq: true,
            en: 'GetDataRequest',
            ti: '.GetDataRequest'
          }, {
            n: 'purpose',
            rq: true,
            an: {
              lp: 'purpose'
            },
            t: 'a'
          }, {
            n: 'name',
            rq: true,
            an: {
              lp: 'name'
            },
            t: 'a'
          }, {
            n: 'type',
            rq: true,
            an: {
              lp: 'type'
            },
            t: 'a'
          }, {
            n: 'length',
            rq: true,
            ti: 'Integer',
            an: {
              lp: 'length'
            },
            t: 'a'
          }, {
            n: 'decimals',
            ti: 'Integer',
            an: {
              lp: 'decimals'
            },
            t: 'a'
          }]
      }, {
        ln: 'OutputMechanismsType',
        ps: [{
            n: 'mechanism',
            rq: true,
            col: true,
            en: 'Mechanism',
            ti: '.Mechanism'
          }]
      }, {
        ln: 'AbstractType',
        ps: [{
            n: 'otherAttributes',
            t: 'aa'
          }, {
            n: 'content',
            col: true,
            typed: false,
            t: 'ae'
          }]
      }, {
        ln: 'FrameworkKey.Column',
        tn: null,
        ps: [{
            n: 'name',
            rq: true,
            an: {
              lp: 'name'
            },
            t: 'a'
          }, {
            n: 'type',
            rq: true,
            an: {
              lp: 'type'
            },
            t: 'a'
          }, {
            n: 'length',
            rq: true,
            ti: 'Integer',
            an: {
              lp: 'length'
            },
            t: 'a'
          }, {
            n: 'decimals',
            ti: 'Integer',
            an: {
              lp: 'decimals'
            },
            t: 'a'
          }]
      }, {
        ln: 'Rowset.Row.V',
        tn: null,
        ps: [{
            n: 'value',
            t: 'v'
          }, {
            n: 'aid',
            an: {
              lp: 'aid'
            },
            t: 'a'
          }, {
            n: '_null',
            ti: 'Boolean',
            an: {
              lp: 'null'
            },
            t: 'a'
          }]
      }, {
        ln: 'FrameworkKey',
        tn: null,
        ps: [{
            n: 'column',
            rq: true,
            col: true,
            en: 'Column',
            ti: '.FrameworkKey.Column'
          }]
      }, {
        ln: 'DataDescriptions',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            col: true,
            en: 'Framework',
            ti: '.FrameworkDatasetDescribeDataType'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'SpatialFrameworks',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            col: true,
            en: 'Framework',
            ti: '.SpatialFrameworks.Framework'
          }]
      }, {
        ln: 'GetCapabilities.AcceptVersions',
        tn: null,
        ps: [{
            n: 'version',
            rq: true,
            col: true,
            en: 'Version'
          }]
      }, {
        ln: 'JoinData.AttributeData',
        tn: null,
        ps: [{
            n: 'getDataURL',
            rq: true,
            en: 'GetDataURL'
          }, {
            n: 'getDataXML',
            rq: true,
            en: 'GetDataXML',
            ti: '.JoinData.AttributeData.GetDataXML'
          }]
      }, {
        ln: 'DatasetDescriptions',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            col: true,
            en: 'Framework',
            ti: '.DatasetDescriptions.Framework'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'SpatialFrameworks.Framework',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }]
      }, {
        ln: 'Columnset.FrameworkKey.Column',
        tn: null,
        ps: [{
            n: 'name',
            rq: true,
            an: {
              lp: 'name'
            },
            t: 'a'
          }, {
            n: 'type',
            rq: true,
            an: {
              lp: 'type'
            },
            t: 'a'
          }, {
            n: 'length',
            rq: true,
            ti: 'Integer',
            an: {
              lp: 'length'
            },
            t: 'a'
          }, {
            n: 'decimals',
            ti: 'Integer',
            an: {
              lp: 'decimals'
            },
            t: 'a'
          }]
      }, {
        ln: 'DescribeData',
        tn: null,
        bti: '.RequestBaseType',
        ps: [{
            n: 'frameworkURI',
            en: 'FrameworkURI'
          }, {
            n: 'datasetURI',
            en: 'DatasetURI'
          }, {
            n: 'attributes',
            en: 'Attributes'
          }]
      }, {
        ln: 'Framework',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'dataset',
            rq: true,
            en: 'Dataset',
            ti: '.Dataset'
          }]
      }, {
        ln: 'FrameworkKeyDescription',
        tn: null,
        ps: [{
            n: 'framework',
            rq: true,
            en: 'Framework',
            ti: '.DescribeFrameworkKeyType'
          }, {
            n: 'service',
            rq: true,
            an: {
              lp: 'service'
            },
            t: 'a'
          }, {
            n: 'version',
            rq: true,
            an: {
              lp: 'version'
            },
            t: 'a'
          }, {
            n: 'capabilities',
            rq: true,
            an: {
              lp: 'capabilities'
            },
            t: 'a'
          }, {
            n: 'lang',
            rq: true,
            an: {
              lp: 'lang',
              ns: 'http:\/\/www.w3.org\/XML\/1998\/namespace'
            },
            t: 'a'
          }]
      }, {
        ln: 'DatasetDescriptions.Framework',
        tn: null,
        ps: [{
            n: 'frameworkURI',
            rq: true,
            en: 'FrameworkURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'frameworkKey',
            rq: true,
            en: 'FrameworkKey',
            ti: '.FrameworkKey'
          }, {
            n: 'boundingCoordinates',
            rq: true,
            en: 'BoundingCoordinates',
            ti: '.BoundingCoordinates'
          }, {
            n: 'describeDatasetsRequest',
            rq: true,
            en: 'DescribeDatasetsRequest',
            ti: '.DescribeDatasetsRequest'
          }, {
            n: 'dataset',
            rq: true,
            col: true,
            en: 'Dataset',
            ti: '.DatasetDescriptions.Framework.Dataset'
          }]
      }, {
        ln: 'Rowset.Row',
        tn: null,
        ps: [{
            n: 'k',
            rq: true,
            col: true,
            en: 'K',
            ti: '.K'
          }, {
            n: 'v',
            rq: true,
            col: true,
            en: 'V',
            ti: '.Rowset.Row.V'
          }]
      }, {
        ln: 'Nominal.Classes',
        tn: null,
        ps: [{
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'value',
            rq: true,
            col: true,
            en: 'Value',
            ti: '.Nominal.Classes.Value'
          }]
      }, {
        ln: 'JoinDataResponse.Status',
        tn: null,
        ps: [{
            n: 'accepted',
            rq: true,
            en: 'Accepted',
            ti: 'AnyType'
          }, {
            n: 'completed',
            rq: true,
            en: 'Completed',
            ti: 'AnyType'
          }, {
            n: 'failed',
            rq: true,
            en: 'Failed',
            ti: '.JoinDataResponse.Status.Failed'
          }, {
            n: 'href',
            rq: true,
            an: {
              lp: 'href',
              ns: 'http:\/\/www.w3.org\/1999\/xlink'
            },
            t: 'a'
          }, {
            n: 'creationTime',
            rq: true,
            an: {
              lp: 'creationTime'
            },
            t: 'a'
          }]
      }, {
        ln: 'GDAS.Framework.Dataset',
        tn: null,
        ps: [{
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'describeDataRequest',
            rq: true,
            en: 'DescribeDataRequest',
            ti: '.DescribeDataRequest'
          }, {
            n: 'columnset',
            rq: true,
            en: 'Columnset',
            ti: '.Columnset'
          }, {
            n: 'rowset',
            rq: true,
            en: 'Rowset',
            ti: '.Rowset'
          }]
      }, {
        ln: 'DatasetDescriptions.Framework.Dataset',
        tn: null,
        ps: [{
            n: 'datasetURI',
            rq: true,
            en: 'DatasetURI'
          }, {
            n: 'organization',
            rq: true,
            en: 'Organization'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'referenceDate',
            rq: true,
            en: 'ReferenceDate',
            ti: '.ReferenceDate'
          }, {
            n: 'version',
            rq: true,
            en: 'Version'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'describeDataRequest',
            rq: true,
            en: 'DescribeDataRequest',
            ti: '.DescribeDataRequest'
          }]
      }, {
        ln: 'DescribeDataRequest',
        tn: null,
        ps: [{
            n: 'href',
            rq: true,
            an: {
              lp: 'href',
              ns: 'http:\/\/www.w3.org\/1999\/xlink'
            },
            t: 'a'
          }]
      }, {
        ln: 'NominalOrdinalExceptions.Null',
        tn: null,
        ps: [{
            n: 'identifier',
            rq: true,
            en: 'Identifier'
          }, {
            n: 'title',
            rq: true,
            en: 'Title'
          }, {
            n: '_abstract',
            rq: true,
            en: 'Abstract',
            ti: '.AbstractType'
          }, {
            n: 'documentation',
            en: 'Documentation'
          }, {
            n: 'color',
            an: {
              lp: 'color'
            },
            t: 'a'
          }]
      }, {
        t: 'enum',
        ln: 'JoinDataValueType',
        vs: ['JoinData']
      }, {
        t: 'enum',
        ln: 'DescribeDatasetsValueType',
        vs: ['DescribeDatasets']
      }, {
        t: 'enum',
        ln: 'GetCapabilitiesValueType',
        vs: ['GetCapabilities']
      }, {
        t: 'enum',
        ln: 'VersionType',
        vs: ['1.0']
      }, {
        t: 'enum',
        ln: 'DescribeDataValueType',
        vs: ['DescribeData']
      }, {
        t: 'enum',
        ln: 'DescribeFrameworksValueType',
        vs: ['DescribeFrameworks']
      }, {
        t: 'enum',
        ln: 'DescribeJoinAbilitiesValueType',
        vs: ['DescribeJoinAbilities']
      }, {
        t: 'enum',
        ln: 'DescribeKeyValueType',
        vs: ['DescribeKey']
      }, {
        t: 'enum',
        ln: 'GetDataValueType',
        vs: ['GetData']
      }, {
        t: 'enum',
        ln: 'RequestServiceType',
        vs: ['TJS']
      }],
    eis: [{
        en: 'Nominal',
        ti: '.Nominal'
      }, {
        en: 'Version'
      }, {
        en: 'DescribeKey',
        ti: '.DescribeKey'
      }, {
        en: 'Rowset',
        ti: '.Rowset'
      }, {
        en: 'ReferenceDate',
        ti: '.ReferenceDate'
      }, {
        en: 'BoundingCoordinates',
        ti: '.BoundingCoordinates'
      }, {
        en: 'Attributes'
      }, {
        en: 'LinkageKeys'
      }, {
        en: 'GetDataRequest',
        ti: '.GetDataRequest'
      }, {
        en: 'DescribeData',
        ti: '.DescribeData'
      }, {
        en: 'DescribeDataRequest',
        ti: '.DescribeDataRequest'
      }, {
        en: 'DataDescriptions',
        ti: '.DataDescriptions'
      }, {
        en: 'Identifier'
      }, {
        en: 'DatasetURI'
      }, {
        en: 'DescribeFrameworks',
        ti: '.DescribeFrameworks'
      }, {
        en: 'DescribeDatasets',
        ti: '.DescribeDatasets'
      }, {
        en: 'JoinAbilities',
        ti: '.JoinAbilities'
      }, {
        en: 'Documentation'
      }, {
        en: 'Uncertainty',
        ti: '.Uncertainty'
      }, {
        en: 'Title'
      }, {
        en: 'JoinData',
        ti: '.JoinData'
      }, {
        en: 'DatasetDescriptions',
        ti: '.DatasetDescriptions'
      }, {
        en: 'FrameworkKeyDescription',
        ti: '.FrameworkKeyDescription'
      }, {
        en: 'AttributeLimit',
        ti: 'Integer'
      }, {
        en: 'Ordinal',
        ti: '.Ordinal'
      }, {
        en: 'DescribeJoinAbilities',
        ti: '.RequestBaseType'
      }, {
        en: 'Count',
        ti: '.Count'
      }, {
        en: 'FrameworkKey',
        ti: '.FrameworkKey'
      }, {
        en: 'Organization'
      }, {
        en: 'Mechanism',
        ti: '.Mechanism'
      }, {
        en: 'Framework',
        ti: '.Framework'
      }, {
        en: 'Columnset',
        ti: '.Columnset'
      }, {
        en: 'Styling',
        ti: '.Styling'
      }, {
        en: 'GetData',
        ti: '.GetData'
      }, {
        en: 'Measure',
        ti: '.Measure'
      }, {
        en: 'FrameworkDescriptions',
        ti: '.FrameworkDescriptions'
      }, {
        en: 'Capabilities',
        ti: '.TjsCapabilitiesType'
      }, {
        en: 'GetCapabilities',
        ti: '.GetCapabilities'
      }, {
        en: 'JoinDataResponse',
        ti: '.JoinDataResponse'
      }, {
        en: 'UOM',
        ti: '.UOM'
      }, {
        en: 'DataClass'
      }, {
        en: 'GDAS',
        ti: '.GDAS'
      }, {
        en: 'Values',
        ti: '.Values'
      }, {
        en: 'Dataset',
        ti: '.Dataset'
      }, {
        en: 'K',
        ti: '.K'
      }, {
        en: 'FrameworkURI'
      }, {
        en: 'DescribeDatasetsRequest',
        ti: '.DescribeDatasetsRequest'
      }, {
        en: 'SpatialFrameworks',
        ti: '.SpatialFrameworks'
      }, {
        en: 'Abstract',
        ti: '.AbstractType'
      }]
  };
  return {
    TJS_1_0: TJS_1_0
  };
};
if (typeof define === 'function' && define.amd) {
  define([], TJS_1_0_Module_Factory);
}
else {
  var TJS_1_0_Module = TJS_1_0_Module_Factory();
  if (typeof module !== 'undefined' && module.exports) {
    module.exports.TJS_1_0 = TJS_1_0_Module.TJS_1_0;
  }
  else {
    var TJS_1_0 = TJS_1_0_Module.TJS_1_0;
  }
}