/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.ws.wadl2java.Wadl2Java;
import org.jvnet.ws.wadl2java.Wadl2JavaMessages;

public class WJCTask
extends Task {
    private String pkg;
    private boolean autoPackage;
    private File target;
    private URI desc;
    private List<FileSet> producedFileSets;
    private List<FileSet> consumedFileSets;
    private List<FileSet> customizationFileSets;
    private List<ClassNameMapper> customClassNames = new ArrayList<ClassNameMapper>();

    public ClassNameMapper createCustomClassName() {
        ClassNameMapper mapper = new ClassNameMapper();
        this.customClassNames.add(mapper);
        return mapper;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public void setAutoSchemaPackage(boolean auto) {
        this.autoPackage = auto;
    }

    public void setDescription(URI desc) {
        this.desc = desc;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void addConfiguredProduces(FileSet fileset) {
        this.producedFileSets.add(fileset);
    }

    public void addConfiguredCustomizations(FileSet fileset) {
        this.customizationFileSets.add(fileset);
    }

    public void addConfiguredDepends(FileSet fileset) {
        this.consumedFileSets.add(fileset);
    }

    public void init() throws BuildException {
        super.init();
        this.pkg = null;
        this.autoPackage = false;
        this.target = null;
        this.desc = null;
        this.producedFileSets = new ArrayList<FileSet>();
        this.consumedFileSets = new ArrayList<FileSet>();
        this.customizationFileSets = new ArrayList<FileSet>();
    }

    public void execute() throws BuildException {
        if (this.pkg == null) {
            throw new BuildException(Wadl2JavaMessages.PACKAGE_ATTRIBUTE_REQUIRED());
        }
        if (this.target == null) {
            throw new BuildException(Wadl2JavaMessages.TARGET_ATTRIBUTE_REQUIRED());
        }
        if (!this.target.exists()) {
            throw new BuildException(Wadl2JavaMessages.TARGET_DIRECTORY_MUST_EXIST((Object)this.target.toString()));
        }
        if (!this.target.isDirectory()) {
            throw new BuildException(Wadl2JavaMessages.TARGET_ATTRIBUTE_DIRECTORY((Object)this.target.toString()));
        }
        if (this.desc == null) {
            throw new BuildException(Wadl2JavaMessages.DESCRIPTION_REQUIRED());
        }
        ArrayList<File> customizations = new ArrayList<File>();
        for (FileSet fs : this.customizationFileSets) {
            String[] includedFiles;
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            for (String filename : includedFiles = ds.getIncludedFiles()) {
                File f = new File(ds.getBasedir(), filename);
                customizations.add(f);
            }
        }
        if (this.desc.getScheme() == null || this.desc.getScheme().equals("file")) {
            File fileDesc = new File(this.getOwningTarget().getProject().getBaseDir(), this.desc.getPath());
            if (!fileDesc.exists()) {
                throw new BuildException(Wadl2JavaMessages.WADL_DESCRIPTION_MUST_EXIST((Object)this.desc.toString()));
            }
            if (!fileDesc.isFile()) {
                throw new BuildException(Wadl2JavaMessages.WADL_DESCRIPTION_FILE((Object)this.desc.toString()));
            }
            this.desc = fileDesc.toURI();
            long earliestProducedFileStamp = Long.MAX_VALUE;
            for (FileSet fs : this.producedFileSets) {
                String[] includedFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String filename : includedFiles = ds.getIncludedFiles()) {
                    File f = new File(ds.getBasedir(), filename);
                    if (f.lastModified() >= earliestProducedFileStamp) continue;
                    earliestProducedFileStamp = f.lastModified();
                }
            }
            long latestConsumedFileStamp = fileDesc.lastModified();
            for (FileSet fs : this.consumedFileSets) {
                String[] includedFiles;
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String filename : includedFiles = ds.getIncludedFiles()) {
                    File f = new File(ds.getBasedir(), filename);
                    if (f.lastModified() <= latestConsumedFileStamp) continue;
                    latestConsumedFileStamp = f.lastModified();
                }
            }
            for (File f : customizations) {
                if (f.lastModified() <= latestConsumedFileStamp) continue;
                latestConsumedFileStamp = f.lastModified();
            }
            if (earliestProducedFileStamp < Long.MAX_VALUE && latestConsumedFileStamp < earliestProducedFileStamp) {
                this.log(Wadl2JavaMessages.SKIPPING_COMPILATION());
                return;
            }
        }
        HashMap<String, String> classCustomization = new HashMap<String, String>();
        for (ClassNameMapper mapper : this.customClassNames) {
            classCustomization.put(mapper.uri, mapper.classname);
        }
        try {
            Wadl2Java wadlProcessor = new Wadl2Java(new Wadl2Java.Parameters().setRootDir(this.target.toURI()).setCodeWriter((CodeWriter)new FileCodeWriter(this.target)).setPkg(this.pkg).setAutoPackage(this.autoPackage).setCustomizationsAsFiles(customizations).setCustomClassNames(classCustomization));
            wadlProcessor.process(this.desc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException(Wadl2JavaMessages.PROCESSING_FAILED(), (Throwable)ex);
        }
    }

    public class ClassNameMapper {
        private String uri;
        private String classname;

        public void setClassName(String className) {
            this.classname = className;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }
    }
}

