/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jvoicexml.xml.XmlDocument;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.XmlNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class AbstractXmlNode
implements XmlNode {
    private final Node node;
    private final XmlNodeFactory<? extends XmlNode> factory;

    protected AbstractXmlNode(Node n, XmlNodeFactory<? extends XmlNode> nodeFactory) {
        Node current = n;
        while (current instanceof XmlNode) {
            XmlNode xmlnode = (XmlNode)current;
            if ((current = xmlnode.getNode()) != null) continue;
            current = xmlnode;
            break;
        }
        this.node = current;
        this.factory = nodeFactory;
    }

    @Override
    public final NodeList getChildNodes() {
        return new XmlNodeList<XmlNode>(this.factory, this.node.getChildNodes());
    }

    @Override
    public final Node getNode() {
        Node current = this.node;
        while (current instanceof XmlNode) {
            XmlNode xmlnode = (XmlNode)current;
            if ((current = xmlnode.getNode()) != null) continue;
            return xmlnode;
        }
        return current;
    }

    public final XmlNodeFactory<? extends XmlNode> getNodeFactory() {
        return this.factory;
    }

    @Override
    public final String getAttribute(String attribute) {
        NamedNodeMap attributes = this.node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node item = attributes.getNamedItem(attribute);
        if (item == null) {
            return null;
        }
        return item.getNodeValue();
    }

    public final boolean hasAttribute(String attribute) {
        NamedNodeMap attributes = this.node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node item = attributes.getNamedItem(attribute);
        return item != null;
    }

    @Override
    public final void setAttribute(String name, String value) {
        NamedNodeMap attributes = this.node.getAttributes();
        if (attributes == null) {
            return;
        }
        if (value == null) {
            if (attributes.getNamedItem(name) != null) {
                attributes.removeNamedItem(name);
            }
        } else {
            if (attributes.getNamedItem(name) != null) {
                attributes.removeNamedItem(name);
            }
            Document owner = this.node.getOwnerDocument();
            Attr item = owner.createAttribute(name);
            item.setNodeValue(value);
            attributes.setNamedItem(item);
        }
    }

    @Override
    public final Node appendChild(Node newChild) {
        return this.node.appendChild(this.getRawNode(newChild));
    }

    public AbstractXmlNode appendDeepClone(AbstractXmlNode origin) {
        String tag = origin.getNodeName();
        AbstractXmlNode clone = (AbstractXmlNode)this.addChild(tag);
        NamedNodeMap attributes = origin.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            clone.setAttribute(name, value);
        }
        Collection children = origin.getChildren();
        for (AbstractXmlNode child : children) {
            clone.appendDeepClone(child);
        }
        return clone;
    }

    @Override
    public final Node cloneNode(boolean deep) {
        return this.node.cloneNode(deep);
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    @Override
    public final String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public final String getNodeName() {
        return this.node.getNodeName();
    }

    @Override
    public final short getNodeType() {
        return this.node.getNodeType();
    }

    @Override
    public final String getNodeValue() {
        return this.node.getNodeValue();
    }

    @Override
    public final Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    public final <T extends XmlDocument> T getOwnerXmlDocument(Class<T> documentClass) {
        Document doc = this.node.getOwnerDocument();
        try {
            Constructor<T> constructor = documentClass.getConstructor(Document.class);
            return (T)((XmlDocument)constructor.newInstance(doc));
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public final String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public final Object getUserData(String key) {
        return this.node.getUserData(key);
    }

    @Override
    public final boolean hasAttributes() {
        return this.node.hasAttributes();
    }

    @Override
    public final boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) {
        return this.node.insertBefore(this.getRawNode(newChild), this.getRawNode(refChild));
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.node.isSupported(feature, version);
    }

    @Override
    public final void normalize() {
        this.node.normalize();
    }

    @Override
    public final Node removeChild(Node oldChild) {
        return this.node.removeChild(this.getRawNode(oldChild));
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) {
        return this.node.replaceChild(this.getRawNode(newChild), this.getRawNode(oldChild));
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.node.setNodeValue(nodeValue);
    }

    @Override
    public final void setPrefix(String prefix) {
        this.node.setPrefix(prefix);
    }

    @Override
    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.node.setUserData(key, data, handler);
    }

    @Override
    public final Node getFirstChild() {
        return this.factory.getXmlNode(this.node.getFirstChild());
    }

    @Override
    public final Node getLastChild() {
        Node lastChild = this.node.getLastChild();
        return this.factory.getXmlNode(lastChild);
    }

    @Override
    public final Node getNextSibling() {
        return this.factory.getXmlNode(this.node.getNextSibling());
    }

    @Override
    public final Node getPreviousSibling() {
        return this.factory.getXmlNode(this.node.getPreviousSibling());
    }

    @Override
    public final Node getParentNode() {
        return this.factory.getXmlNode(this.node.getParentNode());
    }

    @Override
    public final String getBaseURI() {
        return this.node.getBaseURI();
    }

    @Override
    public final short compareDocumentPosition(Node other) {
        return this.node.compareDocumentPosition(this.getRawNode(other));
    }

    @Override
    public final String getTextContent() {
        return this.node.getTextContent();
    }

    public final String getFirstLevelTextContent() {
        if (this.node.getNodeType() == 2) {
            return this.node.getNodeValue();
        }
        StringBuilder str = new StringBuilder();
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type != 3 && type != 4) continue;
            str.append(child.getNodeValue());
        }
        return str.toString();
    }

    @Override
    public final void setTextContent(String textContent) {
        this.node.setTextContent(textContent);
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this.node.isSameNode(this.getRawNode(other));
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        return this.node.lookupPrefix(namespaceURI);
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        return this.node.isDefaultNamespace(namespaceURI);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        return this.node.lookupNamespaceURI(prefix);
    }

    @Override
    public final boolean isEqualNode(Node other) {
        return this.node.isEqualNode(this.getRawNode(other));
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return this.node.getFeature(feature, version);
    }

    private Node getRawNode(Node arg) {
        Node rawNode;
        if (arg instanceof XmlNode) {
            XmlNode xmlNode = (XmlNode)arg;
            rawNode = xmlNode.getNode();
        } else {
            rawNode = arg;
        }
        return rawNode;
    }

    public final <T extends XmlNode> T addChild(Class<T> tagClass) {
        try {
            XmlNode tempTag = (XmlNode)tagClass.newInstance();
            String tagName = tempTag.getTagName();
            if (this.canContainChild(tagName)) {
                Document document = this.getOwnerDocument();
                Element newNode = document.createElement(tagName);
                XmlNode newTag = (XmlNode)tagClass.cast(tempTag.newInstance(newNode, this.factory));
                return (T)newTag;
            }
            throw new IllegalArgumentException("<" + this.getTagName() + "> must not contain <" + tagName + ">");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public final <T extends XmlNode> T appendChild(Class<T> tagClass) {
        T newTag = this.addChild(tagClass);
        this.appendChild((Node)newTag);
        return newTag;
    }

    @Override
    public final XmlNode addChild(String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException("tag name must not be null!");
        }
        String tag = tagName.trim();
        if (tag.indexOf(32) >= 0) {
            throw new IllegalArgumentException("tag name must not contain attributes!");
        }
        int dotPos = tag.indexOf(58);
        if (this.canContainChild(tag) || dotPos >= 0) {
            Document document = this.getOwnerDocument();
            Element newNode = document.createElement(tag);
            XmlNode newTag = this.factory.getXmlNode(newNode);
            this.appendChild(newTag);
            return newTag;
        }
        throw new IllegalArgumentException("<" + this.getTagName() + "> must not contain <" + tagName + ">");
    }

    @Override
    public final <T extends XmlNode> Collection<T> getChildNodes(Class<T> tagClass) {
        ArrayList<T> nodes = new ArrayList<T>();
        try {
            XmlNode newInstance = (XmlNode)tagClass.newInstance();
            String tagName = newInstance.getTagName();
            NodeList list = this.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!(n instanceof XmlNode)) continue;
                XmlNode xmlNode = (XmlNode)n;
                String xmlNodeTagName = xmlNode.getNodeName();
                String localName = xmlNode.getLocalName();
                if (!tagName.equals(xmlNodeTagName) && !tagName.equals(localName)) continue;
                nodes.add(tagClass.cast(xmlNode));
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return nodes;
    }

    @Override
    public final <T extends XmlNode> Collection<T> getChildren() {
        ArrayList<XmlNode> nodes = new ArrayList<XmlNode>();
        NodeList list = this.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!(n instanceof XmlNode)) continue;
            XmlNode xmlNode = this.factory.getXmlNode(n);
            nodes.add(xmlNode);
        }
        return nodes;
    }

    protected abstract boolean canContainChild(String var1);

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            String encoding = System.getProperty("jvoicexml.xml.encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(this.node);
            transformer.transform(source, result);
            return out.toString(encoding);
        }
        catch (TransformerException e) {
            return super.toString();
        }
        catch (UnsupportedEncodingException e) {
            return super.toString();
        }
    }

    @Override
    public Collection<String> getAttributeNames() {
        return new ArrayList<String>();
    }

    public final Collection<String> getDefinedAttributeNames() {
        int index;
        ArrayList<String> attributes = new ArrayList<String>();
        NamedNodeMap nodes = this.getAttributes();
        Node current = nodes.item(index);
        for (index = 0; index < nodes.getLength(); ++index) {
            String name = current.getNodeName();
            attributes.add(name);
        }
        return attributes;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractXmlNode)) {
            return false;
        }
        AbstractXmlNode other = (AbstractXmlNode)obj;
        if (this.node == other.node) {
            return true;
        }
        if (this.node == null) {
            return false;
        }
        return this.node.isEqualNode(other.node);
    }

    public final int hashCode() {
        if (this.node == null) {
            return super.hashCode();
        }
        return this.node.hashCode();
    }
}

