/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml;

import java.util.Locale;

public final class LanguageIdentifierConverter {
    private LanguageIdentifierConverter() {
    }

    public static String toLanguageIdentifier(Locale locale) {
        if (locale == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        str.append(locale.getLanguage());
        String country = locale.getCountry();
        if (!country.isEmpty()) {
            str.append('-');
            str.append(country);
        }
        return str.toString();
    }

    public static Locale toLocale(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        String[] parts = identifier.split("-");
        String language = parts[0];
        if (language.length() != 2) {
            throw new IllegalArgumentException("Language must be a 2-letter code!");
        }
        if (parts.length == 1) {
            return new Locale(language.toLowerCase());
        }
        String country = parts[1];
        if (country.length() != 2) {
            throw new IllegalArgumentException("Country must be a 2-letter code!");
        }
        return new Locale(language.toLowerCase(), country.toUpperCase());
    }
}

