/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml;

import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TextContainer;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class NodeHelper {
    private NodeHelper() {
    }

    public static Text addText(TextContainer container, String text) {
        Text textNode;
        if (text == null || text.isEmpty()) {
            return null;
        }
        String append = text.trim();
        if (append.isEmpty()) {
            return null;
        }
        Node lastChild = container.getLastChild();
        if (lastChild instanceof Text) {
            textNode = (Text)lastChild;
            String value = textNode.getNodeValue().trim();
            StringBuilder str = new StringBuilder();
            str.append(value);
            char first = append.charAt(0);
            if (first != '.' && first != ',' && first != '!' && first != '?') {
                str.append(' ');
            }
            str.append(append);
            textNode.setNodeValue(str.toString());
        } else {
            Document document = container.getOwnerDocument();
            org.w3c.dom.Text node = document.createTextNode(append);
            XmlNodeFactory<? extends XmlNode> factory = container.getNodeFactory();
            textNode = new Text(node, factory);
            container.appendChild(textNode);
        }
        return textNode;
    }
}

