/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml;

import java.math.BigDecimal;

public final class TimeParser {
    private static final int MSECS_PER_SEC = 1000;
    private final String time;

    public TimeParser(String str) {
        this.time = str;
    }

    public long parse() {
        BigDecimal number;
        long factor;
        String timeValue;
        boolean isSeconds;
        if (this.time == null) {
            return 0L;
        }
        if (this.time.endsWith("ms")) {
            isSeconds = false;
        } else if (this.time.endsWith("s")) {
            isSeconds = true;
        } else {
            return -1L;
        }
        if (isSeconds) {
            timeValue = this.time.substring(0, this.time.length() - 1);
            factor = 1000L;
        } else {
            timeValue = this.time.substring(0, this.time.length() - "ms".length());
            factor = 1L;
        }
        try {
            number = new BigDecimal(timeValue);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        float flt = number.floatValue();
        return (long)(flt * (float)factor);
    }
}

